** BLOGHANDLER.PRG
** Result handler for multi-threaded
** blog author requests.

DEFINE CLASS AuthorsHandler AS CUSTOM
	cURL = ""

	PROCEDURE Init (tcURL As String)
		This.cURL = ALLTRIM(tcURL)
	ENDPROC

	PROCEDURE ProcessResult (tcString AS String)
		LOCAL lcString As String
		lcString = tcString
		
		lcAuthor = STREXTRACT(lcString,[<author><name>],[</name>],1)
		IF !EMPTY(ALLTRIM(lcAuthor))
			lcAuthor = STRTRAN(ALLTRIM(m.lcAuthor),"&#039;","'")
		ELSE
			lcAuthor = STREXTRACT(lcString,[<title>],[</title>],1)
			IF !EMPTY(lcAuthor)
				lcAuthor = STRTRAN(ALLTRIM(m.lcAuthor),"&#039;","'")
			ENDIF		
		ENDIF
		
		IF USED("xBlogs")
			IF !EMPTY(lcAuthor)
				TRY
					UPDATE xBlogs SET cAuthor = ALLTRIM(m.lcAuthor) ;
						WHERE ALLTRIM(cURL) = ALLTRIM(This.cURL)
				CATCH
				ENDTRY
			ELSE
				TRY
					UPDATE xBlogs SET cAuthor = "Unknown" ;
						WHERE ALLTRIM(cURL) = ALLTRIM(This.cURL)
				CATCH
				ENDTRY
			ENDIF
		ENDIF
					
		** We're done with processing the result, so release this
		This.Release()
	ENDPROC
			
	PROCEDURE Release
		RELEASE THIS
	ENDPROC
ENDDEFINE
