 
*:*****************************************************************************
*:
*: Procedure file: PCAL.PRG
*:         System: Calendar Popup Utility
*:         Author: Thomas Phaneuf
*:      Copyright (c) 1994, Phaneuf Consulting
*:  Last modified: 10-09-1994 at 15:37:10
*:
*:  Procs & Fncts: P_PIX2FOX()
*:               : P_EATKEY()
*:               : P_CALWIN()
*:               : P_SHOWMON()
*:               : P_CURSORBOX()
*:               : P_READPREP()
*:               : P_HANDLER()
*:               : P_RESIZE()
*:               : P_MOUSEDT()
*:               : P_LASTDAY()
*:               : P_WINWIDTH()
*:               : P_WINHEIGHT()
*:               : P_WINVPIX()
*:               : P_WINHPIX()
*:
*:          Calls: P_PIX2FOX()        (function in PCAL.PRG)
*:               : P_EATKEY()         (function in PCAL.PRG)
*:               : P_CALWIN()         (function in PCAL.PRG)
*:               : P_SHOWMON()        (function in PCAL.PRG)
*:               : P_CURSORBOX()      (function in PCAL.PRG)
*:               : P_READPREP()       (function in PCAL.PRG)
*:               : P_HANDLER()        (function in PCAL.PRG)
*:               : P_RESIZE()         (function in PCAL.PRG)
*:
*:      Documented 15:38:36                                FoxDoc version 3.00a
*:*****************************************************************************
parameters ldDate, lnWRow, lnWCol, lcObjNam, cTextBoxName
Local cTemp

** Hey its 2.6 code!
Set StrictDate to 0

*:*****************************************************************************
** COPYRIGHT. This software is owned by Phaneuf Consulting and is protected by 
** United States copyright laws and international treaty provisions. Therefore,
** you must treat the SOFTWARE like any other copyrighted material (i.e. a book
** or a musical recording) except that you may include modify and compile the
** provided source code into yuor applications. In no instance shall you
** distribute the source code that is provided, or any modified version of that
** source code, in any form or fashion.
** 
** All source code that is made available to you is provided solely for your 
** organizations internal use, and may not be sold, distributed, or 
** disseminated in any form or fashion except as compiled code within your 
** applications. Appropriate safeguards will be taken, such as keeping all 
** source code in a secure location, and strict non-disclosure agreements 
** will be required when granting any person or persons not affiliated with 
** Phaneuf Consulting access to the source code. This matter is taken very 
** seriously by Phaneuf Consulting, and any breach may result in severe 
** civil and/or criminal penalties.
**

** CREATED    : 04/18/94 Thomas Phaneuf
** DESCRIPTION: Calendar utility.
** PARAMETERS : ldDate   = Initial date (optional).
**              lnWRow   = Top row of calendar window (optional).
**              lnWCol   = Left column of window (optional).
**              lcObjNam = Name of object to refresh (optional).
** RETURNS    : llRetVal -> True if a date is selected. Updates the parameter
**              ldDate, as well as the FoxPro variable _DIARYDATE.
*......................................................................
*$Log:   C:/pvcs/ref/pcal.prv  $
*  
*     Rev 1.4   09 Oct 1994 15:41:38   THP
*  Cleaned up source code for release.
*
*     Rev 1.3   08 Jun 1994 23:36:38   THP
*  Version 1.01 (shareware). Placed on CompuServe.
*
*     Rev 1.2   31 May 1994 20:30:46   THP
*  Safety put (prior to making possibly destructive changes).
*
*     Rev 1.1   27 May 1994 21:43:48   THP
*  Added recognition of basic _PCAL_... environment variables.
*
*     Rev 1.0   23 May 1994 07:07:28   THP
*  Initial revision.
*......................................................................

#define ROW_DATES	    1.8                        && Row offset for dates display.
#define COL_BORDER      1                        && Number of spaces to left and right of dates.
#define WIN_CALENDAR	"WinCal1"                   && Child window name.
#define WIN_PARENT    "WinCal0"                  && Parent window name.
#define MOUSE_EVENT	    151                      && Readkey() value of mouse click.
#define COL_FUDGE1      1.7                      && Fudge factor used to make things work.

*- Define variable scope...
private lcCENTURY                                && Original century setting
private lcCURSOR                                 && Saved cursor setting.
private lcESCAPE                                 && Original Escape setting.
private lcTALK                                   && Saved Talk setting.
private ldOLDDATE                                && Old date.
private ldWDATE                                  && Working date.
private llEXIT                                   && Exit indicator.
private llREFRESH                                && Flag indicating that an object needs to be refreshed.
private llRETVAL                                 && Value to return to calling program.
private lnOMTIME                                 && Time of previous mouse click.

private saColpos                                 && "Static" array of column positions.
private saMonths                                 && "Static" array of month names.
private scClrdisab                               && "Static" RGB color for disabled days.
private scClrdow                                 && "Static" RGB color for days of the week labels.
private scClrlight                               && "Static" RGB color for higlights.
private scClrshade                               && "Static" RGB color for shadow.
private scClrtoday                               && "Static" RGB color for today's date.
private scClrwin                                 && "Static" RGB color for window color.
private scClrwkday                               && "Static" RGB color for weekday dates.
private scClrwkend                               && "Static" RGB color for weekend dates.
private scDaystr                                 && "Static" string of one letter weekday name abbreviations.
private scExec                                   && "Static" program to execute on ENTER.
private scFont                                   && "Static" font face.
private scObjnam                                 && "Static" object nanme to refresh.
private scShow                                   && "Static" program to execute when date changes.
private scStyle                                  && "Static" font style.
private scWtitle                                 && "Static" window title.
private sdDateshow                               && "Static" date currently being shown.
private sdHrange                                 && "Static" highest allowed date.
private sdLrange                                 && "Static" lowest allowed date.
private slMonths                                 && "Static" flag to use passed in array of months.
private slWfloat                                 && "Static" flag for float.
private slWgrow                                  && "Static" flag for grow.
private slWkeep                                  && "Static" flag for not clear window on exit.
private slWmin                                   && "Static" flag for minimize.
private slWzoom                                  && "Static" flag for zoom.
private snColwd                                  && "Static" column width.
private snFactor                                 && "Static" row factor.
private snLinht                                  && "Static" line height in Foxels.
private snLinwd                                  && "Static" line width in Foxels.
private snNumbw                                  && "Static" width of a number.
private snRdlevel                                && "Static" read level prior to execution of calendar.
private snSize                                   && "Static" font size.
private snSpacew                                 && "Static" width of a space.
private snWcol                                   && "Static" location of window (left column).
private snWcols                                  && "Static" number of columns in window (in Foxels).
private snWrow                                   && "Static" location of window (toprow).
private snWrows                                  && "Static" number of rows in window (in Foxels).
Local   cOldFormName
*-

scFont   = iif(type("_PCAL_cFont"  ) != "C", "Arial", _PCAL_cFONT)
snSize   = iif(type("_PCAL_nSIZE"  ) != "N", 10      , _PCAL_nSIZE)
scStyle  = iif(type("_PCAL_cSTYLE" ) != "C", "N"    , _PCAL_cSTYLE)
scExec   = iif(type("_PCAL_cEXEC"  ) != "C", "" , _PCAL_cEXEC)
scShow 	 = iif(type("_PCAL_cSHOW"  ) != "C", "" , _PCAL_cSHOW)

sdLRange = iif(type("_PCAL_dLRANGE") != "D", {01/01/0100}, _PCAL_dLRANGE)
sdHRange = iif(type("_PCAL_dHRANGE") != "D", {12/31/9999}, _PCAL_dHRANGE)


scDayStr	= iif(type("_PCAL_cDAYS" ) != "C", "SMTWTFS", _PCAL_cDAYS)

scWTitle    = iif(type("_PCAL_cTITLE" ) != "C","" , _PCAL_cTITLE)
slWFloat    = iif(type("_PCAL_lFLOAT" ) != "L",.f. , _PCAL_lFLOAT)
slWMin      = iif(type("_PCAL_lMINIM" ) != "L",.f. , _PCAL_lMINIM)
slWGrow     = iif(type("_PCAL_lGROW"  ) != "L",.f. , _PCAL_lGROW)
slWZoom     = iif(type("_PCAL_lZoom"  ) != "L",.f. , _PCAL_lZoom)
slWKeep     = iif(type("_PCAL_lWKEEP" ) != "L",.f. , _PCAL_lWKEEP)

scClrWkDay 	= iif(type("_PCAL_cWKDAY"   ) != "C", "RGB(0,0,0,,,)"      , _PCAL_cWKDAY  )
scClrWkEnd 	= iif(type("_PCAL_cWKEND"   ) != "C", "RGB(0,0,128,,,)"    , _PCAL_cWKEND  )
scClrToday	= iif(type("_PCAL_cTODAY"   ) != "C", "RGB(255,0,0,,,)"    , _PCAL_cTODAY  )
scClrDOW	= iif(type("_PCAL_cDOW"     ) != "C", "RGB(128,0,0,,,)"    , _PCAL_cDOW    )
scClrWin 	= iif(type("_PCAL_cWINDOW"  ) != "C", "RGB(192,192,192,192,192,192)", _PCAL_cWINDOW )
scClrShade	= iif(type("_PCAL_cSHADE"   ) != "C", "RGB(128,128,128,,,)", _PCAL_cSHADE  )
scClrLight	= iif(type("_PCAL_cLIGHT"   ) != "C", "RGB(255,255,255,,,)", _PCAL_cLIGHT  )
scClrDisab	= iif(type("_PCAL_cDISABLE" ) != "C", "RGB(128,128,128,,,)", _PCAL_cDISABLE)

snWRow      = iif(empty(lnWRow),0,lnWRow)        && Fix window row parameter.
snWCol      = iif(empty(lnWCol),0,lnWCol)        && Fix window column parameter.

sdDateShow  = {space(0)}

declare saMonths[12]
if type("_PCAL_aMONTHS[1]")="U"
  slMonths = .f.
else
  slMonths = .t.
  =acopy(_PCAL_aMONTHS, saMonths)
endif

declare saColPos[7]

*-
ldDate    = iif(empty(ldDate), _DIARYDATE, ldDate) && Fix date parameter.
ldDate    = max(min(ldDate,sdHRange),sdLRange)
lcObjNam  = iif(empty(lcObjNam), "", ;
  upper(alltrim(lcObjNam)))                      && Fix object name parameter.

snFactor  = 1
snRdLevel = rdlevel()
scObjNam  = lcObjNam
snNumbW   = txtwidth("9",scFont, snSize, scStyle)
snSpaceW  = txtwidth(space(1), scFont, snSize, scStyle)
snLinHt   = p_Pix2Fox(2, scFont, snSize, scStyle, .t.)
snLinWd   = p_Pix2Fox(2, scFont, snSize, scStyle)
snColWd   = 2*snNumbW+snSpaceW

lcTalk 	  = set("TALK")
lcCentury = set("CENTURY")
lcEscape  = set("ESCAPE")
lcCursor  = set("CURSOR")

set talk off
*set century on
set escape off
set cursor off

ldWDate   = ldDate                               && Establish working date.
ldOldDate = ldWDate                              && Initialize old date.
lnOMTime  = -1                                   && Initialize old mouse time.
llRefresh = !empty(lcObjNam)
=p_EatKey()
=p_CalWin()                                      && Set up the calendar window.
=p_ShowMon(ldWDate)                              && Set up and show the current month.
=p_CursorBox(ldWDate,.t.)                        && Display current box.

llRetVal = .f.
llExit   = .f.

snWRows  = wrows(WIN_PARENT)
snWCols  = wcols(WIN_PARENT)

do while !llExit                                 && .and. wontop(WIN_CALENDAR)
  
  read ;
    when p_ReadPrep(ldWDate, @ldOldDate) .and.  woutput(WIN_CALENDAR) ;
    valid p_Handler(@ldWDate, @ldOldDate, @lnOMTime, @llExit, @llRetVal)
  if slWGrow .or. slWZoom
    if snWRows != wrows(WIN_PARENT) .or. snWCols != wcols(WIN_PARENT)
      =p_Resize()                                && Resize the window.
      snWRows  = wrows(WIN_PARENT)
      snWCols  = wcols(WIN_PARENT)
    endif
  endif
  
  if readkey()=MOUSE_EVENT .and. !mdown()
    =p_EatKey()
  endif
enddo

if !slWKeep
  release window (WIN_CALENDAR)
  release window (WIN_PARENT)
endif



if llRetVal                                      && Escape key pressed, entry is bad.
  ldDate     = ldWDate                           && Update date parameter.
endif
_DIARYDATE = ldDate                              && Reset diary date.

set century &lcCentury
set escape &lcEscape
set talk &lcTalk
set cursor &lcCursor

return llRetVal

* End: Main Logic (PCAL.prg)

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_CALWIN
*!
*!      Called by: PCAL.PRG                          
*!               : P_RESIZE()         (function in PCAL.PRG)
*!
*!          Calls: P_WINWIDTH()       (function in PCAL.PRG)
*!               : P_WINHEIGHT()      (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_CalWin

** CREATED    : Thomas Phaneuf
** DATE/TIME  : 05/16/94    20:54:30
** DESCRIPTION: Defines and sets up calendar window.
** PARAMETERS : None.
** RETURNS    : .True.

private K                                        && (FL)
private LALETTER                                 && (FL)
private LCINWIN                                  && Window to place pop-up in.
private LCWINSTR                                 && String used in definition of window.
private LNDSPWIDTH                               && (FL)
private LNFACTOR                                 && (FL)
private LNWHEIGHT                                && (FL)
private LNWWIDTH                                 && (FL)
*-

release window (WIN_CALENDAR)
release window (WIN_PARENT)
lcInWin  = woutput()
lcWinStr = iif(empty(lcInWin), "in screen", "in window "+alltrim(lcInWin))
lcWinStr = lcWinStr + space(1)
lcWinStr = lcWinStr + iif(slWFloat, "Float ", space(0))
lcWinStr = lcWinStr + iif(slWGrow, "Grow ", space(0))
lcWinStr = lcWinStr + iif(slWZoom, "Zoom ", space(0))
lcWinStr = lcWinStr + iif(slWMin, "Minimize icon file 'pcal.ico' ", space(0))
lcWinStr = lcWinStr + iif(!empty(scWTitle), 'Title "'+scWTitle+'"', space(0))

lnWWidth = p_WinWidth(scFont, snSize, scStyle)
lnWHeight= p_WinHeight(scFont, snSize, scStyle)

define window (WIN_PARENT) ;
  at snWRow, snWCol ;
  size lnWHeight, lnWWidth ;
  font scFont, snSize ;
  style scStyle ;
  COLOR (scClrWin) ;
  NAME (WIN_PARENT);
  &lcWinStr

define window (WIN_CALENDAR);
  at 0,0 size lnWHeight, lnWWidth ;
  font scFont, snSize ;
  style scStyle ;
  COLOR (scClrWin) ;
  NAME (WIN_CALENDAR);
  in window (WIN_PARENT)

activate window (WIN_PARENT) noshow  TOP
activate window (WIN_CALENDAR) noshow TOP

if empty(snWRow) .and. empty(snWCol)
  move window (WIN_PARENT) center
endif

snWCol   = wlcol(WIN_PARENT)
snWRow   = wlrow(WIN_PARENT)

declare laLetter[7], saColPos[7]
laLetter[1] = substr(scDayStr,1,1)
laLetter[2] = substr(scDayStr,2,1)
laLetter[3] = substr(scDayStr,3,1)
laLetter[4] = substr(scDayStr,4,1)
laLetter[5] = substr(scDayStr,5,1)
laLetter[6] = substr(scDayStr,6,1)
laLetter[7] = substr(scDayStr,7,1)

lnDspWidth = wcols()-(2*COL_BORDER*snSpaceW)-(4*snLinWd)
snColWd = lnDspWidth/7
lnFactor = snColWd/txtwidth(" 99",scFont, ceiling(snSize*.8),"N")

for k = 1 to 7
  saColPos[k] = (COL_BORDER*snSpaceW)+(k-1)*snColWd
  
  @ ROW_DATES-0.500, saColPos[k]+ COL_FUDGE1*snSpaceW ;
    say laLetter[k]  ;
    size 1, snColWd*lnFactor ;
    picture "@I AAA" ;
    font scFont, max(snSize*.8,8) ;
    style "N" ;
    COLOR (scClrDOW)
endfor

release laLetter

*- Dividing line...
@ROW_DATES+0.500+snLinHt/2, 0.000 ;
  to ROW_DATES+0.500+snLinHt/2, wcols() ;
  color (scClrLight)
@ROW_DATES+0.500, 0.000 ;
  to ROW_DATES+0.500, wcols() ;
  color (scClrShade)

*- 3D Border...
@0,0 ;
  to 0,wcols() ;
  color (scClrLight) ;
  pen 2
@0,0 ;
  to wrows(),0 ;
  color (scClrLight) ;
  pen 2
@snLinHt,wcols()-snLinWd ;
  to wrows(),wcols()-snLinWd ;
  color (scClrShade) ;
  pen 2
@wrows()-snLinHt,snLinWd ;
  to wrows()-snLinHt,wcols() ;
  color (scClrShade) ;
  pen 2
*-

show window (WIN_PARENT)
show window (WIN_CALENDAR)

return .t.

* End: p_CalWin()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_SHOWMON
*!
*!      Called by: PCAL.PRG                          
*!               : P_READPREP()       (function in PCAL.PRG)
*!               : P_RESIZE()         (function in PCAL.PRG)
*!               : P_MOUSEDT()        (function in PCAL.PRG)
*!
*!          Calls: P_LASTDAY()        (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_ShowMon
parameters ldDate

** DESCRIPTION: Updates the display of the month name/year and the date
**              display.
** PARAMETERS : ldDate  = Current date being considered.
** RETURNS    : .True.


*- Define variable scope...
private K                                        && (FL)
private LCCOLOR                                  && (FL)
private LCMONTH                                  &&
private LCSTRING                                 &&
private LCYEAR                                   &&
private LDENDDATE                                &&
private LDSTARTDATE                              &&
private LDWDATE                                  &&
private LNCOL                                    &&
private LNDAY                                    &&
private LNDOW                                    && (FL)
private LNNUMDAYS                                &&
private LNNUMROWS                                &&
private LNROW                                    &&
*-

lcMonth   = alltrim(str(month(ldDate),2))
lcYear    = alltrim(str(year(ldDate),4))
lnNumDays = p_lastday(ldDate)

if slMonths
  lcString = alltrim(saMonths[month(ldDate)])+" "+str(Year(ldDate),4)
else
  lcString = cmonth(ldDate)+" "+str(Year(ldDate),4)
endif

@ROW_DATES-1.5,2 say lcString ;
  picture "@I" ;
  size 1,wcols()-3 ;
  color RGB(0,0,128,,,)

activate window (WIN_CALENDAR) noshow TOP

lnRow = ROW_DATES+1

@ROW_DATES+.7, 2*snLinWd ;
  clear to wrows()-2*snLinHt,wcols()-2*snLinWd

ldEndDate = ctod(lcMonth+"/"+alltrim(str(lnNumDays))+"/"+lcYear)
lnDay     = day(ldEndDate)
lnDOW	  = dow(ldEndDate)
lnNumRows = ceiling((lnDay-lnDOW)/7)+1
snFactor  = round(6/lnNumRows,2)

ldStartDate = ctod(lcMonth+"/01/"+lcYear)
for k = 1 to lnNumDays
  ldWDate   = ldStartDate+(k-1)
  lnDay     = day(ldWDate)
  lnDOW	    = dow(ldWDate)
  lnRow     = ROW_DATES + (ceiling((lnDay-lnDOW)/7)+.8)*snFactor
  lnCol     = saColPos[lnDOW]
  
  lcColor = ;
    iif(!between(ldWDate, sdLRange, sdHRange), scClrDisab, ;
    iif(ldWDate=date(), scClrToday, ;
    iif(between(lnDOW,2,6), scClrWkDay, scClrWkEnd) ) )
  
  @lnRow, lnCol ;
    say str(lnDay,3) ;
    size 1, snColWd ;
    picture "@J 999" ;
    color (lcColor)
endfor

show window (WIN_CALENDAR)

return .t.

* End: p_ShowMon()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_MOUSEDT
*!
*!      Called by: P_HANDLER()        (function in PCAL.PRG)
*!
*!          Calls: P_LASTDAY()        (function in PCAL.PRG)
*!               : P_SHOWMON()        (function in PCAL.PRG)
*!               : P_CURSORBOX()      (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_MouseDt
parameters ldDate, lnMRow, lnMCol

** DESCRIPTION: Determines the date that the mouse pointer was over when
**              a mouse click occurred.
** PARAMETERS : ldDate   = Current date that is being considered. Used to
**                         determine current month and year.
**              lnMRow   = Mouse row position relative to window.
**              lnMCol   = Mouse column position relative to window.
** RETURNS    : llRetVal -> True if mouse clicked over a date.
**				      Updates parameter ldDate.

private K                                        && (FL)
private LCMONTH                                  &&
private LCYEAR                                   &&
private LDDATE                                   && (FL)
private LDSTARTDATE                              &&
private LDWDATE                                  &&
private LLRETVAL                                 && (FL)
private LLRETVAL                                 && (FL)
private LNCOL                                    &&
private LNDAY                                    &&
private LNDOW                                    && (FL)
private LNDOW                                    &&
private LNMCOL                                   && (FL)
private LNMROW                                   && (FL)
private LNNUMDAYS                                &&
private LNROW                                    &&
private lnDelay
private lnPass
*-

ldWDate = ldDate
lnDelay = _DBLCLICK/2
lnPass  = 0
llRetVal = .F.

do while mdown()                                 && .and. mwindow(WIN_CALENDAR)
  lnPass      = lnPass+1
  lcMonth     = alltrim(str(month(ldDate),2))
  lcYear      = alltrim(str(year(ldDate),4))
  ldStartDate = ctod(lcMonth+"/01/"+lcYear)
  lnNumDays   = p_lastday(ldDate)
  
  do case
      *-
    case between(lnMRow, ROW_DATES-1.5, ROW_DATES-0.51) && Month/Year line.
      do case
        case lnMCol < wcols()/2
          ldWDate = gomonth(ldWDate,-1)
        case lnMCol > wcols()/2
          ldWDate = gomonth(ldWDate,1)
      endcase
      
      if !between(ldWDate,sdLRange, sdHRange)
        ldWDate = max(min(ldWDate,sdHRange),sdLRange)
      endif
      
      if ldWDate != ldDate
        ldDate = ldWDate
        
        =p_ShowMon(ldDate)                       && Show the new month.
        =p_CursorBox(ldDate,.t.)                 && Remove previous box.
        =inkey(lnDelay, "mh")
        
        lnDelay = max(lnDelay * .5,.05)
      endif
      llRetVal 	= .f.
      *-
    case between(lnMRow, ROW_DATES-0.5, ROW_DATES+0.50) && Week day line.
      for k = 1 to 7
        if between(lnMCol, saColPos[k]+COL_FUDGE1*snSpaceW, saColPos[k]+snColWd)
          lnDOW   = dow(ldWDate)
          ldWDate = ldDate-(lnDOW-k)
          exit
        endif
      endfor
      
      if ldWDate != ldDate
        if month(ldDate)=month(ldWDate)
          =p_CursorBox(ldDate)                   && Remove previous cursor box.
        else
          =p_ShowMon(ldWDate)                    && Show the new month.
        endif
        ldDate = ldWDate
        =p_CursorBox(ldDate,.t.)
      endif
      
      llRetVal 	= .f.
      *-
    otherwise
      llRetVal 	= .f.
      if lnMRow > 0
        
        for k = 1 to lnNumDays
          ldWDate = ldStartDate+(k-1)
          lnDay   = day(ldWDate)
          lnDOW	  = dow(ldWDate)
          lnRow   = ROW_DATES + (ceiling((lnDay-lnDOW)/7)+.8)*snFactor
          lnCol   = saColPos[lnDOW]
          
          if ;
              between(lnMRow, lnRow, lnRow+1) ;
              .and. between(lnMCol, lnCol, lnCol+snColWd+snSpaceW)
            
            if ldWDate != ldDate ;
                .and. between(ldWDate, sdLRange, sdHRange)
              
              =p_CursorBox(ldDate)               && Remove previous box.
              ldDate   = ldWDate
              =p_CursorBox(ldDate,.t.)           && Show current box.
            endif
            
            llRetVal = between(ldWDate, sdLRange, sdHRange)
            exit
          endif
        endfor
      endif
      *-
  endcase
  
  lnMRow = mrow()
  lnmCol = mcol()
enddo

return llRetVal

* End: p_MouseDt()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_LASTDAY
*!
*!      Called by: P_SHOWMON()        (function in PCAL.PRG)
*!               : P_HANDLER()        (function in PCAL.PRG)
*!               : P_MOUSEDT()        (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_LastDay
parameters ldDate

** DESCRIPTION: Determines the last day of the passed in month.
** PARAMETERS : ldDate    = Date in month to determine last day for.
** RETURNS    : NUMERIC number of last day of month.

ldDate = ldDate-(day(ldDate)-1)+31

return day(ldDate-day(ldDate))

* End: p_LastDay()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_READPREP
*!
*!      Called by: PCAL.PRG                          
*!
*!          Calls: P_SHOWMON()        (function in PCAL.PRG)
*!               : P_CURSORBOX()      (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_ReadPrep
parameters ldWDate, ldOldDate

** DESCRIPTION: Prepares the display for the next read cycle.
** PARAMETERS : ldWDate   = Current working date.
**              ldOldDate = Previous working date.
** RETURNS    : .True.

private LDOLDDATE                                && (FL)

_DIARYDATE = ldWDate                             && Set for return value.

if ldWDate != ldOldDate
  if month(ldWDate) != month(ldOldDate) ;
      .or. year(ldWDate) != year(ldOldDate)
    
    =p_ShowMon(ldWDate)                          && Show the new month.
  else
    =p_CursorBox(ldOldDate)                      && Remove previous box.
  endif
endif
=p_CursorBox(ldWDate,.t.)                        && Display current box.

ldOldDate = ldWDate

return .t.

* End: p_ReadPrep()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_HANDLER
*!
*!      Called by: PCAL.PRG                          
*!
*!          Calls: P_MOUSEDT()        (function in PCAL.PRG)
*!               : P_EATKEY()         (function in PCAL.PRG)
*!               : P_LASTDAY()        (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_Handler
parameters ldWDate, ldOldDate, lnOMTime, llExit, llRetVal

** DESCRIPTION: Determines how the mouse click/keystrokes affect the current
**              date.
** PARAMETERS : ldWDate   = Current working date.
**              ldOldDate = Previous working date. Updated.
**              lnOMTime  = Previous time of mouse click. Updated.
**              llExit    = Exit indicator.
**              llRetVal  = Indicates success or failure of selection.
** RETURNS    : .True.

*- Cursor movement keys...
#define KEY_UP           5                       && UP key.
#define KEY_DOWN        24                       && DOWN key.
#define KEY_LEFT        19                       && LEFT key.
#define KEY_RIGHT        4                       && RIGHT key.
#define KEY_HOME         1                       && HOME key.
#define KEY_END          6                       && END key.
#define KEY_PGUP        18                       && PGUP key.
#define KEY_PGDN         3                       && PGDN key.
#define KEY_ESC         27                       && ESC key.
#define KEY_ENTER       13                       && ENTER key.
#define KEY_CTRLHOME    29                       && CTRL+HOME key.
#define KEY_CTLPGUP     31                       && Ctrl+PgUp key.
#define KEY_CTLPGDN     30                       && Ctrl+PgDn key.

private LDDATE                                   && (FL)
private LDOLDDATE                                && (FL)
private LDWDATE                                  && (FL)
private LLEXIT                                   && (FL)
private LLRETVAL                                 && (FL)
private LNKEY                                    && INKEY() value of last key pressed.
private LNMCOL                                   && Mouse column.
private LNMROW                                   && Mouse row.
private LNMTIME                                  && Current mouse time.
private LNOMTIME                                 && (FL)
private LNRKEY                                   &&
*-

if mdown()
  if mwindow(WIN_CALENDAR)
    lnMTime = seconds()
    lnMRow  = mrow(WIN_CALENDAR)
    lnMCol  = mcol(WIN_CALENDAR)


    
    if p_MouseDt(@ldWDate, @lnMRow, @lnMCol) ;
        .and. ldWDate=ldOldDate ;
        .and. lnMRow>ROW_DATES
      
      if !empty(scExec)
        &scExec
        =p_EatKey()
      else
        
        llExit   = .t.                           && Bail.
        llRetVal = .t.
      endif
    else
      ldOldDate = ldWDate
      lnOMTime  = lnMtime                        && Reset old mouse time.
    endif
  else
    if (mcol(WIN_CALENDAR) = -1) or (mrow(WIN_CALENDAR) = -1)
        llExit   = .t.
        llRetVal = .f.
    endif
    lnOMTime  = -1                               && Reset old mouse time.
    if !empty(scObjNam)
      llExit   = .t.
      llRetVal = .f.
    endif
  endif
else
  lnKey  = lastkey()
  lnRKey = readkey()
  
  if lnRKey!=151
    do case
      case lnkey = KEY_UP                        && Lose a week.
        ldWDate  = max(ldWDate-7, sdLRange)
      case lnkey = KEY_DOWN                      && Gain a week
        ldWDate  = min(ldWDate+7, sdHRange)
      case lnkey = KEY_LEFT                      && Lose a day.
        ldWDate  = max(ldWDate-1, sdLRange)
      case lnkey = KEY_RIGHT                     && Gain a day.
        ldWDate  = min(ldWDate+1, sdHRange)
      case lnkey = KEY_PGUP                      && Lose a month.
        ldWDate  = max(gomonth(ldWDate,-1), sdLRange)
      case lnkey = KEY_PGDN                      && Gain a month.
        ldWDate  = min(gomonth(ldWDate,1), sdHRange)
      case lnkey = KEY_HOME                      && Go to first of month.
        ldWDate  = max(ldWDate-(day(ldWDate)-1), sdLRange)
      case lnkey = KEY_END                       && Go to last day of the month.
        ldWDate  = min(ldWDate+(p_lastday(ldWDate)-day(ldWDate)), sdHRange)
      case lnkey = KEY_CTRLHOME                  && Go to today.
        ldWDate  = max(min(date(), sdHRange),sdLRange)
      case lnkey = KEY_CTLPGUP                   && Lose a year.
        ldWDate  = max(gomonth(ldWDate,-12), sdLRange)
      case lnkey = KEY_CTLPGDN                   && Gain a year.
        ldWDate  = min(gomonth(ldWDate,12), sdHRange)
      case lnkey = KEY_ESC                       && Bail->No selection.
        llExit   = .t.
        llRetVal = .f.
      case lnkey = KEY_ENTER                     &&.and. !lnRKey=MOUSE_EVENT  && Bail -> Selection.
        ldDate = ldWDate
        
        if !empty(scExec)
          &scExec
          =p_EatKey()
        else
          llRetVal = .t.
          llExit   = .t.
        endif
    endcase
  endif
endif

#undef KEY_UP
#undef KEY_DOWN
#undef KEY_LEFT
#undef KEY_RIGHT
#undef KEY_HOME
#undef KEY_END
#undef KEY_PGUP
#undef KEY_PGDN
#undef KEY_ESC
#undef KEY_ENTER
#undef KEY_CTRLHOME
#undef KEY_CTLPGUP
#undef KEY_CTLPGDN

return .t.

* End: p_Handler()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_CURSORBOX
*!
*!      Called by: PCAL.PRG                          
*!               : P_READPREP()       (function in PCAL.PRG)
*!               : P_RESIZE()         (function in PCAL.PRG)
*!               : P_MOUSEDT()        (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_CursorBox
parameters ldDate, llOnFlg

** DESCRIPTION: Draws/Undraws box around current date.
** PARAMETERS : ldDate    = Date to draw/undraw around.
**              llOnFlg   = If .t., box is drawn, else box is undrawn.
** RETURNS    : .True.

private LCCOLOR1                                 && Dark color variable.
private LCCOLOR2                                 && Light color variable.
private LNBOTROW                                 && Bottom row of box.
private LNDAY                                    && Day of the month.
private LNDOW                                    && (FL)
private LNLFTCOL                                 && Left column of box.
private LNRGTCOL                                 && Right column of box.
private LNROW                                    && Row of display.
private LNTOPROW                                 && Top row of box.
*-
on key label f11 suspend
lnDay     = day(ldDate)
lnDOW	  = dow(ldDate)
lnRow     = (ceiling((lnDay-lnDOW)/7)+1)*snFactor
lnTopRow  = ROW_DATES+lnRow-.25
lnBotRow  = lnTopRow+1
lnLftCol  = saColPos[lnDOW]+.5*snSpaceW
lnRgtCol  = lnLftCol + 2*snNumbW + snSpaceW

if llOnFlg
  lcColor1  = scClrShade
  lcColor2  = scClrLight
else
  lcColor1  = scClrWin
  lcColor2  = lcColor1
endif

*- Display selected date box...
@ lnTopRow, lnLftCol to lnTopRow, lnRgtCol color (lcColor1)
@ lnTopRow, lnLftCol to lnBotRow, lnLftCol color (lcColor1)
@ lnBotRow, lnLftCol to lnBotRow, lnRgtCol color (lcColor2)
@ lnTopRow, lnRgtCol to lnBotRow, lnRgtCol color (lcColor2)
*-
**VFOX 3.0 Changes

if !chrsaw()
  if !empty(scObjNam)
    &scObjNam = ldDate
    cTemp = cTextBoxName + ".Value"
    Store ldDate to (cTemp)
    
    cTemp = cTextBoxName + ".Refresh"
    &cTemp
    *show get &scObjNam level snRdLevel
  endif
  
  if !empty(scShow) .and. llOnFlg .and. ldDate!=sdDateShow
    &scShow
    sdDateShow = ldDate
  endif
endif

return .t.

* End: p_CursorBox()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_PIX2FOX
*!
*!      Called by: PCAL.PRG                          
*!               : P_RESIZE()         (function in PCAL.PRG)
*!               : P_WINWIDTH()       (function in PCAL.PRG)
*!               : P_WINHEIGHT()      (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_Pix2Fox
parameters lnPixels, lcFont, lnFsize, lcStyle, llVFlg

** DESCRIPTION: Converts pixel values to corresponding values in "Foxels", or
**              multiplier of the specified font, size, and style.
** PARAMETERS : lnPixels  = Number of pixels.
**              lcFont    = Font name.
**              lnFSize   = Font size.
**              lcStyle   = Font style.
**              llVFlg    = Flag indicating that this is a vertical
**                          measurement.
** RETURNS    : (Numeric) -> Multiplier that corresponds to the specified
**              number of pixels.

#define FONT_HEIGHT  1
#define FONT_WIDTH   6

private LNFACTOR                                 &&
*-

if llVFlg
  lnFactor = fontmetric(FONT_HEIGHT, lcFont, lnFsize, lcStyle) && Average character height.
else
  lnFactor = fontmetric(FONT_WIDTH, lcFont, lnFsize, lcStyle) && Average character width.
endif

#undef FONT_HEIGHT
#undef FONT_WIDTH

return (lnPixels/lnFactor)

*- eop - p_Pix2Fox()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_RESIZE
*!
*!      Called by: PCAL.PRG                          
*!
*!          Calls: P_PIX2FOX()        (function in PCAL.PRG)
*!               : P_WINHEIGHT()      (function in PCAL.PRG)
*!               : P_WINWIDTH()       (function in PCAL.PRG)
*!               : P_WINVPIX()        (function in PCAL.PRG)
*!               : P_WINHPIX()        (function in PCAL.PRG)
*!               : P_CALWIN()         (function in PCAL.PRG)
*!               : P_EATKEY()         (function in PCAL.PRG)
*!               : P_SHOWMON()        (function in PCAL.PRG)
*!               : P_CURSORBOX()      (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_Resize

** DESCRIPTION: Resizes the pCal window and updates the program's static
**              variables to reflect the new window's size.
** PARAMETERS : None.
** RETURNS    : .True.

private lngfactor                                &&
private lnhfactor                                &&
private lnhpix                                   &&
private lnmaxh                                   &&
private lnmaxv                                   &&
private lnnewcols                                &&
private lnnewrows                                &&
private lnvfactor                                &&
private lnvpix                                   &&
private lnwinheight                              &&
private lnwinwidth                               &&
*-

lnMaxH    = p_Pix2Fox(sysmetric(21), scFont, snSize, scStyle)
lnMaxV    = p_Pix2Fox(sysmetric(22), scFont, snSize, scStyle,.t.)
lnNewCols = min(wcols(WIN_PARENT), lnMaxH)
lnNewRows = min(wrows(WIN_PARENT), lnMaxV)
lnHFactor = lnNewCols/snWCols
lnVFactor = lnNewRows/snWRows
lnGFactor = iif(1/lnHFactor+lnHFactor > 1/lnVFactor+lnVFactor, lnHFactor, lnVFactor)

if lnGFactor > lnMaxH/snWCols
  lnGFactor = lnMaxH/snWCols
  snWRow    = 0
endif
if lnGFactor > lnMaxV/snWRows
  lnGFactor = lnMaxV/snWRows
  snWCol    = 0
endif

snSize   = max(int(snSize*lnGFactor),8)

do while .t.
  lnWinHeight = p_WinHeight(scFont, snSize, scStyle)
  lnWinWidth  = p_WinWidth(scFont, snSize, scStyle)
  lnVPix = p_WinVPix(lnWinHeight, scFont, snSize, scStyle)
  lnHPix = p_WinHPix(lnWinWidth, scFont, snSize, scStyle)
  
  if lnVPix <= sysmetric(22) .and. lnHPix <= sysmetric(21)
    exit
  else
    snSize = snSize-1
    snWRow = 0
    snWCol = 0
  endif
enddo

snNumbW   = txtwidth("9",scFont, snSize, scStyle)
snSpaceW  = txtwidth(space(1), scFont, snSize, scStyle)
snLinHt   = p_Pix2Fox(2, scFont, snSize, scStyle, .t.)
snLinWd   = p_Pix2Fox(2, scFont, snSize, scStyle)
snColWd   = 2*snNumbW+snSpaceW
snWRow    = wlrow(WIN_PARENT)
snWCol    = wlcol(WIN_PARENT)

=p_CalWin()                                      && Set up the calendar window.
*=p_EatKey()
=p_ShowMon(ldWDate)                              && Set up and show the current month.
=p_CursorBox(ldWDate,.t.)                        && Display current box.

return .t.

*- eop - p_ReSize()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_EATKEY
*!
*!      Called by: PCAL.PRG                          
*!               : P_HANDLER()        (function in PCAL.PRG)
*!               : P_RESIZE()         (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_EatKey

** DESCRIPTION: Clears out the keyboard buffer and resets the value returned
**              by lastkey().
** PARAMETERS : None.
** RETURNS    : .True.

clear typeahead
do while chrsaw()
  =inkey()
enddo
read timeout .001                                && Clear the lastkey() value.

keyboard chr(255)
=inkey(0)

return .t.

*- eop - p_LastKey()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_WINWIDTH
*!
*!      Called by: P_CALWIN()         (function in PCAL.PRG)
*!               : P_RESIZE()         (function in PCAL.PRG)
*!
*!          Calls: P_PIX2FOX()        (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_WinWidth
parameters lcFont, lnSize, lcStyle

** DESCRIPTION: Determines the width of a pCal window in terms of the window's
**              new font/size/style.
** PARAMETERS : lcFont  = Font face to use.
**              lnSize  = Font size in points to use.
**              lcStyle = Font style to use.
** RETURNS    : lnRetVal -> Width of the window in Foxels.

private LNLINWD                                  &&
private LNNUMBW                                  &&
private LNRETVAL                                 &&
private LNSPACEW                                 &&
*-

lnNumbW   = txtwidth("9",lcFont, lnSize, lcStyle)
lnSpaceW  = txtwidth(space(1), lcFont, lnSize, lcStyle)
lnLinWd   = p_Pix2Fox(2, lcFont, lnSize, lcStyle)

lnRetVal  = ;
  4*lnLinWd + ;
  (2*COL_BORDER*lnSpaceW)+ ;
  (6*lnSpaceW) + ;
  (14*lnNumbW)

return lnRetVal

*- eop - p_WinWidth()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_WINHEIGHT
*!
*!      Called by: P_CALWIN()         (function in PCAL.PRG)
*!               : P_RESIZE()         (function in PCAL.PRG)
*!
*!          Calls: P_PIX2FOX()        (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_WinHeight
parameters lcFont, lnSize, lcStyle

** DESCRIPTION: Determines the height of a pCal window in terms of the window's
**              new font/size/style.
** PARAMETERS : lcFont  = Font face to use.
**              lnSize  = Font size in points to use.
**              lcStyle = Font style to use.
** RETURNS    : lnRetVal -> height of the window in Foxels.

private LNLINHT                                  &&
private LNRETVAL                                 &&
*-

lnLinHt  = p_Pix2Fox(2, lcFont, lnSize, lcStyle, .t.)
lnRetVal = ROW_DATES+7+2*lnLinHt

return lnRetVal

*- eop - p_WinHeight()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_WINVPIX
*!
*!      Called by: P_RESIZE()         (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_WinVPix
parameters lnRows, lcFont, lnSize, lcStyle

** DESCRIPTION: Determines the height of a window in pixels based on the
**              passed in number of rows and font specs.
** PARAMETERS : lnRows  = Number of rows.
**              lcFont  = Font face to use.
**              lnSize  = Font size in points to use.
**              lcStyle = Font style to use.
** RETURNS    : lnRetVal -> Height of the pCal window in pixels.

private LLBORDER                                 &&
private LLTITLE                                  &&
private LNRETVAL                                 &&
*-

llTitle  = (slWFloat .or. slWMin .or. !empty(scWTitle))
llBorder = slWGrow

lnRetVal = ;
  iif(llTitle, sysmetric(9), 0) + ;
  iif(llBorder, 2*sysmetric(4),0) + ;
  lnRows*(fontmetric(1,lcFont, lnSize, lcStyle) + ;
  fontmetric(4,lcFont, lnSize, lcStyle) + ;
  fontmetric(5,lcFont, lnSize, lcStyle))

return lnRetVal

*- eop - p_WinVPix()

*------------------------------------------------------------------------------
*!*****************************************************************************
*!
*!       Function: P_WINHPIX
*!
*!      Called by: P_RESIZE()         (function in PCAL.PRG)
*!
*!*****************************************************************************
function p_WinHPix
parameters lnCols, lcFont, lnSize, lcStyle

** DESCRIPTION: Determines the width of a window in pixels based on the
**              passed in number of columns and font specs.
** PARAMETERS : lnCols  = Number of columns.
**              lcFont  = Font face to use.
**              lnSize  = Font size in points to use.
**              lcStyle = Font style to use.
** RETURNS    : lnRetVal -> Width of the pCal window in pixels.

private LLBORDER                                 &&
private LNRETVAL                                 &&
*-

llBorder = slWGrow

lnRetVal = ;
  iif(llBorder, 2*sysmetric(3),0) + ;
  lnCols*(fontmetric(6,lcFont, lnSize, lcStyle) + ;
  fontmetric(18,lcFont, lnSize, lcStyle))

return lnRetVal

*- eop - p_WinHPix()

*------------------------------------------------------------------------------

*: EOF: PCAL.PRG
