;Downloads .Net 4.5 Framework if it isn't installed.
;Based on code found at: http://priyank.co.in/install-dot-net-framework-using-inno-setup

[Files]
Source: isxdl.dll; DestDir: {tmp}; Flags: deleteafterinstall

[Code]
var
    dotnetRedistPath: string;
    downloadNeeded: boolean;
    dotNetNeeded: boolean;
    needRestartFlag : boolean;

procedure isxdl_AddFile(URL, Filename: PChar);
external 'isxdl_AddFile@files:isxdl.dll stdcall';
function isxdl_DownloadFiles(hWnd: Integer): Integer;
external 'isxdl_DownloadFiles@files:isxdl.dll stdcall';
function isxdl_SetOption(Option, Value: PChar): Integer;
external 'isxdl_SetOption@files:isxdl.dll stdcall';

const
 	dotnetfx45full_url = 'http://download.microsoft.com/download/b/a/4/ba4a7e71-2906-4b2d-a0e1-80cf16844f5f/dotnetfx45_full_x86_x64.exe';
 	dotnetfx45full = 'dotnetfx45_full_x86_x64.exe';
  dotNet45RegKey = 'SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full';

function InitializeSetup(): Boolean;
var
  Version: Cardinal;
begin
  Result := true;
  dotNetNeeded := true;
  needRestartFlag := false;

  // Check for required netfx installation
  if (RegValueExists(HKLM, dotNet45RegKey, 'Release')) then
  begin
    RegQueryDWordValue(HKLM, dotNet45RegKey, 'Release', Version);
    if(Version >= 378389) then
    begin
      dotNetNeeded := false;
      downloadNeeded := false;
    end;
  end;

  if(dotNetNeeded) then
  begin
    if (not IsAdminLoggedOn()) then
    begin
      MsgBox('The Microsoft .NET Framework needs to be installed by an Administrator.', mbError, MB_OK);
      Result := false;
    end
	else
    begin
        begin
          dotnetRedistPath := ExpandConstant('{tmp}{\}') + dotnetfx45full;
          isxdl_AddFile(dotnetfx45full_url, dotnetRedistPath);
        end
        downloadNeeded := true;
    end;
  end;
end;

function NextButtonClick(CurPage: Integer): Boolean;
var
  hWnd: Integer;
  ResultCode: Integer;
begin
  Result := true;

  if CurPage = wpReady then
    begin
      hWnd := StrToInt(ExpandConstant('{wizardhwnd}'));

    // don't try to init isxdl if it's not needed because it will error on < ie 3
      if (downloadNeeded) then
        begin
          isxdl_SetOption('label', 'Downloading Microsoft .NET 4.5 Framework');
          isxdl_SetOption('description', 'Please wait while setup installs the Microsoft .NET 4.5 Framework.');
          if isxdl_DownloadFiles(hWnd) = 0 then Result := false;
        end;
      if (Result = true) and (dotNetNeeded = true) then
        begin
          if Exec(ExpandConstant(dotnetRedistPath), '/passive /norestart', '', SW_SHOW, ewWaitUntilTerminated, ResultCode) then
            begin
              // handle success if necessary; ResultCode contains the exit code
              // MSI Deferred boot code 3010 is a success
              if (ResultCode = 3010) then
                begin
                  ResultCode := 0;
                  needRestartFlag := true;
                end;
              if not (ResultCode = 0) then
                begin
                  Result := false;
                end;
            end
          else
            begin
              // handle failure if necessary; ResultCode contains the error code
              Result := false;
            end;
        end;
    end;
end;

function NeedRestart() : Boolean;
begin
  Result := false;
  if (dotNetNeeded) then
  begin
    Result := needRestartFlag;
  end;
end;