#INCLUDE WCONNECT.H

SET PROCEDURE TO wwHTTP ADDITIVE
SET PROCEDURE TO wwUtils additive

#IF .F.
clear
SET STRICTDATE TO 0

*** AUTHORIZE.NET TEST OPERATION
o=CREATEOBJECT("wwAuthorizeNet")

o.cHTTPLink = "https://secure.authorize.net/gateway/transact.dll"
o.cReferringUrl = "https://www.west-wind.com/wwstore/orderform.wws"

o.cStoreName = "YOURSTORE01"

o.cOrderId = "TestOrder" + SYS(2015)

o.nOrderAmount = .11
o.cCardNo = "3722 2213111 91009"
o.cSecurityCode = "6311"

o.cCardExpiration = "08/2008"

*o.cCardMonth = "12"
*o.cCardYear = "2002"
? o.cCardMonth,o.cCardYear

o.cAddress = "North Bounty Road #1"
o.cZip = "94121"

o.cFirstName = "Frederik"
o.cLastName = "Strahl"

lnSecs = SECONDS()
llCCResult = o.ValidateCard()

IF o.lError && Hard Error 
   ? "Error: ",o.cErrorMsg
   RETURN
ENDIF

? "Seconds: ", SECONDS() - lnSecs
? "Validated Result : " ,o.cValidatedResult
? "Validated Message: " ,o.cValidatedMessage
? "Full Result: ",o.cHTTPResult

RETURN

#ENDIF

#IF .F.
clear
SET STRICTDATE TO 0

*** ACCESS POINT TEST OPERATION
o=CREATEOBJECT("wwAccessPoint")

o.cHTTPLink = "https://secure1.merchantmanager.com/apcgateway/ccgateway.asp"
*o.cServer = "secure1.merchantmanager.com"
o.cReferringUrl = "https://www.west-wind.com/wwstore/orderform.wws"

o.cStoreName = "storename_here"

o.cOrderId = "TestOrder" + SYS(2015)

o.nOrderAmount = 1.00
o.cCardNo = "5490 0000 0000 00000"

lcExp = "01/2002"
o.cCardExpiration = "01/2002"
*o.cCardMonth = "12"
*o.cCardYear = "2002"
? o.cCardMonth,o.cCardYear

o.cAddress = "32 Kaiea"
o.cZip = "96779"

o.cName = "Frederik Strahl"

lnSecs = SECONDS()
llCCResult = o.ValidateCard()
IF o.lError && Hard Error 
   ? "Error: ",o.cErrorMsg
   RETURN
ENDIF

? "Seconds: ", SECONDS() - lnSecs
? "Validated Result : " ,o.cValidatedResult
? "Validated Message: " ,o.cValidatedMessage
? "Full Result: ",o.cHTTPResult

RETURN

#ENDIF


#IF .F.
*** LINKPOINT / CLEAR COMMERCE TEST TRANSACTION
LOCAL oCC as wwLinkPoint
*** LINKPOINT TEST TRANSACTION
oCC=create("wwLinkPoint")

*** Optionally log transactions and errors
oCC.cLogFile = "d:\ccLinkpointLog.txt"

oCC.cServer = "staging.linkpt.net"
oCC.nPort = 1129   && Make sure you set this!

*** Point at your .PEM file
oCC.cCertificate = sys(5) + curdir() + "wwStore\LinkPointTest.pem"

*** Run Test Transaction
oCC.lTestTransaction = .T.

*** You can optionally run a PreAuth only 
oCC.lPreAuthOnly = .F.

*** Provide your Identity
oCC.cStorename = "1909103575"  &&& Store number
oCC.cStorePassword = "12345678"

*** Provide contact info   
oCC.cName = "Joe Doe"   && or cFirstName/cLastName
oCC.cCompany = "Test Company"
oCC.cAddress = "123 Noit Road"
oCC.cCity = "concord"
oCC.cState = "CA"
oCC.cZip = "94512"
oCC.cEmail = "test@loser.com"

oCC.nOrderAmount = 1.50   && negative number for credits

oCC.cCardNo = "4111 1111 1111 1112"
oCC.cCardExpiration = "07/2005"   && cExpYear,cExpMonth

*** Do it 
llResult = oCC.ValidateCard()

IF llResult 
   ? oCC.cValidatedResult  && APPROVED
ELSE
   ? oCC.cValidatedResult   && FAILED or DECLINED
   ? oCC.cValidatedMessage   && Provider Message
   ? oCC.cErrorMsg          && True error message (includes system errors)
ENDIF

*** Display the full Response returned from LinkPoint
ShowText( oCC.cHttpRESULT )

RETURN
#ENDIF


*************************************************************
DEFINE CLASS wwCCProcessing AS Custom
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2000
*:Contact: http://www.west-wind.com
*************************************************************

cStoreName = ""  && Store number
cStorePassword = ""

cHTTPLink = ""      && HTML Terminal link
cServer = ""
nPort = 0
nTimeout = 120

cHTTPResult = ""		&& Result of request
cXMLInput = ""			&& XML Input for request
cValidatedResult = ""	&& HTML Terminal customized result
cValidatedMessage = ""           && Full parsed result message


nOrderAmount = 0.00
nTaxAmount = 0.00

cOrderId = SYS(2015)
cName = ""				&& Required
cFirstname = ""
cLastName = ""
cCompany = ""

cAddress = ""
cAddress2 = ""
cCity = ""
cState = ""
cZip = ""
cCountryCode = ""				
cCountry = ""

cPhone = ""
cEmail = ""				&& Required
cFax = ""				

cCardNo = ""				&& Credit Card Number
cCardExpiration = ""		&& Expiration date in MM/YY format
cSecurityCode = ""

*** Used for HTML which works with hex numbers
nCardYear = 0
nCardMonth = 0

*** Used with API which uses strings
cCardYear = "00"			&& Two digit year!
cCardMonth = "00"

cCardType = ""				&& VI, MA, AE, DI (required only for HTML)
cComments = ""				&& Order comments

lTestTransaction = .F.      && API Test Transaction

cReferringUrl = "https://www.west-wind.com/wwstore/orderform.wws"

cErrorMsg = ""
lError = .F.

cLogFile = ""


FUNCTION cName_Access

IF EMPTY(this.cName)
   this.cName = TRIM(THIS.cFirstName) + " "  + TRIM(this.cLastname)
ENDIF

RETURN this.cName
ENDFUNC



************************************************************************
* wwCCProcessing :: SetError
*********************************
***  Function: Sets the error flag and error message
***      Pass: lcErrorMsg   -  Error Message to set
***                            No parameter means clear errors
***    Return: nothing
************************************************************************
PROTECTED FUNCTION SetError
LPARAMETER lcErrorMsg
IF PCOUNT()=0
   THIS.lError = .F.
   THIS.cErrorMsg = ""
   RETURN
ENDIF   

THIS.lError = .T.
THIS.cErrorMsg = lcErrorMsg

THIS.LogTransaction(THIS.cCompany + ", " + THIS.cName + " - " + ;
         LEFT(this.cCardNo,4) + " **** **** " + RIGHT(this.cCardNo,4) + ;
         " - " + this.cValidatedResult + ": " + lcErrorMsg )

RETURN
* LinkPoint :: SetError


************************************************************************
* wwCCProcessing :: ValidateCard
*********************************
***  Function: Abstract method that handles processing credit
***            cards.
************************************************************************
FUNCTION ValidateCard
RETURN .T.
ENDFUNC
* wwCCProcessing :: ValidateCard



************************************************************************
* wwCCProcessing :: LogTransaction
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION LogTransaction(lcLogString)

IF EMPTY(lcLogString)
   lcLogString = "Nothing to log."
ENDIF

IF EMPTY(THIS.cLogFile)
   RETURN .T.
ENDIF

lhFile = FOPEN(this.clogfile,2)
IF lhFile = -1
   lhFile = FCREATE(this.cLogFile)
   IF lhFile = -1
	   RETURN .F.
   ENDIF
ENDIF
FSEEK(lhFile,0,2)
FPUTS(lhFile,TTOC(DATETIME()) + CHR(9) + lcLogString)
FCLOSE(lhFile)

ENDFUNC
*  wwCCProcessing :: LogTransaction

************************************************************************
* wwCCProcessing :: cCardExpiration_Assign
******************************************
***  Function: Converts a character date from mmyy format of any kind
***            into MM/YYYY. Any invalid dates return ""
***      Pass: Input Date in character format
***    Return: mm/yyyy formatted date
*************************************************************************
FUNCTION cCardExpiration_Assign
LPARAMETER lcExp

IF EMPTY(lcExp)
   lcExp = THIS.cCardExpiration
ENDIF   
   
lnYear = INT(VAL(Right(lcExp,4)))
lnMonth = INT(VAL(LEFT(lcExp,2)))
THIS.cCardMonth = PADL(lnMonth,2,"0")
THIS.cCardYear = PADL(lnYear,4,"0")

*** Full date string must be in double digits not 4 digits
lnYear = INT(VAL(Right(lcExp,2)))

lcDate = PADL(lnMonth,2,"0") + "/" + PADL(lnYear,2,"0")
IF lnMonth = 0  
   THIS.cCardExpiration = ""
   RETURN ""
ENDIF

lnCurYear = Year(Date())
lnCurMonth = Month(Date())

IF lnYear > 90
  lnYear = 1900 + lnYear
ELSE
  lnYear = 2000 + lnYear
ENDIF    

IF lnYear > lnCurYear
   THIS.cCardExpiration = lcDate
   RETURN lcDate
ENDIF

IF lnYear < lnCurYear
   THIS.cCardExpiration = ""
   RETURN ""
ENDIF

IF lnMonth < lnCurMonth
   THIS.cCardExpiration = ""
   RETURN ""
ENDIF   

THIS.cCardExpiration = lcDate

RETURN lcDate
* cCardExpiration_Assign

ENDDEFINE
* Class wwCCProcessing



*************************************************************
DEFINE CLASS wwAccessPoint AS wwCCProcessing
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2000
*:Contact: http://www.west-wind.com
*************************************************************

cHTTPLink = "ccgateway.asp"
cServer = "secure1.merchantmanager.com"
nTimeout = 120

*** Required on the server so it can verify where you're coming from
*** Note: that this is a useless security feature since you can
***       fake it here.
cReferringUrl = "https://www.west-wind.com/orderform.wws"


************************************************************************
* wwAccessPoint :: ValidateCard
*********************************
***  Function: This method validates a card with AccessPoint's
***    Assume: AccessPoint doesn't support Credits
***      Pass: Optional preconfigured wwHTTP object
***    Return: .T. or .F.
***            cValidatedResult
***            cValidatedMessage
***            cErrorMsg
************************************************************************
FUNCTION ValidateCard
LPARAMETERS loIP
LOCAL llResult, lnResult, loIP, lcData, lnSize, ;
	lcApproved,	lcHeader

*** AccessPoint doesn't support Credits
IF THIS.nOrderAmount < 0 
   THIS.cValidatedResult = "FAILED"   
   THIS.SetError("Credits are not supported through the AccessPoint API")
   RETURN .F.
ENDIF

IF VARTYPE(loIP) # "O"
	loIP = CREATEOBJECT("wwHTTP")
	loIP.nConnectTimeout = this.nTimeout  && Make sure we wait! Let the server fail!
	*loIP.nHTTPServiceFlags =  INTERNET_FLAG_IGNORE_CERT_DATE_INVALID 
	loIP.nHTTPConnectType = 0
ENDIF


lnResult = loIP.HTTPConnect(THIS.cServer,,,.T.)
IF lnResult # 0
   THIS.cValidatedResult = "FAILED"   
   THIS.SetError(loIP.cErrorMsg)
   RETURN .F.
ENDIF

lcCardNo = CHRTRAN(THIS.cCardNo," -/._#","")

loIP.AddPostKey("REQUESTTYPE","APPROVALONLY")

*** Note: Credits are not supported through the API at this time
loIP.AddPostKey("TRANSTYPE",IIF(THIS.nOrderAmount < 0,"CREDIT","SALE"))

loIP.AddPostKey("MERCHANTID",THIS.cStoreName)
loIP.AddPostKey("AMOUNT",TRANSFORM(ABS(THIS.nOrderAmount)))
loIP.AddPostKey("BNAME",THIS.cName)
loIP.AddPostKey("BCOMPANY",THIS.cCompany)
loIP.AddPostKey("CCNUMBER",lcCardNo)
loIP.AddPostKey("EXPMO",THIS.cCardMonth)
loIP.AddPostKey("EXPYE",THIS.cCardYear)   
loIP.AddPostKey("BADDRESS1",THIS.cAddress)
loIP.AddPostKey("BCITY",THIS.cCity)
loIP.AddPostKey("BSTATE",THIS.cState)
loIP.AddPostKey("BZIPCODE",THIS.cZip)
loIP.AddPostKey("BCountry",THIS.cCountry)
loIP.AddPostKey("BEMAIL",THIS.cEmail)

loIP.AddPostKey("INVOICENO",THIS.cOrderID)

lcData = ""
lnSize = 0

*** Referring Url is required for AccessPoint API
loIP.AddHeader("Referer",this.cReferringUrl)

lnResult = loIP.HTTPGetEx(THIS.cHTTPLink,@lcData,@lnSize)
IF lnResult # 0
   THIS.cValidatedResult = "FAILED"   
   THIS.SetError(loIP.cErrorMsg)
   RETURN .F.
ENDIF

THIS.cHTTPResult = "&" + lcData + "&"

lcApproved = GetUrlEncodedKey(THIS.cHTTPResult,"approved")
THIS.cValidatedMessage = GetUrlEncodedKey(THIS.cHTTPResult,"Msg")
IF EMPTY(THIS.cValidatedMessage)
   THIS.cValidatedMessage = STRTRAN(THIS.cHttpResult,"&","")
ENDIF

llResult = .T.
IF lcApproved = "Y"
   THIS.cValidatedResult = "APPROVED"
ELSE
   *** This needs work
   THIS.cValidatedResult = "DECLINED"   
   llResult = .F.
ENDIF

THIS.LogTransaction(THIS.cCompany + ", " + THIS.cName + CHR(9) + THIS.cValidatedResult + CHR(9) + UrlDecode(lcData))

RETURN llResult
ENDFUNC

ENDDEFINE
* Class wwAccessPoint

*************************************************************
DEFINE CLASS wwPayFlowPro AS wwCCProcessing
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2001
*:Contact: http://www.west-wind.com
*:Created: 11/20/2001
*************************************************************

cServer = "payflow.verisign.com"
cTestServer = "test-payflow.verisign.com"
nPort = 443

nTimeout = 40

************************************************************************
* wwPayFlowPro :: ValidateCard
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ValidateCard()
LOCAL  loEval
PRIVATE loPF

THIS.lError = .F.
THIS.cErrorMsg = ""

IF THIS.nOrderAmount < 0 
   *** Credit
   lcParms = "TRXTYPE=C"
   THIS.nOrderAmount = THIS.nOrderAmount * -1
ELSE
   *** Sale
   lcParms = "TRXTYPE=S"
ENDIF

lcCardNo = CHRTRAN(THIS.cCardNo," -/:","")

lcParms = lcParms +  "&TENDER=C" + ;
                     "&ACCT=" + lcCardNo + ;
                     "&COMMENT1=" + THIS.cComments + ;
                     "&PWD=" + THIS.cStorePassword + ;
                     "&VENDOR=" + THIS.cStoreName  +;
                     "&USER=" + THIS.cStoreName  +;
                     "&PARTNER=Verisign" + ;
                     "&AMT=" + TRANSFORM( THIS.nOrderAmount ) + ;
                     "&EXPDATE=" + THIS.cCardMonth + RIGHT(THIS.cCardYear,2) + ;
                     "&STREET=" + THIS.cAddress + ;
                     "&CITY=" + THIS.cCity + ;
                     "&STATE=" + THIS.cState + ;
                     "&ZIP=" + THIS.cZIP + ;
                     "&EMAIL=" + THIS.cEmail

IF THIS.lTestTransaction
  *** Use 
  THIS.cServer = THIS.cTestServer
ENDIF

loPF = CreateObject("PFProCOMControl.PFProCOMControl.1")
lnContext = loPF.CreateContext(THIS.cServer,THIS.nPort,THIS.nTimeout,"",0,"","")


loEval = CREATEOBJECT("wwEval")
THIS.cHTTPResult = loEval.Evaluate("loPF.SubmitTransaction(lnContext, lcParms, Len(lcParms))")
loPF.DestroyContext (lnContext)


lcResult = ""
IF loEval.lError
  AERROR(laError)
  IF TYPE("laError[1,3]") = "C"
     THIS.cHTTPResult = laError[1,3]   && COM exception error
  ELSE
     THIS.cErrorMsg = "Error: Connecting to server." + CHR(13) + ;
                      loEval.cErrorMessage
     RETURN .F.
  ENDIF
ENDIf

lcResult = GetURLEncodedKey(THIS.cHTTPResult,"RESULT")

DO CASE
  CASE lcResult == "0"
    THIS.cValidatedResult = "APPROVED"
    RETURN .T.
  CASE EMPTY(lcResult)
    THIS.cValidatedResult = "FAILED"
    THIS.cErrorMsg = "Unknown Error"
    RETURN .F.
  CASE lcResult = "-"   && Communication Error
    THIS.cValidatedResult = "FAILED"
    THIS.cErrormsg = GetUrlEncodedKey(THIS.cHTTPResult,"RESPMSG")
    RETURN .F.
  OTHERWISE
     *** DECLINED
     THIS.cValidatedResult = "DECLINED"
     THIS.cErrormsg = GetUrlEncodedKey(THIS.cHTTPResult,"RESPMSG")
     RETURN .F.
ENDCASE

*File2Var("ccresult.txt",THIS.cHTTPResult)

ENDFUNC
*  wwPayFlowPro :: ValidateCard


ENDDEFINE
*EOC wwPayFlowPro 


*************************************************************
DEFINE CLASS wwAuthorizeNet AS wwCCProcessing
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2004
*:Contact: http://www.west-wind.com
*:Created: 10/12/2004
*************************************************************
#IF .F.
*:Help Documentation
*:Topic:
Class wwAuthorizeNet

*:Description:
Handles Credit Card Validation for Authorize.NET

*:ENDHELP
#ENDIF

*** Custom Properties
cHTTPLink = "https://secure.authorize.net/gateway/transact.dll"

*** Stock Properties

************************************************************************
* wwAuthorizeNet :: ValidateCard
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ValidateCard(loHTTP)
LOCAL lcCardNo

IF VARTYPE(loHTTP) # "O"
   loHTTP = CREATEOBJECT("wwHTTP")
   loHTTP.nConnectTimeout = this.nTimeout  && Make sure we wait! Let the server fail!
   *loIP.nHTTPServiceFlags =  INTERNET_FLAG_IGNORE_CERT_DATE_INVALID 
   loHTTP.nHTTPConnectType = 0
ENDIF

lcCardNo = CHRTRAN( this.cCardNo,"[ -/._#]","")

loHttp.AddPostKey("x_version","3.1")
loHttp.AddPostKey("x_method","CC")
loHttp.AddPostKey("x_delim_data","True")
loHttp.AddPostKey("x_password",this.cStorePassword)
loHttp.AddPostKey("x_login",this.cStoreName)

if (this.lTestTransaction) 
   loHttp.AddPostKey("x_test_request","True")
ENDIF
         
if (this.nOrderAmount >= 0)
   loHttp.AddPostKey("x_type","AUTH_CAPTURE")
else
   loHttp.AddPostKey("x_type","CREDIT")
ENDIF

loHttp.AddPostKey("x_amount",TRANSFORM(this.nOrderAmount))
if (this.nTaxAmount > 0.00) 
   this.Http.AddPostKey("x_tax",TRANSFORM(this.nTaxAmount))
ENDIF

loHttp.AddPostKey("x_card_num",lcCardNo)
loHttp.AddPostKey("x_exp_date",this.cCardMonth + "-" + ;
                                 this.cCardYear )
  
if (!EMPTY(this.cSecurityCode) )
   loHttp.AddPostKey("x_card_code",this.cSecurityCode)
ENDIF

loHTTP.AddPostKey("x_first_name",this.cFirstname)
loHTTP.AddPostKey("x_last_name",this.cLastname)
loHTTP.AddPostKey("x_company",this.cCompany)
loHTTP.AddPostKey("x_address",this.cAddress)
loHTTP.AddPostKey("x_city",this.cCity)
loHTTP.AddPostKey("x_state",this.cState)
loHTTP.AddPostKey("x_zip",this.cZip)
loHTTP.AddPostKey("x_country",this.cCountry)

IF ( EMPTY(this.cPhone) )
   loHTTP.AddPostKey("x_phone",this.cPhone)
ENDIF

loHTTP.AddPostKey("x_email",this.cEmail)

loHTTP.AddPostKey("x_invoice_num",this.cOrderId)
loHTTP.AddPostKey("x_description",this.cComments)

*** Must add the Refering URL!
*loHTTP.AddHeader("Referer",THIS.cReferringURL)

this.cHttpResult = loHTTP.HTTPGet(this.cHttpLink);

IF loHttp.nError # 0
   THIS.cValidatedResult = "FAILED"   
   THIS.SetError(loHttp.cErrorMsg)
   RETURN .F.
ENDIF

IF EMPTY( this.cHttpResult )
   THIS.cValidatedResult = "FAILED"   
   THIS.SetError("Invalid Result returned")
   RETURN .F.
ENDIF

*** Split Auth.NET response message - comma separated list
*** First char is error code, 4th is message
lnCount = ALINES(laResult,this.cHttpResult,3,",")

*** Failed Operation
DO CASE
CASE lnCount < 1
   THIS.cValidatedResult = "FAILED"   
   THIS.SetError("Invalid Result returned")
CASE laResult[1] = "3"
   *** Consider invalid card a DECLINE not a failure
   *** we want to send that back to the user
   IF ATC("Credit Card Number",laResult[4]) > 0
      this.cValidatedResult = "DECLINED"
   ELSE
      THIS.cValidatedResult = "FAILED"   
   ENDIF
   THIS.SetError(laResult[4])
   this.cValidatedMessage = laResult[4]
   RETURN .F.
CASE laResult[1] = "2" OR laResult = "4"
   THIS.cValidatedResult = "DECLINED"   
   THIS.SetError(laResult[4])
   this.cValidatedMessage = laResult[4]
   RETURN .F.
OTHERWISE
   this.cValidatedResult = "APPROVED"
ENDCASE

THIS.LogTransaction(THIS.cCompany + ", " + THIS.cName + " - " + ;
                    LEFT(this.cCardNo,4) + " **** **** " + RIGHT(this.cCardNo,4) + " - " +;
                    THIS.cValidatedResult)
   
RETURN !this.lError
ENDFUNC
*  wwAuthorizeNet :: ValidateCard


ENDDEFINE
*EOC wwAuthorizeNet 

*************************************************************
DEFINE CLASS wwLinkPoint AS wwccProcessing
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2005
*:Contact: http://www.west-wind.com
*:Created: 01/14/2005
*************************************************************
#IF .F.
*:Help Documentation
*:Topic:
Class ccLinkPoint

*:Description:

*:Example:

*:Remarks:

*:SeeAlso:


*:ENDHELP
#ENDIF

*** Custom Properties
*** Path of the Linkpoint Certificate issued to you
*** Typically a .PEM file provided by 
cCertificate = sys(5) + curdir() + "testcert.pem"

*** Foreign Country Address
c_Address = ""
c_City = ""
c_State = ""
c_Zip = ""

*** Overridden Properties
cServer = "secure.linkpt.net"
nPort = 1139

lPreAuthOnly = .F.

************************************************************************
* wwLinkPoint :: ValidateCard
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ValidateCard()
LOCAL llError

LOCAL loOrder as LpiCom_6_0.LPOrderPart
loOrder = CreateObject("LpiCom_6_0.LPOrderPart")
loOrder.setPartName("order")

LOCAL loOrderPart as LpiCom_6_0.LPOrderPart
loOrderPart = CreateObject("LpiCom_6_0.LPOrderPart")                

IF this.nOrderAmount < 0
   loOrderPart.put("ordertype", "CREDIT")
ELSE
   IF THIS.lPreAuthOnly
      loOrderPart.put("ordertype", "PREAUTH")
   ELSE
      loOrderPart.put("ordertype", "SALE")
   ENDIF
ENDIF   

IF THIS.lTestTransaction 
   *loOrderPart.put("result","DECLINE")
  loOrderPart.put("result","GOOD")
ENDIF

*** add orderoptions to order
loOrder.addPart("orderoptions", loOrderPart)

** Build 'merchantinfo'
loOrderPart.clear()
loOrderPart.put("configfile", this.cStoreName)

loOrder.addPart("merchantinfo", loOrderPart)

*** Build 'billing'
*** Required for AVS. If not provided, 
*** transactions will downgrade.
loOrderPart.clear()
loOrderPart.put("name",TRIM(this.cName))
loOrderPart.put("company",TRIM(this.cCompany))
loOrderPart.put("address1",MLINE(this.cAddress,1) )
loOrderPart.put("state",this.cState)
loOrderPart.put("zip", TRIM(this.cZip))
IF !EMPTY(this.cCountryCode)
   loOrderPart.put("country",this.cCountryCode)
ENDIF   
loOrderPart.put("email",this.cEmail)
loOrderPart.put("phone",this.cPhone)
loOrderPart.put("addrnum", TRANSFORM(INT(VAL(this.cAddress))))

loOrder.addPart("billing", loOrderPart)

*** Build 'creditcard'
loOrderPart.clear()
loOrderPart.put("cardnumber", this.cCardNo)
loOrderPart.put("cardexpmonth", this.cCardMonth)
loOrderPart.put("cardexpyear",RIGHT(this.cCardYear,2) )

IF !EMPTY(this.cSecurityCode)
   loOrderPart.put("cvmvalue",this.cSecurityCode)
   loOrderPart.put("cvmindicator","provided")
ENDIF

loOrder.addPart("creditcard", loOrderPart)

*** Build 'payment'
loOrderPart.clear()
loOrderPart.put("chargetotal", this.nOrderAmount)

loOrder.addPart("payment", loOrderPart)        

*** create transaction object   
LOCAL loTransaction as LpiCom_6_0.LinkPointTxn
loTransaction = CreateObject("LpiCom_6_0.LinkPointTxn")

       
*** get outgoing XML from 'order' object
this.cXMLInput = loOrder.toXML()

*** Send to LinkPoint
llError = .f.
TRY 
   resp = loTransaction.send( this.cCertificate, this.cServer, this.nPort, this.cXMLInput)
CATCH
   llError = .t.
ENDTRY

this.cHTTPResult = resp

*** Parse the response
this.cValidatedResult = EXTRACT(resp,"<r_approved>","</r_approved>")
this.cValidatedMessage =  Extract(resp,"<r_message>","</r_message>")

IF THIS.cValidatedResult # "APPROVED"
   this.SetError( Extract(resp,"<r_error>","</r_error>") )
   this.cValidatedMessage = this.cErrorMsg
ELSE
   this.lError = .f.
   this.cErrorMsg = ""
   this.cValidatedMessage = ""   
   THIS.LogTransaction(THIS.cCompany + ", " + THIS.cName + " - " + ;
         LEFT(this.cCardNo,4) + " **** **** " + RIGHT(this.cCardNo,4) + ;
         " - " + "APPROVED" )
ENDIF

RETURN !this.lError
ENDFUNC
*  wwLinkPoint :: ValidateCard


ENDDEFINE
*EOC ccLinkPoint 
 
*************************************************************
DEFINE CLASS wwClearCommerce AS wwCCProcessing
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2000
*:Contact: http://www.west-wind.com
*************************************************************

*** Custom Properties

*** Path of the Linkpoint Certificate issued to you
*** Typically a .PEM file provided by 
cCertificate = sys(5) + curdir() + "testcert.pem"

*** Foreign Country Address
c_Address = ""
c_City = ""
c_State = ""
c_Zip = ""

*** Overridden Properties
cServer = "secure.linkpt.net"
nPort = 1139

lPreAuthOnly = .F.

************************************************************************
* wwClearCommerce :: ValidateCard
*********************************
***  Function: Uses the ClearLink API via a small wrapper
***            DLL that can take XML input to validate a credit
***            card. Properties must be set to make this call
***            see example above).
***    Assume: Requires:
***            linkpointapi.dll  - in a FOX accessible path
***            yourcert.pem		 - Full path to the certificate file
***    Return: .T. or .F.
***            Error message in the .lError and .cErrorMsg properties
************************************************************************
FUNCTION ValidateCard
LOCAL lcXML, lcErrorMsg

*** Convert this object to XML
lcXML = THIS.ExportToXML()
THIS.cXMLInput = lcXML

*** Make sure our input buffer is big enough to hold result
IF LEN(lcXML) < 1024
   lcXML = PADR(lcXML,1024)
ENDIF

*** Call the DLL with the XML input
*** lcXML will be updated with the result data
DECLARE INTEGER ValidateCC ;
   IN LinkPointAPI.dll ;
   STRING @lcXML

IF ValidateCC(@lcXML) = 0
   THIS.SetError("Linkpoint API call failed.")
   RETURN .F.
ENDIF

lcXML  = STRTRAN(lcXML,CHR(0)," ")
THIS.cHTTPResult = lcXML

THIS.cValidatedResult = Extract(lcXML,"<approved>","</approved>")

*** ERror message or confirmation number
lcErrorMsg = Extract(lcXML,"<errormsg>","</errormsg>")

IF THIS.cValidatedResult = "FRAUD" or ;
   THIS.cValidatedResult = "FAILED" OR ;
   THIS.cValidatedResult = "DECLINED"
   THIS.cValidatedMessage = lcErrorMsg
   THIS.SetError(lcErrorMsg)
   RETURN .F.
ELSE
   THIS.cValidatedMessage = Extract(lcXML,"<resultcode>","</resultcode>")   
ENDIF

RETURN .T.
ENDFUNC
* EOF ValidateCardAPI
	
	
************************************************************************
* LinkPoint :: ValidateCardHTML
*********************************
***  Function: Validates a credit card using the Linkpoint 
***            HTML terminal by driving the code through wwHTTP.
***            
***    Assume: International orders must enter a US address to
***            pass fraud checks.
***    Return:
************************************************************************
FUNCTION ValidateCardHTML
LOCAL loIP, lcData, lnSize, lnResult

loIP=create("wwHTTP")
loIP.nConnectTimeout = 60

loIP.httpconnect(THIS.cServer,THIS.cStoreName,THIS.cStorePassword,.T.)

*<INPUT TYPE="hidden" NAME="2000" VALUE="00c3">
loIP.AddPostKey("2000","00c3")

IF EMPTY(THIS.cOrderID)
   THIS.cOrderID = SYS(2015)
ENDIF   
loIP.AddPostKey("2001",TRIM(THIS.cOrderId))

loIP.AddPostKey("2002",TRANS(THIS.nOrderAmount))

IF EMPTY(THIS.cCardType)
   DO CASE
      CASE LEFT(THIS.cCardNo,1) = "4"
        THIS.cCardType = "V"
      CASE LEFT(THIS.cCardNo,1) = "5"
        THIS.cCardType = "M"
      CASE LEFT(THIS.cCardno,1) = "3"
        THIS.cCardType = "A"
      OTHERWISE
         THIS.SetError("Invalid Card Number")
        RETURN .F.
   ENDCASE
ENDIF   
loIP.AddPostKey("201d",THIS.cCardType)  && Visa


loIP.AddPostKey("2003",THIS.cCardNo)

*** expiration date must be in hex format
IF THIS.nCardYear < YEAR( date() ) OR ;
   (THIS.nCardYear = Year( DATE() ) AND THIS.nCardMonth < MONTH( date() ))
   THIS.SetError("Invalid Expiration Year")
   RETURN
ENDIF   
loIP.AddPostKey("2004",RIGHT(TRANS(THIS.nCardMonth,"@0"),2))
loIP.AddPostKey("2005",RIGHT(TRANS(THIS.nCardYear,"@0"),4))  && Date in hex

loIP.AddPostKey("2006",THIS.cName)

IF EMPTY(THIS.cCountry)
	loIP.AddPostKey("2007",THIS.cAddress)
	loIP.AddPostKey("2008",THIS.cAddress2)

	loIP.AddPostKey("2009",THIS.cCity)
	loIP.AddPostKey("200a",TRIM(THIS.cState))
	loIP.AddPostKey("200b",TRIM(THIS.cZip))
ELSE
	loIP.AddPostKey("2007",THIS.c_Address)
	loIP.AddPostKey("2009",THIS.c_City)
	loIP.AddPostKey("200a",TRIM(THIS.c_State))
	loIP.AddPostKey("200b",TRIM(THIS.c_Zip))
ENDIF

loIP.AddPostKey("200c",TRIM(THIS.cPhone))  && Home
loIP.AddPostKey("200d",THIS.cFax)  && Fax

loIP.AddPostKey("200e",TRIM(THIS.cEmail))

loIP.AddPostKey("200f",THIS.cComments)

loIP.AddPostKey("Submit","Submit")

lcData = ""
lnSize = 0


IF EMPTY(THIS.cHTTPLink)
   THIS.cHTTPLink = "/admin/" + THIS.cStoreName +  "/vlp"
ENDIF   
lnResult = loIP.HTTPGetEx(THIS.cHTTPLink,@lcData,@lnSize)

IF lnResult # 0
   THIS.SetError(loIP.cErrorMsg)
   RETURN .F.
ENDIF   

THIS.cHTTPResult = lcData

*** Parse as we need
RETURN THIS.OnValidateDone(lcData)
ENDFUNC
* LinkPoint :: ValidateCard	


************************************************************************
* LinkPoint :: OnValidateDone
*********************************
***  Function: Event fired when the HTML terminal piece is complete.
***            Exists to allow you to parse the result HTML and
***            retrieve the relevant code. Default implementation
***            just grabs the validation portion of the HTML table.
***      Pass: HTML result
***    Return: .T. or .F.
************************************************************************
FUNCTION OnValidateDone
LPARAMETER lcData
*** Just capture the HTML result
THIS.cValidatedResult = SUBSTR(lcData,RATC("<table",lcData))
IF EMPTY(THIS.cValidatedResult)
   THIS.cValidatedResult = THIS.cHTTPResult
ENDIF
RETURN .T.
ENDFUNC
* LinkPoint :: OnValidateDone



************************************************************************
* LinkPoint :: ExportToXML
*********************************
***  Function: Dumps the current object to XML.
***    Assume: requires wwXML
***    Return: XML of the object
************************************************************************
FUNCTION ExportToXML
LOCAL loXML

loXML = CREATE("wwXML")
loXML.cDocrootname = "linkpoint"
loXML.lStripTypePrefix = .T.

RETURN loXML.ObjectToXML(THIS)
ENDFUNC
* LinkPoint :: ExportToXML

ENDDEFINE

************************************************************************
*** Support functions
************************************************************************

************************************************************************
PROCEDURE ccCheck
******************
***  Modified: 06/19/96
***  Function: Checks whether a credit card number is valid.
***            MOD 10 CHECK
***      Pass: lcCardNumber
***    Return: .t. or .f.
*************************************************************************
LPARAMETER lcCardNumber
LOCAL lnCheckDigit, lnSize, lnDigit, x, lnResult, lnWeight

lcCardnumber=IIF(type("lcCardnumber")="C",lcCardnumber,"")

*** Strip out bad characters
lcCardnumber=CHRTRAN(TRIM(lower(lcCardnumber))," ,-/\.:abcdefghijklmnopqrstvuxyz","")

lnSize=LEN(lcCardNumber)

lnCheckDigit=RIGHT(lcCardNumber,1)
IF !ISDIGIT(lnCheckDigit)
   RETURN .F.
ENDIF
lnCheckDigit=VAL(lnCheckDigit)

lnResult=0
lnWeight=2  && Alternating Number Weight start with 2

*** Read digits Backwards from second last to first digit
FOR x=lnSize-1 TO 1 STEP -1
    lnDigit=SUBSTR(lcCardNumber,x,1)

    *** Multiply times the weight (1 or 2)
    lnDigit=VAL(lnDigit) * lnWeight

    *** Add to total counter
    IF lnDigit > 9
       *** Digits need to be added
       *** Example: 11 = 1+1 = 1 + 11 - 10  = 2
       ***          15 = 1+5 = 1 + 15 - 10  = 6
       lnResult= lnResult + 1 + lnDigit - 10
    ELSE
       lnResult = lnResult + lnDigit 
    ENDIF
    
    *** Weights alternate
    IF lnWeight=1
       lnWeight=2
    ELSE
       lnWeight=1
    ENDIF
ENDFOR && x=lnSize-1 TO 1

*** Mod 10 value
lnResult=lnResult % 10

*** Subtract the value from 10 - should match last digit
IF (10 - lnResult=lnCheckDigit) OR (lnCheckdigit=0 AND lnResult=0)
   RETURN .T.
ENDIF

RETURN .F.


************************************************************************
PROCEDURE ccCardType
********************
***  Modified: 09/01/96
***  Function: Checks for the validity of the credit card types
***            based on the beginning digits of the card.
***      Pass: lcCardNum   -
***            lcCardType  -
***    Return:
*************************************************************************
LPARAMETER lcCardNum, lcCardType

DO CASE
   CASE lcCardType="V" and lcCardNum="4"
      RETURN .T.
   CASE lcCardType="M" and lcCardNum>="51" and lcCardNum<="55"
      RETURN .T.
   CASE lcCardType="A" and lcCardNum>="34" and lcCardNum<="37"
      RETURN .T.
   CASE lcCardType="D" and lcCardNum="6011"
      RETURN .T.
ENDCASE

RETURN .F.


