SET PROCEDURE TO wwUtils ADDITIVE
SET PROCEDURE TO wwapi additive
SET PROCEDURE TO Rss2Feed ADDITIVE

#DEFINE CRLF CHR(13) + CHR(10)
#if .F.
LOCAL o as Rss2Feed
o = CREATEOBJECT("Rss2Feed")
o.cRss2Url = 'http://www.west-wind.com/Westwindnews.rss.xml'
** o.cRss2Url = 'http://west-wind.com/WebLog/Rss.aspx'
o.ReadItems()
SET STEP ON 
ShowHtml( o.ToHtml() )

SET STEP ON 
#ENDIF

*************************************************************
DEFINE CLASS RSS2Feed AS Custom
*************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 2004
*:Contact: http://www.west-wind.com
*:Created: 05/02/2004
*:  
*: Description:
*: Creates a collection of news items from an RSS 2.0 feed.
*: 
*************************************************************

cRss2Url = ""

*** Item Collection
oItems = null

*** Channel details
oChannelInfo = null

oXML = null

FUNCTION Init
this.oItems = CREATEOBJECT("Collection")
ENDFUNC

************************************************************************
* RSS2Feed :: ReadItems
****************************************
***  Function: Reads the news items into the oItems collection
***    Assume: Note: ChannelInfo is not loaded
***      Pass:
***    Return:
************************************************************************
FUNCTION ReadItems() as Integer
LOCAL lnX, loRss

this.oItems = CREATEOBJECT("Collection")
lnX = 0

IF (!this.LoadFeed())
   RETURN -1
ENDIF

loItems = this.oXML.DocumentElement.selectNodes(".//item")

FOR EACH loItem IN loitems
   loRss = This.GetNewRssItem()
   
   loRss.Title = loItem.SelectSingleNode("title").Text
   
   loRss.Description = this.GetItem(loItem,"description")
   loRss.Url = this.GetItem(loItem,"link")
   loRss.CommentUrl = this.GetItem(loItem,"comments")
   loRss.TrackBackUrl = this.GetItem(loItem,"trackback:ping")
   loRss.Author = this.GetItem(loItem,"author") 
   loRss.pubDate = this.GetItem(loItem,"pubDate")
   loRss.pubDate = MimeDateTime(loRss.PubDate,.T.) && Convert to T
   loRss.Pk = SYS(2015)   
   this.oItems.Add(loRss)
   lnX = lnX + 1 
ENDFOR

RETURN lnX


************************************************************************
* RSS2Feed :: GetChannelInfo
****************************************
***  Function: Reads the Channel information from the internal XML data
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION GetChannelInfo() as Boolean
LOCAL loChannel

IF (!this.LoadFeed())
   RETURN .f.
ENDIF

loChannel = this.oXML.DocumentElement.ChildNodes.Item(0)

loProps = this.GetNewChannel()
loProps.title = this.GetItem(loChannel,"title")
loProps.description  = this.GetItem(loChannel,"description")
loProps.link = this.GetItem(loChannel,"link")
loProps.rssUrl = this.crss2Url
loProps.lastBuildDate = this.GetItem(loChannel,"lastBuildDate")
loProps.LastBuilddate = MimeDateTime( loProps.LastBuildDate,.t.)
loProps.language = this.GetItem(loChannel,"language")

this.oChannelInfo = loProps
RETURN .T.
ENDFUNC
*  RSS2Feed :: GetChannelInfo




************************************************************************
* RSS2Feed :: GetRssItem
****************************************
***  Function: Factory method for a new RSS Item
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION GetNewRssItem()
LOCAL loRss

loRss = CREATEOBJECT("Empty")

ADDPROPERTY(loRSS,"Title","")
ADDPROPERTY(loRSS,"Description","")
ADDPROPERTY(loRSS,"Url","")
ADDPROPERTY(loRss,"CommentUrl","")
ADDPROPERTY(loRss,"TrackbackUrl","")
ADDPROPERTY(loRSS,"Author","")
ADDPROPERTY(loRSS,"PubDate",{ : })
ADDPROPERTY(loRSS,"PK","")

RETURN loRSS


************************************************************************
* rssChannel :: GetNewChannel
****************************************
***  Function: Factory method for a new empty channel item
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION GetNewChannel()
LOCAL loChannel, loProps

loProps = CREATEOBJECT("Empty")
ADDPROPERTY(loProps,"title","")
ADDPROPERTY(loProps,"description","")
ADDPROPERTY(loProps,"link","")
ADDPROPERTY(loProps,"rssUrl","")
ADDPROPERTY(loProps,"lastBuildDate",{ : })
ADDPROPERTY(loProps,"language","")

RETURN loProps
ENDFUNC
*  rssChannel :: GetNewChannel

************************************************************************
* RSS2Feed :: LoadFeed
****************************************
***  Function: Loads the XML feed using the XML DOM parser
***    Assume:
***      Pass:
***    Return:
************************************************************************
PROTECTED FUNCTION LoadFeed(llForce)

IF ISNULL(this.oXML) OR llForce
   this.oXML = CREATEOBJECT("Msxml2.DOMDocument") &&.4.0")
   THIS.oXML.async = .f.
   this.oXML.load(this.cRss2Url)
   IF !EMPTY(this.oXML.parseError.Reason)
      RETURN .f.
   ENDIF
ENDIF

RETURN .T.
ENDFUNC
*  RSS2Feed :: LoadFeed


************************************************************************
* rss2Feed :: GetItem
****************************************
***  Function: Retrieves a node by XPath value
***    Assume:
***      Pass:
***    Return:
************************************************************************
PROTECTED FUNCTION GetItem(loDomNode,lcKey) as String

loNode = loDOMNode.selectSingleNode(lcKey)
IF ISNULL(loNode)
   RETURN ""
ENDIF
RETURN loNode.Text


************************************************************************
* rssToCollection :: ToHtml()
****************************************
***  Function: Turns the feed into HTML 
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ToHtml(llNoGroupHeader,llNoDetail)

lcHTML = ""

IF (!llNoGroupHeader)
   THIS.GetChannelInfo()
   lcHtml = ;
[<h2 class='ChannelHeader'><a href='] + THIS.oChannelInfo.link + [' class='ChannelHeader' style="text-decoration:none;">] + ;
this.oChannelInfo.Title + [</a></h2>] + CHR(13) + CHR(10) +;
[<div style='margin-left:10px;margin-top:30px'>]
ENDIF

TEXT TO lcHTML ADDITIVE NOSHOW
<script>
function ShowDescription(loItem,lcId) 
{
   loDesc = document.getElementById(lcId);
   loAbstract = document.getElementById(lcId + "_Abstract");
   
   if ( loItem.innerText == "+" ) 
   {
      loItem.innerText = "-";
      loDesc.style.display = "block";
      loAbstract.style.display = "none";

   }
   else
   {
      loItem.innerText = "+";
      loDesc.style.display = "none";
      loAbstract.style.display = "block";
   }
}
</script>
ENDTEXT

FOR EACH loRssItem IN THIS.oItems

lcHtml = lcHtml + ;
[<span onclick='ShowDescription(this,"] + loRssItem.pk + [");'] +CRLF +;
[      style="width:10;height:10;text-align:center;cursor:hand;font-size:6pt;border:1px groove black">+</span>] +CRLF +;
[<b><a href='] + loRssItem.Url + [' target='Feed'>] + loRssItem.Title + [</a></b><br>] +CRLF +;
[<small><i>] + DateToC(loRssItem.PubDate) + [</i></small><br>] +CRLF 

IF (!llNoDetail)
   lcComment = ""
   IF !EMPTY(loRssItem.CommentUrl)
      lcComment = "<small><a href='" + loRssItem.CommentUrl + "' target='Feed'>Comments</a></small>"   
   ENDIF
   
   *** Create short abstract of no more than 400 chars
   lcAbstract = LEFT(StripHtml(loRssItem.Description),300)
   lnAt = RAT(" ",lcAbstract)
   lcAbstract = LEFT(lcAbstract,lnAT-1) + "..." 

   lcHtml = lcHTML + ;
   [<div id="] + loRssItem.PK + [_Abstract"] +CRLF +;
   [style="margin-left:10pt;margin-top:2pt;">] +CRLF +; 
   lcAbstract + CRLF +;
   [</div>] +CRLF +;
   [<div id="] + loRssItem.Pk +[" ] +CRLF +;
   [     style="margin-left:10pt;margin-top:2pt;display:none">] +CRLF +;
   loRssItem.Description +CRLF +;
   [</div>] +CRLF +;
   lcComment +CRLF +;
   [<hr style="height=1">] +CRLF 
ELSE
   lcHTML = lcHTML + "<br>"
ENDIF

ENDFOR

lcHtml = lcHtml + "</div>"

RETURN lcHTML

************************************************************************
* rss2Feed :: ToCursor()
****************************************
***  Function: Exports the current collection into a cursor
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ToCursor()

CREATE CURSOR TRSSFeed ( Title C(128), Url M, Descript M, Author c(30), pubDate T, PK c(10))

FOR EACH RssItem IN this.oItems
   INSERT INTO TRssFeed ;
   (Title,Url,Descript,Author,pubDate,PK) ;
      Values ;
   ( RssItem.Title, RssItem.Url, RssItem.Description, RssItem.Author, RssItem.pubDate, RssItem.PK)
ENDFOR

REPLACE ALL pubDate WITH DATETIME() FOR EMPTY(pubDate)

RETURN RECCOUNT()
ENDFUNC
*  rss2Feed :: ToCursor()


FUNCTION Reset
THIS.oXML = null
ENDFUNC

ENDDEFINE
*EOC RSS2Feed 