* Demo program for SW Fox 2005 by Barbara Peisch (c) 2005
*   You may include or modify any of the code or forms included in this demo as you see fit.
*   You may not claim it as your own, nor try to enforce a copyright.
*   All samples in this demo are provided "as is" with no implied guarantees nor waranties.

* NOTES:
*  This demo assumes that you have copies of the Mind's Eye Reporting Engine and XFRX
*  in order to run reports using those products. These are commercial third party
*  products for which you must have a legal copy on your machine in order to run.
*  Eval versions are available:
* Mind's Eye Reporting Engine http://www.mindseyeinc.com
* XFRX: http://www.eqeus.com/xfrxdemo.php
*  You may need to change the SET PATH statement, below, to the directory where you
*  have installed these products.

public oApp

local OldTalk, OldStatus, OldCentury, OldDelete, OldMultiLocks, OldBell
local OldSafety, OldStatusbar

* One feature of this demo allows you to use the gReportMode variable to define if
* the output mode is pre-determined or can be chosen at runtime.  Set the
* variable to an empty string to cause the output selection option to be displayed
* on the screen.  Otherwise, output choices this program understands are:
*   "NATIVE" - for native VFP report output
*   "MINDSEYE" - to display reports using the Mind's Eye Report Engine
*   "XFRX" - to display reports using XFRX

OldTalk = set('Talk')
set talk off
OldStatus = set('Status')
OldCentury = set('Century')
OldDelete = set('Deleted')
OldMultilocks = set('Multilocks')
OldBell = set('Bell')
OldSafety = set('Safety')
OldStatusbar = set('Status bar')
OldNotify = set('Notify')
on shutdown quit
close databases all		&& Closes an DBCs
close databases			&& Closes free tables

_screen.windowstate = 2
clear
_screen.visible = .T.
_screen.Caption = "Report Class Demo"

close databases all
hide window all           && will hide the project manager if it's open
if wexist('Standard')
   hide window Standard      && hide standard toolbar if it's open
endif
if wexist('Form Controls')   && hide form controls toolbar if it's open
	hide window Form
endif

oApp = createobject('DemoApp')

* Must use absolute pathing for cases when they send output to a PDF in a different
* directory.
* Acrobat is changing the default directory!
oApp.AppDir = SYS(5)+CURDIR()
set path to XFRX;XFRX\XFRXLIB

IF NOT DIRECTORY('REPORTS')
	MD REPORTS
ENDIF 

do form PrtOut

set status &OldStatus
set talk &OldTalk
set century &OldCentury
set deleted &OldDelete
set multilocks &OldMultilocks
set bell &OldBell
set safety &OldSafety
set sysmenu to default
set status bar &OldStatusbar
set notify &OldNotify

return
*------------------------------------------------------------------------------
FUNCTION PctBar
*    Returns a bar for printing/display of the appropriate length according to Pct passed
*    Lngth is length of bar in characters at 100%.  If not passed, a default of 100 is used

lparameter Pct, Lngth, Char

local BarGrph, BSize

if empty(Lngth)
	Lngth = 100
endif

if empty(Char)
	Char = chr(110)
endif

BarGrph = ''

if not empty(Pct)
	BSize = round((Pct/100)*Lngth,0)
	
	BarGrph = replicate(Char,round(BSize, 0))
endif

return BarGrph

ENDFUNC
*------------------------------------------------------------------------------
* Application object
define class DemoApp as relation

	AppDir = ''
	oRptForm = .Null.  && For the Minds Eye Report Engine (must stay in scope after calling class)

enddefine
*------------------------------------------------------------------------------
DEFINE CLASS DoReports as Custom
	*   A generic and centralized place for calling reports

	oRpt = .Null.
	lFirst = .T.
	cSetClass = SET("Classlib")
	cReportMode = "NATIVE"
	cDefaultOutputFile = ''
	lDontConfirmOutput = .F.
	cPrinter = ''
	cOldPrinter = ''
	lCancelProcessing = .F.
	lXFRXBookmarks = .F.
	cProgressMess = ''
	cOutput = ''
	oScripts = .Null.
	
	DIMENSION aRpts2Run[1]

	*-----------------------------------------------------
	FUNCTION InitRptMode(tcOutput as String)
	* Called when report mode is switched on the form with the option buttons
	* tcOutput = determines where to send the report, e.g. Preiview, Printer, PDF

	IF EMPTY(tcOutput)
		This.cOutput = 'PREVIEW'
	ELSE
		This.cOutput = UPPER(tcOutput)
	ENDIF 

	This.lFirst = .T.
	
	DO CASE 
	CASE this.cReportMode = "MINDSEYE"
		this.InitMindsEye()
	CASE This.cReportMode = "XFRX"
		this.InitXFRX()
	CASE this.cReportMode = "NATIVE"
		this.InitNative()
	ENDCASE 
	
	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION Destroy
	LOCAL lcClass

	IF This.cReportMode = "XFRX" AND NOT ISNULL(This.oScripts)
		* It's not necessary to unregister scripts, if we're going
		* to exit, but I'm just showing how to do it.
		This.oRpt.UnRegisterAllScripts()
		this.oScripts = .Null.
	ENDIF
	this.oRpt = .Null.
	
	IF NOT EMPTY(this.cOldPrinter)
		SET PRINTER TO (this.cOldPrinter)
	ENDIF
	
	DO CASE 
	CASE this.cReportMode = "MINDSEYE"
		IF NOT EMPTY(this.cSetClass)
			lcClass = this.cSetClass
			SET CLASSLIB TO &lcClass
		ENDIF 
	ENDCASE

	IF FILE("_XFRX.Log")
		ERASE _XFRX.Log
	ENDIF 
	
	ENDFUNC
	*-----------------------------------------------------
	FUNCTION DoIt(tcReportName as String)
	* tcReportName = the name of the FRX file

	LOCAL lcRptClause, lnRows

	IF NOT EMPTY(This.cProgressMess)
		WAIT WINDOW NOWAIT This.cProgressMess
	ENDIF

	DO CASE 
	CASE this.cReportMode = "MINDSEYE"
		DO CASE 
		CASE This.cOutput = "PREVIEW"
			IF this.lFirst
				oApp.oRptForm = this.oRpt.ReportFormObject(tcReportName+".FRX")
				this.lFirst = .F.
				oApp.oRptForm.show()
			ELSE
				this.oRpt.AppendReportToObject(oApp.oRptform,tcReportName+".frx")
			ENDIF 
		CASE INLIST(This.cOUTPUT,"PDF","PRINT")
				IF this.lFirst
					oApp.oRptForm = this.oRpt.ReportFormObject(tcReportName+".FRX")
					this.lFirst = .F.
				ELSE
					this.oRpt.AppendReportToObject(oApp.oRptform,tcReportName+".frx")
				ENDIF 
		OTHERWISE
			MESSAGEBOX("Invalid output method sent to DoReports",48,"Invalid output")
			RETURN .F.
		ENDCASE 
	CASE this.cReportMode = "XFRX" AND This.cOutput <> "PRINT"
		this.oRpt.SetOtherParams("PRINT_BOOKMARKS",This.lXFRXBookmarks,1)	&& If HTML, the 1 parameter prints report bookmarks only

		* Calling ProcessReport is the pre-VFP 9 technique.
		* For VFP 9 we need to queue all the reports and call REPORT FORM for each report, which I do in the SendRptToOutput method.
*!*			IF This.cOutput = "PREVIEW"
			IF ALEN(this.aRpts2Run) = 1
				lnRows = 1
			ELSE
				lnRows = ALEN(this.aRpts2Run,1)+1
			ENDIF 
			DIMENSION this.aRpts2Run[lnRows,2]
			this.aRpts2Run[lnRows,1] = tcReportName
			this.aRpts2Run[lnRows,2] = ALIAS()
*!*			ELSE 
*!*				IF TYPE("this.oRpt") <> "O"
*!*					MESSAGEBOX("Report mode was not initialized!",48,"Missing info")
*!*					This.lCancelProcessing = .T.
*!*				ELSE
*!*					this.oRpt.ProcessReport(tcReportName)
*!*				ENDIF 
*!*			ENDIF 
	OTHERWISE
		DO case
		CASE This.cOutput = "PREVIEW"
			lcRptClause = ' to printer prompt preview'
		CASE This.cOutput = "PRINT"
			IF EMPTY(This.cPrinter)
				this.cPrinter = GETPRINTER()
				IF EMPTY(this.cPrinter)
					RETURN .F.
				ENDIF 
			ENDIF 
			lcRptClause = "to printer noconsole"
		CASE This.cOutput = "PDF"
			lcRptClause = ''
		OTHERWISE
			MESSAGEBOX("Invalid output method sent to DoReports",48,"Invalid output")
			RETURN .F.
		ENDCASE 

		REPORT FORM (tcReportName) &lcRptClause
	ENDCASE

	WAIT CLEAR 

	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION InitNative
	
	IF NOT INLIST(This.cOutput,"","PREVIEW","PRINT")
		MESSAGEBOX("Reporting is currently configured for Native mode,"+CHR(13) ;
				+"which can only handle the Screen and Printer output options",64,"Invalid output option")
		RETURN .F.
	ENDIF 
	this.cOldPrinter = SET("Print",3)
	IF This.cOutput = "PRINT"
		this.cPrinter = GETPRINTER()
		IF EMPTY(this.cPrinter)
			This.lCancelProcessing = .T.
			RETURN .F.
		ENDIF 
		SET PRINTER TO (this.cPrinter)
	ENDIF 

	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION InitMindsEye
	
*!*		IF NOT INLIST(This.cOutput,"","PREIVEW","PRINT","PDF")
*!*			MESSAGEBOX("Reporting is currently configured for the Mind's Eye Report Engine,"+CHR(13) ;
*!*						+"which can only handle the Screen, Printer and PDF output options",64,"Invalid output option")
*!*			RETURN .F.
*!*		ENDIF 
*!*		SET CLASSLIB TO \MindsEyeReportEngine\Libs\MindsEyeReportEngine ADDITIVE 
*!*		this.oRpt = CREATEOBJECT("MindsEyeReportEngine")
*!*		this.oRpt.nScale = 100
*!*		this.oRpt.lDisplayexecutiontime = .F.
*!*		this.oRpt.lShowReportPreviewToolbar = .F.

	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION InitXFRX
	LOCAL lcOutputFile, lnRetVal

	IF INLIST(This.cOutput,"PRINT")
		RETURN .T.
	ENDIF 

	DIMENSION This.aRpts2Run[1]
	This.aRpts2Run[1] = ''

	* For the evaluation mode, you need to wrap calls to the XFRX() method with an EVALUATE() function or it won't compile.
	* For the regular version, this isn't necessary.
	this.oRpt = EVALUATE([xfrx("XFRX#LISTENER")])

	DO CASE 
	CASE this.cOutput = 'PREVIEW'
		lcOutputFile = ''
	CASE this.lDontConfirmOutput
		lcOutputFile = This.cDefaultOutputFile
	OTHERWISE  
		lcOutputFile = PUTFILE(This.cOutput+" file name:",This.cDefaultOutputFile,This.cOutput)
	ENDCASE

	IF NOT EMPTY(lcOutputFile) OR this.cOutput = "PREVIEW"
		lnRetVal = this.oRpt.SetParams(lcOutputFile,,.F.,,.T.,,IIF(This.cOutput="PREVIEW",'XFF',This.cOutput))
		This.RegisterXFRXScripts()
	
		IF lnRetVal = 0
			* Everything was Ok
			this.oRpt.ShrinkHeight(0)	&& Only affects HTML output
		ELSE
			MESSAGEBOX(This.oRpt.ErrorMessage(lnRetVal),16,"Report error")
		ENDIF 
	ELSE
		This.lCancelProcessing = .T.
	ENDIF

	RETURN lnRetVal

	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION SendRptToOutput
	
	IF NOT EMPTY(This.cProgressMess)
		WAIT WINDOW NOWAIT This.cProgressMess
	ENDIF
	
	DO CASE 
	CASE this.cReportMode = "MINDSEYE"
*!*			IF This.cOutput = "PDF"
*!*				lcPDFFile = PUTFILE("PDF file name:",This.cDefaultOutputFile,This.cOutput)
*!*				IF NOT EMPTY(lcPDFFile)
*!*					oApp.oRptForm.oReportEngine.SaveToPDF(lcPDFFile,.T.)
*!*				ENDIF
*!*			else
*!*				oApp.oRptForm.oReportEngine.PrintReport()
*!*			endif
*!*			WAIT clear
	CASE this.cReportMode = "XFRX" AND NOT INLIST(This.cOutput,"PRINT")
		this.XFRXOutput()
		IF This.cOutput = "PREVIEW"
			* The preview form is modal so we must call wait clear before calling the form
			WAIT clear
			* Only call one of these forms:
			* The "Preview" form is an instance of the XFRX Preview form with the container
*			DO FORM Preview WITH this
			* The "MyPreview" form is an instance of a VFP base form with the container
			DO FORM MyPreview WITH this
		ELSE 
			* The Finalize method is only needed for the pre-VFP 9 technique or if
			* you used NOPAGEEJECT with the last REPORT FORM call.
*			this.oRpt.Finalize()
			WAIT clear
		ENDIF 
	ENDCASE 
	
	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION XFRXOutput
	
	FOR lnRpt = 1 TO ALEN(This.aRpts2Run,1)
		SELECT (This.aRpts2Run[lnRpt,2])
		
		* Note: NORESET affects the page number that the CURRENT report starts with
		DO CASE 
		CASE lnRpt = 1
			* We want to make sure the page number is reset for the first report, but
			* only keep it from ejecting if there are more reports to run.
			IF ALEN(This.aRpts2Run,1) = 1
				lcClauses = ""
			ELSE
				lcClauses = "NOPAGEEJECT"
			endif
		CASE lnRpt = ALEN(This.aRpts2Run,1)
			lcClauses = "NORESET"
		OTHERWISE 
			lcClauses = "NOPAGEEJECT NORESET"
		ENDCASE		
		REPORT FORM (This.aRpts2Run[lnRpt,1]) OBJECT This.oRpt &lcClauses noconsole
	ENDFOR 	

	ENDFUNC 
	*-----------------------------------------------------
	FUNCTION RegisterXFRXScripts
	LOCAL lcPages
	* If any scripts were defined in MyXFRXScripts, find them and register them

	This.oScripts = CREATEOBJECT("MyXFRXScripts")

	* Find out what all the native members are so we can pick out the ones that aren't
	AMEMBERS(aNative,This.oScripts,1,"N")
	* Now get all the members
	AMEMBERS(aScripts,This.oScripts,1)
	FOR i = 1 TO ALEN(aScripts,1)
		IF UPPER(aScripts[i,2]) = "METHOD" AND ASCAN(aNative,aScripts[i,1]) = 0
			* It's a method and it's not native
			IF NOT PEMSTATUS(This.oScripts,aScripts[i,1]+"Cond",5) OR EVALUATE(EVALUATE('This.oScripts.'+aScripts[i,1]+"Cond"))
				IF PEMSTATUS(This.oScripts,aScripts[i,1]+"Pages",5)
					* Register it as a page bound script
					lcPages = EVALUATE('This.oScripts.'+aScripts[i,1]+"Pages")
					* The third parameter specifies if the script output should be under
					* on top of report objects.  The fourth parameter specifies the page
					* numbering type--see XFRX manual.
					This.oRpt.RegisterScript(This.oScripts,aScripts[i,1],0,lcPages,0)
				ELSE
					* Register it as a named script
					This.oRpt.RegisterScript(This.oScripts,aScripts[i,1])
				ENDIF 
			ENDIF 
		ENDIF
	ENDFOR 

	ENDFUNC 
	*-----------------------------------------------------
ENDDEFINE
****************************************************************************
DEFINE CLASS MyXFRXScripts as Custom
	* Create a property for each script that is called the script name plus "Pages".
	* This keeps the RegisterScript function from having to know which pages we want
	* the script to run on.
	* If there is no such property, RegisterXFRXScripts will treat it as a named script.
	* Valid choices are:
	*	"ALL" for all pages
	*	"ODD" for odd pages
	*	"EVEN" for even pages
	*	"X" where X is a specific page number (note that this must be a string, not numeric)
	*	"X,Y,Z" where X, Y and Z are specific pages to print
	* 	"X-Z" where X is the starting page and Z is the ending page
	*	or you can mix the two choices above, e.g. "X,Y,Z,A-D"
	DrawWatermarkPages = "ALL"
	DrawBlueRectanglePages = "5"

	* If a script should only be registered under certain conditions, create a property
	* for the script name plus "Cond" and store the condition in that property.
	* This condition will be evaluated from the RegisterXFRXScripts method of the
	* DoReports class, so any references to "This" will be referring to that class.
	DrawWatermarkCond = [inlist(this.cOutput,"PREVIEW","PDF")]

	*-----------------------------------------------------
	FUNCTION DrawWatermark
	* Draw a watermark
	LPARAMETERS toXFD
	
	toXFD.SetPos(100,500)
	toXFD.SetColor(210,210,210)
	toXFD.SetFont("Arial",100,.T.)
	* The second parameter of the DrawText method specifies the angle of
	* rotation in a counterclockwise direction.
	* Rotation will only appear for PDF output and when printing
	* from the preview.  Rotation in the preview will be implemented soon.
	toXFD.DrawText("Watermark",45)
	
	ENDFUNC 
	*-----------------------------------------------------
	PROCEDURE drawBlueRectangle
	* This example comes straight out of the XFRX manual
	LPARAMETERS toXFD

	toXFD.setColor(0,0,255,-1,-1,-1)
	toXFD.drawRectangle(100,200,50,50)

	ENDPROC
	*-----------------------------------------------------
ENDDEFINE
**********************************************************************
