* File........: WINDOWS.H
* Author......: Gary DeWitt
* Purpose.....: #DEFINE Windows API constants.
* Description.: Over 4000 Win32API constants from WINUSER.H, WINGDI.H, 
* WINREG.H and WINBASE.H and WINNT.H are included in this file. I have removed
* all typecasts but that shouldn't affect passing values from VFP
* with functions declared with DECLARE - DLL.
*
* Although there may be some constants from the files named above that
* are missing from this file, most of them are here. All values have
* been converted from hexadecimal to decimal, as far as I know, but
* before using any values in VFP 3, check them to be sure. Hexadecimal values
* are preceded by "0x". Also be sure that none of the numbers
* are followed by non-numeric characters.
*
* Some of the constants below are defined with the value of other 
* constants. If you cut and paste from this file, be sure that you get
* both constants.

* 09/15/05 - Modified by Barbara Peisch: Removed duplicate constants to avoid compile errors
************************************************************************************

*-- WINUSER.H
#DEFINE WINVER                               1024
#DEFINE DIFFERENCE                           11
#DEFINE SB_HORZ                              0
#DEFINE SB_VERT                              1
#DEFINE SB_CTL                               2
#DEFINE SB_BOTH                              3
#DEFINE SB_LINEUP                            0
#DEFINE SB_LINELEFT                          0
#DEFINE SB_LINEDOWN                          1
#DEFINE SB_LINERIGHT                         1
#DEFINE SB_PAGEUP                            2
#DEFINE SB_PAGELEFT                          2
#DEFINE SB_PAGEDOWN                          3
#DEFINE SB_PAGERIGHT                         3
#DEFINE SB_THUMBPOSITION                     4
#DEFINE SB_THUMBTRACK                        5
#DEFINE SB_TOP                               6
#DEFINE SB_LEFT                              6
#DEFINE SB_BOTTOM                            7
#DEFINE SB_RIGHT                             7
#DEFINE SB_ENDSCROLL                         8
#DEFINE SW_HIDE                              0
#DEFINE SW_SHOWNORMAL                        1
#DEFINE SW_NORMAL                            1
#DEFINE SW_SHOWMINIMIZED                     2
#DEFINE SW_SHOWMAXIMIZED                     3
#DEFINE SW_MAXIMIZE                          3
#DEFINE SW_SHOWNOACTIVATE                    4
#DEFINE SW_SHOW                              5
#DEFINE SW_MINIMIZE                          6
#DEFINE SW_SHOWMINNOACTIVE                   7
#DEFINE SW_SHOWNA                            8
#DEFINE SW_RESTORE                           9
#DEFINE SW_SHOWDEFAULT                       10
#DEFINE SW_MAX                               10
#DEFINE HIDE_WINDOW                          0
#DEFINE SHOW_OPENWINDOW                      1
#DEFINE SHOW_ICONWINDOW                      2
#DEFINE SHOW_FULLSCREEN                      3
#DEFINE SHOW_OPENNOACTIVATE                  4
#DEFINE SW_PARENTCLOSING                     1
#DEFINE SW_OTHERZOOM                         2
#DEFINE SW_PARENTOPENING                     3
#DEFINE SW_OTHERUNZOOM                       4
#DEFINE KF_EXTENDED                          256
#DEFINE KF_DLGMODE                           2048
#DEFINE KF_MENUMODE                          4096
#DEFINE KF_ALTDOWN                           8192
#DEFINE KF_REPEAT                            16384
#DEFINE KF_UP                                32768
#DEFINE VK_LBUTTON                           1
#DEFINE VK_RBUTTON                           2
#DEFINE VK_CANCEL                            3
#DEFINE VK_MBUTTON                           4
#DEFINE VK_BACK                              8
#DEFINE VK_TAB                               9
#DEFINE VK_CLEAR                             13
#DEFINE VK_RETURN                            14
#DEFINE VK_SHIFT                             16
#DEFINE VK_CONTROL                           17
#DEFINE VK_MENU                              18
#DEFINE VK_PAUSE                             19
#DEFINE VK_CAPITAL                           20
#DEFINE VK_ESCAPE                            28
#DEFINE VK_SPACE                             32
#DEFINE VK_PRIOR                             33
#DEFINE VK_NEXT                              34
#DEFINE VK_END                               35
#DEFINE VK_HOME                              36
#DEFINE VK_LEFT                              37
#DEFINE VK_UP                                38
#DEFINE VK_RIGHT                             39
#DEFINE VK_DOWN                              40
#DEFINE VK_SELECT                            41
#DEFINE VK_PRINT                             43
#DEFINE VK_EXECUTE                           44
#DEFINE VK_SNAPSHOT                          45
#DEFINE VK_INSERT                            46
#DEFINE VK_DELETE                            47
#DEFINE VK_HELP                              48
#DEFINE VK_LWIN                              92
#DEFINE VK_RWIN                              93
#DEFINE VK_APPS                              94
#DEFINE VK_NUMPAD0                           96
#DEFINE VK_NUMPAD1                           97
#DEFINE VK_NUMPAD2                           98
#DEFINE VK_NUMPAD3                           99
#DEFINE VK_NUMPAD4                           100
#DEFINE VK_NUMPAD5                           101
#DEFINE VK_NUMPAD6                           102
#DEFINE VK_NUMPAD7                           103
#DEFINE VK_NUMPAD8                           104
#DEFINE VK_NUMPAD9                           105
#DEFINE VK_MULTIPLY                          107
#DEFINE VK_ADD                               108
#DEFINE VK_SEPARATOR                         109
#DEFINE VK_SUBTRACT                          110
#DEFINE VK_DECIMAL                           111
#DEFINE VK_DIVIDE                            112
#DEFINE VK_F1                                112
#DEFINE VK_F2                                113
#DEFINE VK_F3                                114
#DEFINE VK_F4                                115
#DEFINE VK_F5                                116
#DEFINE VK_F6                                117
#DEFINE VK_F7                                118
#DEFINE VK_F8                                119
#DEFINE VK_F9                                120
#DEFINE VK_F10                               121
#DEFINE VK_F11                               123
#DEFINE VK_F12                               124
#DEFINE VK_F13                               125
#DEFINE VK_F14                               126
#DEFINE VK_F15                               127
#DEFINE VK_F16                               128
#DEFINE VK_F17                               128
#DEFINE VK_F18                               129
#DEFINE VK_F19                               130
#DEFINE VK_F20                               131
#DEFINE VK_F21                               132
#DEFINE VK_F22                               133
#DEFINE VK_F23                               134
#DEFINE VK_F24                               135
#DEFINE VK_NUMLOCK                           144
#DEFINE VK_SCROLL                            145
#DEFINE VK_LSHIFT                            176
#DEFINE VK_RSHIFT                            177
#DEFINE VK_LCONTROL                          178
#DEFINE VK_RCONTROL                          179
#DEFINE VK_LMENU                             180
#DEFINE VK_RMENU                             181
#DEFINE VK_PROCESSKEY                        245
#DEFINE VK_ATTN                              262
#DEFINE VK_CRSEL                             263
#DEFINE VK_EXSEL                             264
#DEFINE VK_EREOF                             265
#DEFINE VK_PLAY                              267
#DEFINE VK_ZOOM                              268
#DEFINE VK_NONAME                            269
#DEFINE VK_PA1                               270
#DEFINE VK_OEM_CLEAR                         271
#DEFINE WH_MIN                               -1
#DEFINE WH_MSGFILTER                         -1
#DEFINE WH_JOURNALRECORD                     0
#DEFINE WH_JOURNALPLAYBACK                   1
#DEFINE WH_KEYBOARD                          2
#DEFINE WH_GETMESSAGE                        3
#DEFINE WH_CALLWNDPROC                       4
#DEFINE WH_CBT                               5
#DEFINE WH_SYSMSGFILTER                      6
#DEFINE WH_MOUSE                             7
#DEFINE WH_HARDWARE                          8
#DEFINE WH_DEBUG                             9
#DEFINE WH_SHELL                             10
#DEFINE WH_FOREGROUNDIDLE                    11
#DEFINE WH_CALLWNDPROCRET                    12
#DEFINE WH_MAX                               12
#DEFINE WH_MINHOOK                           WH_MIN
#DEFINE WH_MAXHOOK                           WH_MAX
#DEFINE HC_ACTION                            0
#DEFINE HC_GETNEXT                           1
#DEFINE HC_SKIP                              2
#DEFINE HC_NOREMOVE                          3
#DEFINE HC_NOREM                             HC_NOREMOVE
#DEFINE HC_SYSMODALON                        4
#DEFINE HC_SYSMODALOFF                       5
#DEFINE HCBT_MOVESIZE                        0
#DEFINE HCBT_MINMAX                          1
#DEFINE HCBT_QS                              2
#DEFINE HCBT_CREATEWND                       3
#DEFINE HCBT_DESTROYWND                      4
#DEFINE HCBT_ACTIVATE                        5
#DEFINE HCBT_CLICKSKIPPED                    6
#DEFINE HCBT_KEYSKIPPED                      7
#DEFINE HCBT_SYSCOMMAND                      8
#DEFINE HCBT_SETFOCUS                        9
#DEFINE MSGF_DIALOGBOX                       0
#DEFINE MSGF_MESSAGEBOX                      1
#DEFINE MSGF_MENU                            2
#DEFINE MSGF_MOVE                            3
#DEFINE MSGF_SIZE                            4
#DEFINE MSGF_SCROLLBAR                       5
#DEFINE MSGF_NEXTWINDOW                      6
#DEFINE MSGF_MAINLOOP                        8
#DEFINE MSGF_MAX                             8
#DEFINE MSGF_USER                            4096
#DEFINE HSHELL_WINDOWCREATED                 1
#DEFINE HSHELL_WINDOWDESTROYED               2
#DEFINE HSHELL_ACTIVATESHELLWINDOW           3
#DEFINE HSHELL_WINDOWACTIVATED               4
#DEFINE HSHELL_GETMINRECT                    5
#DEFINE HSHELL_REDRAW                        6
#DEFINE HSHELL_TASKMAN                       7
#DEFINE HSHELL_LANGUAGE                      8
#DEFINE HKL_PREV                             0
#DEFINE HKL_NEXT                             1
#DEFINE KLF_ACTIVATE                         1
#DEFINE KLF_SUBSTITUTE_OK                    2
#DEFINE KLF_UNLOADPREVIOUS                   4
#DEFINE KLF_REORDER                          8
#DEFINE KLF_REPLACELANG                      16
#DEFINE KLF_NOTELLSHELL                      128
#DEFINE KL_NAMELENGTH                        9
#DEFINE DESKTOP_READOBJECTS                  1
#DEFINE DESKTOP_CREATEWINDOW                 2
#DEFINE DESKTOP_CREATEMENU                   4
#DEFINE DESKTOP_HOOKCONTROL                  8
#DEFINE DESKTOP_JOURNALRECORD                16
#DEFINE DESKTOP_JOURNALPLAYBACK              32
#DEFINE DESKTOP_ENUMERATE                    64
#DEFINE DESKTOP_WRITEOBJECTS                 128
#DEFINE DESKTOP_SWITCHDESKTOP                256
#DEFINE DF_ALLOWOTHERACCOUNTHOOK             1
#DEFINE WINSTA_ENUMDESKTOPS                  1
#DEFINE WINSTA_READATTRIBUTES                2
#DEFINE WINSTA_ACCESSCLIPBOARD               4
#DEFINE WINSTA_CREATEDESKTOP                 8
#DEFINE WINSTA_WRITEATTRIBUTES               16
#DEFINE WINSTA_ACCESSGLOBALATOMS             32
#DEFINE WINSTA_EXITWINDOWS                   64
#DEFINE WINSTA_ENUMERATE                     256
#DEFINE WINSTA_READSCREEN                    512
#DEFINE WSF_VISIBLE                          1
#DEFINE UOI_FLAGS                            1
#DEFINE UOI_NAME                             2
#DEFINE UOI_TYPE                             3
#DEFINE GWL_WNDPROC                          -4
#DEFINE GWL_HINSTANCE                        -6
#DEFINE GWL_HWNDPARENT                       -8
#DEFINE GWL_STYLE                            -16
#DEFINE GWL_EXSTYLE                          -20
#DEFINE GWL_USERDATA                         -21
#DEFINE GWL_ID                               -12
#DEFINE GCL_MENUNAME                         -8
#DEFINE GCL_HBRBACKGROUND                    -10
#DEFINE GCL_HCURSOR                          -12
#DEFINE GCL_HICON                            -14
#DEFINE GCL_HMODULE                          -16
#DEFINE GCL_CBWNDEXTRA                       -18
#DEFINE GCL_CBCLSEXTRA                       -20
#DEFINE GCL_WNDPROC                          -24
#DEFINE GCL_STYLE                            -26
#DEFINE GCW_ATOM                             -32
#DEFINE GCL_HICONSM                          -34
#DEFINE WM_NULL                              0
#DEFINE WM_CREATE                            1
#DEFINE WM_DESTROY                           2
#DEFINE WM_MOVE                              3
#DEFINE WM_SIZE                              5
#DEFINE WM_ACTIVATE                          6
#DEFINE WA_INACTIVE                          0
#DEFINE WA_ACTIVE                            1
#DEFINE WA_CLICKACTIVE                       2
#DEFINE WM_SETFOCUS                          7
#DEFINE WM_KILLFOCUS                         8
#DEFINE WM_ENABLE                            11
#DEFINE WM_SETREDRAW                         12
#DEFINE WM_SETTEXT                           13
#DEFINE WM_GETTEXT                           14
#DEFINE WM_GETTEXTLENGTH                     15
#DEFINE WM_PAINT                             16
#DEFINE WM_CLOSE                             16
#DEFINE WM_QUERYENDSESSION                   17
#DEFINE WM_QUIT                              18
#DEFINE WM_QUERYOPEN                         19
#DEFINE WM_ERASEBKGND                        20
#DEFINE WM_SYSCOLORCHANGE                    21
#DEFINE WM_ENDSESSION                        22
#DEFINE WM_SHOWWINDOW                        24
#DEFINE WM_WININICHANGE                      27
#DEFINE WM_SETTINGCHANGE                     WM_WININICHANGE
#DEFINE WM_DEVMODECHANGE                     28
#DEFINE WM_ACTIVATEAPP                       29
#DEFINE WM_FONTCHANGE                        30
#DEFINE WM_TIMECHANGE                        31
#DEFINE WM_CANCELMODE                        32
#DEFINE WM_SETCURSOR                         32
#DEFINE WM_MOUSEACTIVATE                     33
#DEFINE WM_CHILDACTIVATE                     34
#DEFINE WM_QUEUESYNC                         35
#DEFINE WM_GETMINMAXINFO                     36
#DEFINE WM_PAINTICON                         38
#DEFINE WM_ICONERASEBKGND                    39
#DEFINE WM_NEXTDLGCTL                        40
#DEFINE WM_SPOOLERSTATUS                     43
#DEFINE WM_DRAWITEM                          44
#DEFINE WM_MEASUREITEM                       45
#DEFINE WM_DELETEITEM                        46
#DEFINE WM_VKEYTOITEM                        47
#DEFINE WM_CHARTOITEM                        48
#DEFINE WM_SETFONT                           48
#DEFINE WM_GETFONT                           49
#DEFINE WM_SETHOTKEY                         50
#DEFINE WM_GETHOTKEY                         51
#DEFINE WM_QUERYDRAGICON                     55
#DEFINE WM_COMPAREITEM                       57
#DEFINE WM_COMPACTING                        65
#DEFINE WM_COMMNOTIFY                        68
#DEFINE WM_WINDOWPOSCHANGING                 70
#DEFINE WM_WINDOWPOSCHANGED                  71
#DEFINE WM_POWER                             72
#DEFINE PWR_OK                               1
#DEFINE PWR_FAIL                             -1
#DEFINE PWR_SUSPENDREQUEST                   1
#DEFINE PWR_SUSPENDRESUME                    2
#DEFINE PWR_CRITICALRESUME                   3
#DEFINE WM_COPYDATA                          75
#DEFINE WM_CANCELJOURNAL                     76
#DEFINE WM_NOTIFY                            79
#DEFINE WM_INPUTLANGCHANGEREQUEST            80
#DEFINE WM_INPUTLANGCHANGE                   81
#DEFINE WM_TCARD                             82
#DEFINE WM_HELP                              83
#DEFINE WM_USERCHANGED                       84
#DEFINE WM_NOTIFYFORMAT                      85
#DEFINE NFR_ANSI                             1
#DEFINE NFR_UNICODE                          2
#DEFINE NF_QUERY                             3
#DEFINE NF_REQUERY                           4
#DEFINE WM_CONTEXTMENU                       124
#DEFINE WM_STYLECHANGING                     125
#DEFINE WM_STYLECHANGED                      126
#DEFINE WM_DISPLAYCHANGE                     127
#DEFINE WM_GETICON                           128
#DEFINE WM_SETICON                           128
#DEFINE WM_NCCREATE                          129
#DEFINE WM_NCDESTROY                         130
#DEFINE WM_NCCALCSIZE                        131
#DEFINE WM_NCHITTEST                         132
#DEFINE WM_NCPAINT                           133
#DEFINE WM_NCACTIVATE                        134
#DEFINE WM_GETDLGCODE                        135
#DEFINE WM_NCMOUSEMOVE                       176
#DEFINE WM_NCLBUTTONDOWN                     177
#DEFINE WM_NCLBUTTONUP                       178
#DEFINE WM_NCLBUTTONDBLCLK                   179
#DEFINE WM_NCRBUTTONDOWN                     180
#DEFINE WM_NCRBUTTONUP                       181
#DEFINE WM_NCRBUTTONDBLCLK                   182
#DEFINE WM_NCMBUTTONDOWN                     183
#DEFINE WM_NCMBUTTONUP                       184
#DEFINE WM_NCMBUTTONDBLCLK                   185
#DEFINE WM_KEYFIRST                          256
#DEFINE WM_KEYDOWN                           256
#DEFINE WM_KEYUP                             257
#DEFINE WM_CHAR                              258
#DEFINE WM_DEADCHAR                          259
#DEFINE WM_SYSKEYDOWN                        260
#DEFINE WM_SYSKEYUP                          261
#DEFINE WM_SYSCHAR                           262
#DEFINE WM_SYSDEADCHAR                       263
#DEFINE WM_KEYLAST                           264
#DEFINE WM_IME_STARTCOMPOSITION              270
#DEFINE WM_IME_ENDCOMPOSITION                271
#DEFINE WM_IME_COMPOSITION                   272
#DEFINE WM_IME_KEYLAST                       272
#DEFINE WM_INITDIALOG                        272
#DEFINE WM_COMMAND                           273
#DEFINE WM_SYSCOMMAND                        274
#DEFINE WM_TIMER                             275
#DEFINE WM_HSCROLL                           276
#DEFINE WM_VSCROLL                           277
#DEFINE WM_INITMENU                          278
#DEFINE WM_INITMENUPOPUP                     279
#DEFINE WM_MENUSELECT                        288
#DEFINE WM_MENUCHAR                          288
#DEFINE WM_ENTERIDLE                         289
#DEFINE WM_CTLCOLORMSGBOX                    306
#DEFINE WM_CTLCOLOREDIT                      307
#DEFINE WM_CTLCOLORLISTBOX                   308
#DEFINE WM_CTLCOLORBTN                       309
#DEFINE WM_CTLCOLORDLG                       310
#DEFINE WM_CTLCOLORSCROLLBAR                 311
#DEFINE WM_CTLCOLORSTATIC                    312
#DEFINE WM_MOUSEFIRST                        512
#DEFINE WM_MOUSEMOVE                         512
#DEFINE WM_LBUTTONDOWN                       513
#DEFINE WM_LBUTTONUP                         514
#DEFINE WM_LBUTTONDBLCLK                     515
#DEFINE WM_RBUTTONDOWN                       516
#DEFINE WM_RBUTTONUP                         517
#DEFINE WM_RBUTTONDBLCLK                     518
#DEFINE WM_MBUTTONDOWN                       519
#DEFINE WM_MBUTTONUP                         520
#DEFINE WM_MBUTTONDBLCLK                     521
#DEFINE WM_MOUSELAST                         521
#DEFINE WM_PARENTNOTIFY                      528
#DEFINE MENULOOP_WINDOW                      0
#DEFINE MENULOOP_POPUP                       1
#DEFINE WM_ENTERMENULOOP                     529
#DEFINE WM_EXITMENULOOP                      530
#DEFINE WM_NEXTMENU                          531
#DEFINE WM_SIZING                            532
#DEFINE WM_CAPTURECHANGED                    533
#DEFINE WM_MOVING                            534
#DEFINE WM_POWERBROADCAST                    536
#DEFINE WM_DEVICECHANGE                      537
#DEFINE WM_IME_SETCONTEXT                    641
#DEFINE WM_IME_NOTIFY                        642
#DEFINE WM_IME_CONTROL                       643
#DEFINE WM_IME_COMPOSITIONFULL               644
#DEFINE WM_IME_SELECT                        645
#DEFINE WM_IME_CHAR                          646
#DEFINE WM_IME_KEYDOWN                       656
#DEFINE WM_IME_KEYUP                         657
#DEFINE WM_MDICREATE                         544
#DEFINE WM_MDIDESTROY                        545
#DEFINE WM_MDIACTIVATE                       546
#DEFINE WM_MDIRESTORE                        547
#DEFINE WM_MDINEXT                           548
#DEFINE WM_MDIMAXIMIZE                       549
#DEFINE WM_MDITILE                           550
#DEFINE WM_MDICASCADE                        551
#DEFINE WM_MDIICONARRANGE                    552
#DEFINE WM_MDIGETACTIVE                      553
#DEFINE WM_MDISETMENU                        560
#DEFINE WM_ENTERSIZEMOVE                     561
#DEFINE WM_EXITSIZEMOVE                      562
#DEFINE WM_DROPFILES                         563
#DEFINE WM_MDIREFRESHMENU                    564
#DEFINE WM_CUT                               768
#DEFINE WM_COPY                              769
#DEFINE WM_PASTE                             770
#DEFINE WM_CLEAR                             771
#DEFINE WM_UNDO                              772
#DEFINE WM_RENDERFORMAT                      773
#DEFINE WM_RENDERALLFORMATS                  774
#DEFINE WM_DESTROYCLIPBOARD                  775
#DEFINE WM_DRAWCLIPBOARD                     776
#DEFINE WM_PAINTCLIPBOARD                    777
#DEFINE WM_VSCROLLCLIPBOARD                  779
#DEFINE WM_SIZECLIPBOARD                     780
#DEFINE WM_ASKCBFORMATNAME                   781
#DEFINE WM_CHANGECBCHAIN                     782
#DEFINE WM_HSCROLLCLIPBOARD                  783
#DEFINE WM_QUERYNEWPALETTE                   784
#DEFINE WM_PALETTEISCHANGING                 784
#DEFINE WM_PALETTECHANGED                    785
#DEFINE WM_HOTKEY                            786
#DEFINE WM_PRINT                             791
#DEFINE WM_PRINTCLIENT                       792
#DEFINE WM_HANDHELDFIRST                     856
#DEFINE WM_HANDHELDLAST                      864
#DEFINE WM_AFXFIRST                          864
#DEFINE WM_AFXLAST                           896
#DEFINE WM_PENWINFIRST                       896
#DEFINE WM_PENWINLAST                        912
#DEFINE WM_APP                               32768
#DEFINE WM_USER                              1024
#DEFINE WMSZ_LEFT                            1
#DEFINE WMSZ_RIGHT                           2
#DEFINE WMSZ_TOP                             3
#DEFINE WMSZ_TOPLEFT                         4
#DEFINE WMSZ_TOPRIGHT                        5
#DEFINE WMSZ_BOTTOM                          6
#DEFINE WMSZ_BOTTOMLEFT                      7
#DEFINE WMSZ_BOTTOMRIGHT                     8
#DEFINE ST_BEGINSWP                          0
#DEFINE ST_ENDSWP                            1
#DEFINE HTERROR                              -2
#DEFINE HTTRANSPARENT                        -1
#DEFINE HTNOWHERE                            0
#DEFINE HTCLIENT                             1
#DEFINE HTCAPTION                            2
#DEFINE HTSYSMENU                            3
#DEFINE HTGROWBOX                            4
#DEFINE HTSIZE                               HTGROWBOX
#DEFINE HTMENU                               5
#DEFINE HTHSCROLL                            6
#DEFINE HTVSCROLL                            7
#DEFINE HTMINBUTTON                          8
#DEFINE HTMAXBUTTON                          9
#DEFINE HTLEFT                               10
#DEFINE HTRIGHT                              11
#DEFINE HTTOP                                12
#DEFINE HTTOPLEFT                            13
#DEFINE HTTOPRIGHT                           14
#DEFINE HTBOTTOM                             15
#DEFINE HTBOTTOMLEFT                         16
#DEFINE HTBOTTOMRIGHT                        17
#DEFINE HTBORDER                             18
#DEFINE HTREDUCE                             HTMINBUTTON
#DEFINE HTZOOM                               HTMAXBUTTON
#DEFINE HTSIZEFIRST                          HTLEFT
#DEFINE HTSIZELAST                           HTBOTTOMRIGHT
#DEFINE HTOBJECT                             19
#DEFINE HTCLOSE                              20
#DEFINE HTHELP                               21
#DEFINE SMTO_NORMAL                          0
#DEFINE SMTO_BLOCK                           1
#DEFINE SMTO_ABORTIFHUNG                     2
#DEFINE MA_ACTIVATE                          1
#DEFINE MA_ACTIVATEANDEAT                    2
#DEFINE MA_NOACTIVATE                        3
#DEFINE MA_NOACTIVATEANDEAT                  4
#DEFINE SIZE_RESTORED                        0
#DEFINE SIZE_MINIMIZED                       1
#DEFINE SIZE_MAXIMIZED                       2
#DEFINE SIZE_MAXSHOW                         3
#DEFINE SIZE_MAXHIDE                         4
#DEFINE SIZENORMAL                           SIZE_RESTORED
#DEFINE SIZEICONIC                           SIZE_MINIMIZED
#DEFINE SIZEFULLSCREEN                       SIZE_MAXIMIZED
#DEFINE SIZEZOOMSHOW                         SIZE_MAXSHOW
#DEFINE SIZEZOOMHIDE                         SIZE_MAXHIDE
#DEFINE WVR_ALIGNTOP                         16
#DEFINE WVR_ALIGNLEFT                        32
#DEFINE WVR_ALIGNBOTTOM                      64
#DEFINE WVR_ALIGNRIGHT                       128
#DEFINE WVR_HREDRAW                          256
#DEFINE WVR_VREDRAW                          512
#DEFINE WVR_VALIDRECTS                       1024
#DEFINE MK_LBUTTON                           1
#DEFINE MK_RBUTTON                           2
#DEFINE MK_SHIFT                             4
#DEFINE MK_CONTROL                           8
#DEFINE MK_MBUTTON                           16
#DEFINE WS_OVERLAPPED                        0
#DEFINE WS_POPUP                             2147483648
#DEFINE WS_CHILD                             1073741824
#DEFINE WS_MINIMIZE                          536870912
#DEFINE WS_VISIBLE                           268435456
#DEFINE WS_DISABLED                          134217728
#DEFINE WS_CLIPSIBLINGS                      67108864
#DEFINE WS_CLIPCHILDREN                      33554432
#DEFINE WS_MAXIMIZE                          16777216
#DEFINE WS_CAPTION                           13631488
#DEFINE WS_BORDER                            8388608
#DEFINE WS_DLGFRAME                          4194304
#DEFINE WS_VSCROLL                           2097152
#DEFINE WS_HSCROLL                           1048576
#DEFINE WS_SYSMENU                           524288
#DEFINE WS_THICKFRAME                        262144
#DEFINE WS_GROUP                             131072
#DEFINE WS_TABSTOP                           65536
#DEFINE WS_MINIMIZEBOX                       131072
#DEFINE WS_MAXIMIZEBOX                       65536
#DEFINE WS_TILED                             WS_OVERLAPPED
#DEFINE WS_ICONIC                            WS_MINIMIZE
#DEFINE WS_SIZEBOX                           WS_THICKFRAME
#DEFINE WS_TILEDWINDOW                       WS_OVERLAPPEDWINDOW
#DEFINE WS_EX_DLGMODALFRAME                  1
#DEFINE WS_EX_NOPARENTNOTIFY                 4
#DEFINE WS_EX_TOPMOST                        8
#DEFINE WS_EX_ACCEPTFILES                    16
#DEFINE WS_EX_TRANSPARENT                    32
#DEFINE WS_EX_MDICHILD                       64
#DEFINE WS_EX_TOOLWINDOW                     128
#DEFINE WS_EX_WINDOWEDGE                     256
#DEFINE WS_EX_CLIENTEDGE                     512
#DEFINE WS_EX_CONTEXTHELP                    1024
#DEFINE WS_EX_RIGHT                          4096
#DEFINE WS_EX_LEFT                           0
#DEFINE WS_EX_RTLREADING                     8192
#DEFINE WS_EX_LTRREADING                     0
#DEFINE WS_EX_LEFTSCROLLBAR                  16384
#DEFINE WS_EX_RIGHTSCROLLBAR                 0
#DEFINE WS_EX_CONTROLPARENT                  65536
#DEFINE WS_EX_STATICEDGE                     131072
#DEFINE WS_EX_APPWINDOW                      262144
#DEFINE CS_VREDRAW                           1
#DEFINE CS_HREDRAW                           2
#DEFINE CS_KEYCVTWINDOW                      4
#DEFINE CS_DBLCLKS                           8
#DEFINE CS_OWNDC                             32
#DEFINE CS_CLASSDC                           64
#DEFINE CS_PARENTDC                          128
#DEFINE CS_NOKEYCVT                          256
#DEFINE CS_NOCLOSE                           512
#DEFINE CS_SAVEBITS                          2048
#DEFINE CS_BYTEALIGNCLIENT                   4096
#DEFINE CS_BYTEALIGNWINDOW                   8192
#DEFINE CS_GLOBALCLASS                       16384
#DEFINE CS_IME                               65536
#DEFINE PRF_CHECKVISIBLE                     1
#DEFINE PRF_NONCLIENT                        2
#DEFINE PRF_CLIENT                           4
#DEFINE PRF_ERASEBKGND                       8
#DEFINE PRF_CHILDREN                         16
#DEFINE PRF_OWNED                            32
#DEFINE BDR_RAISEDOUTER                      1
#DEFINE BDR_SUNKENOUTER                      2
#DEFINE BDR_RAISEDINNER                      4
#DEFINE BDR_SUNKENINNER                      8
#DEFINE BDR_OUTER                            3
#DEFINE BDR_INNER                            13
#DEFINE BDR_RAISED                           5
#DEFINE BDR_SUNKEN                           11
#DEFINE BF_LEFT                              1
#DEFINE BF_TOP                               2
#DEFINE BF_RIGHT                             4
#DEFINE BF_BOTTOM                            8
#DEFINE BF_DIAGONAL                          16
#DEFINE BF_MIDDLE                            2048
#DEFINE BF_SOFT                              4096
#DEFINE BF_ADJUST                            8192
#DEFINE BF_FLAT                              16384
#DEFINE BF_MONO                              32768
#DEFINE DFC_CAPTION                          1
#DEFINE DFC_MENU                             2
#DEFINE DFC_SCROLL                           3
#DEFINE DFC_BUTTON                           4
#DEFINE DFCS_CAPTIONCLOSE                    0
#DEFINE DFCS_CAPTIONMIN                      1
#DEFINE DFCS_CAPTIONMAX                      2
#DEFINE DFCS_CAPTIONRESTORE                  3
#DEFINE DFCS_CAPTIONHELP                     4
#DEFINE DFCS_MENUARROW                       0
#DEFINE DFCS_MENUCHECK                       1
#DEFINE DFCS_MENUBULLET                      2
#DEFINE DFCS_MENUARROWRIGHT                  4
#DEFINE DFCS_SCROLLUP                        0
#DEFINE DFCS_SCROLLDOWN                      1
#DEFINE DFCS_SCROLLLEFT                      2
#DEFINE DFCS_SCROLLRIGHT                     3
#DEFINE DFCS_SCROLLCOMBOBOX                  5
#DEFINE DFCS_SCROLLSIZEGRIP                  8
#DEFINE DFCS_SCROLLSIZEGRIPRIGHT             16
#DEFINE DFCS_BUTTONCHECK                     0
#DEFINE DFCS_BUTTONRADIOIMAGE                1
#DEFINE DFCS_BUTTONRADIOMASK                 2
#DEFINE DFCS_BUTTONRADIO                     4
#DEFINE DFCS_BUTTON3STATE                    8
#DEFINE DFCS_BUTTONPUSH                      16
#DEFINE DFCS_INACTIVE                        256
#DEFINE DFCS_PUSHED                          512
#DEFINE DFCS_CHECKED                         1024
#DEFINE DFCS_ADJUSTRECT                      8192
#DEFINE DFCS_FLAT                            16384
#DEFINE DFCS_MONO                            32768
#DEFINE DC_ACTIVE                            1
#DEFINE DC_SMALLCAP                          2
#DEFINE DC_ICON                              4
#DEFINE DC_TEXT                              8
#DEFINE DC_INBUTTON                          16
#DEFINE IDANI_OPEN                           1
#DEFINE IDANI_CLOSE                          2
#DEFINE IDANI_CAPTION                        3
#DEFINE CF_TEXT                              1
#DEFINE CF_BITMAP                            2
#DEFINE CF_METAFILEPICT                      3
#DEFINE CF_SYLK                              4
#DEFINE CF_DIF                               5
#DEFINE CF_TIFF                              6
#DEFINE CF_OEMTEXT                           7
#DEFINE CF_DIB                               8
#DEFINE CF_PALETTE                           9
#DEFINE CF_PENDATA                           10
#DEFINE CF_RIFF                              11
#DEFINE CF_WAVE                              12
#DEFINE CF_UNICODETEXT                       13
#DEFINE CF_ENHMETAFILE                       14
#DEFINE CF_HDROP                             15
#DEFINE CF_LOCALE                            16
#DEFINE CF_MAX                               17
#DEFINE CF_OWNERDISPLAY                      128
#DEFINE CF_DSPTEXT                           129
#DEFINE CF_DSPBITMAP                         130
#DEFINE CF_DSPMETAFILEPICT                   131
#DEFINE CF_DSPENHMETAFILE                    143
#DEFINE CF_PRIVATEFIRST                      512
#DEFINE CF_PRIVATELAST                       784
#DEFINE CF_GDIOBJFIRST                       768
#DEFINE CF_GDIOBJLAST                        1040
#DEFINE FVIRTKEY                             1
#DEFINE FNOINVERT                            2
#DEFINE FSHIFT                               4
#DEFINE FCONTROL                             8
#DEFINE FALT                                 16
#DEFINE WPF_SETMINPOSITION                   1
#DEFINE WPF_RESTORETOMAXIMIZED               2
#DEFINE ODT_MENU                             1
#DEFINE ODT_LISTBOX                          2
#DEFINE ODT_COMBOBOX                         3
#DEFINE ODT_BUTTON                           4
#DEFINE ODT_STATIC                           5
#DEFINE ODA_DRAWENTIRE                       1
#DEFINE ODA_SELECT                           2
#DEFINE ODA_FOCUS                            4
#DEFINE ODS_SELECTED                         1
#DEFINE ODS_GRAYED                           2
#DEFINE ODS_DISABLED                         4
#DEFINE ODS_CHECKED                          8
#DEFINE ODS_FOCUS                            16
#DEFINE ODS_DEFAULT                          32
#DEFINE ODS_COMBOBOXEDIT                     4096
#DEFINE PM_NOREMOVE                          0
#DEFINE PM_REMOVE                            1
#DEFINE PM_NOYIELD                           2
#DEFINE MOD_ALT                              1
#DEFINE MOD_CONTROL                          2
#DEFINE MOD_SHIFT                            4
#DEFINE MOD_WIN                              8
#DEFINE IDHOT_SNAPWINDOW                     -1
#DEFINE IDHOT_SNAPDESKTOP                    -2
#DEFINE EW_RESTARTWINDOWS                    66
#DEFINE EW_REBOOTSYSTEM                      67
#DEFINE EW_EXITANDEXECAPP                    68
#DEFINE EWX_LOGOFF                           0
#DEFINE EWX_SHUTDOWN                         1
#DEFINE EWX_REBOOT                           2
#DEFINE EWX_FORCE                            4
#DEFINE EWX_POWEROFF                         8
#DEFINE BSM_ALLCOMPONENTS                    0
#DEFINE BSM_VXDS                             1
#DEFINE BSM_NETDRIVER                        2
#DEFINE BSM_INSTALLABLEDRIVERS               4
#DEFINE BSM_APPLICATIONS                     8
#DEFINE BSF_QUERY                            1
#DEFINE BSF_IGNORECURRENTTASK                2
#DEFINE BSF_FLUSHDISK                        4
#DEFINE BSF_NOHANG                           8
#DEFINE BSF_POSTMESSAGE                      16
#DEFINE BSF_FORCEIFHUNG                      32
#DEFINE BSF_NOTIMEOUTIFNOTHUNG               64
#DEFINE DBWF_LPARAMPOINTER                   32768
#DEFINE BROADCAST_QUERY_DENY                 1112428868
#DEFINE HWND_BROADCAST                       69904
#DEFINE CW_USEDEFAULT                        2147483648
#DEFINE HWND_DESKTOP                         0
#DEFINE SWP_NOSIZE                           1
#DEFINE SWP_NOMOVE                           2
#DEFINE SWP_NOZORDER                         4
#DEFINE SWP_NOREDRAW                         8
#DEFINE SWP_NOACTIVATE                       16
#DEFINE SWP_FRAMECHANGED                     32
#DEFINE SWP_SHOWWINDOW                       64
#DEFINE SWP_HIDEWINDOW                       128
#DEFINE SWP_NOCOPYBITS                       256
#DEFINE SWP_NOOWNERZORDER                    512
#DEFINE SWP_NOSENDCHANGING                   1024
#DEFINE SWP_DRAWFRAME                        SWP_FRAMECHANGED
#DEFINE SWP_NOREPOSITION                     SWP_NOOWNERZORDER
#DEFINE SWP_DEFERERASE                       8192
#DEFINE SWP_ASYNCWINDOWPOS                   16384
#DEFINE HWND_TOP                             0
#DEFINE HWND_BOTTOM                          1
#DEFINE HWND_TOPMOST                         -1
#DEFINE HWND_NOTOPMOST                       -2
#DEFINE DLGWINDOWEXTRA                       30
#DEFINE KEYEVENTF_EXTENDEDKEY                1
#DEFINE KEYEVENTF_KEYUP                      2
#DEFINE MOUSEEVENTF_MOVE                     1
#DEFINE MOUSEEVENTF_LEFTDOWN                 2
#DEFINE MOUSEEVENTF_LEFTUP                   4
#DEFINE MOUSEEVENTF_RIGHTDOWN                8
#DEFINE MOUSEEVENTF_RIGHTUP                  16
#DEFINE MOUSEEVENTF_MIDDLEDOWN               32
#DEFINE MOUSEEVENTF_MIDDLEUP                 64
#DEFINE MOUSEEVENTF_ABSOLUTE                 32768
#DEFINE QS_KEY                               1
#DEFINE QS_MOUSEMOVE                         2
#DEFINE QS_MOUSEBUTTON                       4
#DEFINE QS_POSTMESSAGE                       8
#DEFINE QS_TIMER                             16
#DEFINE QS_PAINT                             32
#DEFINE QS_SENDMESSAGE                       64
#DEFINE QS_HOTKEY                            128
#DEFINE SM_CXSCREEN                          0
#DEFINE SM_CYSCREEN                          1
#DEFINE SM_CXVSCROLL                         2
#DEFINE SM_CYHSCROLL                         3
#DEFINE SM_CYCAPTION                         4
#DEFINE SM_CXBORDER                          5
#DEFINE SM_CYBORDER                          6
#DEFINE SM_CXDLGFRAME                        7
#DEFINE SM_CYDLGFRAME                        8
#DEFINE SM_CYVTHUMB                          9
#DEFINE SM_CXHTHUMB                          10
#DEFINE SM_CXICON                            11
#DEFINE SM_CYICON                            12
#DEFINE SM_CXCURSOR                          13
#DEFINE SM_CYCURSOR                          14
#DEFINE SM_CYMENU                            15
#DEFINE SM_CXFULLSCREEN                      16
#DEFINE SM_CYFULLSCREEN                      17
#DEFINE SM_CYKANJIWINDOW                     18
#DEFINE SM_MOUSEPRESENT                      19
#DEFINE SM_CYVSCROLL                         20
#DEFINE SM_CXHSCROLL                         21
#DEFINE SM_DEBUG                             22
#DEFINE SM_SWAPBUTTON                        23
#DEFINE SM_RESERVED1                         24
#DEFINE SM_RESERVED2                         25
#DEFINE SM_RESERVED3                         26
#DEFINE SM_RESERVED4                         27
#DEFINE SM_CXMIN                             28
#DEFINE SM_CYMIN                             29
#DEFINE SM_CXSIZE                            30
#DEFINE SM_CYSIZE                            31
#DEFINE SM_CXFRAME                           32
#DEFINE SM_CYFRAME                           33
#DEFINE SM_CXMINTRACK                        34
#DEFINE SM_CYMINTRACK                        35
#DEFINE SM_CXDOUBLECLK                       36
#DEFINE SM_CYDOUBLECLK                       37
#DEFINE SM_CXICONSPACING                     38
#DEFINE SM_CYICONSPACING                     39
#DEFINE SM_MENUDROPALIGNMENT                 40
#DEFINE SM_PENWINDOWS                        41
#DEFINE SM_DBCSENABLED                       42
#DEFINE SM_CMOUSEBUTTONS                     43
#DEFINE SM_CXFIXEDFRAME                      SM_CXDLGFRAME
#DEFINE SM_CYFIXEDFRAME                      SM_CYDLGFRAME
#DEFINE SM_CXSIZEFRAME                       SM_CXFRAME
#DEFINE SM_CYSIZEFRAME                       SM_CYFRAME
#DEFINE SM_SECURE                            44
#DEFINE SM_CXEDGE                            45
#DEFINE SM_CYEDGE                            46
#DEFINE SM_CXMINSPACING                      47
#DEFINE SM_CYMINSPACING                      48
#DEFINE SM_CXSMICON                          49
#DEFINE SM_CYSMICON                          50
#DEFINE SM_CYSMCAPTION                       51
#DEFINE SM_CXSMSIZE                          52
#DEFINE SM_CYSMSIZE                          53
#DEFINE SM_CXMENUSIZE                        54
#DEFINE SM_CYMENUSIZE                        55
#DEFINE SM_ARRANGE                           56
#DEFINE SM_CXMINIMIZED                       57
#DEFINE SM_CYMINIMIZED                       58
#DEFINE SM_CXMAXTRACK                        59
#DEFINE SM_CYMAXTRACK                        60
#DEFINE SM_CXMAXIMIZED                       61
#DEFINE SM_CYMAXIMIZED                       62
#DEFINE SM_NETWORK                           63
#DEFINE SM_CLEANBOOT                         67
#DEFINE SM_CXDRAG                            68
#DEFINE SM_CYDRAG                            69
#DEFINE SM_SHOWSOUNDS                        70
#DEFINE SM_CXMENUCHECK                       71
#DEFINE SM_CYMENUCHECK                       72
#DEFINE SM_SLOWMACHINE                       73
#DEFINE SM_MIDEASTENABLED                    74
#DEFINE SM_CMETRICS                          75
#DEFINE MNC_IGNORE                           0
#DEFINE MNC_CLOSE                            1
#DEFINE MNC_EXECUTE                          2
#DEFINE MNC_SELECT                           3
#DEFINE MIIM_STATE                           1
#DEFINE MIIM_ID                              2
#DEFINE MIIM_SUBMENU                         4
#DEFINE MIIM_CHECKMARKS                      8
#DEFINE MIIM_TYPE                            16
#DEFINE MIIM_DATA                            32
#DEFINE GMDI_USEDISABLED                     1
#DEFINE GMDI_GOINTOPOPUPS                    2
#DEFINE TPM_LEFTBUTTON                       0
#DEFINE TPM_RIGHTBUTTON                      2
#DEFINE TPM_LEFTALIGN                        0
#DEFINE TPM_CENTERALIGN                      4
#DEFINE TPM_RIGHTALIGN                       8
#DEFINE TPM_TOPALIGN                         0
#DEFINE TPM_VCENTERALIGN                     16
#DEFINE TPM_BOTTOMALIGN                      32
#DEFINE TPM_HORIZONTAL                       0
#DEFINE TPM_VERTICAL                         64
#DEFINE TPM_NONOTIFY                         128
#DEFINE TPM_RETURNCMD                        256
#DEFINE DOF_EXECUTABLE                       32769
#DEFINE DOF_DOCUMENT                         32770
#DEFINE DOF_DIRECTORY                        32771
#DEFINE DOF_MULTIPLE                         32772
#DEFINE DOF_PROGMAN                          1
#DEFINE DOF_SHELLDATA                        2
#DEFINE DO_DROPFILE                          1162692934
#DEFINE DO_PRINTFILE                         1414484560
#DEFINE DT_TOP                               0
#DEFINE DT_LEFT                              0
#DEFINE DT_CENTER                            1
#DEFINE DT_RIGHT                             2
#DEFINE DT_VCENTER                           4
#DEFINE DT_BOTTOM                            8
#DEFINE DT_WORDBREAK                         16
#DEFINE DT_SINGLELINE                        32
#DEFINE DT_EXPANDTABS                        64
#DEFINE DT_TABSTOP                           128
#DEFINE DT_NOCLIP                            256
#DEFINE DT_EXTERNALLEADING                   512
#DEFINE DT_CALCRECT                          1024
#DEFINE DT_NOPREFIX                          2048
#DEFINE DT_INTERNAL                          4096
#DEFINE DT_EDITCONTROL                       8192
#DEFINE DT_PATH_ELLIPSIS                     16384
#DEFINE DT_END_ELLIPSIS                      32768
#DEFINE DT_MODIFYSTRING                      65536
#DEFINE DT_RTLREADING                        131072
#DEFINE DT_WORD_ELLIPSIS                     262144
#DEFINE DST_COMPLEX                          0
#DEFINE DST_TEXT                             1
#DEFINE DST_PREFIXTEXT                       2
#DEFINE DST_ICON                             3
#DEFINE DST_BITMAP                           4
#DEFINE DSS_NORMAL                           0
#DEFINE DSS_UNION                            16
#DEFINE DSS_DISABLED                         32
#DEFINE DSS_MONO                             128
#DEFINE DSS_RIGHT                            32768
#DEFINE DCX_WINDOW                           1
#DEFINE DCX_CACHE                            2
#DEFINE DCX_NORESETATTRS                     4
#DEFINE DCX_CLIPCHILDREN                     8
#DEFINE DCX_CLIPSIBLINGS                     16
#DEFINE DCX_PARENTCLIP                       32
#DEFINE DCX_EXCLUDERGN                       64
#DEFINE DCX_INTERSECTRGN                     128
#DEFINE DCX_EXCLUDEUPDATE                    256
#DEFINE DCX_INTERSECTUPDATE                  512
#DEFINE DCX_LOCKWINDOWUPDATE                 1024
#DEFINE DCX_VALIDATE                         2097152
#DEFINE RDW_INVALIDATE                       1
#DEFINE RDW_INTERNALPAINT                    2
#DEFINE RDW_ERASE                            4
#DEFINE RDW_VALIDATE                         8
#DEFINE RDW_NOINTERNALPAINT                  16
#DEFINE RDW_NOERASE                          32
#DEFINE RDW_NOCHILDREN                       64
#DEFINE RDW_ALLCHILDREN                      128
#DEFINE RDW_UPDATENOW                        256
#DEFINE RDW_ERASENOW                         512
#DEFINE RDW_FRAME                            1024
#DEFINE RDW_NOFRAME                          2048
#DEFINE SW_SCROLLCHILDREN                    1
#DEFINE SW_INVALIDATE                        2
#DEFINE SW_ERASE                             4
#DEFINE ESB_ENABLE_BOTH                      0
#DEFINE ESB_DISABLE_BOTH                     3
#DEFINE ESB_DISABLE_LEFT                     1
#DEFINE ESB_DISABLE_RIGHT                    2
#DEFINE ESB_DISABLE_UP                       1
#DEFINE ESB_DISABLE_DOWN                     2
#DEFINE ESB_DISABLE_LTUP                     ESB_DISABLE_LEFT
#DEFINE ESB_DISABLE_RTDN                     ESB_DISABLE_RIGHT
#DEFINE HELPINFO_WINDOW                      1
#DEFINE HELPINFO_MENUITEM                    2
#DEFINE MB_OK                                0
#DEFINE MB_OKCANCEL                          1
#DEFINE MB_ABORTRETRYIGNORE                  2
#DEFINE MB_YESNOCANCEL                       3
#DEFINE MB_YESNO                             4
#DEFINE MB_RETRYCANCEL                       5
#DEFINE MB_ICONHAND                          16
#DEFINE MB_ICONQUESTION                      32
#DEFINE MB_ICONEXCLAMATION                   48
#DEFINE MB_ICONASTERISK                      64
#DEFINE MB_ICONWARNING                       MB_ICONEXCLAMATION
#DEFINE MB_ICONERROR                         MB_ICONHAND
#DEFINE MB_ICONINFORMATION                   MB_ICONASTERISK
#DEFINE MB_ICONSTOP                          MB_ICONHAND
#DEFINE MB_DEFBUTTON1                        0
#DEFINE MB_DEFBUTTON2                        256
#DEFINE MB_DEFBUTTON3                        512
#DEFINE MB_DEFBUTTON4                        768
#DEFINE MB_APPLMODAL                         0
#DEFINE MB_SYSTEMMODAL                       4096
#DEFINE MB_TASKMODAL                         8192
#DEFINE MB_HELP                              16384
#DEFINE MB_RIGHT                             524288
#DEFINE MB_RTLREADING                        1048576
#DEFINE MB_NOFOCUS                           32768
#DEFINE MB_SETFOREGROUND                     65536
#DEFINE MB_DEFAULT_DESKTOP_ONLY              131072
#DEFINE MB_SERVICE_NOTIFICATION              262144
#DEFINE MB_TYPEMASK                          16
#DEFINE MB_USERICON                          128
#DEFINE MB_ICONMASK                          256
#DEFINE MB_DEFMASK                           4096
#DEFINE MB_MODEMASK                          12288
#DEFINE MB_MISCMASK                          53248
#DEFINE MB_TOPMOST                           262144
#DEFINE CWP_ALL                              0
#DEFINE CWP_SKIPINVISIBLE                    1
#DEFINE CWP_SKIPDISABLED                     2
#DEFINE CWP_SKIPTRANSPARENT                  4
#DEFINE CTLCOLOR_MSGBOX                      0
#DEFINE CTLCOLOR_EDIT                        1
#DEFINE CTLCOLOR_LISTBOX                     2
#DEFINE CTLCOLOR_BTN                         3
#DEFINE CTLCOLOR_DLG                         4
#DEFINE CTLCOLOR_SCROLLBAR                   5
#DEFINE CTLCOLOR_STATIC                      6
#DEFINE CTLCOLOR_MAX                         7
#DEFINE COLOR_SCROLLBAR                      0
#DEFINE COLOR_BACKGROUND                     1
#DEFINE COLOR_ACTIVECAPTION                  2
#DEFINE COLOR_INACTIVECAPTION                3
#DEFINE COLOR_MENU                           4
#DEFINE COLOR_WINDOW                         5
#DEFINE COLOR_WINDOWFRAME                    6
#DEFINE COLOR_MENUTEXT                       7
#DEFINE COLOR_WINDOWTEXT                     8
#DEFINE COLOR_CAPTIONTEXT                    9
#DEFINE COLOR_ACTIVEBORDER                   10
#DEFINE COLOR_INACTIVEBORDER                 11
#DEFINE COLOR_APPWORKSPACE                   12
#DEFINE COLOR_HIGHLIGHT                      13
#DEFINE COLOR_HIGHLIGHTTEXT                  14
#DEFINE COLOR_BTNFACE                        15
#DEFINE COLOR_BTNSHADOW                      16
#DEFINE COLOR_GRAYTEXT                       17
#DEFINE COLOR_BTNTEXT                        18
#DEFINE COLOR_INACTIVECAPTIONTEXT            19
#DEFINE COLOR_BTNHIGHLIGHT                   20
#DEFINE COLOR_3DDKSHADOW                     21
#DEFINE COLOR_3DLIGHT                        22
#DEFINE COLOR_INFOTEXT                       23
#DEFINE COLOR_INFOBK                         24
#DEFINE COLOR_DESKTOP                        COLOR_BACKGROUND
#DEFINE COLOR_3DFACE                         COLOR_BTNFACE
#DEFINE COLOR_3DSHADOW                       COLOR_BTNSHADOW
#DEFINE COLOR_3DHIGHLIGHT                    COLOR_BTNHIGHLIGHT
#DEFINE COLOR_3DHILIGHT                      COLOR_BTNHIGHLIGHT
#DEFINE COLOR_BTNHILIGHT                     COLOR_BTNHIGHLIGHT
#DEFINE GW_HWNDFIRST                         0
#DEFINE GW_HWNDLAST                          1
#DEFINE GW_HWNDNEXT                          2
#DEFINE GW_HWNDPREV                          3
#DEFINE GW_OWNER                             4
#DEFINE GW_CHILD                             5
#DEFINE GW_MAX                               5
#DEFINE MF_INSERT                            0
#DEFINE MF_CHANGE                            128
#DEFINE MF_APPEND                            256
#DEFINE MF_DELETE                            512
#DEFINE MF_REMOVE                            4096
#DEFINE MF_BYCOMMAND                         0
#DEFINE MF_BYPOSITION                        1024
#DEFINE MF_SEPARATOR                         2048
#DEFINE MF_ENABLED                           0
#DEFINE MF_GRAYED                            1
#DEFINE MF_DISABLED                          2
#DEFINE MF_UNCHECKED                         0
#DEFINE MF_CHECKED                           8
#DEFINE MF_USECHECKBITMAPS                   512
#DEFINE MF_STRING                            0
#DEFINE MF_BITMAP                            4
#DEFINE MF_OWNERDRAW                         256
#DEFINE MF_POPUP                             16
#DEFINE MF_MENUBARBREAK                      32
#DEFINE MF_MENUBREAK                         64
#DEFINE MF_UNHILITE                          0
#DEFINE MF_HILITE                            128
#DEFINE MF_DEFAULT                           4096
#DEFINE MF_SYSMENU                           8192
#DEFINE MF_HELP                              16384
#DEFINE MF_RIGHTJUSTIFY                      16384
#DEFINE MF_MOUSESELECT                       32768
#DEFINE MF_END                               128
#DEFINE MFT_STRING                           MF_STRING
#DEFINE MFT_BITMAP                           MF_BITMAP
#DEFINE MFT_MENUBARBREAK                     MF_MENUBARBREAK
#DEFINE MFT_MENUBREAK                        MF_MENUBREAK
#DEFINE MFT_OWNERDRAW                        MF_OWNERDRAW
#DEFINE MFT_RADIOCHECK                       512
#DEFINE MFT_SEPARATOR                        MF_SEPARATOR
#DEFINE MFT_RIGHTORDER                       8192
#DEFINE MFT_RIGHTJUSTIFY                     MF_RIGHTJUSTIFY
#DEFINE MFS_GRAYED                           3
#DEFINE MFS_DISABLED                         MFS_GRAYED
#DEFINE MFS_CHECKED                          MF_CHECKED
#DEFINE MFS_HILITE                           MF_HILITE
#DEFINE MFS_ENABLED                          MF_ENABLED
#DEFINE MFS_UNCHECKED                        MF_UNCHECKED
#DEFINE MFS_UNHILITE                         MF_UNHILITE
#DEFINE MFS_DEFAULT                          MF_DEFAULT
#DEFINE MF_END                               128
#DEFINE SC_SIZE                              65536
#DEFINE SC_MOVE                              65552
#DEFINE SC_MINIMIZE                          65568
#DEFINE SC_MAXIMIZE                          65584
#DEFINE SC_NEXTWINDOW                        65600
#DEFINE SC_PREVWINDOW                        65616
#DEFINE SC_CLOSE                             65632
#DEFINE SC_VSCROLL                           65648
#DEFINE SC_HSCROLL                           65664
#DEFINE SC_MOUSEMENU                         65680
#DEFINE SC_KEYMENU                           65792
#DEFINE SC_ARRANGE                           65808
#DEFINE SC_RESTORE                           65824
#DEFINE SC_TASKLIST                          65840
#DEFINE SC_SCREENSAVE                        65856
#DEFINE SC_HOTKEY                            65872
#DEFINE SC_DEFAULT                           65888
#DEFINE SC_MONITORPOWER                      65904
#DEFINE SC_CONTEXTHELP                       65920
#DEFINE SC_SEPARATOR                         65552
#DEFINE SC_ICON                              SC_MINIMIZE
#DEFINE SC_ZOOM                              SC_MAXIMIZE
#DEFINE IDC_ARROW                            32512
#DEFINE IDC_IBEAM                            32513
#DEFINE IDC_WAIT                             32514
#DEFINE IDC_CROSS                            32515
#DEFINE IDC_UPARROW                          32516
#DEFINE IDC_SIZE                             32640
#DEFINE IDC_ICON                             32641
#DEFINE IDC_SIZENWSE                         32642
#DEFINE IDC_SIZENESW                         32643
#DEFINE IDC_SIZEWE                           32644
#DEFINE IDC_SIZENS                           32645
#DEFINE IDC_SIZEALL                          32646
#DEFINE IDC_NO                               32648
#DEFINE IDC_APPSTARTING                      32650
#DEFINE IDC_HELP                             32651
#DEFINE IMAGE_BITMAP                         0
#DEFINE IMAGE_ICON                           1
#DEFINE IMAGE_CURSOR                         2
#DEFINE IMAGE_ENHMETAFILE                    3
#DEFINE LR_DEFAULTCOLOR                      0
#DEFINE LR_MONOCHROME                        1
#DEFINE LR_COLOR                             2
#DEFINE LR_COPYRETURNORG                     4
#DEFINE LR_COPYDELETEORG                     8
#DEFINE LR_LOADFROMFILE                      16
#DEFINE LR_LOADTRANSPARENT                   32
#DEFINE LR_DEFAULTSIZE                       64
#DEFINE LR_LOADMAP3DCOLORS                   4096
#DEFINE LR_CREATEDIBSECTION                  8192
#DEFINE LR_COPYFROMRESOURCE                  16384
#DEFINE LR_SHARED                            32768
#DEFINE DI_MASK                              1
#DEFINE DI_IMAGE                             2
#DEFINE DI_NORMAL                            3
#DEFINE DI_COMPAT                            4
#DEFINE DI_DEFAULTSIZE                       8
#DEFINE RES_ICON                             1
#DEFINE RES_CURSOR                           2
#DEFINE OBM_CLOSE                            32754
#DEFINE OBM_UPARROW                          32753
#DEFINE OBM_DNARROW                          32752
#DEFINE OBM_RGARROW                          32751
#DEFINE OBM_LFARROW                          32750
#DEFINE OBM_REDUCE                           32749
#DEFINE OBM_ZOOM                             32748
#DEFINE OBM_RESTORE                          32747
#DEFINE OBM_REDUCED                          32746
#DEFINE OBM_ZOOMD                            32745
#DEFINE OBM_RESTORED                         32744
#DEFINE OBM_UPARROWD                         32743
#DEFINE OBM_DNARROWD                         32742
#DEFINE OBM_RGARROWD                         32741
#DEFINE OBM_LFARROWD                         32740
#DEFINE OBM_MNARROW                          32739
#DEFINE OBM_COMBO                            32738
#DEFINE OBM_UPARROWI                         32737
#DEFINE OBM_DNARROWI                         32736
#DEFINE OBM_RGARROWI                         32735
#DEFINE OBM_LFARROWI                         32734
#DEFINE OBM_OLD_CLOSE                        32767
#DEFINE OBM_SIZE                             32766
#DEFINE OBM_OLD_UPARROW                      32765
#DEFINE OBM_OLD_DNARROW                      32764
#DEFINE OBM_OLD_RGARROW                      32763
#DEFINE OBM_OLD_LFARROW                      32762
#DEFINE OBM_BTSIZE                           32761
#DEFINE OBM_CHECK                            32760
#DEFINE OBM_CHECKBOXES                       32759
#DEFINE OBM_BTNCORNERS                       32758
#DEFINE OBM_OLD_REDUCE                       32757
#DEFINE OBM_OLD_ZOOM                         32756
#DEFINE OBM_OLD_RESTORE                      32755
#DEFINE OCR_NORMAL                           32512
#DEFINE OCR_IBEAM                            32513
#DEFINE OCR_WAIT                             32514
#DEFINE OCR_CROSS                            32515
#DEFINE OCR_UP                               32516
#DEFINE OCR_SIZE                             32640
#DEFINE OCR_ICON                             32641
#DEFINE OCR_SIZENWSE                         32642
#DEFINE OCR_SIZENESW                         32643
#DEFINE OCR_SIZEWE                           32644
#DEFINE OCR_SIZENS                           32645
#DEFINE OCR_SIZEALL                          32646
#DEFINE OCR_ICOCUR                           32647
#DEFINE OCR_NO                               32648
#DEFINE OCR_APPSTARTING                      32650
#DEFINE OIC_SAMPLE                           32512
#DEFINE OIC_HAND                             32513
#DEFINE OIC_QUES                             32514
#DEFINE OIC_BANG                             32515
#DEFINE OIC_NOTE                             32516
#DEFINE OIC_WINLOGO                          32517
#DEFINE OIC_WARNING                          OIC_BANG
#DEFINE OIC_ERROR                            OIC_HAND
#DEFINE OIC_INFORMATION                      OIC_NOTE
#DEFINE ORD_LANGDRIVER                       1
#DEFINE IDI_APPLICATION                      32512
#DEFINE IDI_HAND                             32513
#DEFINE IDI_QUESTION                         32514
#DEFINE IDI_EXCLAMATION                      32515
#DEFINE IDI_ASTERISK                         32516
#DEFINE IDI_WINLOGO                          32517
#DEFINE IDI_APPLICATION                      32512
#DEFINE IDI_HAND                             32513
#DEFINE IDI_QUESTION                         32514
#DEFINE IDI_EXCLAMATION                      32515
#DEFINE IDI_ASTERISK                         32516
#DEFINE IDI_WINLOGO                          32517
#DEFINE IDI_WARNING                          IDI_EXCLAMATION
#DEFINE IDI_ERROR                            IDI_HAND
#DEFINE IDI_INFORMATION                      IDI_ASTERISK
#DEFINE IDOK                                 1
#DEFINE IDCANCEL                             2
#DEFINE IDABORT                              3
#DEFINE IDRETRY                              4
#DEFINE IDIGNORE                             5
#DEFINE IDYES                                6
#DEFINE IDNO                                 7
#DEFINE IDCLOSE                              8
#DEFINE IDHELP                               9
#DEFINE ES_LEFT                              0
#DEFINE ES_CENTER                            1
#DEFINE ES_RIGHT                             2
#DEFINE ES_MULTILINE                         4
#DEFINE ES_UPPERCASE                         8
#DEFINE ES_LOWERCASE                         16
#DEFINE ES_PASSWORD                          32
#DEFINE ES_AUTOVSCROLL                       64
#DEFINE ES_AUTOHSCROLL                       128
#DEFINE ES_NOHIDESEL                         256
#DEFINE ES_OEMCONVERT                        1024
#DEFINE ES_READONLY                          2048
#DEFINE ES_WANTRETURN                        4096
#DEFINE ES_NUMBER                            8192
#DEFINE EN_SETFOCUS                          256
#DEFINE EN_KILLFOCUS                         512
#DEFINE EN_CHANGE                            768
#DEFINE EN_UPDATE                            1024
#DEFINE EN_ERRSPACE                          1280
#DEFINE EN_MAXTEXT                           1281
#DEFINE EN_HSCROLL                           1537
#DEFINE EN_VSCROLL                           1538
#DEFINE EC_LEFTMARGIN                        1
#DEFINE EC_RIGHTMARGIN                       2
#DEFINE EC_USEFONTINFO                       69904
#DEFINE EM_GETSEL                            192
#DEFINE EM_SETSEL                            193
#DEFINE EM_GETRECT                           194
#DEFINE EM_SETRECT                           195
#DEFINE EM_SETRECTNP                         196
#DEFINE EM_SCROLL                            197
#DEFINE EM_LINESCROLL                        198
#DEFINE EM_SCROLLCARET                       199
#DEFINE EM_GETMODIFY                         200
#DEFINE EM_SETMODIFY                         201
#DEFINE EM_GETLINECOUNT                      203
#DEFINE EM_LINEINDEX                         204
#DEFINE EM_SETHANDLE                         205
#DEFINE EM_GETHANDLE                         206
#DEFINE EM_GETTHUMB                          207
#DEFINE EM_LINELENGTH                        209
#DEFINE EM_REPLACESEL                        210
#DEFINE EM_GETLINE                           212
#DEFINE EM_LIMITTEXT                         213
#DEFINE EM_CANUNDO                           214
#DEFINE EM_UNDO                              215
#DEFINE EM_FMTLINES                          216
#DEFINE EM_LINEFROMCHAR                      217
#DEFINE EM_SETTABSTOPS                       220
#DEFINE EM_SETPASSWORDCHAR                   221
#DEFINE EM_EMPTYUNDOBUFFER                   222
#DEFINE EM_GETFIRSTVISIBLELINE               223
#DEFINE EM_SETREADONLY                       224
#DEFINE EM_SETWORDBREAKPROC                  224
#DEFINE EM_GETWORDBREAKPROC                  225
#DEFINE EM_GETPASSWORDCHAR                   226
#DEFINE EM_SETMARGINS                        227
#DEFINE EM_GETMARGINS                        228
#DEFINE EM_SETLIMITTEXT                      EM_LIMITTEXT
#DEFINE EM_GETLIMITTEXT                      229
#DEFINE EM_POSFROMCHAR                       230
#DEFINE EM_CHARFROMPOS                       231
#DEFINE WB_LEFT                              0
#DEFINE WB_RIGHT                             1
#DEFINE WB_ISDELIMITER                       2
#DEFINE BS_PUSHBUTTON                        0
#DEFINE BS_DEFPUSHBUTTON                     1
#DEFINE BS_CHECKBOX                          2
#DEFINE BS_AUTOCHECKBOX                      3
#DEFINE BS_RADIOBUTTON                       4
#DEFINE BS_3STATE                            5
#DEFINE BS_AUTO3STATE                        6
#DEFINE BS_GROUPBOX                          7
#DEFINE BS_USERBUTTON                        8
#DEFINE BS_AUTORADIOBUTTON                   9
#DEFINE BS_OWNERDRAW                         12
#DEFINE BS_LEFTTEXT                          32
#DEFINE BS_TEXT                              0
#DEFINE BS_ICON                              64
#DEFINE BS_BITMAP                            128
#DEFINE BS_LEFT                              256
#DEFINE BS_RIGHT                             512
#DEFINE BS_CENTER                            768
#DEFINE BS_TOP                               1024
#DEFINE BS_BOTTOM                            2048
#DEFINE BS_VCENTER                           3328
#DEFINE BS_PUSHLIKE                          4096
#DEFINE BS_MULTILINE                         8192
#DEFINE BS_NOTIFY                            16384
#DEFINE BS_FLAT                              32768
#DEFINE BS_RIGHTBUTTON                       BS_LEFTTEXT
#DEFINE BN_CLICKED                           0
#DEFINE BN_PAINT                             1
#DEFINE BN_HILITE                            2
#DEFINE BN_UNHILITE                          3
#DEFINE BN_DISABLE                           4
#DEFINE BN_DOUBLECLICKED                     5
#DEFINE BN_PUSHED                            BN_HILITE
#DEFINE BN_UNPUSHED                          BN_UNHILITE
#DEFINE BN_DBLCLK                            BN_DOUBLECLICKED
#DEFINE BN_SETFOCUS                          6
#DEFINE BN_KILLFOCUS                         7
#DEFINE BM_GETCHECK                          256
#DEFINE BM_SETCHECK                          257
#DEFINE BM_GETSTATE                          258
#DEFINE BM_SETSTATE                          259
#DEFINE BM_SETSTYLE                          260
#DEFINE BM_CLICK                             261
#DEFINE BM_GETIMAGE                          262
#DEFINE BM_SETIMAGE                          263
#DEFINE BST_UNCHECKED                        0
#DEFINE BST_CHECKED                          1
#DEFINE BST_INDETERMINATE                    2
#DEFINE BST_PUSHED                           4
#DEFINE BST_FOCUS                            8
#DEFINE SS_LEFT                              0
#DEFINE SS_CENTER                            1
#DEFINE SS_RIGHT                             2
#DEFINE SS_ICON                              3
#DEFINE SS_BLACKRECT                         4
#DEFINE SS_GRAYRECT                          5
#DEFINE SS_WHITERECT                         6
#DEFINE SS_BLACKFRAME                        7
#DEFINE SS_GRAYFRAME                         8
#DEFINE SS_WHITEFRAME                        9
#DEFINE SS_USERITEM                          11
#DEFINE SS_SIMPLE                            12
#DEFINE SS_LEFTNOWORDWRAP                    13
#DEFINE SS_BITMAP                            15
#DEFINE SS_OWNERDRAW                         14
#DEFINE SS_ENHMETAFILE                       16
#DEFINE SS_ETCHEDHORZ                        16
#DEFINE SS_ETCHEDVERT                        17
#DEFINE SS_ETCHEDFRAME                       18
#DEFINE SS_TYPEMASK                          32
#DEFINE SS_NOPREFIX                          128
#DEFINE SS_NOTIFY                            256
#DEFINE SS_CENTERIMAGE                       512
#DEFINE SS_RIGHTJUST                         1024
#DEFINE SS_REALSIZEIMAGE                     2048
#DEFINE SS_SUNKEN                            4096
#DEFINE STM_SETICON                          368
#DEFINE STM_GETICON                          369
#DEFINE STM_SETIMAGE                         370
#DEFINE STM_GETIMAGE                         371
#DEFINE STN_CLICKED                          0
#DEFINE STN_DBLCLK                           1
#DEFINE STN_ENABLE                           2
#DEFINE STN_DISABLE                          3
#DEFINE STM_MSGMAX                           372
#DEFINE WC_DIALOG                            32770
#DEFINE DWL_MSGRESULT                        0
#DEFINE DWL_DLGPROC                          4
#DEFINE DWL_USER                             8
#DEFINE DDL_READWRITE                        0
#DEFINE DDL_READONLY                         1
#DEFINE DDL_HIDDEN                           2
#DEFINE DDL_SYSTEM                           4
#DEFINE DDL_DIRECTORY                        16
#DEFINE DDL_ARCHIVE                          32
#DEFINE DDL_POSTMSGS                         8192
#DEFINE DDL_DRIVES                           16384
#DEFINE DDL_EXCLUSIVE                        32768
#DEFINE DS_ABSALIGN                          1
#DEFINE DS_SYSMODAL                          2
#DEFINE DS_LOCALEDIT                         32
#DEFINE DS_SETFONT                           64
#DEFINE DS_MODALFRAME                        128
#DEFINE DS_NOIDLEMSG                         256
#DEFINE DS_SETFOREGROUND                     512
#DEFINE DS_3DLOOK                            4
#DEFINE DS_FIXEDSYS                          8
#DEFINE DS_NOFAILCREATE                      16
#DEFINE DS_CONTROL                           1024
#DEFINE DS_CENTER                            2048
#DEFINE DS_CENTERMOUSE                       4096
#DEFINE DS_CONTEXTHELP                       8192
#DEFINE DM_GETDEFID                          WM_USER + 0
#DEFINE DM_SETDEFID                          WM_USER + 1
#DEFINE DM_REPOSITION                        WM_USER + 2
#DEFINE PSM_PAGEINFO                         WM_USER + 100
#DEFINE PSM_SHEETINFO                        WM_USER + 101
#DEFINE PSI_SETACTIVE                        1
#DEFINE PSI_KILLACTIVE                       2
#DEFINE PSI_APPLY                            3
#DEFINE PSI_RESET                            4
#DEFINE PSI_HASHELP                          5
#DEFINE PSI_HELP                             6
#DEFINE PSI_CHANGED                          1
#DEFINE PSI_GUISTART                         2
#DEFINE PSI_REBOOT                           3
#DEFINE PSI_GETSIBLINGS                      4
#DEFINE DC_HASDEFID                          21324
#DEFINE DLGC_WANTARROWS                      1
#DEFINE DLGC_WANTTAB                         2
#DEFINE DLGC_WANTALLKEYS                     4
#DEFINE DLGC_WANTMESSAGE                     4
#DEFINE DLGC_HASSETSEL                       8
#DEFINE DLGC_DEFPUSHBUTTON                   16
#DEFINE DLGC_UNDEFPUSHBUTTON                 32
#DEFINE DLGC_RADIOBUTTON                     64
#DEFINE DLGC_WANTCHARS                       128
#DEFINE DLGC_STATIC                          256
#DEFINE DLGC_BUTTON                          8192
#DEFINE LB_CTLCODE                           0
#DEFINE LB_OKAY                              0
#DEFINE LB_ERR                               -1
#DEFINE LB_ERRSPACE                          -2
#DEFINE LBN_ERRSPACE                         -2
#DEFINE LBN_SELCHANGE                        1
#DEFINE LBN_DBLCLK                           2
#DEFINE LBN_SELCANCEL                        3
#DEFINE LBN_SETFOCUS                         4
#DEFINE LBN_KILLFOCUS                        5
#DEFINE LB_ADDSTRING                         384
#DEFINE LB_INSERTSTRING                      385
#DEFINE LB_DELETESTRING                      386
#DEFINE LB_SELITEMRANGEEX                    387
#DEFINE LB_RESETCONTENT                      388
#DEFINE LB_SETSEL                            389
#DEFINE LB_SETCURSEL                         390
#DEFINE LB_GETSEL                            391
#DEFINE LB_GETCURSEL                         392
#DEFINE LB_GETTEXT                           393
#DEFINE LB_GETTEXTLEN                        395
#DEFINE LB_GETCOUNT                          396
#DEFINE LB_SELECTSTRING                      397
#DEFINE LB_DIR                               398
#DEFINE LB_GETTOPINDEX                       399
#DEFINE LB_FINDSTRING                        400
#DEFINE LB_GETSELCOUNT                       400
#DEFINE LB_GETSELITEMS                       401
#DEFINE LB_SETTABSTOPS                       402
#DEFINE LB_GETHORIZONTALEXTENT               403
#DEFINE LB_SETHORIZONTALEXTENT               404
#DEFINE LB_SETCOLUMNWIDTH                    405
#DEFINE LB_ADDFILE                           406
#DEFINE LB_SETTOPINDEX                       407
#DEFINE LB_GETITEMRECT                       408
#DEFINE LB_GETITEMDATA                       409
#DEFINE LB_SETITEMDATA                       411
#DEFINE LB_SELITEMRANGE                      412
#DEFINE LB_SETANCHORINDEX                    413
#DEFINE LB_GETANCHORINDEX                    414
#DEFINE LB_SETCARETINDEX                     415
#DEFINE LB_GETCARETINDEX                     416
#DEFINE LB_SETITEMHEIGHT                     432
#DEFINE LB_GETITEMHEIGHT                     433
#DEFINE LB_FINDSTRINGEXACT                   434
#DEFINE LB_SETLOCALE                         437
#DEFINE LB_GETLOCALE                         438
#DEFINE LB_SETCOUNT                          439
#DEFINE LB_INITSTORAGE                       440
#DEFINE LB_ITEMFROMPOINT                     441
#DEFINE LB_MSGMAX                            448
#DEFINE LBS_NOTIFY                           1
#DEFINE LBS_SORT                             2
#DEFINE LBS_NOREDRAW                         4
#DEFINE LBS_MULTIPLESEL                      8
#DEFINE LBS_OWNERDRAWFIXED                   16
#DEFINE LBS_OWNERDRAWVARIABLE                32
#DEFINE LBS_HASSTRINGS                       64
#DEFINE LBS_USETABSTOPS                      128
#DEFINE LBS_NOINTEGRALHEIGHT                 256
#DEFINE LBS_MULTICOLUMN                      512
#DEFINE LBS_WANTKEYBOARDINPUT                1024
#DEFINE LBS_EXTENDEDSEL                      2048
#DEFINE LBS_DISABLENOSCROLL                  4096
#DEFINE LBS_NODATA                           8192
#DEFINE LBS_NOSEL                            16384
#DEFINE CB_OKAY                              0
#DEFINE CB_ERR                               -1
#DEFINE CB_ERRSPACE                          -2
#DEFINE CBN_ERRSPACE                         -1
#DEFINE CBN_SELCHANGE                        1
#DEFINE CBN_DBLCLK                           2
#DEFINE CBN_SETFOCUS                         3
#DEFINE CBN_KILLFOCUS                        4
#DEFINE CBN_EDITCHANGE                       5
#DEFINE CBN_EDITUPDATE                       6
#DEFINE CBN_DROPDOWN                         7
#DEFINE CBN_CLOSEUP                          8
#DEFINE CBN_SELENDOK                         9
#DEFINE CBN_SELENDCANCEL                     10
#DEFINE CBS_SIMPLE                           1
#DEFINE CBS_DROPDOWN                         2
#DEFINE CBS_DROPDOWNLIST                     3
#DEFINE CBS_OWNERDRAWFIXED                   16
#DEFINE CBS_OWNERDRAWVARIABLE                32
#DEFINE CBS_AUTOHSCROLL                      64
#DEFINE CBS_OEMCONVERT                       128
#DEFINE CBS_SORT                             256
#DEFINE CBS_HASSTRINGS                       512
#DEFINE CBS_NOINTEGRALHEIGHT                 1024
#DEFINE CBS_DISABLENOSCROLL                  2048
#DEFINE CBS_UPPERCASE                        8192
#DEFINE CBS_LOWERCASE                        16384
#DEFINE CB_GETEDITSEL                        320
#DEFINE CB_LIMITTEXT                         321
#DEFINE CB_SETEDITSEL                        322
#DEFINE CB_ADDSTRING                         323
#DEFINE CB_DELETESTRING                      324
#DEFINE CB_DIR                               325
#DEFINE CB_GETCOUNT                          326
#DEFINE CB_GETCURSEL                         327
#DEFINE CB_GETLBTEXT                         328
#DEFINE CB_GETLBTEXTLEN                      329
#DEFINE CB_INSERTSTRING                      331
#DEFINE CB_RESETCONTENT                      332
#DEFINE CB_FINDSTRING                        333
#DEFINE CB_SELECTSTRING                      334
#DEFINE CB_SETCURSEL                         335
#DEFINE CB_SHOWDROPDOWN                      336
#DEFINE CB_GETITEMDATA                       336
#DEFINE CB_SETITEMDATA                       337
#DEFINE CB_GETDROPPEDCONTROLRECT             338
#DEFINE CB_SETITEMHEIGHT                     339
#DEFINE CB_GETITEMHEIGHT                     340
#DEFINE CB_SETEXTENDEDUI                     341
#DEFINE CB_GETEXTENDEDUI                     342
#DEFINE CB_GETDROPPEDSTATE                   343
#DEFINE CB_FINDSTRINGEXACT                   344
#DEFINE CB_SETLOCALE                         345
#DEFINE CB_GETLOCALE                         347
#DEFINE CB_GETTOPINDEX                       348
#DEFINE CB_SETTOPINDEX                       349
#DEFINE CB_GETHORIZONTALEXTENT               350
#DEFINE CB_SETHORIZONTALEXTENT               351
#DEFINE CB_GETDROPPEDWIDTH                   352
#DEFINE CB_SETDROPPEDWIDTH                   352
#DEFINE CB_INITSTORAGE                       353
#DEFINE CB_MSGMAX                            354
#DEFINE SBS_HORZ                             0
#DEFINE SBS_VERT                             1
#DEFINE SBS_TOPALIGN                         2
#DEFINE SBS_LEFTALIGN                        2
#DEFINE SBS_BOTTOMALIGN                      4
#DEFINE SBS_RIGHTALIGN                       4
#DEFINE SBS_SIZEBOXTOPLEFTALIGN              2
#DEFINE SBS_SIZEBOXBOTTOMRIGHTALIGN          4
#DEFINE SBS_SIZEBOX                          8
#DEFINE SBS_SIZEGRIP                         16
#DEFINE SBM_SETPOS                           240
#DEFINE SBM_GETPOS                           241
#DEFINE SBM_SETRANGE                         242
#DEFINE SBM_SETRANGEREDRAW                   246
#DEFINE SBM_GETRANGE                         243
#DEFINE SBM_ENABLE_ARROWS                    244
#DEFINE SBM_SETSCROLLINFO                    249
#DEFINE SBM_GETSCROLLINFO                    251
#DEFINE SIF_RANGE                            1
#DEFINE SIF_PAGE                             2
#DEFINE SIF_POS                              4
#DEFINE SIF_DISABLENOSCROLL                  8
#DEFINE SIF_TRACKPOS                         16
#DEFINE MDIS_ALLCHILDSTYLES                  1
#DEFINE MDITILE_VERTICAL                     0
#DEFINE MDITILE_HORIZONTAL                   1
#DEFINE MDITILE_SKIPDISABLED                 2
#DEFINE IMC_GETCANDIDATEPOS                  7
#DEFINE IMC_SETCANDIDATEPOS                  8
#DEFINE IMC_GETCOMPOSITIONFONT               9
#DEFINE IMC_SETCOMPOSITIONFONT               11
#DEFINE IMC_GETCOMPOSITIONWINDOW             12
#DEFINE IMC_SETCOMPOSITIONWINDOW             13
#DEFINE IMC_GETSTATUSWINDOWPOS               16
#DEFINE IMC_SETSTATUSWINDOWPOS               16
#DEFINE IMC_CLOSESTATUSWINDOW                33
#DEFINE IMC_OPENSTATUSWINDOW                 34
#DEFINE IMN_CLOSESTATUSWINDOW                1
#DEFINE IMN_OPENSTATUSWINDOW                 2
#DEFINE IMN_CHANGECANDIDATE                  3
#DEFINE IMN_CLOSECANDIDATE                   4
#DEFINE IMN_OPENCANDIDATE                    5
#DEFINE IMN_SETCONVERSIONMODE                6
#DEFINE IMN_SETSENTENCEMODE                  7
#DEFINE IMN_SETOPENSTATUS                    8
#DEFINE IMN_SETCANDIDATEPOS                  9
#DEFINE IMN_SETCOMPOSITIONFONT               11
#DEFINE IMN_SETCOMPOSITIONWINDOW             12
#DEFINE IMN_SETSTATUSWINDOWPOS               13
#DEFINE IMN_GUIDELINE                        14
#DEFINE IMN_PRIVATE                          15
#DEFINE HELP_CONTEXT                         1
#DEFINE HELP_QUIT                            2
#DEFINE HELP_INDEX                           3
#DEFINE HELP_CONTENTS                        3
#DEFINE HELP_HELPONHELP                      4
#DEFINE HELP_SETINDEX                        5
#DEFINE HELP_SETCONTENTS                     5
#DEFINE HELP_CONTEXTPOPUP                    8
#DEFINE HELP_FORCEFILE                       9
#DEFINE HELP_KEY                             257
#DEFINE HELP_COMMAND                         258
#DEFINE HELP_PARTIALKEY                      261
#DEFINE HELP_MULTIKEY                        513
#DEFINE HELP_SETWINPOS                       515
#DEFINE HELP_CONTEXTMENU                     11
#DEFINE HELP_FINDER                          12
#DEFINE HELP_WM_HELP                         13
#DEFINE HELP_SETPOPUP_POS                    14
#DEFINE HELP_TCARD                           32768
#DEFINE HELP_TCARD_DATA                      16
#DEFINE HELP_TCARD_OTHER_CALLER              17
#DEFINE IDH_NO_HELP                          28440
#DEFINE IDH_MISSING_CONTEXT                  28441
#DEFINE IDH_GENERIC_HELP_BUTTON              28442
#DEFINE IDH_OK                               28443
#DEFINE IDH_CANCEL                           28444
#DEFINE IDH_HELP                             28445
#DEFINE SPI_GETBEEP                          1
#DEFINE SPI_SETBEEP                          2
#DEFINE SPI_GETMOUSE                         3
#DEFINE SPI_SETMOUSE                         4
#DEFINE SPI_GETBORDER                        5
#DEFINE SPI_SETBORDER                        6
#DEFINE SPI_GETKEYBOARDSPEED                 10
#DEFINE SPI_SETKEYBOARDSPEED                 11
#DEFINE SPI_LANGDRIVER                       12
#DEFINE SPI_ICONHORIZONTALSPACING            13
#DEFINE SPI_GETSCREENSAVETIMEOUT             14
#DEFINE SPI_SETSCREENSAVETIMEOUT             15
#DEFINE SPI_GETSCREENSAVEACTIVE              16
#DEFINE SPI_SETSCREENSAVEACTIVE              17
#DEFINE SPI_GETGRIDGRANULARITY               18
#DEFINE SPI_SETGRIDGRANULARITY               19
#DEFINE SPI_SETDESKWALLPAPER                 20
#DEFINE SPI_SETDESKPATTERN                   21
#DEFINE SPI_GETKEYBOARDDELAY                 22
#DEFINE SPI_SETKEYBOARDDELAY                 23
#DEFINE SPI_ICONVERTICALSPACING              24
#DEFINE SPI_GETICONTITLEWRAP                 25
#DEFINE SPI_SETICONTITLEWRAP                 26
#DEFINE SPI_GETMENUDROPALIGNMENT             27
#DEFINE SPI_SETMENUDROPALIGNMENT             28
#DEFINE SPI_SETDOUBLECLKWIDTH                29
#DEFINE SPI_SETDOUBLECLKHEIGHT               30
#DEFINE SPI_GETICONTITLELOGFONT              31
#DEFINE SPI_SETDOUBLECLICKTIME               32
#DEFINE SPI_SETMOUSEBUTTONSWAP               33
#DEFINE SPI_SETICONTITLELOGFONT              34
#DEFINE SPI_GETFASTTASKSWITCH                35
#DEFINE SPI_SETFASTTASKSWITCH                36
#DEFINE SPI_SETDRAGFULLWINDOWS               37
#DEFINE SPI_GETDRAGFULLWINDOWS               38
#DEFINE SPI_GETNONCLIENTMETRICS              41
#DEFINE SPI_SETNONCLIENTMETRICS              42
#DEFINE SPI_GETMINIMIZEDMETRICS              43
#DEFINE SPI_SETMINIMIZEDMETRICS              44
#DEFINE SPI_GETICONMETRICS                   45
#DEFINE SPI_SETICONMETRICS                   46
#DEFINE SPI_SETWORKAREA                      47
#DEFINE SPI_GETWORKAREA                      48
#DEFINE SPI_SETPENWINDOWS                    49
#DEFINE SPI_GETHIGHCONTRAST                  66
#DEFINE SPI_SETHIGHCONTRAST                  67
#DEFINE SPI_GETKEYBOARDPREF                  68
#DEFINE SPI_SETKEYBOARDPREF                  69
#DEFINE SPI_GETSCREENREADER                  70
#DEFINE SPI_SETSCREENREADER                  71
#DEFINE SPI_GETANIMATION                     72
#DEFINE SPI_SETANIMATION                     73
#DEFINE SPI_GETFONTSMOOTHING                 74
#DEFINE SPI_SETFONTSMOOTHING                 75
#DEFINE SPI_SETDRAGWIDTH                     76
#DEFINE SPI_SETDRAGHEIGHT                    77
#DEFINE SPI_SETHANDHELD                      78
#DEFINE SPI_GETLOWPOWERTIMEOUT               79
#DEFINE SPI_GETPOWEROFFTIMEOUT               80
#DEFINE SPI_SETLOWPOWERTIMEOUT               81
#DEFINE SPI_SETPOWEROFFTIMEOUT               82
#DEFINE SPI_GETLOWPOWERACTIVE                83
#DEFINE SPI_GETPOWEROFFACTIVE                84
#DEFINE SPI_SETLOWPOWERACTIVE                85
#DEFINE SPI_SETPOWEROFFACTIVE                86
#DEFINE SPI_SETCURSORS                       87
#DEFINE SPI_SETICONS                         88
#DEFINE SPI_GETDEFAULTINPUTLANG              89
#DEFINE SPI_SETDEFAULTINPUTLANG              90
#DEFINE SPI_SETLANGTOGGLE                    91
#DEFINE SPI_GETWINDOWSEXTENSION              92
#DEFINE SPI_SETMOUSETRAILS                   93
#DEFINE SPI_GETMOUSETRAILS                   94
#DEFINE SPI_SCREENSAVERRUNNING               97
#DEFINE SPI_GETFILTERKEYS                    50
#DEFINE SPI_SETFILTERKEYS                    51
#DEFINE SPI_GETTOGGLEKEYS                    52
#DEFINE SPI_SETTOGGLEKEYS                    53
#DEFINE SPI_GETMOUSEKEYS                     54
#DEFINE SPI_SETMOUSEKEYS                     55
#DEFINE SPI_GETSHOWSOUNDS                    56
#DEFINE SPI_SETSHOWSOUNDS                    57
#DEFINE SPI_GETSTICKYKEYS                    58
#DEFINE SPI_SETSTICKYKEYS                    59
#DEFINE SPI_GETACCESSTIMEOUT                 60
#DEFINE SPI_SETACCESSTIMEOUT                 61
#DEFINE SPI_GETSERIALKEYS                    62
#DEFINE SPI_SETSERIALKEYS                    63
#DEFINE SPI_GETSOUNDSENTRY                   64
#DEFINE SPI_SETSOUNDSENTRY                   65
#DEFINE SPIF_UPDATEINIFILE                   1
#DEFINE SPIF_SENDWININICHANGE                2
#DEFINE SPIF_SENDCHANGE                      SPIF_SENDWININICHANGE
#DEFINE METRICS_USEDEFAULT                   -1
#DEFINE ARW_BOTTOMLEFT                       0
#DEFINE ARW_BOTTOMRIGHT                      1
#DEFINE ARW_TOPLEFT                          2
#DEFINE ARW_TOPRIGHT                         3
#DEFINE ARW_STARTMASK                        3
#DEFINE ARW_STARTRIGHT                       1
#DEFINE ARW_STARTTOP                         2
#DEFINE ARW_LEFT                             0
#DEFINE ARW_RIGHT                            0
#DEFINE ARW_UP                               4
#DEFINE ARW_DOWN                             4
#DEFINE ARW_HIDE                             8
#DEFINE ARW_VALID                            16
#DEFINE SERKF_SERIALKEYSON                   1
#DEFINE SERKF_AVAILABLE                      2
#DEFINE SERKF_INDICATOR                      4
#DEFINE HCF_HIGHCONTRASTON                   1
#DEFINE HCF_AVAILABLE                        2
#DEFINE HCF_HOTKEYACTIVE                     4
#DEFINE HCF_CONFIRMHOTKEY                    8
#DEFINE HCF_HOTKEYSOUND                      16
#DEFINE HCF_INDICATOR                        32
#DEFINE HCF_HOTKEYAVAILABLE                  64
#DEFINE CDS_UPDATEREGISTRY                   1
#DEFINE CDS_TEST                             2
#DEFINE CDS_FULLSCREEN                       4
#DEFINE DISP_CHANGE_SUCCESSFUL               0
#DEFINE DISP_CHANGE_RESTART                  1
#DEFINE DISP_CHANGE_FAILED                   -1
#DEFINE DISP_CHANGE_BADMODE                  -2
#DEFINE DISP_CHANGE_NOTUPDATED               -3
#DEFINE DISP_CHANGE_BADFLAGS                 -4
#DEFINE FKF_FILTERKEYSON                     1
#DEFINE FKF_AVAILABLE                        2
#DEFINE FKF_HOTKEYACTIVE                     4
#DEFINE FKF_CONFIRMHOTKEY                    8
#DEFINE FKF_HOTKEYSOUND                      16
#DEFINE FKF_INDICATOR                        32
#DEFINE FKF_CLICKON                          64
#DEFINE SKF_STICKYKEYSON                     1
#DEFINE SKF_AVAILABLE                        2
#DEFINE SKF_HOTKEYACTIVE                     4
#DEFINE SKF_CONFIRMHOTKEY                    8
#DEFINE SKF_HOTKEYSOUND                      16
#DEFINE SKF_INDICATOR                        32
#DEFINE SKF_AUDIBLEFEEDBACK                  64
#DEFINE SKF_TRISTATE                         128
#DEFINE SKF_TWOKEYSOFF                       256
#DEFINE MKF_MOUSEKEYSON                      1
#DEFINE MKF_AVAILABLE                        2
#DEFINE MKF_HOTKEYACTIVE                     4
#DEFINE MKF_CONFIRMHOTKEY                    8
#DEFINE MKF_HOTKEYSOUND                      16
#DEFINE MKF_INDICATOR                        32
#DEFINE MKF_MODIFIERS                        64
#DEFINE MKF_REPLACENUMBERS                   128
#DEFINE ATF_TIMEOUTON                        1
#DEFINE ATF_ONOFFFEEDBACK                    2
#DEFINE SSGF_NONE                            0
#DEFINE SSGF_DISPLAY                         3
#DEFINE SSTF_NONE                            0
#DEFINE SSTF_CHARS                           1
#DEFINE SSTF_BORDER                          2
#DEFINE SSTF_DISPLAY                         3
#DEFINE SSWF_NONE                            0
#DEFINE SSWF_TITLE                           1
#DEFINE SSWF_WINDOW                          2
#DEFINE SSWF_DISPLAY                         3
#DEFINE SSWF_CUSTOM                          4
#DEFINE SSF_SOUNDSENTRYON                    1
#DEFINE SSF_AVAILABLE                        2
#DEFINE SSF_INDICATOR                        4
#DEFINE TKF_TOGGLEKEYSON                     1
#DEFINE TKF_AVAILABLE                        2
#DEFINE TKF_HOTKEYACTIVE                     4
#DEFINE TKF_CONFIRMHOTKEY                    8
#DEFINE TKF_HOTKEYSOUND                      16
#DEFINE TKF_INDICATOR                        32
#DEFINE SLE_ERROR                            1
#DEFINE SLE_MINORERROR                       2
#DEFINE SLE_WARNING                          3

*-- WINGDI.H
#DEFINE R2_BLACK                             1
#DEFINE R2_NOTMERGEPEN                       2
#DEFINE R2_MASKNOTPEN                        3
#DEFINE R2_NOTCOPYPEN                        4
#DEFINE R2_MASKPENNOT                        5
#DEFINE R2_NOT                               6
#DEFINE R2_XORPEN                            7
#DEFINE R2_NOTMASKPEN                        8
#DEFINE R2_MASKPEN                           9
#DEFINE R2_NOTXORPEN                         10
#DEFINE R2_NOP                               11
#DEFINE R2_MERGENOTPEN                       12
#DEFINE R2_COPYPEN                           13
#DEFINE R2_MERGEPENNOT                       14
#DEFINE R2_MERGEPEN                          15
#DEFINE R2_WHITE                             16
#DEFINE R2_LAST                              16
#DEFINE SRCCOPY                              14483488
#DEFINE SRCPAINT                             16711814
#DEFINE SRCAND                               8913110
#DEFINE SRCINVERT                            6684742
#DEFINE SRCERASE                             4457256
#DEFINE NOTSRCCOPY                           3342344
#DEFINE NOTSRCERASE                          1114294
#DEFINE MERGECOPY                            13631707
#DEFINE MERGEPAINT                           13369894
#DEFINE PATCOPY                              16777249
#DEFINE PATPAINT                             17566473
#DEFINE PATINVERT                            5963849
#DEFINE DSTINVERT                            5570569
#DEFINE BLACKNESS                            66
#DEFINE WHITENESS                            17825890
#DEFINE GDI_ERROR                            4581298448
#DEFINE HGDI_ERROR                           4581298448
#DEFINE ERROR                                0
#DEFINE NULLREGION                           1
#DEFINE SIMPLEREGION                         2
#DEFINE COMPLEXREGION                        3
#DEFINE RGN_AND                              1
#DEFINE RGN_OR                               2
#DEFINE RGN_XOR                              3
#DEFINE RGN_DIFF                             4
#DEFINE RGN_COPY                             5
#DEFINE RGN_MIN                              RGN_AND
#DEFINE RGN_MAX                              RGN_COPY
#DEFINE BLACKONWHITE                         1
#DEFINE WHITEONBLACK                         2
#DEFINE COLORONCOLOR                         3
#DEFINE HALFTONE                             4
#DEFINE MAXSTRETCHBLTMODE                    4
#DEFINE STRETCH_ANDSCANS                     BLACKONWHITE
#DEFINE STRETCH_ORSCANS                      WHITEONBLACK
#DEFINE STRETCH_DELETESCANS                  COLORONCOLOR
#DEFINE STRETCH_HALFTONE                     HALFTONE
#DEFINE ALTERNATE                            1
#DEFINE WINDING                              2
#DEFINE POLYFILL_LAST                        2
#DEFINE TA_NOUPDATECP                        0
#DEFINE TA_UPDATECP                          1
#DEFINE TA_LEFT                              0
#DEFINE TA_RIGHT                             2
#DEFINE TA_CENTER                            6
#DEFINE TA_TOP                               0
#DEFINE TA_BOTTOM                            8
#DEFINE TA_BASELINE                          24
#DEFINE TA_RTLREADING                        256
#DEFINE TA_MASK                              TA_BASELINE + TA_CENTER + TA_UPDATECP + TA_RTLREADING
#DEFINE VTA_BASELINE                         TA_BASELINE
#DEFINE VTA_LEFT                             TA_BOTTOM
#DEFINE VTA_RIGHT                            TA_TOP
#DEFINE VTA_CENTER                           TA_CENTER
#DEFINE VTA_BOTTOM                           TA_RIGHT
#DEFINE VTA_TOP                              TA_LEFT
#DEFINE ETO_OPAQUE                           2
#DEFINE ETO_CLIPPED                          4
#DEFINE ETO_GLYPH_INDEX                      16
#DEFINE ETO_RTLREADING                       128
#DEFINE ASPECT_FILTERING                     1
#DEFINE DCB_RESET                            1
#DEFINE DCB_ACCUMULATE                       2
#DEFINE DCB_DIRTY                            DCB_ACCUMULATE
#DEFINE DCB_ENABLE                           4
#DEFINE DCB_DISABLE                          8
#DEFINE META_SETBKCOLOR                      513
#DEFINE META_SETBKMODE                       258
#DEFINE META_SETMAPMODE                      259
#DEFINE META_SETROP2                         260
#DEFINE META_SETRELABS                       261
#DEFINE META_SETPOLYFILLMODE                 262
#DEFINE META_SETSTRETCHBLTMODE               263
#DEFINE META_SETTEXTCHAREXTRA                264
#DEFINE META_SETTEXTCOLOR                    521
#DEFINE META_SETTEXTJUSTIFICATION            523
#DEFINE META_SETWINDOWORG                    524
#DEFINE META_SETWINDOWEXT                    525
#DEFINE META_SETVIEWPORTORG                  526
#DEFINE META_SETVIEWPORTEXT                  527
#DEFINE META_OFFSETWINDOWORG                 528
#DEFINE META_SCALEWINDOWEXT                  1040
#DEFINE META_OFFSETVIEWPORTORG               529
#DEFINE META_SCALEVIEWPORTEXT                1042
#DEFINE META_LINETO                          531
#DEFINE META_MOVETO                          532
#DEFINE META_EXCLUDECLIPRECT                 1045
#DEFINE META_INTERSECTCLIPRECT               1046
#DEFINE META_ARC                             2071
#DEFINE META_ELLIPSE                         1048
#DEFINE META_FLOODFILL                       1049
#DEFINE META_PIE                             2075
#DEFINE META_RECTANGLE                       1052
#DEFINE META_ROUNDRECT                       1565
#DEFINE META_PATBLT                          1566
#DEFINE META_SAVEDC                          31
#DEFINE META_SETPIXEL                        1056
#DEFINE META_OFFSETCLIPRGN                   544
#DEFINE META_TEXTOUT                         1313
#DEFINE META_BITBLT                          2338
#DEFINE META_STRETCHBLT                      3107
#DEFINE META_POLYGON                         804
#DEFINE META_POLYLINE                        805
#DEFINE META_ESCAPE                          1574
#DEFINE META_RESTOREDC                       295
#DEFINE META_FILLREGION                      552
#DEFINE META_FRAMEREGION                     1065
#DEFINE META_INVERTREGION                    299
#DEFINE META_PAINTREGION                     300
#DEFINE META_SELECTCLIPREGION                301
#DEFINE META_SELECTOBJECT                    302
#DEFINE META_SETTEXTALIGN                    303
#DEFINE META_CHORD                           2096
#DEFINE META_SETMAPPERFLAGS                  561
#DEFINE META_EXTTEXTOUT                      2866
#DEFINE META_SETDIBTODEV                     3635
#DEFINE META_SELECTPALETTE                   564
#DEFINE META_REALIZEPALETTE                  53
#DEFINE META_ANIMATEPALETTE                  1078
#DEFINE META_SETPALENTRIES                   55
#DEFINE META_POLYPOLYGON                     1336
#DEFINE META_RESIZEPALETTE                   313
#DEFINE META_DIBBITBLT                       2368
#DEFINE META_DIBSTRETCHBLT                   3137
#DEFINE META_DIBCREATEPATTERNBRUSH           322
#DEFINE META_STRETCHDIB                      4163
#DEFINE META_EXTFLOODFILL                    1352
#DEFINE META_DELETEOBJECT                    512
#DEFINE META_CREATEPALETTE                   263
#DEFINE META_CREATEPATTERNBRUSH              521
#DEFINE META_CREATEPENINDIRECT               779
#DEFINE META_CREATEFONTINDIRECT              780
#DEFINE META_CREATEBRUSHINDIRECT             781
#DEFINE META_CREATEREGION                    1808
#DEFINE NEWFRAME                             1
#DEFINE ABORTDOC                             2
#DEFINE NEXTBAND                             3
#DEFINE SETCOLORTABLE                        4
#DEFINE GETCOLORTABLE                        5
#DEFINE FLUSHOUTPUT                          6
#DEFINE DRAFTMODE                            7
#DEFINE QUERYESCSUPPORT                      8
#DEFINE SETABORTPROC                         9
#DEFINE STARTDOC                             10
#DEFINE ENDDOC                               11
#DEFINE GETPHYSPAGESIZE                      12
#DEFINE GETPRINTINGOFFSET                    13
#DEFINE GETSCALINGFACTOR                     14
#DEFINE MFCOMMENT                            15
#DEFINE GETPENWIDTH                          16
#DEFINE SETCOPYCOUNT                         17
#DEFINE SELECTPAPERSOURCE                    18
#DEFINE DEVICEDATA                           19
#DEFINE PASSTHROUGH                          19
#DEFINE GETTECHNOLGY                         20
#DEFINE GETTECHNOLOGY                        20
#DEFINE SETLINECAP                           21
#DEFINE SETLINEJOIN                          22
#DEFINE SETMITERLIMIT                        23
#DEFINE BANDINFO                             24
#DEFINE DRAWPATTERNRECT                      25
#DEFINE GETVECTORPENSIZE                     26
#DEFINE GETVECTORBRUSHSIZE                   27
#DEFINE ENABLEDUPLEX                         28
#DEFINE GETSETPAPERBINS                      29
#DEFINE GETSETPRINTORIENT                    30
#DEFINE ENUMPAPERBINS                        31
#DEFINE SETDIBSCALING                        32
#DEFINE EPSPRINTING                          33
#DEFINE ENUMPAPERMETRICS                     34
#DEFINE GETSETPAPERMETRICS                   35
#DEFINE POSTSCRIPT_DATA                      37
#DEFINE POSTSCRIPT_IGNORE                    38
#DEFINE MOUSETRAILS                          39
#DEFINE GETDEVICEUNITS                       42
#DEFINE GETEXTENDEDTEXTMETRICS               256
#DEFINE GETEXTENTTABLE                       257
#DEFINE GETPAIRKERNTABLE                     258
#DEFINE GETTRACKKERNTABLE                    259
#DEFINE EXTTEXTOUT                           512
#DEFINE GETFACENAME                          513
#DEFINE DOWNLOADFACE                         514
#DEFINE ENABLERELATIVEWIDTHS                 768
#DEFINE ENABLEPAIRKERNING                    769
#DEFINE SETKERNTRACK                         770
#DEFINE SETALLJUSTVALUES                     771
#DEFINE SETCHARSET                           772
#DEFINE STRETCHBLT                           2048
#DEFINE GETSETSCREENPARAMS                   3072
#DEFINE QUERYDIBSUPPORT                      3073
#DEFINE BEGIN_PATH                           4096
#DEFINE CLIP_TO_PATH                         4097
#DEFINE END_PATH                             4098
#DEFINE EXT_DEVICE_CAPS                      4099
#DEFINE RESTORE_CTM                          4100
#DEFINE SAVE_CTM                             4101
#DEFINE SET_ARC_DIRECTION                    4102
#DEFINE SET_BACKGROUND_COLOR                 4103
#DEFINE SET_POLY_MODE                        4104
#DEFINE SET_SCREEN_ANGLE                     4105
#DEFINE SET_SPREAD                           4106
#DEFINE TRANSFORM_CTM                        4107
#DEFINE SET_CLIP_BOX                         4108
#DEFINE SET_BOUNDS                           4109
#DEFINE SET_MIRROR_MODE                      4110
#DEFINE OPENCHANNEL                          4110
#DEFINE DOWNLOADHEADER                       4111
#DEFINE CLOSECHANNEL                         4112
#DEFINE POSTSCRIPT_PASSTHROUGH               4115
#DEFINE ENCAPSULATED_POSTSCRIPT              4116
#DEFINE QDI_SETDIBITS                        1
#DEFINE QDI_GETDIBITS                        2
#DEFINE QDI_DIBTOSCREEN                      4
#DEFINE QDI_STRETCHDIB                       8
#DEFINE SP_NOTREPORTED                       16384
#DEFINE SP_ERROR                             -1
#DEFINE SP_APPABORT                          -2
#DEFINE SP_USERABORT                         -3
#DEFINE SP_OUTOFDISK                         -4
#DEFINE SP_OUTOFMEMORY                       -5
#DEFINE PR_JOBSTATUS                         0
#DEFINE OBJ_PEN                              1
#DEFINE OBJ_BRUSH                            2
#DEFINE OBJ_DC                               3
#DEFINE OBJ_METADC                           4
#DEFINE OBJ_PAL                              5
#DEFINE OBJ_FONT                             6
#DEFINE OBJ_BITMAP                           7
#DEFINE OBJ_REGION                           8
#DEFINE OBJ_METAFILE                         9
#DEFINE OBJ_MEMDC                            10
#DEFINE OBJ_EXTPEN                           11
#DEFINE OBJ_ENHMETADC                        12
#DEFINE OBJ_ENHMETAFILE                      13
#DEFINE MWT_IDENTITY                         1
#DEFINE MWT_LEFTMULTIPLY                     2
#DEFINE MWT_RIGHTMULTIPLY                    3
#DEFINE MWT_MIN                              MWT_IDENTITY
#DEFINE MWT_MAX                              MWT_RIGHTMULTIPLY
#DEFINE CM_OUT_OF_GAMUT                      255
#DEFINE CM_IN_GAMUT                          0
#DEFINE BI_RGB                               0
#DEFINE BI_RLE8                              1
#DEFINE BI_RLE4                              2
#DEFINE BI_BITFIELDS                         3
#DEFINE TCI_SRCCHARSET                       1
#DEFINE TCI_SRCCODEPAGE                      2
#DEFINE TCI_SRCFONTSIG                       3
#DEFINE TMPF_FIXED_PITCH                     1
#DEFINE TMPF_VECTOR                          2
#DEFINE TMPF_DEVICE                          8
#DEFINE TMPF_TRUETYPE                        4
#DEFINE NTM_REGULAR                          64
#DEFINE NTM_BOLD                             32
#DEFINE NTM_ITALIC                           1
#DEFINE LF_FACESIZE                          32
#DEFINE LF_FULLFACESIZE                      64
#DEFINE OUT_DEFAULT_PRECIS                   0
#DEFINE OUT_STRING_PRECIS                    1
#DEFINE OUT_CHARACTER_PRECIS                 2
#DEFINE OUT_STROKE_PRECIS                    3
#DEFINE OUT_TT_PRECIS                        4
#DEFINE OUT_DEVICE_PRECIS                    5
#DEFINE OUT_RASTER_PRECIS                    6
#DEFINE OUT_TT_ONLY_PRECIS                   7
#DEFINE OUT_OUTLINE_PRECIS                   8
#DEFINE CLIP_DEFAULT_PRECIS                  0
#DEFINE CLIP_CHARACTER_PRECIS                1
#DEFINE CLIP_STROKE_PRECIS                   2
#DEFINE CLIP_MASK                            16
#DEFINE DEFAULT_QUALITY                      0
#DEFINE DRAFT_QUALITY                        1
#DEFINE PROOF_QUALITY                        2
#DEFINE NONANTIALIASED_QUALITY               3
#DEFINE ANTIALIASED_QUALITY                  4
#DEFINE DEFAULT_PITCH                        0
#DEFINE FIXED_PITCH                          1
#DEFINE VARIABLE_PITCH                       2
#DEFINE MONO_FONT                            8
#DEFINE ANSI_CHARSET                         0
#DEFINE DEFAULT_CHARSET                      1
#DEFINE SYMBOL_CHARSET                       2
#DEFINE SHIFTJIS_CHARSET                     128
#DEFINE HANGEUL_CHARSET                      129
#DEFINE GB2312_CHARSET                       134
#DEFINE CHINESEBIG5_CHARSET                  136
#DEFINE OEM_CHARSET                          255
#DEFINE JOHAB_CHARSET                        130
#DEFINE HEBREW_CHARSET                       177
#DEFINE ARABIC_CHARSET                       178
#DEFINE GREEK_CHARSET                        161
#DEFINE TURKISH_CHARSET                      162
#DEFINE THAI_CHARSET                         222
#DEFINE EASTEUROPE_CHARSET                   238
#DEFINE RUSSIAN_CHARSET                      204
#DEFINE MAC_CHARSET                          77
#DEFINE FS_JOHAB                             2097152
#DEFINE FS_SYMBOL                            2147483648
#DEFINE FW_DONTCARE                          0
#DEFINE FW_THIN                              100
#DEFINE FW_EXTRALIGHT                        200
#DEFINE FW_LIGHT                             300
#DEFINE FW_NORMAL                            400
#DEFINE FW_MEDIUM                            500
#DEFINE FW_SEMIBOLD                          600
#DEFINE FW_BOLD                              700
#DEFINE FW_EXTRABOLD                         800
#DEFINE FW_HEAVY                             900
#DEFINE FW_ULTRALIGHT                        FW_EXTRALIGHT
#DEFINE FW_REGULAR                           FW_NORMAL
#DEFINE FW_DEMIBOLD                          FW_SEMIBOLD
#DEFINE FW_ULTRABOLD                         FW_EXTRABOLD
#DEFINE FW_BLACK                             FW_HEAVY
#DEFINE PANOSE_COUNT                         10
#DEFINE PAN_FAMILYTYPE_INDEX                 0
#DEFINE PAN_SERIFSTYLE_INDEX                 1
#DEFINE PAN_WEIGHT_INDEX                     2
#DEFINE PAN_PROPORTION_INDEX                 3
#DEFINE PAN_CONTRAST_INDEX                   4
#DEFINE PAN_STROKEVARIATION_INDEX            5
#DEFINE PAN_ARMSTYLE_INDEX                   6
#DEFINE PAN_LETTERFORM_INDEX                 7
#DEFINE PAN_MIDLINE_INDEX                    8
#DEFINE PAN_XHEIGHT_INDEX                    9
#DEFINE PAN_CULTURE_LATIN                    0
#DEFINE PAN_ANY                              0
#DEFINE PAN_NO_FIT                           1
#DEFINE PAN_FAMILY_TEXT_DISPLAY              2
#DEFINE PAN_FAMILY_SCRIPT                    3
#DEFINE PAN_FAMILY_DECORATIVE                4
#DEFINE PAN_FAMILY_PICTORIAL                 5
#DEFINE PAN_SERIF_COVE                       2
#DEFINE PAN_SERIF_OBTUSE_COVE                3
#DEFINE PAN_SERIF_SQUARE_COVE                4
#DEFINE PAN_SERIF_OBTUSE_SQUARE_COVE         5
#DEFINE PAN_SERIF_SQUARE                     6
#DEFINE PAN_SERIF_THIN                       7
#DEFINE PAN_SERIF_BONE                       8
#DEFINE PAN_SERIF_EXAGGERATED                9
#DEFINE PAN_SERIF_TRIANGLE                   10
#DEFINE PAN_SERIF_NORMAL_SANS                11
#DEFINE PAN_SERIF_OBTUSE_SANS                12
#DEFINE PAN_SERIF_PERP_SANS                  13
#DEFINE PAN_SERIF_FLARED                     14
#DEFINE PAN_SERIF_ROUNDED                    15
#DEFINE PAN_WEIGHT_VERY_LIGHT                2
#DEFINE PAN_WEIGHT_LIGHT                     3
#DEFINE PAN_WEIGHT_THIN                      4
#DEFINE PAN_WEIGHT_BOOK                      5
#DEFINE PAN_WEIGHT_MEDIUM                    6
#DEFINE PAN_WEIGHT_DEMI                      7
#DEFINE PAN_WEIGHT_BOLD                      8
#DEFINE PAN_WEIGHT_HEAVY                     9
#DEFINE PAN_WEIGHT_BLACK                     10
#DEFINE PAN_WEIGHT_NORD                      11
#DEFINE PAN_PROP_OLD_STYLE                   2
#DEFINE PAN_PROP_MODERN                      3
#DEFINE PAN_PROP_EVEN_WIDTH                  4
#DEFINE PAN_PROP_EXPANDED                    5
#DEFINE PAN_PROP_CONDENSED                   6
#DEFINE PAN_PROP_VERY_EXPANDED               7
#DEFINE PAN_PROP_VERY_CONDENSED              8
#DEFINE PAN_PROP_MONOSPACED                  9
#DEFINE PAN_CONTRAST_NONE                    2
#DEFINE PAN_CONTRAST_VERY_LOW                3
#DEFINE PAN_CONTRAST_LOW                     4
#DEFINE PAN_CONTRAST_MEDIUM_LOW              5
#DEFINE PAN_CONTRAST_MEDIUM                  6
#DEFINE PAN_CONTRAST_MEDIUM_HIGH             7
#DEFINE PAN_CONTRAST_HIGH                    8
#DEFINE PAN_CONTRAST_VERY_HIGH               9
#DEFINE PAN_STROKE_GRADUAL_DIAG              2
#DEFINE PAN_STROKE_GRADUAL_TRAN              3
#DEFINE PAN_STROKE_GRADUAL_VERT              4
#DEFINE PAN_STROKE_GRADUAL_HORZ              5
#DEFINE PAN_STROKE_RAPID_VERT                6
#DEFINE PAN_STROKE_RAPID_HORZ                7
#DEFINE PAN_STROKE_INSTANT_VERT              8
#DEFINE PAN_STRAIGHT_ARMS_HORZ               2
#DEFINE PAN_STRAIGHT_ARMS_WEDGE              3
#DEFINE PAN_STRAIGHT_ARMS_VERT               4
#DEFINE PAN_STRAIGHT_ARMS_SINGLE_SERIF       5
#DEFINE PAN_STRAIGHT_ARMS_DOUBLE_SERIF       6
#DEFINE PAN_BENT_ARMS_HORZ                   7
#DEFINE PAN_BENT_ARMS_WEDGE                  8
#DEFINE PAN_BENT_ARMS_VERT                   9
#DEFINE PAN_BENT_ARMS_SINGLE_SERIF           10
#DEFINE PAN_BENT_ARMS_DOUBLE_SERIF           11
#DEFINE PAN_LETT_NORMAL_CONTACT              2
#DEFINE PAN_LETT_NORMAL_WEIGHTED             3
#DEFINE PAN_LETT_NORMAL_BOXED                4
#DEFINE PAN_LETT_NORMAL_FLATTENED            5
#DEFINE PAN_LETT_NORMAL_ROUNDED              6
#DEFINE PAN_LETT_NORMAL_OFF_CENTER           7
#DEFINE PAN_LETT_NORMAL_SQUARE               8
#DEFINE PAN_LETT_OBLIQUE_CONTACT             9
#DEFINE PAN_LETT_OBLIQUE_WEIGHTED            10
#DEFINE PAN_LETT_OBLIQUE_BOXED               11
#DEFINE PAN_LETT_OBLIQUE_FLATTENED           12
#DEFINE PAN_LETT_OBLIQUE_ROUNDED             13
#DEFINE PAN_LETT_OBLIQUE_OFF_CENTER          14
#DEFINE PAN_LETT_OBLIQUE_SQUARE              15
#DEFINE PAN_MIDLINE_STANDARD_TRIMMED         2
#DEFINE PAN_MIDLINE_STANDARD_POINTED         3
#DEFINE PAN_MIDLINE_STANDARD_SERIFED         4
#DEFINE PAN_MIDLINE_HIGH_TRIMMED             5
#DEFINE PAN_MIDLINE_HIGH_POINTED             6
#DEFINE PAN_MIDLINE_HIGH_SERIFED             7
#DEFINE PAN_MIDLINE_CONSTANT_TRIMMED         8
#DEFINE PAN_MIDLINE_CONSTANT_POINTED         9
#DEFINE PAN_MIDLINE_CONSTANT_SERIFED         10
#DEFINE PAN_MIDLINE_LOW_TRIMMED              11
#DEFINE PAN_MIDLINE_LOW_POINTED              12
#DEFINE PAN_MIDLINE_LOW_SERIFED              13
#DEFINE PAN_XHEIGHT_CONSTANT_SMALL           2
#DEFINE PAN_XHEIGHT_CONSTANT_STD             3
#DEFINE PAN_XHEIGHT_CONSTANT_LARGE           4
#DEFINE PAN_XHEIGHT_DUCKING_SMALL            5
#DEFINE PAN_XHEIGHT_DUCKING_STD              6
#DEFINE PAN_XHEIGHT_DUCKING_LARGE            7
#DEFINE ELF_VENDOR_SIZE                      4
#DEFINE ELF_VERSION                          0
#DEFINE ELF_CULTURE_LATIN                    0
#DEFINE RASTER_FONTTYPE                      1
#DEFINE DEVICE_FONTTYPE                      2
#DEFINE TRUETYPE_FONTTYPE                    4
#DEFINE PALETTEINDEXi                        16777216
#DEFINE PC_RESERVED                          1
#DEFINE PC_EXPLICIT                          2
#DEFINE PC_NOCOLLAPSE                        4
#DEFINE TRANSPARENT                          1
#DEFINE OPAQUE                               2
#DEFINE BKMODE_LAST                          2
#DEFINE GM_COMPATIBLE                        1
#DEFINE GM_ADVANCED                          2
#DEFINE GM_LAST                              2
#DEFINE PT_CLOSEFIGURE                       1
#DEFINE PT_LINETO                            2
#DEFINE PT_BEZIERTO                          4
#DEFINE PT_MOVETO                            6
#DEFINE MM_TEXT                              1
#DEFINE MM_LOMETRIC                          2
#DEFINE MM_HIMETRIC                          3
#DEFINE MM_LOENGLISH                         4
#DEFINE MM_HIENGLISH                         5
#DEFINE MM_TWIPS                             6
#DEFINE MM_ISOTROPIC                         7
#DEFINE MM_ANISOTROPIC                       8
#DEFINE MM_MIN                               MM_TEXT
#DEFINE MM_MAX                               MM_ANISOTROPIC
#DEFINE MM_MAX_FIXEDSCALE                    MM_TWIPS
#DEFINE ABSOLUTE                             1
#DEFINE RELATIVE                             2
#DEFINE WHITE_BRUSH                          0
#DEFINE LTGRAY_BRUSH                         1
#DEFINE GRAY_BRUSH                           2
#DEFINE DKGRAY_BRUSH                         3
#DEFINE BLACK_BRUSH                          4
#DEFINE NULL_BRUSH                           5
#DEFINE HOLLOW_BRUSH                         NULL_BRUSH
#DEFINE WHITE_PEN                            6
#DEFINE BLACK_PEN                            7
#DEFINE NULL_PEN                             8
#DEFINE OEM_FIXED_FONT                       10
#DEFINE ANSI_FIXED_FONT                      11
#DEFINE ANSI_VAR_FONT                        12
#DEFINE SYSTEM_FONT                          13
#DEFINE DEVICE_DEFAULT_FONT                  14
#DEFINE DEFAULT_PALETTE                      15
#DEFINE SYSTEM_FIXED_FONT                    16
#DEFINE DEFAULT_GUI_FONT                     17
#DEFINE STOCK_LAST                           17
#DEFINE CLR_INVALID                          4581298448
#DEFINE BS_SOLID                             0
#DEFINE BS_NULL                              1
#DEFINE BS_HOLLOW                            BS_NULL
#DEFINE BS_HATCHED                           2
#DEFINE BS_PATTERN                           3
#DEFINE BS_INDEXED                           4
#DEFINE BS_DIBPATTERN                        5
#DEFINE BS_DIBPATTERNPT                      6
#DEFINE BS_PATTERN8X8                        7
#DEFINE BS_DIBPATTERN8X8                     8
#DEFINE HS_HORIZONTAL                        0
#DEFINE HS_VERTICAL                          1
#DEFINE HS_FDIAGONAL                         2
#DEFINE HS_BDIAGONAL                         3
#DEFINE HS_CROSS                             4
#DEFINE HS_DIAGCROSS                         5
#DEFINE PS_SOLID                             0
#DEFINE PS_DASH                              1
#DEFINE PS_DOT                               2
#DEFINE PS_DASHDOT                           3
#DEFINE PS_DASHDOTDOT                        4
#DEFINE PS_NULL                              5
#DEFINE PS_INSIDEFRAME                       6
#DEFINE PS_USERSTYLE                         7
#DEFINE PS_ALTERNATE                         8
#DEFINE PS_STYLE_MASK                        16
#DEFINE PS_ENDCAP_ROUND                      0
#DEFINE PS_ENDCAP_SQUARE                     256
#DEFINE PS_ENDCAP_FLAT                       512
#DEFINE PS_ENDCAP_MASK                       4096
#DEFINE PS_JOIN_ROUND                        0
#DEFINE PS_JOIN_BEVEL                        4096
#DEFINE PS_JOIN_MITER                        8192
#DEFINE PS_JOIN_MASK                         65536
#DEFINE PS_COSMETIC                          0
#DEFINE PS_GEOMETRIC                         65536
#DEFINE PS_TYPE_MASK                         1048576
#DEFINE AD_COUNTERCLOCKWISE                  1
#DEFINE AD_CLOCKWISE                         2
#DEFINE DRIVERVERSION                        0
#DEFINE TECHNOLOGY                           2
#DEFINE HORZSIZE                             4
#DEFINE VERTSIZE                             6
#DEFINE HORZRES                              8
#DEFINE VERTRES                              10
#DEFINE BITSPIXEL                            12
#DEFINE PLANES                               14
#DEFINE NUMBRUSHES                           16
#DEFINE NUMPENS                              18
#DEFINE NUMMARKERS                           20
#DEFINE NUMFONTS                             22
#DEFINE NUMCOLORS                            24
#DEFINE PDEVICESIZE                          26
#DEFINE CURVECAPS                            28
#DEFINE LINECAPS                             30
#DEFINE POLYGONALCAPS                        32
#DEFINE TEXTCAPS                             34
#DEFINE CLIPCAPS                             36
#DEFINE RASTERCAPS                           38
#DEFINE ASPECTX                              40
#DEFINE ASPECTY                              42
#DEFINE ASPECTXY                             44
#DEFINE LOGPIXELSX                           88
#DEFINE LOGPIXELSY                           90
#DEFINE SIZEPALETTE                          104
#DEFINE NUMRESERVED                          106
#DEFINE COLORRES                             108
#DEFINE PHYSICALWIDTH                        110
#DEFINE PHYSICALHEIGHT                       111
#DEFINE PHYSICALOFFSETX                      112
#DEFINE PHYSICALOFFSETY                      113
#DEFINE SCALINGFACTORX                       114
#DEFINE SCALINGFACTORY                       115
#DEFINE VREFRESH                             116
#DEFINE DESKTOPVERTRES                       117
#DEFINE DESKTOPHORZRES                       118
#DEFINE BLTALIGNMENT                         119
#DEFINE DT_PLOTTER                           0
#DEFINE DT_RASDISPLAY                        1
#DEFINE DT_RASPRINTER                        2
#DEFINE DT_RASCAMERA                         3
#DEFINE DT_CHARSTREAM                        4
#DEFINE DT_METAFILE                          5
#DEFINE DT_DISPFILE                          6
#DEFINE CC_NONE                              0
#DEFINE CC_CIRCLES                           1
#DEFINE CC_PIE                               2
#DEFINE CC_CHORD                             4
#DEFINE CC_ELLIPSES                          8
#DEFINE CC_WIDE                              16
#DEFINE CC_STYLED                            32
#DEFINE CC_WIDESTYLED                        64
#DEFINE CC_INTERIORS                         128
#DEFINE CC_ROUNDRECT                         256
#DEFINE LC_NONE                              0
#DEFINE LC_POLYLINE                          2
#DEFINE LC_MARKER                            4
#DEFINE LC_POLYMARKER                        8
#DEFINE LC_WIDE                              16
#DEFINE LC_STYLED                            32
#DEFINE LC_WIDESTYLED                        64
#DEFINE LC_INTERIORS                         128
#DEFINE PC_NONE                              0
#DEFINE PC_POLYGON                           1
#DEFINE PC_RECTANGLE                         2
#DEFINE PC_WINDPOLYGON                       4
#DEFINE PC_TRAPEZOID                         4
#DEFINE PC_SCANLINE                          8
#DEFINE PC_WIDE                              16
#DEFINE PC_STYLED                            32
#DEFINE PC_WIDESTYLED                        64
#DEFINE PC_INTERIORS                         128
#DEFINE PC_POLYPOLYGON                       256
#DEFINE PC_PATHS                             512
#DEFINE CP_NONE                              0
#DEFINE CP_RECTANGLE                         1
#DEFINE CP_REGION                            2
#DEFINE TC_OP_CHARACTER                      1
#DEFINE TC_OP_STROKE                         2
#DEFINE TC_CP_STROKE                         4
#DEFINE TC_CR_90                             8
#DEFINE TC_CR_ANY                            16
#DEFINE TC_SF_X_YINDEP                       32
#DEFINE TC_SA_DOUBLE                         64
#DEFINE TC_SA_INTEGER                        128
#DEFINE TC_SA_CONTIN                         256
#DEFINE TC_EA_DOUBLE                         512
#DEFINE TC_IA_ABLE                           1024
#DEFINE TC_UA_ABLE                           2048
#DEFINE TC_SO_ABLE                           4096
#DEFINE TC_RA_ABLE                           8192
#DEFINE TC_VA_ABLE                           16384
#DEFINE TC_RESERVED                          32768
#DEFINE TC_SCROLLBLT                         65536
#DEFINE RC_BITBLT                            1
#DEFINE RC_BANDING                           2
#DEFINE RC_SCALING                           4
#DEFINE RC_BITMAP64                          8
#DEFINE RC_GDI20_OUTPUT                      16
#DEFINE RC_GDI20_STATE                       32
#DEFINE RC_SAVEBITMAP                        64
#DEFINE RC_DI_BITMAP                         128
#DEFINE RC_PALETTE                           256
#DEFINE RC_DIBTODEV                          512
#DEFINE RC_BIGFONT                           1024
#DEFINE RC_STRETCHBLT                        2048
#DEFINE RC_FLOODFILL                         4096
#DEFINE RC_STRETCHDIB                        8192
#DEFINE RC_OP_DX_OUTPUT                      16384
#DEFINE RC_DEVBITS                           32768
#DEFINE DIB_RGB_COLORS                       0
#DEFINE DIB_PAL_COLORS                       1
#DEFINE SYSPAL_ERROR                         0
#DEFINE SYSPAL_STATIC                        1
#DEFINE SYSPAL_NOSTATIC                      2
#DEFINE CBM_INIT                             4
#DEFINE FLOODFILLBORDER                      0
#DEFINE FLOODFILLSURFACE                     1
#DEFINE CCHDEVICENAME                        32
#DEFINE CCHFORMNAME                          32
#DEFINE DM_SPECVERSION                       1024
#DEFINE DM_ORIENTATION                       1
#DEFINE DM_PAPERSIZE                         2
#DEFINE DM_PAPERLENGTH                       4
#DEFINE DM_PAPERWIDTH                        8
#DEFINE DM_SCALE                             16
#DEFINE DM_COPIES                            256
#DEFINE DM_DEFAULTSOURCE                     512
#DEFINE DM_PRINTQUALITY                      1024
#DEFINE DM_COLOR                             2048
#DEFINE DM_DUPLEX                            4096
#DEFINE DM_YRESOLUTION                       8192
#DEFINE DM_TTOPTION                          16384
#DEFINE DM_COLLATE                           32768
#DEFINE DM_FORMNAME                          65536
#DEFINE DM_LOGPIXELS                         131072
#DEFINE DM_BITSPERPEL                        262144
#DEFINE DM_PELSWIDTH                         524288
#DEFINE DM_PELSHEIGHT                        1048576
#DEFINE DM_DISPLAYFLAGS                      2097152
#DEFINE DM_DISPLAYFREQUENCY                  4194304
#DEFINE DM_ICMMETHOD                         8388608
#DEFINE DM_ICMINTENT                         16777216
#DEFINE DM_MEDIATYPE                         33554432
#DEFINE DM_DITHERTYPE                        67108864
#DEFINE DMORIENT_PORTRAIT                    1
#DEFINE DMORIENT_LANDSCAPE                   2
#DEFINE DMPAPER_FIRST                        DMPAPER_LETTER
#DEFINE DMPAPER_LETTER                       1
#DEFINE DMPAPER_LETTERSMALL                  2
#DEFINE DMPAPER_TABLOID                      3
#DEFINE DMPAPER_LEDGER                       4
#DEFINE DMPAPER_LEGAL                        5
#DEFINE DMPAPER_STATEMENT                    6
#DEFINE DMPAPER_EXECUTIVE                    7
#DEFINE DMPAPER_A3                           8
#DEFINE DMPAPER_A4                           9
#DEFINE DMPAPER_A4SMALL                      10
#DEFINE DMPAPER_A5                           11
#DEFINE DMPAPER_B4                           12
#DEFINE DMPAPER_B5                           13
#DEFINE DMPAPER_FOLIO                        14
#DEFINE DMPAPER_QUARTO                       15
#DEFINE DMPAPER_10X14                        20
#DEFINE DMPAPER_11X17                        17
#DEFINE DMPAPER_NOTE                         18
#DEFINE DMPAPER_ENV_9                        19
#DEFINE DMPAPER_ENV_10                       20
#DEFINE DMPAPER_ENV_11                       21
#DEFINE DMPAPER_ENV_12                       22
#DEFINE DMPAPER_ENV_14                       23
#DEFINE DMPAPER_CSHEET                       24
#DEFINE DMPAPER_DSHEET                       25
#DEFINE DMPAPER_ESHEET                       26
#DEFINE DMPAPER_ENV_DL                       27
#DEFINE DMPAPER_ENV_C5                       28
#DEFINE DMPAPER_ENV_C3                       29
#DEFINE DMPAPER_ENV_C4                       30
#DEFINE DMPAPER_ENV_C6                       31
#DEFINE DMPAPER_ENV_C65                      32
#DEFINE DMPAPER_ENV_B4                       33
#DEFINE DMPAPER_ENV_B5                       34
#DEFINE DMPAPER_ENV_B6                       35
#DEFINE DMPAPER_ENV_ITALY                    36
#DEFINE DMPAPER_ENV_MONARCH                  37
#DEFINE DMPAPER_ENV_PERSONAL                 38
#DEFINE DMPAPER_FANFOLD_US                   39
#DEFINE DMPAPER_FANFOLD_STD_GERMAN           40
#DEFINE DMPAPER_FANFOLD_LGL_GERMAN           41
#DEFINE DMPAPER_ISO_B4                       42
#DEFINE DMPAPER_JAPANESE_POSTCARD            43
#DEFINE DMPAPER_9X11                         44
#DEFINE DMPAPER_10X11                        45
#DEFINE DMPAPER_15X11                        46
#DEFINE DMPAPER_ENV_INVITE                   47
#DEFINE DMPAPER_RESERVED_48                  48
#DEFINE DMPAPER_RESERVED_49                  49
#DEFINE DMPAPER_LETTER_EXTRA                 50
#DEFINE DMPAPER_LEGAL_EXTRA                  51
#DEFINE DMPAPER_TABLOID_EXTRA                52
#DEFINE DMPAPER_A4_EXTRA                     53
#DEFINE DMPAPER_LETTER_TRANSVERSE            54
#DEFINE DMPAPER_A4_TRANSVERSE                55
#DEFINE DMPAPER_LETTER_EXTRA_TRANSVERSE      56
#DEFINE DMPAPER_A_PLUS                       57
#DEFINE DMPAPER_B_PLUS                       58
#DEFINE DMPAPER_LETTER_PLUS                  59
#DEFINE DMPAPER_A4_PLUS                      60
#DEFINE DMPAPER_A5_TRANSVERSE                61
#DEFINE DMPAPER_B5_TRANSVERSE                62
#DEFINE DMPAPER_A3_EXTRA                     63
#DEFINE DMPAPER_A5_EXTRA                     64
#DEFINE DMPAPER_B5_EXTRA                     65
#DEFINE DMPAPER_A2                           66
#DEFINE DMPAPER_A3_TRANSVERSE                67
#DEFINE DMPAPER_A3_EXTRA_TRANSVERSE          68
#DEFINE DMPAPER_LAST                         DMPAPER_A3_EXTRA_TRANSVERSE
#DEFINE DMPAPER_USER                         256
#DEFINE DMBIN_FIRST                          DMBIN_UPPER
#DEFINE DMBIN_UPPER                          1
#DEFINE DMBIN_ONLYONE                        1
#DEFINE DMBIN_LOWER                          2
#DEFINE DMBIN_MIDDLE                         3
#DEFINE DMBIN_MANUAL                         4
#DEFINE DMBIN_ENVELOPE                       5
#DEFINE DMBIN_ENVMANUAL                      6
#DEFINE DMBIN_AUTO                           7
#DEFINE DMBIN_TRACTOR                        8
#DEFINE DMBIN_SMALLFMT                       9
#DEFINE DMBIN_LARGEFMT                       10
#DEFINE DMBIN_LARGECAPACITY                  11
#DEFINE DMBIN_CASSETTE                       14
#DEFINE DMBIN_FORMSOURCE                     15
#DEFINE DMBIN_LAST                           DMBIN_FORMSOURCE
#DEFINE DMBIN_USER                           256
#DEFINE DMRES_DRAFT                          -1
#DEFINE DMRES_LOW                            -2
#DEFINE DMRES_MEDIUM                         -3
#DEFINE DMRES_HIGH                           -4
#DEFINE DMCOLOR_MONOCHROME                   1
#DEFINE DMCOLOR_COLOR                        2
#DEFINE DMDUP_SIMPLEX                        1
#DEFINE DMDUP_VERTICAL                       2
#DEFINE DMDUP_HORIZONTAL                     3
#DEFINE DMTT_BITMAP                          1
#DEFINE DMTT_DOWNLOAD                        2
#DEFINE DMTT_SUBDEV                          3
#DEFINE DMTT_DOWNLOAD_OUTLINE                4
#DEFINE DMCOLLATE_FALSE                      0
#DEFINE DMCOLLATE_TRUE                       1
#DEFINE DM_GRAYSCALE                         1
#DEFINE DM_INTERLACED                        2
#DEFINE DMICMMETHOD_NONE                     1
#DEFINE DMICMMETHOD_SYSTEM                   2
#DEFINE DMICMMETHOD_DRIVER                   3
#DEFINE DMICMMETHOD_DEVICE                   4
#DEFINE DMICMMETHOD_USER                     256
#DEFINE DMICM_SATURATE                       1
#DEFINE DMICM_CONTRAST                       2
#DEFINE DMICM_COLORMETRIC                    3
#DEFINE DMICM_USER                           256
#DEFINE DMMEDIA_STANDARD                     1
#DEFINE DMMEDIA_TRANSPARENCY                 2
#DEFINE DMMEDIA_GLOSSY                       3
#DEFINE DMMEDIA_USER                         256
#DEFINE DMDITHER_NONE                        1
#DEFINE DMDITHER_COARSE                      2
#DEFINE DMDITHER_FINE                        3
#DEFINE DMDITHER_LINEART                     4
#DEFINE DMDITHER_ERRORDIFFUSION              5
#DEFINE DMDITHER_RESERVED6                   6
#DEFINE DMDITHER_RESERVED7                   7
#DEFINE DMDITHER_RESERVED8                   8
#DEFINE DMDITHER_RESERVED9                   9
#DEFINE DMDITHER_GRAYSCALE                   10
#DEFINE DMDITHER_USER                        256
#DEFINE RDH_RECTANGLES                       1
#DEFINE GGO_METRICS                          0
#DEFINE GGO_BITMAP                           1
#DEFINE GGO_NATIVE                           2
#DEFINE GGO_GRAY2_BITMAP                     4
#DEFINE GGO_GRAY4_BITMAP                     5
#DEFINE GGO_GRAY8_BITMAP                     6
#DEFINE TT_POLYGON_TYPE                      24
#DEFINE TT_PRIM_LINE                         1
#DEFINE TT_PRIM_QSPLINE                      2
#DEFINE GCP_DBCS                             1
#DEFINE GCP_REORDER                          2
#DEFINE GCP_USEKERNING                       8
#DEFINE GCP_GLYPHSHAPE                       16
#DEFINE GCP_LIGATE                           32
#DEFINE GCP_DIACRITIC                        256
#DEFINE GCP_KASHIDA                          1024
#DEFINE GCP_ERROR                            32768
#DEFINE FLI_MASK                             4156
#DEFINE GCP_JUSTIFY                          65536
#DEFINE FLI_GLYPHS                           262144
#DEFINE GCP_CLASSIN                          524288
#DEFINE GCP_MAXEXTENT                        1048576
#DEFINE GCP_JUSTIFYIN                        2097152
#DEFINE GCP_DISPLAYZWG                       4194304
#DEFINE GCP_SYMSWAPOFF                       8388608
#DEFINE GCP_NUMERICOVERRIDE                  16777216
#DEFINE GCP_NEUTRALOVERRIDE                  33554432
#DEFINE GCP_NUMERICSLATIN                    67108864
#DEFINE GCP_NUMERICSLOCAL                    134217728
#DEFINE GCPCLASS_LATIN                       1
#DEFINE GCPCLASS_HEBREW                      2
#DEFINE GCPCLASS_ARABIC                      2
#DEFINE GCPCLASS_NEUTRAL                     3
#DEFINE GCPCLASS_LOCALNUMBER                 4
#DEFINE GCPCLASS_LATINNUMBER                 5
#DEFINE GCPCLASS_LATINNUMERICTERMINATOR      6
#DEFINE GCPCLASS_LATINNUMERICSEPARATOR       7
#DEFINE GCPCLASS_NUMERICSEPARATOR            8
#DEFINE GCPCLASS_PREBOUNDLTR                 128
#DEFINE GCPCLASS_PREBOUNDRTL                 64
#DEFINE GCPCLASS_POSTBOUNDLTR                32
#DEFINE GCPCLASS_POSTBOUNDRTL                16
#DEFINE GCPGLYPH_LINKBEFORE                  32768
#DEFINE GCPGLYPH_LINKAFTER                   16384
#DEFINE TT_AVAILABLE                         1
#DEFINE TT_ENABLED                           2
#DEFINE PFD_TYPE_RGBA                        0
#DEFINE PFD_TYPE_COLORINDEX                  1
#DEFINE PFD_MAIN_PLANE                       0
#DEFINE PFD_OVERLAY_PLANE                    1
#DEFINE PFD_UNDERLAY_PLANE                   -1
#DEFINE PFD_DOUBLEBUFFER                     1
#DEFINE PFD_STEREO                           2
#DEFINE PFD_DRAW_TO_WINDOW                   4
#DEFINE PFD_DRAW_TO_BITMAP                   8
#DEFINE PFD_SUPPORT_GDI                      16
#DEFINE PFD_SUPPORT_OPENGL                   32
#DEFINE PFD_GENERIC_FORMAT                   64
#DEFINE PFD_NEED_PALETTE                     128
#DEFINE PFD_NEED_SYSTEM_PALETTE              256
#DEFINE PFD_SWAP_EXCHANGE                    512
#DEFINE PFD_SWAP_COPY                        1024
#DEFINE PFD_DOUBLEBUFFER_DONTCARE            1073741824
#DEFINE PFD_STEREO_DONTCARE                  2147483648
#DEFINE OLDFONTENUMPROC                      OLDFONTENUMPROCW
#DEFINE DM_UPDATE                            1
#DEFINE DM_COPY                              2
#DEFINE DM_PROMPT                            4
#DEFINE DM_MODIFY                            8
#DEFINE DM_IN_BUFFER                         DM_MODIFY
#DEFINE DM_IN_PROMPT                         DM_PROMPT
#DEFINE DM_OUT_BUFFER                        DM_COPY
#DEFINE DM_OUT_DEFAULT                       DM_UPDATE
#DEFINE DC_FIELDS                            1
#DEFINE DC_PAPERS                            2
#DEFINE DC_PAPERSIZE                         3
#DEFINE DC_MINEXTENT                         4
#DEFINE DC_MAXEXTENT                         5
#DEFINE DC_BINS                              6
#DEFINE DC_DUPLEX                            7
#DEFINE DC_SIZE                              8
#DEFINE DC_EXTRA                             9
#DEFINE DC_VERSION                           10
#DEFINE DC_DRIVER                            11
#DEFINE DC_BINNAMES                          12
#DEFINE DC_ENUMRESOLUTIONS                   13
#DEFINE DC_FILEDEPENDENCIES                  14
#DEFINE DC_TRUETYPE                          15
#DEFINE DC_PAPERNAMES                        16
#DEFINE DC_ORIENTATION                       17
#DEFINE DC_COPIES                            18
#DEFINE DC_BINADJUST                         19
#DEFINE DC_EMF_COMPLIANT                     20
#DEFINE DC_DATATYPE_PRODUCED                 21
#DEFINE DC_MANUFACTURER                      23
#DEFINE DC_MODEL                             24
#DEFINE DCTT_BITMAP                          1
#DEFINE DCTT_DOWNLOAD                        2
#DEFINE DCTT_SUBDEV                          4
#DEFINE DCTT_DOWNLOAD_OUTLINE                8
#DEFINE DCBA_FACEUPNONE                      0
#DEFINE DCBA_FACEUPCENTER                    1
#DEFINE DCBA_FACEUPLEFT                      2
#DEFINE DCBA_FACEUPRIGHT                     3
#DEFINE DCBA_FACEDOWNNONE                    256
#DEFINE DCBA_FACEDOWNCENTER                  257
#DEFINE DCBA_FACEDOWNLEFT                    258
#DEFINE DCBA_FACEDOWNRIGHT                   259
#DEFINE CA_NEGATIVE                          1
#DEFINE CA_LOG_FILTER                        2
#DEFINE ILLUMINANT_DEVICE_DEFAULT            0
#DEFINE ILLUMINANT_A                         1
#DEFINE ILLUMINANT_B                         2
#DEFINE ILLUMINANT_C                         3
#DEFINE ILLUMINANT_D50                       4
#DEFINE ILLUMINANT_D55                       5
#DEFINE ILLUMINANT_D65                       6
#DEFINE ILLUMINANT_D75                       7
#DEFINE ILLUMINANT_F2                        8
#DEFINE ILLUMINANT_MAX_INDEX                 ILLUMINANT_F2
#DEFINE ILLUMINANT_TUNGSTEN                  ILLUMINANT_A
#DEFINE ILLUMINANT_DAYLIGHT                  ILLUMINANT_C
#DEFINE ILLUMINANT_FLUORESCENT               ILLUMINANT_F2
#DEFINE ILLUMINANT_NTSC                      ILLUMINANT_C
#DEFINE RGB_GAMMA_MIN                        2500
#DEFINE RGB_GAMMA_MAX                        65000
#DEFINE REFERENCE_WHITE_MIN                  6000
#DEFINE REFERENCE_WHITE_MAX                  10000
#DEFINE REFERENCE_BLACK_MIN                  0
#DEFINE REFERENCE_BLACK_MAX                  4000
#DEFINE COLOR_ADJ_MIN                        -100
#DEFINE COLOR_ADJ_MAX                        100
#DEFINE DI_APPBANDING                        1
#DEFINE FONTMAPPER_MAX                       10
#DEFINE ICM_OFF                              1
#DEFINE ICM_ON                               2
#DEFINE ICM_QUERY                            3
#DEFINE ICMENUMPROC                          ICMENUMPROCW
#DEFINE ENHMETA_SIGNATURE                    1179534624
#DEFINE ENHMETA_STOCK_OBJECT                 2147483648
#DEFINE EMR_HEADER                           1
#DEFINE EMR_POLYBEZIER                       2
#DEFINE EMR_POLYGON                          3
#DEFINE EMR_POLYLINE                         4
#DEFINE EMR_POLYBEZIERTO                     5
#DEFINE EMR_POLYLINETO                       6
#DEFINE EMR_POLYPOLYLINE                     7
#DEFINE EMR_POLYPOLYGON                      8
#DEFINE EMR_SETWINDOWEXTEX                   9
#DEFINE EMR_SETWINDOWORGEX                   10
#DEFINE EMR_SETVIEWPORTEXTEX                 11
#DEFINE EMR_SETVIEWPORTORGEX                 12
#DEFINE EMR_SETBRUSHORGEX                    13
#DEFINE EMR_EOF                              14
#DEFINE EMR_SETPIXELV                        15
#DEFINE EMR_SETMAPPERFLAGS                   16
#DEFINE EMR_SETMAPMODE                       17
#DEFINE EMR_SETBKMODE                        18
#DEFINE EMR_SETPOLYFILLMODE                  19
#DEFINE EMR_SETROP2                          20
#DEFINE EMR_SETSTRETCHBLTMODE                21
#DEFINE EMR_SETTEXTALIGN                     22
#DEFINE EMR_SETCOLORADJUSTMENT               23
#DEFINE EMR_SETTEXTCOLOR                     24
#DEFINE EMR_SETBKCOLOR                       25
#DEFINE EMR_OFFSETCLIPRGN                    26
#DEFINE EMR_MOVETOEX                         27
#DEFINE EMR_SETMETARGN                       28
#DEFINE EMR_EXCLUDECLIPRECT                  29
#DEFINE EMR_INTERSECTCLIPRECT                30
#DEFINE EMR_SCALEVIEWPORTEXTEX               31
#DEFINE EMR_SCALEWINDOWEXTEX                 32
#DEFINE EMR_SAVEDC                           33
#DEFINE EMR_RESTOREDC                        34
#DEFINE EMR_SETWORLDTRANSFORM                35
#DEFINE EMR_MODIFYWORLDTRANSFORM             36
#DEFINE EMR_SELECTOBJECT                     37
#DEFINE EMR_CREATEPEN                        38
#DEFINE EMR_CREATEBRUSHINDIRECT              39
#DEFINE EMR_DELETEOBJECT                     40
#DEFINE EMR_ANGLEARC                         41
#DEFINE EMR_ELLIPSE                          42
#DEFINE EMR_RECTANGLE                        43
#DEFINE EMR_ROUNDRECT                        44
#DEFINE EMR_ARC                              45
#DEFINE EMR_CHORD                            46
#DEFINE EMR_PIE                              47
#DEFINE EMR_SELECTPALETTE                    48
#DEFINE EMR_CREATEPALETTE                    49
#DEFINE EMR_SETPALETTEENTRIES                50
#DEFINE EMR_RESIZEPALETTE                    51
#DEFINE EMR_REALIZEPALETTE                   52
#DEFINE EMR_EXTFLOODFILL                     53
#DEFINE EMR_LINETO                           54
#DEFINE EMR_ARCTO                            55
#DEFINE EMR_POLYDRAW                         56
#DEFINE EMR_SETARCDIRECTION                  57
#DEFINE EMR_SETMITERLIMIT                    58
#DEFINE EMR_BEGINPATH                        59
#DEFINE EMR_ENDPATH                          60
#DEFINE EMR_CLOSEFIGURE                      61
#DEFINE EMR_FILLPATH                         62
#DEFINE EMR_STROKEANDFILLPATH                63
#DEFINE EMR_STROKEPATH                       64
#DEFINE EMR_FLATTENPATH                      65
#DEFINE EMR_WIDENPATH                        66
#DEFINE EMR_SELECTCLIPPATH                   67
#DEFINE EMR_ABORTPATH                        68
#DEFINE EMR_GDICOMMENT                       70
#DEFINE EMR_FILLRGN                          71
#DEFINE EMR_FRAMERGN                         72
#DEFINE EMR_INVERTRGN                        73
#DEFINE EMR_PAINTRGN                         74
#DEFINE EMR_EXTSELECTCLIPRGN                 75
#DEFINE EMR_BITBLT                           76
#DEFINE EMR_STRETCHBLT                       77
#DEFINE EMR_MASKBLT                          78
#DEFINE EMR_PLGBLT                           79
#DEFINE EMR_SETDIBITSTODEVICE                80
#DEFINE EMR_STRETCHDIBITS                    81
#DEFINE EMR_EXTCREATEFONTINDIRECTW           82
#DEFINE EMR_EXTTEXTOUTA                      83
#DEFINE EMR_EXTTEXTOUTW                      84
#DEFINE EMR_POLYBEZIER16                     85
#DEFINE EMR_POLYGON16                        86
#DEFINE EMR_POLYLINE16                       87
#DEFINE EMR_POLYBEZIERTO16                   88
#DEFINE EMR_POLYLINETO16                     89
#DEFINE EMR_POLYPOLYLINE16                   90
#DEFINE EMR_POLYPOLYGON16                    91
#DEFINE EMR_POLYDRAW16                       92
#DEFINE EMR_CREATEMONOBRUSH                  93
#DEFINE EMR_CREATEDIBPATTERNBRUSHPT          94
#DEFINE EMR_EXTCREATEPEN                     95
#DEFINE EMR_POLYTEXTOUTA                     96
#DEFINE EMR_POLYTEXTOUTW                     97
#DEFINE EMR_SETICMMODE                       98
#DEFINE EMR_CREATECOLORSPACE                 99
#DEFINE EMR_SETCOLORSPACE                    100
#DEFINE EMR_DELETECOLORSPACE                 101
#DEFINE EMR_MIN                              1
#DEFINE EMR_MAX                              101
#DEFINE GDICOMMENT_IDENTIFIER                1128875079
#DEFINE GDICOMMENT_WINDOWS_METAFILE          2147483649
#DEFINE GDICOMMENT_BEGINGROUP                2
#DEFINE GDICOMMENT_ENDGROUP                  3
#DEFINE GDICOMMENT_MULTIFORMATS              1073741828
#DEFINE EPS_SIGNATURE                        1179865157
#DEFINE WGL_FONT_LINES                       0
#DEFINE WGL_FONT_POLYGONS                    1

*-- WINREG.H
#DEFINE HKEY_CLASSES_ROOT                    2147483648
#DEFINE HKEY_CURRENT_USER                    2147483649
#DEFINE HKEY_LOCAL_MACHINE                   2147483650
#DEFINE HKEY_USERS                           2147483651
#DEFINE HKEY_PERFORMANCE_DATA                2147483652
#DEFINE HKEY_CURRENT_CONFIG                  2147483653
#DEFINE HKEY_DYN_DATA                        2147483654
#DEFINE PROVIDER_KEEPS_VALUE_LENGTH          1

*-- WINBASE.H
#DEFINE INVALID_HANDLE_VALUE                 -1
#DEFINE INVALID_FILE_SIZE                    4581298448
#DEFINE FILE_BEGIN                           0
#DEFINE FILE_CURRENT                         1
#DEFINE FILE_END                             2
#DEFINE TIME_ZONE_ID_INVALID                 4581298448
#DEFINE WAIT_FAILED                          4581298448
#DEFINE WAIT_OBJECT_0                        STATUS_WAIT_0  + 0
#DEFINE WAIT_ABANDONED                       STATUS_ABANDONED_WAIT_0  + 0
#DEFINE WAIT_ABANDONED_0                     STATUS_ABANDONED_WAIT_0  + 0
#DEFINE WAIT_TIMEOUT                         STATUS_TIMEOUT
#DEFINE WAIT_IO_COMPLETION                   STATUS_USER_APC
#DEFINE STILL_ACTIVE                         STATUS_PENDING
#DEFINE EXCEPTION_ACCESS_VIOLATION           STATUS_ACCESS_VIOLATION
#DEFINE EXCEPTION_DATATYPE_MISALIGNMENT      STATUS_DATATYPE_MISALIGNMENT
#DEFINE EXCEPTION_BREAKPOINT                 STATUS_BREAKPOINT
#DEFINE EXCEPTION_SINGLE_STEP                STATUS_SINGLE_STEP
#DEFINE EXCEPTION_ARRAY_BOUNDS_EXCEEDED      STATUS_ARRAY_BOUNDS_EXCEEDED
#DEFINE EXCEPTION_FLT_DENORMAL_OPERAND       STATUS_FLOAT_DENORMAL_OPERAND
#DEFINE EXCEPTION_FLT_DIVIDE_BY_ZERO         STATUS_FLOAT_DIVIDE_BY_ZERO
#DEFINE EXCEPTION_FLT_INEXACT_RESULT         STATUS_FLOAT_INEXACT_RESULT
#DEFINE EXCEPTION_FLT_INVALID_OPERATION      STATUS_FLOAT_INVALID_OPERATION
#DEFINE EXCEPTION_FLT_OVERFLOW               STATUS_FLOAT_OVERFLOW
#DEFINE EXCEPTION_FLT_STACK_CHECK            STATUS_FLOAT_STACK_CHECK
#DEFINE EXCEPTION_FLT_UNDERFLOW              STATUS_FLOAT_UNDERFLOW
#DEFINE EXCEPTION_INT_DIVIDE_BY_ZERO         STATUS_INTEGER_DIVIDE_BY_ZERO
#DEFINE EXCEPTION_INT_OVERFLOW               STATUS_INTEGER_OVERFLOW
#DEFINE EXCEPTION_PRIV_INSTRUCTION           STATUS_PRIVILEGED_INSTRUCTION
#DEFINE EXCEPTION_IN_PAGE_ERROR              STATUS_IN_PAGE_ERROR
#DEFINE EXCEPTION_ILLEGAL_INSTRUCTION        STATUS_ILLEGAL_INSTRUCTION
#DEFINE EXCEPTION_NONCONTINUABLE_EXCEPTION   STATUS_NONCONTINUABLE_EXCEPTION
#DEFINE EXCEPTION_STACK_OVERFLOW             STATUS_STACK_OVERFLOW
#DEFINE EXCEPTION_INVALID_DISPOSITION        STATUS_INVALID_DISPOSITION
#DEFINE EXCEPTION_GUARD_PAGE                 STATUS_GUARD_PAGE_VIOLATION
#DEFINE CONTROL_C_EXIT                       STATUS_CONTROL_C_EXIT
#DEFINE FILE_FLAG_WRITE_THROUGH              2147483648
#DEFINE FILE_FLAG_OVERLAPPED                 1073741824
#DEFINE FILE_FLAG_NO_BUFFERING               536870912
#DEFINE FILE_FLAG_RANDOM_ACCESS              268435456
#DEFINE FILE_FLAG_SEQUENTIAL_SCAN            134217728
#DEFINE FILE_FLAG_DELETE_ON_CLOSE            67108864
#DEFINE FILE_FLAG_BACKUP_SEMANTICS           33554432
#DEFINE FILE_FLAG_POSIX_SEMANTICS            16777216
#DEFINE CREATE_NEW                           1
#DEFINE CREATE_ALWAYS                        2
#DEFINE OPEN_EXISTING                        3
#DEFINE OPEN_ALWAYS                          4
#DEFINE TRUNCATE_EXISTING                    5
#DEFINE PIPE_ACCESS_INBOUND                  1
#DEFINE PIPE_ACCESS_OUTBOUND                 2
#DEFINE PIPE_ACCESS_DUPLEX                   3
#DEFINE PIPE_CLIENT_END                      0
#DEFINE PIPE_SERVER_END                      1
#DEFINE PIPE_WAIT                            0
#DEFINE PIPE_NOWAIT                          1
#DEFINE PIPE_READMODE_BYTE                   0
#DEFINE PIPE_READMODE_MESSAGE                2
#DEFINE PIPE_TYPE_BYTE                       0
#DEFINE PIPE_TYPE_MESSAGE                    4
#DEFINE PIPE_UNLIMITED_INSTANCES             255
#DEFINE SECURITY_CONTEXT_TRACKING            262144
#DEFINE SECURITY_EFFECTIVE_ONLY              524288
#DEFINE SECURITY_SQOS_PRESENT                1048576
#DEFINE SECURITY_VALID_SQOS_FLAGS            2097152
#DEFINE MUTEX_MODIFY_STATE                   MUTANT_QUERY_STATE
#DEFINE MUTEX_ALL_ACCESS                     MUTANT_ALL_ACCESS
#DEFINE SP_SERIALCOMM                        1
#DEFINE PST_UNSPECIFIED                      0
#DEFINE PST_RS232                            1
#DEFINE PST_PARALLELPORT                     2
#DEFINE PST_RS422                            3
#DEFINE PST_RS423                            4
#DEFINE PST_RS449                            5
#DEFINE PST_MODEM                            6
#DEFINE PST_FAX                              33
#DEFINE PST_SCANNER                          34
#DEFINE PST_NETWORK_BRIDGE                   256
#DEFINE PST_LAT                              257
#DEFINE PST_TCPIP_TELNET                     258
#DEFINE PST_X25                              259
#DEFINE PCF_DTRDSR                           1
#DEFINE PCF_RTSCTS                           2
#DEFINE PCF_RLSD                             4
#DEFINE PCF_PARITY_CHECK                     8
#DEFINE PCF_XONXOFF                          16
#DEFINE PCF_SETXCHAR                         32
#DEFINE PCF_TOTALTIMEOUTS                    64
#DEFINE PCF_INTTIMEOUTS                      128
#DEFINE PCF_SPECIALCHARS                     256
#DEFINE PCF_16BITMODE                        512
#DEFINE SP_PARITY                            1
#DEFINE SP_BAUD                              2
#DEFINE SP_DATABITS                          4
#DEFINE SP_STOPBITS                          8
#DEFINE SP_HANDSHAKING                       16
#DEFINE SP_PARITY_CHECK                      32
#DEFINE SP_RLSD                              64
#DEFINE BAUD_075                             1
#DEFINE BAUD_110                             2
#DEFINE BAUD_134_5                           4
#DEFINE BAUD_150                             8
#DEFINE BAUD_300                             16
#DEFINE BAUD_600                             32
#DEFINE BAUD_1200                            64
#DEFINE BAUD_1800                            128
#DEFINE BAUD_2400                            256
#DEFINE BAUD_4800                            512
#DEFINE BAUD_7200                            1024
#DEFINE BAUD_9600                            2048
#DEFINE BAUD_14400                           4096
#DEFINE BAUD_19200                           8192
#DEFINE BAUD_38400                           16384
#DEFINE BAUD_56K                             32768
#DEFINE BAUD_128K                            65536
#DEFINE BAUD_115200                          131072
#DEFINE BAUD_57600                           262144
#DEFINE BAUD_USER                            268435456
#DEFINE DATABITS_5                           1
#DEFINE DATABITS_6                           2
#DEFINE DATABITS_7                           4
#DEFINE DATABITS_8                           8
#DEFINE DATABITS_16                          16
#DEFINE DATABITS_16X                         32
#DEFINE STOPBITS_10                          1
#DEFINE STOPBITS_15                          2
#DEFINE STOPBITS_20                          4
#DEFINE PARITY_NONE                          256
#DEFINE PARITY_ODD                           512
#DEFINE PARITY_EVEN                          1024
#DEFINE PARITY_MARK                          2048
#DEFINE PARITY_SPACE                         4096
#DEFINE COMMPROP_INITIALIZED                 4148036911
#DEFINE DTR_CONTROL_DISABLE                  0
#DEFINE DTR_CONTROL_ENABLE                   1
#DEFINE DTR_CONTROL_HANDSHAKE                2
#DEFINE RTS_CONTROL_DISABLE                  0
#DEFINE RTS_CONTROL_ENABLE                   1
#DEFINE RTS_CONTROL_HANDSHAKE                2
#DEFINE RTS_CONTROL_TOGGLE                   3
#DEFINE GMEM_FIXED                           0
#DEFINE GMEM_MOVEABLE                        2
#DEFINE GMEM_NOCOMPACT                       16
#DEFINE GMEM_NODISCARD                       32
#DEFINE GMEM_ZEROINIT                        64
#DEFINE GMEM_MODIFY                          128
#DEFINE GMEM_DISCARDABLE                     256
#DEFINE GMEM_NOT_BANKED                      4096
#DEFINE GMEM_SHARE                           8192
#DEFINE GMEM_DDESHARE                        8192
#DEFINE GMEM_NOTIFY                          16384
#DEFINE GMEM_LOWER                           GMEM_NOT_BANKED
#DEFINE GMEM_VALID_FLAGS                     32882
#DEFINE GMEM_INVALID_HANDLE                  32768
#DEFINE GMEM_DISCARDED                       16384
#DEFINE GMEM_LOCKCOUNT                       272
#DEFINE LMEM_FIXED                           0
#DEFINE LMEM_MOVEABLE                        2
#DEFINE LMEM_NOCOMPACT                       16
#DEFINE LMEM_NODISCARD                       32
#DEFINE LMEM_ZEROINIT                        64
#DEFINE LMEM_MODIFY                          128
#DEFINE LMEM_DISCARDABLE                     4096
#DEFINE LMEM_VALID_FLAGS                     4210
#DEFINE LMEM_INVALID_HANDLE                  32768
#DEFINE LMEM_DISCARDED                       16384
#DEFINE LMEM_LOCKCOUNT                       272
#DEFINE DEBUG_PROCESS                        1
#DEFINE DEBUG_ONLY_THIS_PROCESS              2
#DEFINE CREATE_SUSPENDED                     4
#DEFINE DETACHED_PROCESS                     8
#DEFINE CREATE_NEW_CONSOLE                   16
#DEFINE NORMAL_PRIORITY_CLASS                32
#DEFINE IDLE_PRIORITY_CLASS                  64
#DEFINE HIGH_PRIORITY_CLASS                  128
#DEFINE REALTIME_PRIORITY_CLASS              256
#DEFINE CREATE_NEW_PROCESS_GROUP             512
#DEFINE CREATE_UNICODE_ENVIRONMENT           1024
#DEFINE CREATE_SEPARATE_WOW_VDM              2048
#DEFINE CREATE_SHARED_WOW_VDM                4096
#DEFINE CREATE_DEFAULT_ERROR_MODE            67108864
#DEFINE CREATE_NO_WINDOW                     134217728
#DEFINE PROFILE_USER                         268435456
#DEFINE PROFILE_KERNEL                       536870912
#DEFINE PROFILE_SERVER                       1073741824
#DEFINE THREAD_PRIORITY_LOWEST               THREAD_BASE_PRIORITY_MIN
#DEFINE THREAD_PRIORITY_BELOW_NORMAL         THREAD_PRIORITY_LOWEST + 1
#DEFINE THREAD_PRIORITY_NORMAL               0
#DEFINE THREAD_PRIORITY_HIGHEST              THREAD_BASE_PRIORITY_MAX
#DEFINE THREAD_PRIORITY_ABOVE_NORMAL         THREAD_PRIORITY_HIGHEST - 1
#DEFINE THREAD_PRIORITY_ERROR_RETURN         MAXLONG
#DEFINE THREAD_PRIORITY_TIME_CRITICAL        THREAD_BASE_PRIORITY_LOWRT
#DEFINE THREAD_PRIORITY_IDLE                 THREAD_BASE_PRIORITY_IDLE
#DEFINE EXCEPTION_DEBUG_EVENT                1
#DEFINE CREATE_THREAD_DEBUG_EVENT            2
#DEFINE CREATE_PROCESS_DEBUG_EVENT           3
#DEFINE EXIT_THREAD_DEBUG_EVENT              4
#DEFINE EXIT_PROCESS_DEBUG_EVENT             5
#DEFINE LOAD_DLL_DEBUG_EVENT                 6
#DEFINE UNLOAD_DLL_DEBUG_EVENT               7
#DEFINE OUTPUT_DEBUG_STRING_EVENT            8
#DEFINE RIP_EVENT                            9
#DEFINE DRIVE_UNKNOWN                        0
#DEFINE DRIVE_NO_ROOT_DIR                    1
#DEFINE DRIVE_REMOVABLE                      2
#DEFINE DRIVE_FIXED                          3
#DEFINE DRIVE_REMOTE                         4
#DEFINE DRIVE_CDROM                          5
#DEFINE DRIVE_RAMDISK                        6
#DEFINE FILE_TYPE_UNKNOWN                    0
#DEFINE FILE_TYPE_DISK                       1
#DEFINE FILE_TYPE_CHAR                       2
#DEFINE FILE_TYPE_PIPE                       3
#DEFINE FILE_TYPE_REMOTE                     32768
#DEFINE STD_INPUT_HANDLE                     -10
#DEFINE STD_OUTPUT_HANDLE                    -11
#DEFINE STD_ERROR_HANDLE                     -12
#DEFINE NOPARITY                             0
#DEFINE ODDPARITY                            1
#DEFINE EVENPARITY                           2
#DEFINE MARKPARITY                           3
#DEFINE SPACEPARITY                          4
#DEFINE ONESTOPBIT                           0
#DEFINE ONE5STOPBITS                         1
#DEFINE TWOSTOPBITS                          2
#DEFINE IGNORE                               0
#DEFINE INFINITE                             4581298448
#DEFINE CBR_110                              110
#DEFINE CBR_300                              300
#DEFINE CBR_600                              600
#DEFINE CBR_1200                             1200
#DEFINE CBR_2400                             2400
#DEFINE CBR_4800                             4800
#DEFINE CBR_9600                             9600
#DEFINE CBR_14400                            14400
#DEFINE CBR_19200                            19200
#DEFINE CBR_38400                            38400
#DEFINE CBR_56000                            56000
#DEFINE CBR_57600                            57600
#DEFINE CBR_115200                           115200
#DEFINE CBR_128000                           128000
#DEFINE CBR_256000                           256000
#DEFINE CE_RXOVER                            1
#DEFINE CE_OVERRUN                           2
#DEFINE CE_RXPARITY                          4
#DEFINE CE_FRAME                             8
#DEFINE CE_BREAK                             16
#DEFINE CE_TXFULL                            256
#DEFINE CE_PTO                               512
#DEFINE CE_IOE                               1024
#DEFINE CE_DNS                               2048
#DEFINE CE_OOP                               4096
#DEFINE CE_MODE                              32768
#DEFINE IE_BADID                             -1
#DEFINE IE_OPEN                              -2
#DEFINE IE_NOPEN                             -3
#DEFINE IE_MEMORY                            -4
#DEFINE IE_DEFAULT                           -5
#DEFINE IE_HARDWARE                          -10
#DEFINE IE_BYTESIZE                          -11
#DEFINE IE_BAUDRATE                          -12
#DEFINE EV_RXCHAR                            1
#DEFINE EV_RXFLAG                            2
#DEFINE EV_TXEMPTY                           4
#DEFINE EV_CTS                               8
#DEFINE EV_DSR                               16
#DEFINE EV_RLSD                              32
#DEFINE EV_BREAK                             64
#DEFINE EV_ERR                               128
#DEFINE EV_RING                              256
#DEFINE EV_PERR                              512
#DEFINE EV_RX80FULL                          1024
#DEFINE EV_EVENT1                            2048
#DEFINE EV_EVENT2                            4096
#DEFINE SETXOFF                              1
#DEFINE SETXON                               2
#DEFINE SETRTS                               3
#DEFINE CLRRTS                               4
#DEFINE SETDTR                               5
#DEFINE CLRDTR                               6
#DEFINE RESETDEV                             7
#DEFINE SETBREAK                             8
#DEFINE CLRBREAK                             9
#DEFINE PURGE_TXABORT                        1
#DEFINE PURGE_RXABORT                        2
#DEFINE PURGE_TXCLEAR                        4
#DEFINE PURGE_RXCLEAR                        8
#DEFINE LPTx                                 128
#DEFINE MS_CTS_ON                            16
#DEFINE MS_DSR_ON                            32
#DEFINE MS_RING_ON                           64
#DEFINE MS_RLSD_ON                           128
#DEFINE S_QUEUEEMPTY                         0
#DEFINE S_THRESHOLD                          1
#DEFINE S_ALLTHRESHOLD                       2
#DEFINE S_NORMAL                             0
#DEFINE S_LEGATO                             1
#DEFINE S_STACCATO                           2
#DEFINE S_PERIOD512                          0
#DEFINE S_PERIOD1024                         1
#DEFINE S_PERIOD2048                         2
#DEFINE S_PERIODVOICE                        3
#DEFINE S_WHITE512                           4
#DEFINE S_WHITE1024                          5
#DEFINE S_WHITE2048                          6
#DEFINE S_WHITEVOICE                         7
#DEFINE S_SERDVNA                            -1
#DEFINE S_SEROFM                             -2
#DEFINE S_SERMACT                            -3
#DEFINE S_SERQFUL                            -4
#DEFINE S_SERBDNT                            -5
#DEFINE S_SERDLN                             -6
#DEFINE S_SERDCC                             -7
#DEFINE S_SERDTP                             -8
#DEFINE S_SERDVL                             -9
#DEFINE S_SERDMD                             -10
#DEFINE S_SERDSH                             -11
#DEFINE S_SERDPT                             -12
#DEFINE S_SERDFQ                             -13
#DEFINE S_SERDDR                             -14
#DEFINE S_SERDSR                             -15
#DEFINE S_SERDST                             -16
#DEFINE NMPWAIT_WAIT_FOREVER                 4581298448
#DEFINE NMPWAIT_NOWAIT                       1
#DEFINE NMPWAIT_USE_DEFAULT_WAIT             0
#DEFINE FS_CASE_IS_PRESERVED                 FILE_CASE_PRESERVED_NAMES
#DEFINE FS_CASE_SENSITIVE                    FILE_CASE_SENSITIVE_SEARCH
#DEFINE FS_UNICODE_STORED_ON_DISK            FILE_UNICODE_ON_DISK
#DEFINE FS_PERSISTENT_ACLS                   FILE_PERSISTENT_ACLS
#DEFINE FS_VOL_IS_COMPRESSED                 FILE_VOLUME_IS_COMPRESSED
#DEFINE FS_FILE_COMPRESSION                  FILE_FILE_COMPRESSION
#DEFINE FILE_MAP_COPY                        SECTION_QUERY
#DEFINE FILE_MAP_WRITE                       SECTION_MAP_WRITE
#DEFINE FILE_MAP_READ                        SECTION_MAP_READ
#DEFINE FILE_MAP_ALL_ACCESS                  SECTION_ALL_ACCESS
#DEFINE OF_READ                              0
#DEFINE OF_WRITE                             1
#DEFINE OF_READWRITE                         2
#DEFINE OF_SHARE_COMPAT                      0
#DEFINE OF_SHARE_EXCLUSIVE                   16
#DEFINE OF_SHARE_DENY_WRITE                  32
#DEFINE OF_SHARE_DENY_READ                   48
#DEFINE OF_SHARE_DENY_NONE                   64
#DEFINE OF_PARSE                             256
#DEFINE OF_DELETE                            512
#DEFINE OF_VERIFY                            1024
#DEFINE OF_CANCEL                            2048
#DEFINE OF_CREATE                            4096
#DEFINE OF_PROMPT                            8192
#DEFINE OF_EXIST                             16384
#DEFINE OF_REOPEN                            32768
#DEFINE OFS_MAXPATHNAME                      128
#DEFINE MAXINTATOM                           53248
#DEFINE INVALID_ATOM                         0
#DEFINE PROCESS_HEAP_REGION                  1
#DEFINE PROCESS_HEAP_UNCOMMITTED_RANGE       2
#DEFINE PROCESS_HEAP_ENTRY_BUSY              4
#DEFINE PROCESS_HEAP_ENTRY_MOVEABLE          16
#DEFINE PROCESS_HEAP_ENTRY_DDESHARE          32
#DEFINE SCS_32BIT_BINARY                     0
#DEFINE SCS_DOS_BINARY                       1
#DEFINE SCS_WOW_BINARY                       2
#DEFINE SCS_PIF_BINARY                       3
#DEFINE SCS_POSIX_BINARY                     4
#DEFINE SCS_OS216_BINARY                     5
#DEFINE SEM_FAILCRITICALERRORS               1
#DEFINE SEM_NOGPFAULTERRORBOX                2
#DEFINE SEM_NOALIGNMENTFAULTEXCEPT           4
#DEFINE SEM_NOOPENFILEERRORBOX               32768
#DEFINE LOCKFILE_FAIL_IMMEDIATELY            1
#DEFINE LOCKFILE_EXCLUSIVE_LOCK              2
#DEFINE HANDLE_FLAG_INHERIT                  1
#DEFINE HANDLE_FLAG_PROTECT_FROM_CLOSE       2
#DEFINE HINSTANCE_ERROR                      32
#DEFINE GET_TAPE_MEDIA_INFORMATION           0
#DEFINE GET_TAPE_DRIVE_INFORMATION           1
#DEFINE SET_TAPE_MEDIA_INFORMATION           0
#DEFINE SET_TAPE_DRIVE_INFORMATION           1
#DEFINE FORMAT_MESSAGE_ALLOCATE_BUFFER       256
#DEFINE FORMAT_MESSAGE_IGNORE_INSERTS        512
#DEFINE FORMAT_MESSAGE_FROM_STRING           1024
#DEFINE FORMAT_MESSAGE_FROM_HMODULE          2048
#DEFINE FORMAT_MESSAGE_FROM_SYSTEM           4096
#DEFINE FORMAT_MESSAGE_ARGUMENT_ARRAY        8192
#DEFINE FORMAT_MESSAGE_MAX_WIDTH_MASK        272
#DEFINE TLS_OUT_OF_INDEXES                   4581298448
#DEFINE BACKUP_INVALID                       0
#DEFINE BACKUP_DATA                          1
#DEFINE BACKUP_EA_DATA                       2
#DEFINE BACKUP_SECURITY_DATA                 3
#DEFINE BACKUP_ALTERNATE_DATA                4
#DEFINE BACKUP_LINK                          5
#DEFINE BACKUP_PROPERTY_DATA                 6
#DEFINE STREAM_NORMAL_ATTRIBUTE              0
#DEFINE STREAM_MODIFIED_WHEN_READ            1
#DEFINE STREAM_CONTAINS_SECURITY             2
#DEFINE STREAM_CONTAINS_PROPERTIES           4
#DEFINE STARTF_USESHOWWINDOW                 1
#DEFINE STARTF_USESIZE                       2
#DEFINE STARTF_USEPOSITION                   4
#DEFINE STARTF_USECOUNTCHARS                 8
#DEFINE STARTF_USEFILLATTRIBUTE              16
#DEFINE STARTF_RUNFULLSCREEN                 32
#DEFINE STARTF_FORCEONFEEDBACK               64
#DEFINE STARTF_FORCEOFFFEEDBACK              128
#DEFINE STARTF_USESTDHANDLES                 256
#DEFINE STARTF_USEHOTKEY                     512
#DEFINE SHUTDOWN_NORETRY                     1
#DEFINE DONT_RESOLVE_DLL_REFERENCES          1
#DEFINE LOAD_LIBRARY_AS_DATAFILE             2
#DEFINE LOAD_WITH_ALTERED_SEARCH_PATH        8
#DEFINE DDD_RAW_TARGET_PATH                  1
#DEFINE DDD_REMOVE_DEFINITION                2
#DEFINE DDD_EXACT_MATCH_ON_REMOVE            4
#DEFINE MOVEFILE_REPLACE_EXISTING            1
#DEFINE MOVEFILE_COPY_ALLOWED                2
#DEFINE MOVEFILE_DELAY_UNTIL_REBOOT          4
#DEFINE MAX_COMPUTERNAME_LENGTH              15
#DEFINE LOGON32_LOGON_INTERACTIVE            2
#DEFINE LOGON32_LOGON_BATCH                  4
#DEFINE LOGON32_LOGON_SERVICE                5
#DEFINE LOGON32_PROVIDER_DEFAULT             0
#DEFINE LOGON32_PROVIDER_WINNT35             1
#DEFINE VER_PLATFORM_WIN32s                  0
#DEFINE VER_PLATFORM_WIN32_WINDOWS           1
#DEFINE VER_PLATFORM_WIN32_NT                2
#DEFINE TC_NORMAL                            0
#DEFINE TC_HARDERR                           1
#DEFINE TC_GP_TRAP                           2
#DEFINE TC_SIGNAL                            3
#DEFINE AC_LINE_OFFLINE                      0
#DEFINE AC_LINE_ONLINE                       1
#DEFINE AC_LINE_BACKUP_POWER                 2
#DEFINE AC_LINE_UNKNOWN                      272
#DEFINE BATTERY_FLAG_HIGH                    1
#DEFINE BATTERY_FLAG_LOW                     2
#DEFINE BATTERY_FLAG_CRITICAL                4
#DEFINE BATTERY_FLAG_CHARGING                8
#DEFINE BATTERY_FLAG_NO_BATTERY              128
#DEFINE BATTERY_FLAG_UNKNOWN                 272
#DEFINE BATTERY_PERCENTAGE_UNKNOWN           272
#DEFINE BATTERY_LIFE_UNKNOWN                 4581298448

*-- WINNT.H
#DEFINE APPLICATION_ERROR_MASK               536870912    
#DEFINE ERROR_SEVERITY_SUCCESS               0            
#DEFINE ERROR_SEVERITY_INFORMATIONAL         1073741824   
#DEFINE ERROR_SEVERITY_WARNING               2147483648   
#DEFINE ERROR_SEVERITY_ERROR                 3221225472   
#DEFINE MINCHAR                              128          
#DEFINE MAXCHAR                              127          
#DEFINE MINSHORT                             32768        
#DEFINE MAXSHORT                             32767        
#DEFINE MINLONG                              2147483648   
#DEFINE MAXLONG                              2147483647   
#DEFINE MAXBYTE                              255          
#DEFINE MAXWORD                              65535        
#DEFINE MAXDWORD                             4294967295   
#DEFINE LANG_NEUTRAL                         0            
#DEFINE LANG_AFRIKAANS                       54           
#DEFINE LANG_ALBANIAN                        28           
#DEFINE LANG_ARABIC                          1            
#DEFINE LANG_BASQUE                          45           
#DEFINE LANG_BELARUSIAN                      35           
#DEFINE LANG_BULGARIAN                       2            
#DEFINE LANG_CATALAN                         3            
#DEFINE LANG_CHINESE                         4            
#DEFINE LANG_CROATIAN                        26           
#DEFINE LANG_CZECH                           5            
#DEFINE LANG_DANISH                          6            
#DEFINE LANG_DUTCH                           19           
#DEFINE LANG_ENGLISH                         9            
#DEFINE LANG_ESTONIAN                        37           
#DEFINE LANG_FAEROESE                        56           
#DEFINE LANG_FARSI                           41           
#DEFINE LANG_FINNISH                         11           
#DEFINE LANG_FRENCH                          12           
#DEFINE LANG_GERMAN                          7            
#DEFINE LANG_GREEK                           8            
#DEFINE LANG_HEBREW                          13           
#DEFINE LANG_HUNGARIAN                       14           
#DEFINE LANG_ICELANDIC                       15           
#DEFINE LANG_INDONESIAN                      33           
#DEFINE LANG_ITALIAN                         16           
#DEFINE LANG_JAPANESE                        17           
#DEFINE LANG_KOREAN                          18           
#DEFINE LANG_LATVIAN                         38           
#DEFINE LANG_LITHUANIAN                      39           
#DEFINE LANG_NORWEGIAN                       20           
#DEFINE LANG_POLISH                          21           
#DEFINE LANG_PORTUGUESE                      22           
#DEFINE LANG_ROMANIAN                        24           
#DEFINE LANG_RUSSIAN                         25           
#DEFINE LANG_SERBIAN                         26           
#DEFINE LANG_SLOVAK                          27           
#DEFINE LANG_SLOVENIAN                       36           
#DEFINE LANG_SPANISH                         10           
#DEFINE LANG_SWEDISH                         29           
#DEFINE LANG_THAI                            30           
#DEFINE LANG_TURKISH                         31           
#DEFINE LANG_UKRAINIAN                       34           
#DEFINE LANG_VIETNAMESE                      42           
#DEFINE SUBLANG_NEUTRAL                      0            && language neutral
#DEFINE SUBLANG_DEFAULT                      1            && user default
#DEFINE SUBLANG_SYS_DEFAULT                  2            && system default
#DEFINE SUBLANG_ARABIC_SAUDI_ARABIA          1            && Arabic (Saudi Arabia)
#DEFINE SUBLANG_ARABIC_IRAQ                  2            && Arabic (Iraq)
#DEFINE SUBLANG_ARABIC_EGYPT                 3            && Arabic (Egypt)
#DEFINE SUBLANG_ARABIC_LIBYA                 4            && Arabic (Libya)
#DEFINE SUBLANG_ARABIC_ALGERIA               5            && Arabic (Algeria)
#DEFINE SUBLANG_ARABIC_MOROCCO               6            && Arabic (Morocco)
#DEFINE SUBLANG_ARABIC_TUNISIA               7            && Arabic (Tunisia)
#DEFINE SUBLANG_ARABIC_OMAN                  8            && Arabic (Oman)
#DEFINE SUBLANG_ARABIC_YEMEN                 9            && Arabic (Yemen)
#DEFINE SUBLANG_ARABIC_SYRIA                 10           && Arabic (Syria)
#DEFINE SUBLANG_ARABIC_JORDAN                11           && Arabic (Jordan)
#DEFINE SUBLANG_ARABIC_LEBANON               12           && Arabic (Lebanon)
#DEFINE SUBLANG_ARABIC_KUWAIT                13           && Arabic (Kuwait)
#DEFINE SUBLANG_ARABIC_UAE                   14           && Arabic (U.A.E)
#DEFINE SUBLANG_ARABIC_BAHRAIN               15           && Arabic (Bahrain)
#DEFINE SUBLANG_ARABIC_QATAR                 16           && Arabic (Qatar)
#DEFINE SUBLANG_CHINESE_TRADITIONAL          1            && Chinese (Taiwan)
#DEFINE SUBLANG_CHINESE_SIMPLIFIED           2            && Chinese (PR China)
#DEFINE SUBLANG_CHINESE_HONGKONG             3            && Chinese (Hong Kong)
#DEFINE SUBLANG_CHINESE_SINGAPORE            4            && Chinese (Singapore)
#DEFINE SUBLANG_DUTCH                        1            && Dutch
#DEFINE SUBLANG_DUTCH_BELGIAN                2            && Dutch (Belgian)
#DEFINE SUBLANG_ENGLISH_US                   1            && English (USA)
#DEFINE SUBLANG_ENGLISH_UK                   2            && English (UK)
#DEFINE SUBLANG_ENGLISH_AUS                  3            && English (Australian)
#DEFINE SUBLANG_ENGLISH_CAN                  4            && English (Canadian)
#DEFINE SUBLANG_ENGLISH_NZ                   5            && English (New Zealand)
#DEFINE SUBLANG_ENGLISH_EIRE                 6            && English (Irish)
#DEFINE SUBLANG_ENGLISH_SOUTH_AFRICA         7            && English (South Africa)
#DEFINE SUBLANG_ENGLISH_JAMAICA              8            && English (Jamaica)
#DEFINE SUBLANG_ENGLISH_CARIBBEAN            9            && English (Caribbean)
#DEFINE SUBLANG_ENGLISH_BELIZE               10           && English (Belize)
#DEFINE SUBLANG_ENGLISH_TRINIDAD             11           && English (Trinidad)
#DEFINE SUBLANG_FRENCH                       1            && French
#DEFINE SUBLANG_FRENCH_BELGIAN               2            && French (Belgian)
#DEFINE SUBLANG_FRENCH_CANADIAN              3            && French (Canadian)
#DEFINE SUBLANG_FRENCH_SWISS                 4            && French (Swiss)
#DEFINE SUBLANG_FRENCH_LUXEMBOURG            5            && French (Luxembourg)
#DEFINE SUBLANG_GERMAN                       1            && German
#DEFINE SUBLANG_GERMAN_SWISS                 2            && German (Swiss)
#DEFINE SUBLANG_GERMAN_AUSTRIAN              3            && German (Austrian)
#DEFINE SUBLANG_GERMAN_LUXEMBOURG            4            && German (Luxembourg)
#DEFINE SUBLANG_GERMAN_LIECHTENSTEIN         5            && German (Liechtenstein)
#DEFINE SUBLANG_ITALIAN                      1            && Italian
#DEFINE SUBLANG_ITALIAN_SWISS                2            && Italian (Swiss)
#DEFINE SUBLANG_KOREAN                       1            && Korean (Extended Wansung)
#DEFINE SUBLANG_KOREAN_JOHAB                 2            && Korean (Johab)
#DEFINE SUBLANG_NORWEGIAN_BOKMAL             1            && Norwegian (Bokmal)
#DEFINE SUBLANG_NORWEGIAN_NYNORSK            2            && Norwegian (Nynorsk)
#DEFINE SUBLANG_PORTUGUESE                   2            && Portuguese
#DEFINE SUBLANG_PORTUGUESE_BRAZILIAN         1            && Portuguese (Brazilian)
#DEFINE SUBLANG_SERBIAN_LATIN                2            && Serbian (Latin)
#DEFINE SUBLANG_SERBIAN_CYRILLIC             3            && Serbian (Cyrillic)
#DEFINE SUBLANG_SPANISH                      1            && Spanish (Castilian)
#DEFINE SUBLANG_SPANISH_MEXICAN              2            && Spanish (Mexican)
#DEFINE SUBLANG_SPANISH_MODERN               3            && Spanish (Modern)
#DEFINE SUBLANG_SPANISH_GUATEMALA            4            && Spanish (Guatemala)
#DEFINE SUBLANG_SPANISH_COSTA_RICA           5            && Spanish (Costa Rica)
#DEFINE SUBLANG_SPANISH_PANAMA               6            && Spanish (Panama)
#DEFINE SUBLANG_SPANISH_DOMINICAN_REPUBLIC   7            && Spanish (Dominican Republic)
#DEFINE SUBLANG_SPANISH_VENEZUELA            8            && Spanish (Venezuela)
#DEFINE SUBLANG_SPANISH_COLOMBIA             9            && Spanish (Colombia)
#DEFINE SUBLANG_SPANISH_PERU                 10           && Spanish (Peru)
#DEFINE SUBLANG_SPANISH_ARGENTINA            11           && Spanish (Argentina)
#DEFINE SUBLANG_SPANISH_ECUADOR              12           && Spanish (Ecuador)
#DEFINE SUBLANG_SPANISH_CHILE                13           && Spanish (Chile)
#DEFINE SUBLANG_SPANISH_URUGUAY              14           && Spanish (Uruguay)
#DEFINE SUBLANG_SPANISH_PARAGUAY             15           && Spanish (Paraguay)
#DEFINE SUBLANG_SPANISH_BOLIVIA              16           && Spanish (Bolivia)
#DEFINE SUBLANG_SPANISH_EL_SALVADOR          17           && Spanish (El Salvador)
#DEFINE SUBLANG_SPANISH_HONDURAS             18           && Spanish (Honduras)
#DEFINE SUBLANG_SPANISH_NICARAGUA            19           && Spanish (Nicaragua)
#DEFINE SUBLANG_SPANISH_PUERTO_RICO          20           && Spanish (Puerto Rico)
#DEFINE SUBLANG_SWEDISH                      1            && Swedish
#DEFINE SUBLANG_SWEDISH_FINLAND              2            && Swedish (Finland)
#DEFINE SORT_DEFAULT                         0            && sorting default
#DEFINE SORT_JAPANESE_XJIS                   0            && Japanese XJIS order
#DEFINE SORT_JAPANESE_UNICODE                1            && Japanese Unicode order
#DEFINE SORT_CHINESE_BIG5                    0            && Chinese BIG5 order
#DEFINE SORT_CHINESE_PRCP                    0            && PRC Chinese Phonetic order
#DEFINE SORT_CHINESE_UNICODE                 1            && Chinese Unicode order
#DEFINE SORT_CHINESE_PRC                     2            && PRC Chinese Stroke Count order
#DEFINE SORT_KOREAN_KSC                      0            && Korean KSC order
#DEFINE SORT_KOREAN_UNICODE                  1            && Korean Unicode order
#DEFINE SORT_GERMAN_PHONE_BOOK               1            && German Phone Book order
#DEFINE NLS_VALID_LOCALE_MASK                1048575      
#DEFINE STATUS_WAIT_0                        0            
#DEFINE STATUS_ABANDONED_WAIT_0              128          
#DEFINE STATUS_USER_APC                      192          
#DEFINE STATUS_TIMEOUT                       258          
#DEFINE STATUS_PENDING                       259          
#DEFINE STATUS_SEGMENT_NOTIFICATION          1073741829   
#DEFINE STATUS_GUARD_PAGE_VIOLATION          2147483649   
#DEFINE STATUS_DATATYPE_MISALIGNMENT         2147483650   
#DEFINE STATUS_BREAKPOINT                    2147483651   
#DEFINE STATUS_SINGLE_STEP                   2147483652   
#DEFINE STATUS_ACCESS_VIOLATION              3221225477   
#DEFINE STATUS_IN_PAGE_ERROR                 3221225478   
#DEFINE STATUS_INVALID_HANDLE                3221225480   
#DEFINE STATUS_NO_MEMORY                     3221225495   
#DEFINE STATUS_ILLEGAL_INSTRUCTION           3221225501   
#DEFINE STATUS_NONCONTINUABLE_EXCEPTION      3221225509   
#DEFINE STATUS_INVALID_DISPOSITION           3221225510   
#DEFINE STATUS_ARRAY_BOUNDS_EXCEEDED         3221225612   
#DEFINE STATUS_FLOAT_DENORMAL_OPERAND        3221225613   
#DEFINE STATUS_FLOAT_DIVIDE_BY_ZERO          3221225614   
#DEFINE STATUS_FLOAT_INEXACT_RESULT          3221225615   
#DEFINE STATUS_FLOAT_INVALID_OPERATION       3221225616   
#DEFINE STATUS_FLOAT_OVERFLOW                3221225617   
#DEFINE STATUS_FLOAT_STACK_CHECK             3221225618   
#DEFINE STATUS_FLOAT_UNDERFLOW               3221225619   
#DEFINE STATUS_INTEGER_DIVIDE_BY_ZERO        3221225620   
#DEFINE STATUS_INTEGER_OVERFLOW              3221225621   
#DEFINE STATUS_PRIVILEGED_INSTRUCTION        3221225622   
#DEFINE STATUS_STACK_OVERFLOW                3221225725   
#DEFINE STATUS_CONTROL_C_EXIT                3221225786   
#DEFINE SIZE_OF_80387_REGISTERS              80           
#DEFINE CONTEXT_i386                         65536        && this assumes that i386 and
#DEFINE CONTEXT_i486                         65536        && i486 have identical context records
#DEFINE CONTEXT32_LENGTH                     304          && The original 32-bit Context length (pre NT 4.0)
#DEFINE CONTEXT_CONTROL                      1            
#DEFINE CONTEXT_FLOATING_POINT               2            
#DEFINE CONTEXT_INTEGER                      4            
#DEFINE CONTEXT_DEBUG_REGISTERS              8            
#DEFINE EXCEPTION_NONCONTINUABLE             1            && Noncontinuable exception
#DEFINE EXCEPTION_MAXIMUM_PARAMETERS         15           && maximum number of exception parameters
#DEFINE PROCESS_TERMINATE                    1            
#DEFINE PROCESS_CREATE_THREAD                2            
#DEFINE PROCESS_VM_OPERATION                 8            
#DEFINE PROCESS_VM_READ                      16           
#DEFINE PROCESS_VM_WRITE                     32           
#DEFINE PROCESS_DUP_HANDLE                   64           
#DEFINE PROCESS_CREATE_PROCESS               128          
#DEFINE PROCESS_SET_QUOTA                    256          
#DEFINE PROCESS_SET_INFORMATION              512          
#DEFINE PROCESS_QUERY_INFORMATION            1024         
#DEFINE MAXIMUM_PROCESSORS                   32           
#DEFINE THREAD_TERMINATE                     1            
#DEFINE THREAD_SUSPEND_RESUME                2            
#DEFINE THREAD_GET_CONTEXT                   8            
#DEFINE THREAD_SET_CONTEXT                   16           
#DEFINE THREAD_SET_INFORMATION               32           
#DEFINE THREAD_QUERY_INFORMATION             64           
#DEFINE THREAD_SET_THREAD_TOKEN              128          
#DEFINE THREAD_IMPERSONATE                   256          
#DEFINE THREAD_DIRECT_IMPERSONATION          512          
#DEFINE THREAD_ALL_ACCESS                    1023         
#DEFINE THREAD_BASE_PRIORITY_LOWRT           15           && value that gets a thread to LowRealtime-1
#DEFINE THREAD_BASE_PRIORITY_MAX             2            && maximum thread base priority boost
#DEFINE THREAD_BASE_PRIORITY_MIN             -2           && minimum thread base priority boost
#DEFINE THREAD_BASE_PRIORITY_IDLE            -15          && value that gets a thread to idle
#DEFINE EVENT_MODIFY_STATE                   2            
#DEFINE EVENT_ALL_ACCESS                     3            
#DEFINE MUTANT_QUERY_STATE                   1            
#DEFINE SEMAPHORE_MODIFY_STATE               2            
#DEFINE SEMAPHORE_ALL_ACCESS                 3            
#DEFINE TIME_ZONE_ID_UNKNOWN                 0            
#DEFINE TIME_ZONE_ID_STANDARD                1            
#DEFINE TIME_ZONE_ID_DAYLIGHT                2            
#DEFINE PROCESSOR_INTEL_386                  386          
#DEFINE PROCESSOR_INTEL_486                  486          
#DEFINE PROCESSOR_INTEL_PENTIUM              586          
#DEFINE PROCESSOR_MIPS_R4000                 4000         
#DEFINE PROCESSOR_ALPHA_21064                21064        
#DEFINE PROCESSOR_ARCHITECTURE_INTEL         0            
#DEFINE PROCESSOR_ARCHITECTURE_MIPS          1            
#DEFINE PROCESSOR_ARCHITECTURE_ALPHA         2            
#DEFINE PROCESSOR_ARCHITECTURE_PPC           3            
#DEFINE PROCESSOR_ARCHITECTURE_UNKNOWN       65535        
#DEFINE PF_FLOATING_POINT_PRECISION_ERRATA   0            
#DEFINE PF_FLOATING_POINT_EMULATED           1            
#DEFINE PF_COMPARE_EXCHANGE_DOUBLE           2            
#DEFINE PF_MMX_INSTRUCTIONS_AVAILABLE        3            
#DEFINE SECTION_QUERY                        1            
#DEFINE SECTION_MAP_WRITE                    2            
#DEFINE SECTION_MAP_READ                     4            
#DEFINE SECTION_MAP_EXECUTE                  8            
#DEFINE SECTION_EXTEND_SIZE                  16           
#DEFINE PAGE_NOACCESS                        1            
#DEFINE PAGE_READONLY                        2            
#DEFINE PAGE_READWRITE                       4            
#DEFINE PAGE_WRITECOPY                       8            
#DEFINE PAGE_EXECUTE                         16           
#DEFINE PAGE_EXECUTE_READ                    32           
#DEFINE PAGE_EXECUTE_READWRITE               64           
#DEFINE PAGE_EXECUTE_WRITECOPY               128          
#DEFINE PAGE_GUARD                           256          
#DEFINE PAGE_NOCACHE                         512          
#DEFINE MEM_COMMIT                           4096         
#DEFINE MEM_RESERVE                          8192         
#DEFINE MEM_DECOMMIT                         16384        
#DEFINE MEM_RELEASE                          32768        
#DEFINE MEM_FREE                             65536        
#DEFINE MEM_PRIVATE                          131072       
#DEFINE MEM_MAPPED                           262144       
#DEFINE MEM_RESET                            524288       
#DEFINE MEM_TOP_DOWN                         1048576      
#DEFINE SEC_FILE                             8388608      
#DEFINE SEC_IMAGE                            16777216     
#DEFINE SEC_RESERVE                          67108864     
#DEFINE SEC_COMMIT                           134217728    
#DEFINE SEC_NOCACHE                          268435456    
#DEFINE MEM_IMAGE                            SEC_IMAGE    
#DEFINE FILE_READ_DATA                       1            && file & pipe
#DEFINE FILE_LIST_DIRECTORY                  1            && directory
#DEFINE FILE_WRITE_DATA                      2            && file & pipe
#DEFINE FILE_ADD_FILE                        2            && directory
#DEFINE FILE_APPEND_DATA                     4            && file
#DEFINE FILE_ADD_SUBDIRECTORY                4            && directory
#DEFINE FILE_CREATE_PIPE_INSTANCE            4            && named pipe
#DEFINE FILE_READ_EA                         8            && file & directory
#DEFINE FILE_WRITE_EA                        16           && file & directory
#DEFINE FILE_EXECUTE                         32           && file
#DEFINE FILE_TRAVERSE                        32           && directory
#DEFINE FILE_DELETE_CHILD                    64           && directory
#DEFINE FILE_READ_ATTRIBUTES                 128          && all
#DEFINE FILE_WRITE_ATTRIBUTES                256          && all
#DEFINE FILE_SHARE_READ                      1            
#DEFINE FILE_SHARE_WRITE                     2            
#DEFINE FILE_SHARE_DELETE                    4            
#DEFINE FILE_ATTRIBUTE_READONLY              1            
#DEFINE FILE_ATTRIBUTE_HIDDEN                2            
#DEFINE FILE_ATTRIBUTE_SYSTEM                4            
#DEFINE FILE_ATTRIBUTE_DIRECTORY             16           
#DEFINE FILE_ATTRIBUTE_ARCHIVE               32           
#DEFINE FILE_ATTRIBUTE_NORMAL                128          
#DEFINE FILE_ATTRIBUTE_TEMPORARY             256          
#DEFINE FILE_ATTRIBUTE_COMPRESSED            2048         
#DEFINE FILE_ATTRIBUTE_OFFLINE               4096         
#DEFINE FILE_NOTIFY_CHANGE_FILE_NAME         1            
#DEFINE FILE_NOTIFY_CHANGE_DIR_NAME          2            
#DEFINE FILE_NOTIFY_CHANGE_ATTRIBUTES        4            
#DEFINE FILE_NOTIFY_CHANGE_SIZE              8            
#DEFINE FILE_NOTIFY_CHANGE_LAST_WRITE        16           
#DEFINE FILE_NOTIFY_CHANGE_LAST_ACCESS       32           
#DEFINE FILE_NOTIFY_CHANGE_CREATION          64           
#DEFINE FILE_NOTIFY_CHANGE_SECURITY          256          
#DEFINE FILE_ACTION_ADDED                    1            
#DEFINE FILE_ACTION_REMOVED                  2            
#DEFINE FILE_ACTION_MODIFIED                 3            
#DEFINE FILE_ACTION_RENAMED_OLD_NAME         4            
#DEFINE FILE_ACTION_RENAMED_NEW_NAME         5            
#DEFINE MAILSLOT_NO_MESSAGE                  -1           
#DEFINE MAILSLOT_WAIT_FOREVER                -1           
#DEFINE FILE_CASE_SENSITIVE_SEARCH           1            
#DEFINE FILE_CASE_PRESERVED_NAMES            2            
#DEFINE FILE_UNICODE_ON_DISK                 4            
#DEFINE FILE_PERSISTENT_ACLS                 8            
#DEFINE FILE_FILE_COMPRESSION                16           
#DEFINE FILE_VOLUME_IS_COMPRESSED            32768        
#DEFINE IO_COMPLETION_MODIFY_STATE           2            
#DEFINE DUPLICATE_CLOSE_SOURCE               1            
#DEFINE DUPLICATE_SAME_ACCESS                2            
#DEFINE DELETE                               65536        
#DEFINE READ_CONTROL                         131072       
#DEFINE WRITE_DAC                            262144       
#DEFINE WRITE_OWNER                          524288       
#DEFINE SYNCHRONIZE                          1048576      
#DEFINE STANDARD_RIGHTS_REQUIRED             983040       
#DEFINE STANDARD_RIGHTS_READ                 READ_CONTROL 
#DEFINE STANDARD_RIGHTS_WRITE                READ_CONTROL 
#DEFINE STANDARD_RIGHTS_EXECUTE              READ_CONTROL 
#DEFINE STANDARD_RIGHTS_ALL                  2031616      
#DEFINE SPECIFIC_RIGHTS_ALL                  65535        
#DEFINE ACCESS_SYSTEM_SECURITY               16777216     
#DEFINE MAXIMUM_ALLOWED                      33554432     
#DEFINE GENERIC_READ                         2147483648   
#DEFINE GENERIC_WRITE                        1073741824   
#DEFINE GENERIC_EXECUTE                      536870912    
#DEFINE GENERIC_ALL                          268435456    
#DEFINE SID_REVISION                         1            && Current revision level
#DEFINE SID_MAX_SUB_AUTHORITIES              15           
#DEFINE SID_RECOMMENDED_SUB_AUTHORITIES      1            && Will change to around 6 in a future release.
#DEFINE SECURITY_NULL_RID                    0            
#DEFINE SECURITY_WORLD_RID                   0            
#DEFINE SECURITY_LOCAL_RID                   0            
#DEFINE SECURITY_CREATOR_OWNER_RID           0            
#DEFINE SECURITY_CREATOR_GROUP_RID           1            
#DEFINE SECURITY_CREATOR_OWNER_SERVER_RID    2            
#DEFINE SECURITY_CREATOR_GROUP_SERVER_RID    3            
#DEFINE SECURITY_DIALUP_RID                  1            
#DEFINE SECURITY_NETWORK_RID                 2            
#DEFINE SECURITY_BATCH_RID                   3            
#DEFINE SECURITY_INTERACTIVE_RID             4            
#DEFINE SECURITY_SERVICE_RID                 6            
#DEFINE SECURITY_ANONYMOUS_LOGON_RID         7            
#DEFINE SECURITY_PROXY_RID                   8            
#DEFINE SECURITY_SERVER_LOGON_RID            9            
#DEFINE SECURITY_LOGON_IDS_RID               5            
#DEFINE SECURITY_LOGON_IDS_RID_COUNT         3            
#DEFINE SECURITY_LOCAL_SYSTEM_RID            18           
#DEFINE SECURITY_NT_NON_UNIQUE               21           
#DEFINE SECURITY_BUILTIN_DOMAIN_RID          32           
#DEFINE DOMAIN_USER_RID_ADMIN                500          
#DEFINE DOMAIN_USER_RID_GUEST                501          
#DEFINE DOMAIN_GROUP_RID_ADMINS              512          
#DEFINE DOMAIN_GROUP_RID_USERS               513          
#DEFINE DOMAIN_GROUP_RID_GUESTS              514          
#DEFINE DOMAIN_ALIAS_RID_ADMINS              544          
#DEFINE DOMAIN_ALIAS_RID_USERS               545          
#DEFINE DOMAIN_ALIAS_RID_GUESTS              546          
#DEFINE DOMAIN_ALIAS_RID_POWER_USERS         547          
#DEFINE DOMAIN_ALIAS_RID_ACCOUNT_OPS         548          
#DEFINE DOMAIN_ALIAS_RID_SYSTEM_OPS          549          
#DEFINE DOMAIN_ALIAS_RID_PRINT_OPS           550          
#DEFINE DOMAIN_ALIAS_RID_BACKUP_OPS          551          
#DEFINE DOMAIN_ALIAS_RID_REPLICATOR          552          
#DEFINE SE_GROUP_MANDATORY                   1            
#DEFINE SE_GROUP_ENABLED_BY_DEFAULT          2            
#DEFINE SE_GROUP_ENABLED                     4            
#DEFINE SE_GROUP_OWNER                       8            
#DEFINE SE_GROUP_LOGON_ID                    3221225472   
#DEFINE ACL_REVISION                         2            
#DEFINE ACL_REVISION1                        1            
#DEFINE ACL_REVISION2                        2            
#DEFINE ACL_REVISION3                        3            
#DEFINE ACCESS_ALLOWED_ACE_TYPE              0            
#DEFINE ACCESS_DENIED_ACE_TYPE               1            
#DEFINE SYSTEM_AUDIT_ACE_TYPE                2            
#DEFINE SYSTEM_ALARM_ACE_TYPE                3            
#DEFINE OBJECT_INHERIT_ACE                   1            
#DEFINE CONTAINER_INHERIT_ACE                2            
#DEFINE NO_PROPAGATE_INHERIT_ACE             4            
#DEFINE INHERIT_ONLY_ACE                     8            
#DEFINE VALID_INHERIT_FLAGS                  15           
#DEFINE SUCCESSFUL_ACCESS_ACE_FLAG           64           
#DEFINE FAILED_ACCESS_ACE_FLAG               128          
#DEFINE SECURITY_DESCRIPTOR_REVISION         1            
#DEFINE SECURITY_DESCRIPTOR_REVISION1        1            
#DEFINE SECURITY_DESCRIPTOR_MIN_LENGTH       20           
#DEFINE SE_OWNER_DEFAULTED                   1            
#DEFINE SE_GROUP_DEFAULTED                   2            
#DEFINE SE_DACL_PRESENT                      4            
#DEFINE SE_DACL_DEFAULTED                    8            
#DEFINE SE_SACL_PRESENT                      16           
#DEFINE SE_SACL_DEFAULTED                    32           
#DEFINE SE_SELF_RELATIVE                     32768        
#DEFINE SE_PRIVILEGE_ENABLED_BY_DEFAULT      1            
#DEFINE SE_PRIVILEGE_ENABLED                 2            
#DEFINE SE_PRIVILEGE_USED_FOR_ACCESS         2147483648   
#DEFINE PRIVILEGE_SET_ALL_NECESSARY          1            
#DEFINE SE_CREATE_TOKEN_NAME                 "SeCreateTokenPrivilege"
#DEFINE SE_ASSIGNPRIMARYTOKEN_NAME           "SeAssignPrimaryTokenPrivilege"
#DEFINE SE_LOCK_MEMORY_NAME                  "SeLockMemoryPrivilege"
#DEFINE SE_INCREASE_QUOTA_NAME               "SeIncreaseQuotaPrivilege"
#DEFINE SE_UNSOLICITED_INPUT_NAME            "SeUnsolicitedInputPrivilege"
#DEFINE SE_MACHINE_ACCOUNT_NAME              "SeMachineAccountPrivilege"
#DEFINE SE_TCB_NAME                          "SeTcbPrivilege"
#DEFINE SE_SECURITY_NAME                     "SeSecurityPrivilege"
#DEFINE SE_TAKE_OWNERSHIP_NAME               "SeTakeOwnershipPrivilege"
#DEFINE SE_LOAD_DRIVER_NAME                  "SeLoadDriverPrivilege"
#DEFINE SE_SYSTEM_PROFILE_NAME               "SeSystemProfilePrivilege"
#DEFINE SE_SYSTEMTIME_NAME                   "SeSystemtimePrivilege"
#DEFINE SE_PROF_SINGLE_PROCESS_NAME          "SeProfileSingleProcessPrivilege"
#DEFINE SE_INC_BASE_PRIORITY_NAME            "SeIncreaseBasePriorityPrivilege"
#DEFINE SE_CREATE_PAGEFILE_NAME              "SeCreatePagefilePrivilege"
#DEFINE SE_CREATE_PERMANENT_NAME             "SeCreatePermanentPrivilege"
#DEFINE SE_BACKUP_NAME                       "SeBackupPrivilege"
#DEFINE SE_RESTORE_NAME                      "SeRestorePrivilege"
#DEFINE SE_SHUTDOWN_NAME                     "SeShutdownPrivilege"
#DEFINE SE_DEBUG_NAME                        "SeDebugPrivilege"
#DEFINE SE_AUDIT_NAME                        "SeAuditPrivilege"
#DEFINE SE_SYSTEM_ENVIRONMENT_NAME           "SeSystemEnvironmentPrivilege"
#DEFINE SE_CHANGE_NOTIFY_NAME                "SeChangeNotifyPrivilege"
#DEFINE SE_REMOTE_SHUTDOWN_NAME              "SeRemoteShutdownPrivilege"
#DEFINE SECURITY_MAX_IMPERSONATION_LEVEL     SecurityDelegation 
#DEFINE DEFAULT_IMPERSONATION_LEVEL          SecurityImpersonation 
#DEFINE TOKEN_ASSIGN_PRIMARY                 1            
#DEFINE TOKEN_DUPLICATE                      2            
#DEFINE TOKEN_IMPERSONATE                    4            
#DEFINE TOKEN_QUERY                          8            
#DEFINE TOKEN_QUERY_SOURCE                   16           
#DEFINE TOKEN_ADJUST_PRIVILEGES              32           
#DEFINE TOKEN_ADJUST_GROUPS                  64           
#DEFINE TOKEN_ADJUST_DEFAULT                 128          
#DEFINE TOKEN_SOURCE_LENGTH                  8            
#DEFINE SECURITY_DYNAMIC_TRACKING            .T.          
#DEFINE SECURITY_STATIC_TRACKING             .F.          
#DEFINE OWNER_SECURITY_INFORMATION           1            
#DEFINE GROUP_SECURITY_INFORMATION           2            
#DEFINE DACL_SECURITY_INFORMATION            4            
#DEFINE SACL_SECURITY_INFORMATION            8            
#DEFINE IMAGE_DOS_SIGNATURE                  23117        && MZ
#DEFINE IMAGE_OS2_SIGNATURE                  17742        && NE
#DEFINE IMAGE_OS2_SIGNATURE_LE               17740        && LE
#DEFINE IMAGE_VXD_SIGNATURE                  17740        && LE
#DEFINE IMAGE_NT_SIGNATURE                   17744        && PE00
#DEFINE IMAGE_SIZEOF_FILE_HEADER             20           
#DEFINE IMAGE_FILE_RELOCS_STRIPPED           1            && Relocation info stripped from file.
#DEFINE IMAGE_FILE_EXECUTABLE_IMAGE          2            && File is executable  (i.e. no unresolved externel references).
#DEFINE IMAGE_FILE_LINE_NUMS_STRIPPED        4            && Line nunbers stripped from file.
#DEFINE IMAGE_FILE_LOCAL_SYMS_STRIPPED       8            && Local symbols stripped from file.
#DEFINE IMAGE_FILE_AGGRESIVE_WS_TRIM         16           && Agressively trim working set
#DEFINE IMAGE_FILE_BYTES_REVERSED_LO         128          && Bytes of machine word are reversed.
#DEFINE IMAGE_FILE_32BIT_MACHINE             256          && 32 bit word machine.
#DEFINE IMAGE_FILE_DEBUG_STRIPPED            512          && Debugging info stripped from file in .DBG file
#DEFINE IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP   1024         && If Image is on removable media, copy and run from the swap file.
#DEFINE IMAGE_FILE_NET_RUN_FROM_SWAP         2048         && If Image is on Net, copy and run from the swap file.
#DEFINE IMAGE_FILE_SYSTEM                    4096         && System File.
#DEFINE IMAGE_FILE_DLL                       8192         && File is a DLL.
#DEFINE IMAGE_FILE_UP_SYSTEM_ONLY            16384        && File should only be run on a UP machine
#DEFINE IMAGE_FILE_BYTES_REVERSED_HI         32768        && Bytes of machine word are reversed.
#DEFINE IMAGE_FILE_MACHINE_UNKNOWN           0            
#DEFINE IMAGE_FILE_MACHINE_I386              332          && Intel 386.
#DEFINE IMAGE_FILE_MACHINE_R3000             354          && MIPS little-endian, 0x160 big-endian
#DEFINE IMAGE_FILE_MACHINE_R4000             358          && MIPS little-endian
#DEFINE IMAGE_FILE_MACHINE_R10000            360          && MIPS little-endian
#DEFINE IMAGE_FILE_MACHINE_ALPHA             388          && Alpha_AXP
#DEFINE IMAGE_FILE_MACHINE_POWERPC           496          && IBM PowerPC Little-Endian
#DEFINE IMAGE_NUMBEROF_DIRECTORY_ENTRIES     16           
#DEFINE IMAGE_SIZEOF_ROM_OPTIONAL_HEADER     56           
#DEFINE IMAGE_SIZEOF_STD_OPTIONAL_HEADER     28           
#DEFINE IMAGE_SIZEOF_NT_OPTIONAL_HEADER      224          
#DEFINE IMAGE_NT_OPTIONAL_HDR_MAGIC          267          
#DEFINE IMAGE_ROM_OPTIONAL_HDR_MAGIC         263          
#DEFINE IMAGE_SUBSYSTEM_UNKNOWN              0            && Unknown subsystem.
#DEFINE IMAGE_SUBSYSTEM_NATIVE               1            && Image doesn't require a subsystem.
#DEFINE IMAGE_SUBSYSTEM_WINDOWS_GUI          2            && Image runs in the Windows GUI subsystem.
#DEFINE IMAGE_SUBSYSTEM_WINDOWS_CUI          3            && Image runs in the Windows character subsystem.
#DEFINE IMAGE_SUBSYSTEM_OS2_CUI              5            && image runs in the OS/2 character subsystem.
#DEFINE IMAGE_SUBSYSTEM_POSIX_CUI            7            && image run  in the Posix character subsystem.
#DEFINE IMAGE_SUBSYSTEM_RESERVED8            8            && image run  in the 8 subsystem.
#DEFINE IMAGE_DIRECTORY_ENTRY_EXPORT         0            && Export Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_IMPORT         1            && Import Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_RESOURCE       2            && Resource Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_EXCEPTION      3            && Exception Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_SECURITY       4            && Security Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_BASERELOC      5            && Base Relocation Table
#DEFINE IMAGE_DIRECTORY_ENTRY_DEBUG          6            && Debug Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_COPYRIGHT      7            && Description String
#DEFINE IMAGE_DIRECTORY_ENTRY_GLOBALPTR      8            && Machine Value (MIPS GP)
#DEFINE IMAGE_DIRECTORY_ENTRY_TLS            9            && TLS Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG    10           && Load Configuration Directory
#DEFINE IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT   11           && Bound Import Directory in headers
#DEFINE IMAGE_DIRECTORY_ENTRY_IAT            12           && Import Address Table
#DEFINE IMAGE_SIZEOF_SHORT_NAME              8            
#DEFINE IMAGE_SIZEOF_SECTION_HEADER          40           
#DEFINE IMAGE_SCN_TYPE_NO_PAD                8            && Reserved.
#DEFINE IMAGE_SCN_CNT_CODE                   32           && Section contains code.
#DEFINE IMAGE_SCN_CNT_INITIALIZED_DATA       64           && Section contains initialized data.
#DEFINE IMAGE_SCN_CNT_UNINITIALIZED_DATA     128          && Section contains uninitialized data.
#DEFINE IMAGE_SCN_LNK_OTHER                  256          && Reserved.
#DEFINE IMAGE_SCN_LNK_INFO                   512          && Section contains comments or some other type of information.
#DEFINE IMAGE_SCN_LNK_REMOVE                 2048         && Section contents will not become part of image.
#DEFINE IMAGE_SCN_LNK_COMDAT                 4096         && Section contents comdat.
#DEFINE IMAGE_SCN_MEM_FARDATA                32768        
#DEFINE IMAGE_SCN_MEM_PURGEABLE              131072       
#DEFINE IMAGE_SCN_MEM_16BIT                  131072       
#DEFINE IMAGE_SCN_MEM_LOCKED                 262144       
#DEFINE IMAGE_SCN_MEM_PRELOAD                524288       
#DEFINE IMAGE_SCN_ALIGN_1BYTES               1048576      &&
#DEFINE IMAGE_SCN_ALIGN_2BYTES               2097152      &&
#DEFINE IMAGE_SCN_ALIGN_4BYTES               3145728      &&
#DEFINE IMAGE_SCN_ALIGN_8BYTES               4194304      &&
#DEFINE IMAGE_SCN_ALIGN_16BYTES              5242880      && Default alignment if no others are specified.
#DEFINE IMAGE_SCN_ALIGN_32BYTES              6291456      &&
#DEFINE IMAGE_SCN_ALIGN_64BYTES              7340032      &&
#DEFINE IMAGE_SCN_LNK_NRELOC_OVFL            16777216     && Section contains extended relocations.
#DEFINE IMAGE_SCN_MEM_DISCARDABLE            33554432     && Section can be discarded.
#DEFINE IMAGE_SCN_MEM_NOT_CACHED             67108864     && Section is not cachable.
#DEFINE IMAGE_SCN_MEM_NOT_PAGED              134217728    && Section is not pageable.
#DEFINE IMAGE_SCN_MEM_SHARED                 268435456    && Section is shareable.
#DEFINE IMAGE_SCN_MEM_EXECUTE                536870912    && Section is executable.
#DEFINE IMAGE_SCN_MEM_READ                   1073741824   && Section is readable.
#DEFINE IMAGE_SCN_MEM_WRITE                  2147483648   && Section is writeable.
#DEFINE IMAGE_SCN_SCALE_INDEX                1            && Tls index is scaled
#DEFINE IMAGE_SIZEOF_SYMBOL                  18           
#DEFINE IMAGE_SYM_UNDEFINED                  0            && Symbol is undefined or is common.
#DEFINE IMAGE_SYM_ABSOLUTE                   -1           && Symbol is an absolute value.
#DEFINE IMAGE_SYM_DEBUG                      -2           && Symbol is a special debug item.
#DEFINE IMAGE_SYM_TYPE_NULL                  0            && no type.
#DEFINE IMAGE_SYM_TYPE_VOID                  1            &&
#DEFINE IMAGE_SYM_TYPE_CHAR                  2            && type character.
#DEFINE IMAGE_SYM_TYPE_SHORT                 3            && type short integer.
#DEFINE IMAGE_SYM_TYPE_INT                   4            &&
#DEFINE IMAGE_SYM_TYPE_LONG                  5            &&
#DEFINE IMAGE_SYM_TYPE_FLOAT                 6            &&
#DEFINE IMAGE_SYM_TYPE_DOUBLE                7            &&
#DEFINE IMAGE_SYM_TYPE_STRUCT                8            &&
#DEFINE IMAGE_SYM_TYPE_UNION                 9            &&
#DEFINE IMAGE_SYM_TYPE_ENUM                  10           && enumeration.
#DEFINE IMAGE_SYM_TYPE_MOE                   11           && member of enumeration.
#DEFINE IMAGE_SYM_TYPE_BYTE                  12           &&
#DEFINE IMAGE_SYM_TYPE_WORD                  13           &&
#DEFINE IMAGE_SYM_TYPE_UINT                  14           &&
#DEFINE IMAGE_SYM_TYPE_DWORD                 15           &&
#DEFINE IMAGE_SYM_TYPE_PCODE                 32768        &&
#DEFINE IMAGE_SYM_DTYPE_NULL                 0            && no derived type.
#DEFINE IMAGE_SYM_DTYPE_POINTER              1            && pointer.
#DEFINE IMAGE_SYM_DTYPE_FUNCTION             2            && function.
#DEFINE IMAGE_SYM_DTYPE_ARRAY                3            && array.
#DEFINE IMAGE_SYM_CLASS_END_OF_FUNCTION      -1           
#DEFINE IMAGE_SYM_CLASS_NULL                 0            
#DEFINE IMAGE_SYM_CLASS_AUTOMATIC            1            
#DEFINE IMAGE_SYM_CLASS_EXTERNAL             2            
#DEFINE IMAGE_SYM_CLASS_STATIC               3            
#DEFINE IMAGE_SYM_CLASS_REGISTER             4            
#DEFINE IMAGE_SYM_CLASS_EXTERNAL_DEF         5            
#DEFINE IMAGE_SYM_CLASS_LABEL                6            
#DEFINE IMAGE_SYM_CLASS_UNDEFINED_LABEL      7            
#DEFINE IMAGE_SYM_CLASS_MEMBER_OF_STRUCT     8            
#DEFINE IMAGE_SYM_CLASS_ARGUMENT             9            
#DEFINE IMAGE_SYM_CLASS_STRUCT_TAG           10           
#DEFINE IMAGE_SYM_CLASS_MEMBER_OF_UNION      11           
#DEFINE IMAGE_SYM_CLASS_UNION_TAG            12           
#DEFINE IMAGE_SYM_CLASS_TYPE_DEFINITION      13           
#DEFINE IMAGE_SYM_CLASS_UNDEFINED_STATIC     14           
#DEFINE IMAGE_SYM_CLASS_ENUM_TAG             15           
#DEFINE IMAGE_SYM_CLASS_MEMBER_OF_ENUM       16           
#DEFINE IMAGE_SYM_CLASS_REGISTER_PARAM       17           
#DEFINE IMAGE_SYM_CLASS_BIT_FIELD            18           
#DEFINE IMAGE_SYM_CLASS_FAR_EXTERNAL         68           
#DEFINE IMAGE_SYM_CLASS_BLOCK                100          
#DEFINE IMAGE_SYM_CLASS_FUNCTION             101          
#DEFINE IMAGE_SYM_CLASS_END_OF_STRUCT        102          
#DEFINE IMAGE_SYM_CLASS_FILE                 103          
#DEFINE IMAGE_SYM_CLASS_SECTION              104          
#DEFINE IMAGE_SYM_CLASS_WEAK_EXTERNAL        105          
#DEFINE N_BTMASK                             15           
#DEFINE N_TMASK                              48           
#DEFINE N_TMASK1                             192          
#DEFINE N_TMASK2                             240          
#DEFINE N_BTSHFT                             4            
#DEFINE N_TSHIFT                             2            
#DEFINE IMAGE_COMDAT_SELECT_NODUPLICATES     1            
#DEFINE IMAGE_COMDAT_SELECT_ANY              2            
#DEFINE IMAGE_COMDAT_SELECT_SAME_SIZE        3            
#DEFINE IMAGE_COMDAT_SELECT_EXACT_MATCH      4            
#DEFINE IMAGE_COMDAT_SELECT_ASSOCIATIVE      5            
#DEFINE IMAGE_COMDAT_SELECT_LARGEST          6            
#DEFINE IMAGE_COMDAT_SELECT_NEWEST           7            
#DEFINE IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY   1            
#DEFINE IMAGE_WEAK_EXTERN_SEARCH_LIBRARY     2            
#DEFINE IMAGE_WEAK_EXTERN_SEARCH_ALIAS       3            
#DEFINE IMAGE_SIZEOF_RELOCATION              10           
#DEFINE IMAGE_REL_I386_ABSOLUTE              0            && Reference is absolute, no relocation is necessary
#DEFINE IMAGE_REL_I386_DIR16                 1            && Direct 16-bit reference to the symbols virtual address
#DEFINE IMAGE_REL_I386_REL16                 2            && PC-relative 16-bit reference to the symbols virtual address
#DEFINE IMAGE_REL_I386_DIR32                 6            && Direct 32-bit reference to the symbols virtual address
#DEFINE IMAGE_REL_I386_DIR32NB               7            && Direct 32-bit reference to the symbols virtual address, base not included
#DEFINE IMAGE_REL_I386_SEG12                 9            && Direct 16-bit reference to the segment-selector bits of a 32-bit virtual address
#DEFINE IMAGE_REL_I386_SECTION               10           
#DEFINE IMAGE_REL_I386_SECREL                11           
#DEFINE IMAGE_REL_I386_REL32                 20           && PC-relative 32-bit reference to the symbols virtual address
#DEFINE IMAGE_SIZEOF_BASE_RELOCATION         8            
#DEFINE IMAGE_REL_BASED_ABSOLUTE             0            
#DEFINE IMAGE_REL_BASED_HIGH                 1            
#DEFINE IMAGE_REL_BASED_LOW                  2            
#DEFINE IMAGE_REL_BASED_HIGHLOW              3            
#DEFINE IMAGE_REL_BASED_HIGHADJ              4            
#DEFINE IMAGE_REL_BASED_MIPS_JMPADDR         5            
#DEFINE IMAGE_REL_BASED_SECTION              6            
#DEFINE IMAGE_REL_BASED_REL32                7            
#DEFINE IMAGE_ARCHIVE_START_SIZE             8            
#DEFINE IMAGE_ARCHIVE_START                  "!<arch>\n"
#DEFINE IMAGE_ARCHIVE_END                    "`\n"
#DEFINE IMAGE_ARCHIVE_PAD                    "\n"
#DEFINE IMAGE_ARCHIVE_LINKER_MEMBER          "/               "
#DEFINE IMAGE_ARCHIVE_LONGNAMES_MEMBER       "//              "
#DEFINE IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR      60           
#DEFINE IMAGE_ORDINAL_FLAG                   2147483648   
#DEFINE IMAGE_RESOURCE_NAME_IS_STRING        2147483648   
#DEFINE IMAGE_RESOURCE_DATA_IS_DIRECTORY     2147483648   
#DEFINE IMAGE_DEBUG_TYPE_UNKNOWN             0            
#DEFINE IMAGE_DEBUG_TYPE_COFF                1            
#DEFINE IMAGE_DEBUG_TYPE_CODEVIEW            2            
#DEFINE IMAGE_DEBUG_TYPE_FPO                 3            
#DEFINE IMAGE_DEBUG_TYPE_MISC                4            
#DEFINE IMAGE_DEBUG_TYPE_EXCEPTION           5            
#DEFINE IMAGE_DEBUG_TYPE_FIXUP               6            
#DEFINE IMAGE_DEBUG_TYPE_OMAP_TO_SRC         7            
#DEFINE IMAGE_DEBUG_TYPE_OMAP_FROM_SRC       8            
#DEFINE FRAME_FPO                            0            
#DEFINE FRAME_TRAP                           1            
#DEFINE FRAME_TSS                            2            
#DEFINE FRAME_NONFPO                         3            
#DEFINE SIZEOF_RFPO_DATA                     16           
#DEFINE IMAGE_DEBUG_MISC_EXENAME             1            
#DEFINE IMAGE_SEPARATE_DEBUG_SIGNATURE       18756        
#DEFINE IMAGE_SEPARATE_DEBUG_FLAGS_MASK      32768        
#DEFINE IMAGE_SEPARATE_DEBUG_MISMATCH        32768        && when DBG was updated, the old checksum didn't match.
#DEFINE HEAP_NO_SERIALIZE                    1            
#DEFINE HEAP_GROWABLE                        2            
#DEFINE HEAP_GENERATE_EXCEPTIONS             4            
#DEFINE HEAP_ZERO_MEMORY                     8            
#DEFINE HEAP_REALLOC_IN_PLACE_ONLY           16           
#DEFINE HEAP_TAIL_CHECKING_ENABLED           32           
#DEFINE HEAP_FREE_CHECKING_ENABLED           64           
#DEFINE HEAP_DISABLE_COALESCE_ON_FREE        128          
#DEFINE HEAP_CREATE_ALIGN_16                 65536        
#DEFINE HEAP_CREATE_ENABLE_TRACING           131072       
#DEFINE HEAP_MAXIMUM_TAG                     4095         
#DEFINE HEAP_PSEUDO_TAG_FLAG                 32768        
#DEFINE HEAP_TAG_SHIFT                       16           
#DEFINE IS_TEXT_UNICODE_ASCII16              1            
#DEFINE IS_TEXT_UNICODE_REVERSE_ASCII16      16           
#DEFINE IS_TEXT_UNICODE_STATISTICS           2            
#DEFINE IS_TEXT_UNICODE_REVERSE_STATISTICS   32           
#DEFINE IS_TEXT_UNICODE_CONTROLS             4            
#DEFINE IS_TEXT_UNICODE_REVERSE_CONTROLS     64           
#DEFINE IS_TEXT_UNICODE_SIGNATURE            8            
#DEFINE IS_TEXT_UNICODE_REVERSE_SIGNATURE    128          
#DEFINE IS_TEXT_UNICODE_ILLEGAL_CHARS        256          
#DEFINE IS_TEXT_UNICODE_ODD_LENGTH           512          
#DEFINE IS_TEXT_UNICODE_DBCS_LEADBYTE        1024         
#DEFINE IS_TEXT_UNICODE_NULL_BYTES           4096         
#DEFINE IS_TEXT_UNICODE_UNICODE_MASK         15           
#DEFINE IS_TEXT_UNICODE_REVERSE_MASK         240          
#DEFINE IS_TEXT_UNICODE_NOT_UNICODE_MASK     3840         
#DEFINE IS_TEXT_UNICODE_NOT_ASCII_MASK       61440        
#DEFINE COMPRESSION_FORMAT_NONE              0            
#DEFINE COMPRESSION_FORMAT_DEFAULT           1            
#DEFINE COMPRESSION_FORMAT_LZNT1             2            
#DEFINE COMPRESSION_ENGINE_STANDARD          0            
#DEFINE COMPRESSION_ENGINE_MAXIMUM           256          
#DEFINE MESSAGE_RESOURCE_UNICODE             1            
#DEFINE RTL_CRITSECT_TYPE                    0            
#DEFINE RTL_RESOURCE_TYPE                    1            
#DEFINE DLL_PROCESS_ATTACH                   1            
#DEFINE DLL_THREAD_ATTACH                    2            
#DEFINE DLL_THREAD_DETACH                    3            
#DEFINE DLL_PROCESS_DETACH                   0            
#DEFINE EVENTLOG_SEQUENTIAL_READ             1            
#DEFINE EVENTLOG_SEEK_READ                   2            
#DEFINE EVENTLOG_FORWARDS_READ               4            
#DEFINE EVENTLOG_BACKWARDS_READ              8            
#DEFINE EVENTLOG_SUCCESS                     0            
#DEFINE EVENTLOG_ERROR_TYPE                  1            
#DEFINE EVENTLOG_WARNING_TYPE                2            
#DEFINE EVENTLOG_INFORMATION_TYPE            4            
#DEFINE EVENTLOG_AUDIT_SUCCESS               8            
#DEFINE EVENTLOG_AUDIT_FAILURE               16           
#DEFINE EVENTLOG_START_PAIRED_EVENT          1            
#DEFINE EVENTLOG_END_PAIRED_EVENT            2            
#DEFINE EVENTLOG_END_ALL_PAIRED_EVENTS       4            
#DEFINE EVENTLOG_PAIRED_EVENT_ACTIVE         8            
#DEFINE EVENTLOG_PAIRED_EVENT_INACTIVE       16           
#DEFINE DBG_CONTINUE                         65538        
#DEFINE DBG_TERMINATE_THREAD                 1073807363   
#DEFINE DBG_TERMINATE_PROCESS                1073807364   
#DEFINE DBG_CONTROL_C                        1073807365   
#DEFINE DBG_CONTROL_BREAK                    1073807368   
#DEFINE DBG_EXCEPTION_NOT_HANDLED            2147549185   
#DEFINE KEY_QUERY_VALUE                      1            
#DEFINE KEY_SET_VALUE                        2            
#DEFINE KEY_CREATE_SUB_KEY                   4            
#DEFINE KEY_ENUMERATE_SUB_KEYS               8            
#DEFINE KEY_NOTIFY                           16           
#DEFINE KEY_CREATE_LINK                      32           
#DEFINE REG_OPTION_RESERVED                  0            && Parameter is reserved
#DEFINE REG_OPTION_NON_VOLATILE              0            && Key is preserved when system is rebooted
#DEFINE REG_OPTION_VOLATILE                  1            && Key is not preserved when system is rebooted
#DEFINE REG_OPTION_CREATE_LINK               2            && Created key is a symbolic link
#DEFINE REG_OPTION_BACKUP_RESTORE            4            && open for backup or restore special access rules privilege required
#DEFINE REG_OPTION_OPEN_LINK                 8            && Open symbolic link
#DEFINE REG_CREATED_NEW_KEY                  1            && New Registry Key created
#DEFINE REG_OPENED_EXISTING_KEY              2            && Existing Key opened
#DEFINE REG_WHOLE_HIVE_VOLATILE              1            && Restore whole hive volatile
#DEFINE REG_REFRESH_HIVE                     2            && Unwind changes to last flush
#DEFINE REG_NO_LAZY_FLUSH                    4            && Never lazy flush this hive
#DEFINE REG_NOTIFY_CHANGE_NAME               1            && Create or delete child)
#DEFINE REG_NOTIFY_CHANGE_ATTRIBUTES         2            
#DEFINE REG_NOTIFY_CHANGE_LAST_SET           4            && time stamp
#DEFINE REG_NOTIFY_CHANGE_SECURITY           8            
#DEFINE REG_NONE                             0            && No value type
#DEFINE REG_SZ                               1            && Unicode nul terminated string
#DEFINE REG_EXPAND_SZ                        2            && Unicode nul terminated string (with environment variable references)
#DEFINE REG_BINARY                           3            && Free form binary
#DEFINE REG_DWORD                            4            && 32-bit number
#DEFINE REG_DWORD_LITTLE_ENDIAN              4            && 32-bit number (same as REG_DWORD)
#DEFINE REG_DWORD_BIG_ENDIAN                 5            && 32-bit number
#DEFINE REG_LINK                             6            && Symbolic Link (unicode)
#DEFINE REG_MULTI_SZ                         7            && Multiple Unicode strings
#DEFINE REG_RESOURCE_LIST                    8            && Resource list in the resource map
#DEFINE REG_FULL_RESOURCE_DESCRIPTOR         9            && Resource list in the hardware description
#DEFINE REG_RESOURCE_REQUIREMENTS_LIST       10           
#DEFINE SERVICE_KERNEL_DRIVER                1            
#DEFINE SERVICE_FILE_SYSTEM_DRIVER           2            
#DEFINE SERVICE_ADAPTER                      4            
#DEFINE SERVICE_RECOGNIZER_DRIVER            8            
#DEFINE SERVICE_WIN32_OWN_PROCESS            16           
#DEFINE SERVICE_WIN32_SHARE_PROCESS          32           
#DEFINE SERVICE_INTERACTIVE_PROCESS          256          
#DEFINE SERVICE_BOOT_START                   0            
#DEFINE SERVICE_SYSTEM_START                 1            
#DEFINE SERVICE_AUTO_START                   2            
#DEFINE SERVICE_DEMAND_START                 3            
#DEFINE SERVICE_DISABLED                     4            
#DEFINE SERVICE_ERROR_IGNORE                 0            
#DEFINE SERVICE_ERROR_NORMAL                 1            
#DEFINE SERVICE_ERROR_SEVERE                 2            
#DEFINE SERVICE_ERROR_CRITICAL               3            
#DEFINE TAPE_ERASE_SHORT                     0            
#DEFINE TAPE_ERASE_LONG                      1            
#DEFINE TAPE_LOAD                            0            
#DEFINE TAPE_UNLOAD                          1            
#DEFINE TAPE_TENSION                         2            
#DEFINE TAPE_LOCK                            3            
#DEFINE TAPE_UNLOCK                          4            
#DEFINE TAPE_FORMAT                          5            
#DEFINE TAPE_SETMARKS                        0            
#DEFINE TAPE_FILEMARKS                       1            
#DEFINE TAPE_SHORT_FILEMARKS                 2            
#DEFINE TAPE_LONG_FILEMARKS                  3            
#DEFINE TAPE_ABSOLUTE_POSITION               0            
#DEFINE TAPE_LOGICAL_POSITION                1            
#DEFINE TAPE_PSEUDO_LOGICAL_POSITION         2            
#DEFINE TAPE_REWIND                          0            
#DEFINE TAPE_ABSOLUTE_BLOCK                  1            
#DEFINE TAPE_LOGICAL_BLOCK                   2            
#DEFINE TAPE_PSEUDO_LOGICAL_BLOCK            3            
#DEFINE TAPE_SPACE_END_OF_DATA               4            
#DEFINE TAPE_SPACE_RELATIVE_BLOCKS           5            
#DEFINE TAPE_SPACE_FILEMARKS                 6            
#DEFINE TAPE_SPACE_SEQUENTIAL_FMKS           7            
#DEFINE TAPE_SPACE_SETMARKS                  8            
#DEFINE TAPE_SPACE_SEQUENTIAL_SMKS           9            
#DEFINE TAPE_DRIVE_FIXED                     1            
#DEFINE TAPE_DRIVE_SELECT                    2            
#DEFINE TAPE_DRIVE_INITIATOR                 4            
#DEFINE TAPE_DRIVE_ERASE_SHORT               16           
#DEFINE TAPE_DRIVE_ERASE_LONG                32           
#DEFINE TAPE_DRIVE_ERASE_BOP_ONLY            64           
#DEFINE TAPE_DRIVE_ERASE_IMMEDIATE           128          
#DEFINE TAPE_DRIVE_TAPE_CAPACITY             256          
#DEFINE TAPE_DRIVE_TAPE_REMAINING            512          
#DEFINE TAPE_DRIVE_FIXED_BLOCK               1024         
#DEFINE TAPE_DRIVE_VARIABLE_BLOCK            2048         
#DEFINE TAPE_DRIVE_WRITE_PROTECT             4096         
#DEFINE TAPE_DRIVE_EOT_WZ_SIZE               8192         
#DEFINE TAPE_DRIVE_ECC                       65536        
#DEFINE TAPE_DRIVE_COMPRESSION               131072       
#DEFINE TAPE_DRIVE_PADDING                   262144       
#DEFINE TAPE_DRIVE_REPORT_SMKS               524288       
#DEFINE TAPE_DRIVE_GET_ABSOLUTE_BLK          1048576      
#DEFINE TAPE_DRIVE_GET_LOGICAL_BLK           2097152      
#DEFINE TAPE_DRIVE_SET_EOT_WZ_SIZE           4194304      
#DEFINE TAPE_DRIVE_EJECT_MEDIA               16777216     
#DEFINE TAPE_DRIVE_RESERVED_BIT              2147483648   && don't use this bit!
#DEFINE TAPE_DRIVE_LOAD_UNLOAD               2147483649   
#DEFINE TAPE_DRIVE_TENSION                   2147483650   
#DEFINE TAPE_DRIVE_LOCK_UNLOCK               2147483652   
#DEFINE TAPE_DRIVE_REWIND_IMMEDIATE          2147483656   
#DEFINE TAPE_DRIVE_SET_BLOCK_SIZE            2147483664   
#DEFINE TAPE_DRIVE_LOAD_UNLD_IMMED           2147483680   
#DEFINE TAPE_DRIVE_TENSION_IMMED             2147483712   
#DEFINE TAPE_DRIVE_LOCK_UNLK_IMMED           2147483776   
#DEFINE TAPE_DRIVE_SET_ECC                   2147483904   
#DEFINE TAPE_DRIVE_SET_COMPRESSION           2147484160   
#DEFINE TAPE_DRIVE_SET_PADDING               2147484672   
#DEFINE TAPE_DRIVE_SET_REPORT_SMKS           2147485696   
#DEFINE TAPE_DRIVE_ABSOLUTE_BLK              2147487744   
#DEFINE TAPE_DRIVE_ABS_BLK_IMMED             2147491840   
#DEFINE TAPE_DRIVE_LOGICAL_BLK               2147500032   
#DEFINE TAPE_DRIVE_LOG_BLK_IMMED             2147516416   
#DEFINE TAPE_DRIVE_END_OF_DATA               2147549184   
#DEFINE TAPE_DRIVE_RELATIVE_BLKS             2147614720   
#DEFINE TAPE_DRIVE_FILEMARKS                 2147745792   
#DEFINE TAPE_DRIVE_SEQUENTIAL_FMKS           2148007936   
#DEFINE TAPE_DRIVE_SETMARKS                  2148532224   
#DEFINE TAPE_DRIVE_SEQUENTIAL_SMKS           2149580800   
#DEFINE TAPE_DRIVE_REVERSE_POSITION          2151677952   
#DEFINE TAPE_DRIVE_SPACE_IMMEDIATE           2155872256   
#DEFINE TAPE_DRIVE_WRITE_SETMARKS            2164260864   
#DEFINE TAPE_DRIVE_WRITE_FILEMARKS           2181038080   
#DEFINE TAPE_DRIVE_WRITE_SHORT_FMKS          2214592512   
#DEFINE TAPE_DRIVE_WRITE_LONG_FMKS           2281701376   
#DEFINE TAPE_DRIVE_WRITE_MARK_IMMED          2415919104   
#DEFINE TAPE_DRIVE_FORMAT                    2684354560   
#DEFINE TAPE_DRIVE_FORMAT_IMMEDIATE          3221225472   
#DEFINE TAPE_DRIVE_HIGH_FEATURES             2147483648   && mask for high features flag
#DEFINE TAPE_FIXED_PARTITIONS                0            
#DEFINE TAPE_SELECT_PARTITIONS               1            
#DEFINE TAPE_INITIATOR_PARTITIONS            2            
