#INCLUDE qbfc.h

LOCAL loQBSM, loRequest

* create the session manager which will communicate with QuickBooks
loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')

* open connection with QuickBooks
loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')

* open a session with QuickBooks using the company file which is
* currently open
loQBSM.BeginSession('', qbFileOpenDoNotCare) && 2

&& C:/qbsdk/QBFC/doc/GuideHTML/Ch22.html
LOCAL lcCompany
lcCompany=loQBSM.GetCurrentCompanyFileName()
MESSAGEBOX("Database in use: + CHR(13) + CHR(13) + lcCompany)


FUNCTION ExampleInvoice

loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')
loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')
loQBSM.BeginSession('', 2)
loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
loRequestSet.Attributes.OnError = 1
loInvoiceAdd = loRequestSet.AppendInvoiceAddRq()
loInvoiceAdd.CustomerRef.FullName.SetValue("Joe Doakes")
loInvoiceAdd.RefNumber.SetValue('99009900')
loInvoiceAdd.TxnDate.SetValue(DATE())
loInvoiceAdd.BillAddress.Addr1.SetValue('123 Main Street')
loInvoiceAdd.BillAddress.Addr2.SetValue("")
loInvoiceAdd.BillAddress.Addr3.SetValue("")
loInvoiceAdd.BillAddress.City.SetValue("")
loInvoiceAdd.BillAddress.State.SetValue("CA")
loInvoiceAdd.BillAddress.PostalCode.SetValue("90040")
*loInvoiceAdd.ClassRef.ListID.SetValue("")
loInvoiceAdd.ARAccountRef.FullName.SetValue("Accounts Receivable")
loInvoiceAdd.IsToBePrinted.SetValue(1)
loInvoiceLineAdd = loInvoiceAdd.ORInvoiceLineAddList.Append.InvoiceLineAdd()
loInvoiceLineAdd.Quantity
loInvoiceLineAdd.Quantity.SetValue(5)
loInvoiceLineAdd.Amount.SetValue(100)
loInvoiceLineAdd.ServiceDate.SetValue(DATE())
loInvoiceLineAdd.Desc.SetValue('Testing')
loInvoiceLineAdd.ItemRef.FullName.SetValue("LH")
*loInvoiceLineAdd.ItemRef.FullName.SetValue("LOCAL")
loResponseSet = loQBSM.DoRequests(loRequestSet)
loResponse = loResponseSet.ResponseList.GetAt(0)
* Any status code other than `0' should be investigated further
IF (loResponse.StatusCode # 0)
	MESSAGEBOX("Status: Code = " + ALLTRIM(STR(loResponse.StatusCode)) + ;
		", Severity = " + loResponse.StatusSeverity + ;
		", Message = " + loResponse.StatusMessage)
ENDIF
ENDFUNC && ExampleInvoice

FUNCTION CheckForInvoice
LPARAMETERS tcInvoice

loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')
loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')
loQBSM.BeginSession('', 2)
loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
loRequestSet.Attributes.OnError = 1
loInvoiceQuery = loRequestSet.AppendInvoiceQueryRq()
loInvoiceQuery.ORInvoiceQuery.InvoiceFilter.ORRefNumberFilter.RefNumberFilter.RefNumber.SetValue(UPPER(tcInvoice))
loInvoiceQuery.ORInvoiceQuery.InvoiceFilter.ORRefNumberFilter.RefNumberFilter.MatchCriterion.SetValue(0) && 0 - Starts With, 1 - Contains, 2 - Ends With
loResponseSet = loQBSM.DoRequests(loRequestSet)
loInvoiceResp = loResponseSet.ResponseList.GetAt(0)
IF loInvoiceResp.StatusCode = 0
	*!*	?loInvoiceResp.Detail
	*!*	?loInvoiceResp.StatusCode
	*!*	?loInvoiceResp.StatusMessage
	*!*	?loInvoiceResp.Type.GetAsString()
	*!*	lcXML=loResponseSet.ToXMLString()
	*!*	MESSAGEBOX(lcxml)
	*!*	?loInvoiceResp.Detail.Count
	loInvoice = loInvoiceResp.Detail.GetAt(0)
	?
	?loInvoice.RefNumber.GetValue()
	?
	RETURN loInvoiceResp.Detail.Count > 0 AND ALLTRIM(UPPER(tcInvoice))== ALLTRIM(loInvoice.RefNumber.GetValue())
ELSE
	RETURN .F.
ENDIF
ENDFUNC && CheckForInvoice
