* qbfcexample.prg
*
* This program demonstrates the use of version 1.1 of the QBFC for
* communicating with QuickBooks from within Visual FoxPro.
*
* The program opens a connection with QuickBooks and makes a three
* part query, asking for lists of
*            1. Customers which are currently Active
*            2. All Employees
*            3. All Vendors
* Certain pieces of information obtained from these lists (contact info,
* phone number, hired date, etc) are then displayed to the user in three
* cursors.
*
* You must have QuickBooks 2002 Pro/Premier and the QBFC version 1.1
* installed on your system before running this program.  This file was
* created with Visual FoxPro 6, but should also work in VFP7.
*
* This is a sample program only.  It does not contain the error handling
* techniques you will need if you write a VFP QBFC application for
* development.  It may crash if QuickBooks is not running with a file open.
* More information about error handling and recovery can be found in the 
* SDK documentation.
*
* Copyright  2002 Intuit Inc. All rights reserved.
* Use is subject to the terms specified at:
*      http://developer.intuit.com/legal/devsite_tos.html
*
* Based on sample code provided by 
* Jennifer Wortman and
* Bill Dimes (bdimes@dimesoftinc.com, www.dimesoftinc.com) on
* the QB SDK developer newsgroup (intuit.quickbooks.dev.sdk)

#DEFINE	qbFileOpenSingleUser	0
#DEFINE	qbFileOpenMultiUser		1
#DEFINE	qbFileOpenDoNotCare 	2

#DEFINE qbStopOnError			0
#DEFINE	qbContinueOnError		1


LOCAL loQBSM, loRequestSet, loCustQuery, loEmpQuery, loVendQuery
LOCAL loResponseSet, lcCompanyFile, loEmpResp, loVendResp
LOCAL loCustResp, loCust, lni, lcFullName, lnSubLevel, lcCustType
LOCAL lcContact, lcPhone, lcFirstName, lcLastName, lcHiredDate, lcName


* clear screen
CLEAR

* create output cursors
CREATE CURSOR Customers (ListID C(20), FullName C(50), Contact C(30), Phone C(20))
CREATE CURSOR Employees (FirstName C(20), LastName C(20), HiredDate C(10), Phone C(20))
CREATE CURSOR Vendors   (VendorName C(30), Contact C(30), Phone C(20))


* create the session manager which will communicate with QuickBooks
loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')

* open connection with QuickBooks
loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')

* open a session with QuickBooks using the company file which is
* currently open
loQBSM.BeginSession('C:\GWPVFP\VT\Villa Transport-New.QBW', 2)

* get a message set request object (version 1.1 xml)
loRequestSet = loQBSM.CreateMsgSetRequest(1,1)

* set the on error attribute for the request
loRequestSet.Attributes.OnError = qbContinueOnError

* add a customer query request to request message set
loCustQuery = loRequestSet.AppendCustomerQueryRq()

* add a filter to the customer request to only pick up active customers
loCustQuery.ORCustomerListQuery.CustomerListFilter.ActiveStatus.SetAsString('ActiveOnly')

* add an employee query to the request message set
loEmpQuery = loRequestSet.AppendEmployeeQueryRq()

* add a vendor query to the request message set
loVendQuery = loRequestSet.AppendVendorQueryRq()


* process the request object returning a response message object
loResponseSet = loQBSM.DoRequests(loRequestSet)

* end the session - we have our response message object
loQBSM.EndSession()

* close the connection
loQBSM.CloseConnection()


* get reference to all responses in response message object,
* these will each be collections of customer/employee/vendor ret objects
loCustResp = loResponseSet.ResponseList.GetAt(0)
loEmpResp = loResponseSet.ResponseList.GetAt(1)
loVendResp = loResponseSet.ResponseList.GetAt(2)


* display status code and message on screen
? "Customer Query Response Status: "	
? loCustResp.StatusCode
? loCustResp.StatusMessage
?
? "Employee Query Response Status: "
? loEmpResp.StatusCode
? loEmpResp.StatusMessage
?
? "Vendor Query Response Status: "
? loVendResp.StatusCode
? loVendResp.StatusMessage


* loop through the collection of customer ret objects
* 0 based array
FOR lni = 0 TO loCustResp.Detail.Count - 1
	
	* get reference to single customer
	loCust = loCustResp.Detail.GetAt(lni)
	
	lcListID = loCust.ListID.GetValue()
	
	* get the value of the fullname tag
	lcFullName = loCust.FullName.GetValue()
	
	* get the contact information if it exists .. if not avoid errors
	IF VARTYPE(loCust.Contact) = "O"
		lcContact = loCust.Contact.GetValue()
	ELSE
		lcContact = "[not set]"
	ENDIF

	* get the phone number if it exists .. if not avoid errors
	IF VARTYPE(loCust.Phone) = "O"
		lcPhone = loCust.Phone.GetValue()
	ELSE
		lcPhone = "[not set]"
	ENDIF

	* get the value of the Sublevel tag
	lnSubLevel = loCust.SubLevel.GetValue()
	
	* note the projects (sublevel is 1)
	IF lnSubLevel = 1
		lcFullName = '    Project: ' + lcFullName
	ENDIF
	
	* insert into cursor
	INSERT INTO Customers VALUES (lcListID, lcFullName, lcContact, lcPhone)

ENDFOR


* loop through the collection of employee ret objects
FOR lni = 0 TO loEmpResp.Detail.Count - 1
	
	* get reference to single employee
	loEmp = loEmpResp.Detail.GetAt(lni)
	
	* get the first name if it exists .. if not avoid errors
	IF VARTYPE(loEmp.FirstName) = "O"
		lcFirstName = loEmp.FirstName.GetValue()
	ELSE
		lcFirstName = "[not set]"
	ENDIF

	* get the last name if it exists .. if not avoid errors
	IF VARTYPE(loEmp.LastName) = "O"
		lcLastName = loEmp.LastName.GetValue()
	ELSE
		lcLastName = "[not set]"
	ENDIF
	
	* get the hired date if it exists .. if not avoid errors
	IF VARTYPE(loEmp.HiredDate) = "O"
		* convert date to string so it can be added to cursor
		lcHiredDate = DTOC(loEmp.HiredDate.GetValue())
	ELSE
		lcHiredDate = "[not set]"
	ENDIF

	* get the phone number if it exists .. if not avoid errors
	IF VARTYPE(loEmp.Phone) = "O"
		lcPhone = loEmp.Phone.GetValue()
	ELSE
		lcPhone = "[not set]"
	ENDIF
	
	* insert into cursor
	INSERT INTO Employees VALUES (lcFirstName, lcLastName, lcHiredDate, lcPhone)

ENDFOR



* loop through the collection of vendor ret objects
FOR lni = 0 TO loVendResp.Detail.Count - 1
	
	* get reference to single vendor
	loVend = loVendResp.Detail.GetAt(lni)
	
	* get the name if it exists .. if not avoid errors
	IF VARTYPE(loVend.Name) = "O"
		lcName = loVend.Name.GetValue()
	ELSE
		lcName = "[not set]"
	ENDIF

	* get the contact info if it exists .. if not avoid errors
	IF VARTYPE(loVend.Contact) = "O"
		lcContact = loVend.Contact.GetValue()
	ELSE
		lcContact = "[not set]"
	ENDIF

	* get the phone number if it exists .. if not avoid errors
	IF VARTYPE(loVend.Phone) = "O"
		lcPhone = loVend.Phone.GetValue()
	ELSE
		lcPhone = "[not set]"
	ENDIF
	
	* insert into cursor
	INSERT INTO Vendors VALUES (lcName, lcContact, lcPhone)

ENDFOR
	
* browse the three cursors
SELECT Customers
GO TOP
BROWSE

SELECT Employees
GO TOP
BROWSE

SELECT Vendors
GO TOP
BROWSE
		



