* COPYRIGHT 2002 MHV ENTERPRISES, INC. COMMERCE, CALIFORNIA
* THIS IS PROPRIETY CODE TAKEN FROM A LARGE APPLICATION.
* YOU DO NOT HAVE THE SUPPORT TABLES TO RUN THIS PROGRAM.
* HOWEVER, YOU CAN LEARN FROM THE CODE AND SEE COMMENTED 
* CODE THAT WAS USED FOR THE OLD .IIF FORMAT VIA EXCEL.
* DIRECT QUESTIONS TO frank@atinnovations.com.

#INCLUDE QBFC.H

FUNCTION QBTruckerInvoiceExport
	LPARAMETER tnBatch, tnEndLot
	LOCAL lcMsgCaption, lcCompany
	LOCAL lcDestDir, lnMainTrkPK
	LOCAL lcInvoicePrefix, lcInvoiceAcct, lcItemAcct
	*!*	LOCAL lcLocalAcct, lcItemSubHaulerAcct
	LOCAL lcCustomer, lcAddr1, lcAddr2, lcAddr3
	LOCAL lcCity, lcState, lcPostalCode, lcTerms
	LOCAL lcShipTo, lcShipToVia, lcSaleRedel
	LOCAL lcXLSFile, lcIIFFile, loExcel
	LOCAL lnCount, lnRow
	LOCAL lnPODSum, lnPODLHSum, lnSODSum
	LOCAL lcMainInvItem, lcLocalHaulInvItem, lcInvItem
	LOCAL lcAmount, lcDesc, lcFullName
	LOCAL ARRAY laPOH[1], laPOD[1]

	lcMsgCaption = "Trucker Invoice Export"

	* Open the Tables
	IF !USED("pbparam")
		USE pbparam IN 0 SHARED
	ENDIF
	IF !USED("vendor")
		USE vendor IN 0 SHARED
	ENDIF
	IF !USED("poheader")
		USE poheader IN 0 SHARED
	ENDIF
	IF !USED("podetail")
		USE podetail IN 0 SHARED
	ENDIF
	IF !USED("soheader")
		USE soheader IN 0 SHARED
	ENDIF
	IF !USED("sodetail")
		USE sodetail IN 0 SHARED
	ENDIF
	IF !USED("vendor")
		USE vendor IN 0 SHARED
	ENDIF
	IF !USED("pbzone")
		USE pbzone IN 0 SHARED
	ENDIF

	SET PROC TO RPTCOMP ADDI

	* Export Parameters - Each item must exactly match the field value in Quickbooks!
	SET PROC TO ICUTIL ADDI
	lcTrkInvExINI = SYS(5) + CURDIR() + "TRKINVEX.INI"
	lcINITag = "Trucker Invoice Export"

	*!*	* Destination Directory
	*!*	lcDestDir = ADDBS(ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "DESTINATION DIRECTORY", ""))
	*!*	IF ISBLANK(lcDestDir)
	*!*		lcDestDir = SYS(5) + CURDIR()
	*!*	ENDIF

	* Database Location
	lcCompany = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "COMPANY LOCATION", "")
	lcCompany = ALLTRIM(lcCompany)
	IF !ISBLANK(lcCompany) AND !FILE(lcCompany)
		MESSAGEBOX("QuickBooks Database could not be located." + CHR(13) + CHR(13) + ;
			"FILE: " + lcCompany, 16, lcMsgCaption)
		RETURN .F.
	ENDIF

	* Trucker Primary Key for Villa Transport
	lnMainTrkPK = pbparam.prm_prim_trk_fk
	IF SEEK(lnMainTrkPK,"vendor","ven_pk")
		lcMainInvItem = ALLT(IIF(ISBLANK(vendor.ven_export_code),vendor.ven_id,vendor.ven_export_code))
	ELSE
		lcMainInvItem = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "MAIN HAUL ITEM", "")
	ENDIF

	* Invoice # Prefix
	lcInvoicePrefix = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "INVOICE PREFIX", "")
	* Local Haul Invoice Item
	lcLocalHaulInvItem = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "LOCAL HAUL ITEM", "")
	* Invoice A/R Account Code
	lcInvoiceAcct = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "ACCOUNTS RECEIVABLE", "")
	* Line Item Income Account Code for Main Hauler
	lcItemAcct = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "MAIN DELIVERIES ITEM", "") &&"MAIN DELIVERIES ACCOUNT", "")
	*!*	* Line Item Income Account Code for Main Hauler
	*!*	lcLocalAcct = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "LOCAL DELIVERIES ACCOUNT", "")
	*!*	* Line Item Income Account Code for Main Hauler
	*!*	lcItemSubHaulerAcct = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "SUBHAULER INCOME ACCOUNT", "")
	* Customer Name, Address 1,2
	lcCustomer = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "CUSTOMER NAME", "")
	lcAddr1 = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "ADDRESS 1", "")
	lcAddr2 = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "ADDRESS 2", "")
	lcAddr3 = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "ADDRESS 3", "")
	lcCity = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "CITY", "")
	lcState = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "STATE", "")
	lcPostalCode = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "POSTAL CODE", "")
	* Terms Code
	lcTerms = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "TERMS", "")
	* Ship To - "TO LOS ANGELES"
	lcShipTo = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "SHIP TO", "")
	* Ship To Via
	lcShipToVia = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "SHIP VIA", "")
	* Sales Redelivery Message
	lcSaleRedel = ICUtilGetINISetting(lcTrkInvExINI, lcINITag, "REDELIVERY MESSAGE", "")

	* poh_date, poh_deliver_on, poh_supplier_so, poh_trk_fk, poh_trkltl, poh_sub_trk_fk, poh_rdl_trk_fk
	IF tnBatch > 0
		lnNewBatch = tnBatch
		SELECT poh_pk, poh_lot ;
			FROM poheader ;
			WHERE poh_ar_batch = tnBatch ;
			ORDER BY poh_lot ;
			INTO ARRAY laPOH
		IF _TALLY = 0
			MESSAGEBOX("There is no batch # " + ALLT(STR(tnBatch)) + "." + CHR(13) + CHR(13) + ;
				"Please select a valid batch #.", 16, lcMsgCaption)
			RETURN .F.
		ENDIF
	ELSE
		SELECT MAX(poh_ar_batch) ;
			FROM poheader ;
			WHERE poh_ar_batch > 0 ;
			INTO ARRAY laPOH
		lnNewBatch = IIF(VARTYPE(laPOH[1]) = "N" AND laPOH[1] > 0, laPOH[1] + 1, 1)

		SELECT poh_pk, poh_lot ;
			FROM poheader ;
			WHERE poh_lot <= tnEndLot AND poh_ar_batch = 0 AND !EMPTY(poh_closed) AND ;
			(poh_trk_fk = lnMainTrkPK OR poh_rdl_trk_fk = lnMainTrkPK) AND poh_fob_soh_fk = 0 AND ;
			EXISTS (SELECT pod_poh_fk ;
			FROM podetail ;
			WHERE podetail.pod_poh_fk = poheader.poh_pk AND ;
			podetail.pod_qty > 0 AND ;
			(podetail.pod_frt_pi > 0 OR podetail.pod_frt_ltl > 0 OR podetail.pod_frt_lh > 0)) ;
			ORDER BY poh_lot ;
			INTO ARRAY laPOH
		IF _TALLY = 0
			MESSAGEBOX("There are no unprocessed closed lots in the selected range.", 16, lcMsgCaption)
			RETURN .F.
		ENDIF
	ENDIF

	WAIT WINDOW "Transferring Invoices to QuickBooks, one moment please..." NOWAIT

	loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')
	loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')
	loQBSM.BeginSession(lcCompany, 2)

	* Check the main trucker name...lcMainInvItem
	* TO DO
	* loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
	* loRequestSet.Attributes.OnError = 1

	lnAddCount = 0
	* Create the content of the export file.
	FOR lnCount = 1 TO ALEN(laPOH,1)
		llSkip = .F.
		IF tnBatch > 0
			* Check for duplicates.
		ENDIF
		IF !llSkip
			loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
			loRequestSet.ATTRIBUTES.OnError = 1
			IF SEEK(laPOH[lnCount,1], "poheader", "poh_pk")
				* Compile the freight rates!
				SELECT podetail.*, pbprod.prd_desc, pblabel.lbl_name ;
					FROM podetail ;
					INNER JOIN pbprod ON podetail.pod_prd_fk = pbprod.prd_pk ;
					INNER JOIN pblabel ON podetail.pod_lbl_fk = pblabel.lbl_pk ;
					WHERE pod_poh_fk = laPOH[lnCount,1] AND pod_qty > 0 ;
					ORDER BY pod_seq, pod_pk ;
					INTO CURSOR crsrPODFreight

				IF poheader.poh_trk_fk = lnMainTrkPK
					CALCULATE SUM(pod_qty * (pod_frt_pi + pod_frt_ltl)) TO lnPODSum
				ELSE
					lnPODSum = 0
				ENDIF

				IF poheader.poh_rdl_trk_fk = lnMainTrkPK &&AND pod_frt_lh > 0
					CALCULATE SUM(pod_qty * pod_frt_lh) TO lnPODLHSum
				ELSE
					lnPODLHSum = 0
				ENDIF

				SELECT sodetail.*, soheader.soh_invoice, soheader.soh_deliver_on, ;
					podetail.pod_pdp_name, podetail.pod_pdg_name, podetail.pod_pds_name, ;
					pbprod.prd_desc, pblabel.lbl_name ;
					FROM sodetail ;
					INNER JOIN podetail ON sodetail.sod_pod_fk = podetail.pod_pk ;
					INNER JOIN soheader ON sodetail.sod_soh_fk = soheader.soh_pk ;
					INNER JOIN pbprod ON podetail.pod_prd_fk = pbprod.prd_pk ;
					INNER JOIN pblabel ON podetail.pod_lbl_fk = pblabel.lbl_pk ;
					WHERE pod_poh_fk = laPOH[lnCount,1] AND soheader.soh_trk_fk = lnMainTrkPK  AND sodetail.sod_frt_lh > 0 ;
					ORDER BY sod_seq, sod_pk ;
					INTO CURSOR crsrSODFreight

				lnSODSum = 0
				CALCULATE SUM(sod_qty * sod_frt_lh) TO lnSODSum

				* Create the Request Set.
				loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
				loRequestSet.ATTRIBUTES.OnError = 1

				* Create the Invoice Header.
				loInvoiceAdd = loRequestSet.AppendInvoiceAddRq()
				loInvoiceAdd.CustomerRef.FullName.SetValue(lcCustomer)
				loInvoiceAdd.RefNumber.SetValue(lcInvoicePrefix+ALLTRIM(STR(poheader.poh_lot)))
				loInvoiceAdd.TxnDate.SetValue(poheader.poh_date)
				loInvoiceAdd.BillAddress.Addr1.SetValue(lcAddr1)
				loInvoiceAdd.BillAddress.Addr2.SetValue(lcAddr2)
				loInvoiceAdd.BillAddress.Addr3.SetValue(lcAddr3)
				loInvoiceAdd.BillAddress.City.SetValue(lcCity)
				loInvoiceAdd.BillAddress.State.SetValue(lcState)
				loInvoiceAdd.BillAddress.PostalCode.SetValue(lcPostalCode)
				*loInvoiceAdd.ClassRef.ListID.SetValue("")
				loInvoiceAdd.ARAccountRef.FullName.SetValue(lcInvoiceAcct)
				loInvoiceAdd.IsToBePrinted.SetValue(1)
				loInvoiceAdd.TermsRef.FullName.SetValue(lcTerms)
				loInvoiceAdd.PONumber.SetValue(ALLT(poheader.poh_supplier_so))
				loInvoiceAdd.ShipDate.SetValue(poheader.poh_deliver_on)
				IF SEEK(poheader.poh_ven_fk, "vendor", "ven_pk")
					loInvoiceAdd.ShipAddress.Addr1.SetValue(UPPER(ALLT(vendor.ven_name)))
				ENDIF
				IF SEEK(poheader.poh_col_fk, "vendor", "ven_pk") AND ;
						vendor.ven_zon_fk > 0 AND ;
						SEEK(vendor.ven_zon_fk, "pbzone", "zon_pk")
					lcDesc = UPPER(ALLT(pbzone.zon_name)) + lcShipTo
					loInvoiceAdd.ShipAddress.Addr2.SetValue(lcDesc)
				ENDIF
				IF poheader.poh_sub_trk_fk > 0 AND SEEK(poheader.poh_sub_trk_fk,"vendor","ven_pk")
					lcDesc = ALLT(lcShipToVia + " - " + UPPER(ALLT(vendor.ven_name)))
					loInvoiceAdd.ShipAddress.Addr3.SetValue(lcDesc)
				ENDIF

				*	!TRNS	TRNSID	TRANSTYPE	DATE	ACCNT
				*	NAME	CLASS	AMOUNT		DOCNUM	MEMO
				*	CLEAR	TOPRINT	NAMEISTAXABLE	ADDR1	ADDR2
				*	ADDR3	TERMS	PONUM		SHIPDATE	SADDR1
				*	SADDR2	SADDR3
				*lnRow = lnRow + 1
				*loExcel.CellSetValue(lnRow,1,"TRNS")
				*loExcel.CellSetValue(lnRow,2,"")
				*loExcel.CellSetValue(lnRow,3,"INVOICE")
				*loExcel.CellSetValue(lnRow,4,poheader.poh_date)
				*loExcel.CellSetValue(lnRow,5,lcInvoiceAcct)
				*loExcel.CellSetValue(lnRow,6,lcCustomer)
				*loExcel.CellSetValue(lnRow,7,"")
				*?*loExcel.CellSetValue(lnRow,8,lnPODSum + lnPODLHSum + lnSODSum)
				*loExcel.CellSetValue(lnRow,9,poheader.poh_lot)
				*loExcel.CellSetValue(lnRow,10,"")
				*loExcel.CellSetValue(lnRow,11,"N")
				*loExcel.CellSetValue(lnRow,12,"Y")
				*loExcel.CellSetValue(lnRow,13,"N")
				*loExcel.CellSetValue(lnRow,14,lcAddr1)
				*loExcel.CellSetValue(lnRow,15,lcAddr2)
				*loExcel.CellSetValue(lnRow,16,lcAddr3)
				*loExcel.CellSetValue(lnRow,17,lcTerms)
				*loExcel.CellSetValue(lnRow,18,ALLT(poheader.poh_supplier_so))
				*loExcel.CellSetValue(lnRow,19,poheader.poh_deliver_on)
				*IF SEEK(poheader.poh_ven_fk, "vendor", "ven_pk")
				*	loExcel.CellSetValue(lnRow,20,UPPER(ALLT(vendor.ven_name)))
				*ENDIF
				*IF SEEK(poheader.poh_col_fk, "vendor", "ven_pk") AND ;
				*		vendor.ven_zon_fk > 0 AND ;
				*		SEEK(vendor.ven_zon_fk, "pbzone", "zon_pk")
				*	loExcel.CellSetValue(lnRow,21,UPPER(ALLT(pbzone.zon_name)) + lcShipTo)
				*ENDIF
				*IF poheader.poh_sub_trk_fk > 0 AND ;
				*		SEEK(poheader.poh_sub_trk_fk,"vendor","ven_pk")
				*	loExcel.CellSetValue(lnRow,22, ALLT(lcShipToVia + " - " + UPPER(ALLT(vendor.ven_name))))
				*ENDIF

				IF RECCOUNT("crsrPODFreight" ) > 0
					SELECT crsrPODFreight
					SCAN
						* Inbound Per Item or LTL Freight
						*	!SPL	SPLID	TRANSTYPE	DATE	ACCNT
						*	NAME	CLASS	AMOUNT		DOCNUM	MEMO
						*	CLEAR	QNTY	PRICE		INVITEM	TAXABLE
						IF poheader.poh_trk_fk = lnMainTrkPK AND (pod_frt_pi + pod_frt_ltl) > 0
							* Create the SPL row.
							loInvoiceLineAdd = loInvoiceAdd.ORInvoiceLineAddList.APPEND.InvoiceLineAdd()
							loInvoiceLineAdd.Quantity.SetValue(pod_qty)
							lcAmount = ALLTRIM(STR(pod_qty*(pod_frt_pi+pod_frt_ltl),11,2))
							loInvoiceLineAdd.Amount.SetValue(lcAmount)
							lcDesc = BuildProductDescription(prd_desc, pod_pdp_name, pod_pdg_name, pod_pds_name, lbl_name, " - ")
							loInvoiceLineAdd.Desc.SetValue(lcDesc)
							*lcFullName = IIF(poheader.poh_sub_trk_fk = 0, lcItemAcct, IIF(ISBLANK(vendor.ven_export_acct),lcItemSubHaulerAcct,vendor.ven_export_acct))
							lcFullName = ALLTRIM(IIF(poheader.poh_sub_trk_fk = 0, lcItemAcct, IIF(ISBLANK(vendor.ven_export_acct),vendor.ven_id,vendor.ven_export_acct)))
							loInvoiceLineAdd.ItemRef.FullName.SetValue(lcFullName)
							loInvoiceLineAdd.ServiceDate.SetValue(poheader.poh_deliver_on)
							*lnRow = lnRow + 1
							*loExcel.CellSetValue(lnRow,1,"SPL")
							*loExcel.CellSetValue(lnRow,2,"")
							*loExcel.CellSetValue(lnRow,3,"INVOICE")
							*loExcel.CellSetValue(lnRow,4,poheader.poh_deliver_on)
							*loExcel.CellSetValue(lnRow,5, ;
							*	IIF(poheader.poh_sub_trk_fk = 0, lcItemAcct, IIF(ISBLANK(vendor.ven_export_acct),lcItemSubHaulerAcct,vendor.ven_export_acct)))
							*loExcel.CellSetValue(lnRow,6,"")
							*loExcel.CellSetValue(lnRow,7,"")
							*loExcel.CellSetValue(lnRow,8,-(pod_qty*(pod_frt_pi+pod_frt_ltl)))
							*loExcel.CellSetValue(lnRow,9,poheader.poh_lot)
							*loExcel.CellSetValue(lnRow,10, BuildProductDescription(prd_desc, pod_pdp_name, pod_pdg_name, pod_pds_name, lbl_name, " - "))
							*ALLT(prd_desc) + IIF(!ISBLANK(lbl_name), " - " + ALLT(lbl_name),""))
							*loExcel.CellSetValue(lnRow,11,"N")
							*loExcel.CellSetValue(lnRow,12,-pod_qty)
							*loExcel.CellSetValue(lnRow,13,pod_frt_pi+pod_frt_ltl)
							*IF poheader.poh_sub_trk_fk > 0
							*	lcInvItem = ALLT(IIF(ISBLANK(vendor.ven_export_code),vendor.ven_id,vendor.ven_export_code))
							*ELSE
							*	lcInvItem = lcMainInvItem
							*ENDIF
							*loExcel.CellSetValue(lnRow,14,lcInvItem)
							*?*loExcel.CellSetValue(lnRow,15,"N")
							*loExcel.CellSetValue(lnRow,16,"")
							*loExcel.CellSetValue(lnRow,17,0)
							*loExcel.CellSetValue(lnRow,18,0)
						ENDIF && poheader.poh_trk_fk = lnMainTrkPK AND (pod_fret_pi + pod_frt_ltl) > 0

						* Local Delivery
						IF poheader.poh_rdl_trk_fk = lnMainTrkPK AND pod_frt_lh > 0
							* Create the SPL row.
							loInvoiceLineAdd = loInvoiceAdd.ORInvoiceLineAddList.APPEND.InvoiceLineAdd()
							loInvoiceLineAdd.Quantity.SetValue(pod_qty)
							lcAmount = ALLTRIM(STR(pod_qty*pod_frt_lh,11,2))
							loInvoiceLineAdd.Amount.SetValue(lcAmount)
							lcDesc = BuildProductDescription(prd_desc, pod_pdp_name, pod_pdg_name, pod_pds_name, lbl_name, " - ")
							loInvoiceLineAdd.DESC.SetValue(lcDesc)
							loInvoiceLineAdd.ItemRef.FullName.SetValue(lcLocalHaulInvItem)
							loInvoiceLineAdd.ServiceDate.SetValue(poheader.poh_deliver_on)
							*lnRow = lnRow + 1
							*loExcel.CellSetValue(lnRow,1,"SPL")
							*loExcel.CellSetValue(lnRow,2,"")
							*loExcel.CellSetValue(lnRow,3,"INVOICE")
							*loExcel.CellSetValue(lnRow,4,poheader.poh_deliver_on)
							*loExcel.CellSetValue(lnRow,5, lcLocalAcct)
							*loExcel.CellSetValue(lnRow,6,"")
							*loExcel.CellSetValue(lnRow,7,"")
							*loExcel.CellSetValue(lnRow,8,-(pod_qty*pod_frt_lh))
							*loExcel.CellSetValue(lnRow,9,poheader.poh_lot)
							*loExcel.CellSetValue(lnRow,10, BuildProductDescription(prd_desc, pod_pdp_name, pod_pdg_name, pod_pds_name, lbl_name, " - "))
							*loExcel.CellSetValue(lnRow,11,"N")
							*loExcel.CellSetValue(lnRow,12,-pod_qty)
							*loExcel.CellSetValue(lnRow,13,pod_frt_lh)
							*loExcel.CellSetValue(lnRow,14,lcLocalHaulInvItem)
							*loExcel.CellSetValue(lnRow,15,"N")
							*loExcel.CellSetValue(lnRow,16,"")
							*loExcel.CellSetValue(lnRow,17,0)
							*loExcel.CellSetValue(lnRow,18,0)
						ENDIF && poheader.poh_rdl_trk_fk = lnMainTrkPK AND pod_frt_lh > 0
					ENDSCAN && crsrPODFreight
				ENDIF
				IF RECCOUNT("crsrSODFreight" ) > 0
					SELECT crsrSODFreight
					SCAN
						* Sales Redelivery Freight
						loInvoiceLineAdd = loInvoiceAdd.ORInvoiceLineAddList.APPEND.InvoiceLineAdd()
						loInvoiceLineAdd.Quantity.SetValue(sod_qty)
						lcAmount = ALLTRIM(STR(sod_qty*sod_frt_lh,11,2))
						loInvoiceLineAdd.Amount.SetValue(lcAmount)
						lcDesc = lcSaleRedel + " " + ALLT(STR(soh_invoice)) + ".  " + BuildProductDescription(prd_desc, pod_pdp_name, pod_pdg_name, pod_pds_name, lbl_name, " - ")
						loInvoiceLineAdd.Desc.SetValue(lcDesc)
						loInvoiceLineAdd.ItemRef.FULLNAME.SetValue(lcLocalHaulInvItem)
						loInvoiceLineAdd.ServiceDate.SetValue(poheader.soh_deliver_on)
						* Create the SPL row.
						*lnRow = lnRow + 1
						*loExcel.CellSetValue(lnRow,1,"SPL")
						*loExcel.CellSetValue(lnRow,2,"")
						*loExcel.CellSetValue(lnRow,3,"INVOICE")
						*loExcel.CellSetValue(lnRow,4,soh_deliver_on)
						*loExcel.CellSetValue(lnRow,5, lcLocalAcct)
						*loExcel.CellSetValue(lnRow,6,"")
						*loExcel.CellSetValue(lnRow,7,"")
						*loExcel.CellSetValue(lnRow,8,-(sod_qty*sod_frt_lh))
						*loExcel.CellSetValue(lnRow,9,poheader.poh_lot)
						*loExcel.CellSetValue(lnRow,10, lcSaleRedel + " " + ALLT(STR(soh_invoice)) + ".  " + BuildProductDescription(prd_desc, pod_pdp_name, pod_pdg_name, pod_pds_name, lbl_name, " - "))
						*loExcel.CellSetValue(lnRow,11,"N")
						*loExcel.CellSetValue(lnRow,12,-sod_qty)
						*loExcel.CellSetValue(lnRow,13,sod_frt_lh)
						*loExcel.CellSetValue(lnRow,14,lcLocalHaulInvItem)
						*loExcel.CellSetValue(lnRow,15,"N")
						*loExcel.CellSetValue(lnRow,16,"")
						*loExcel.CellSetValue(lnRow,17,0)
						*loExcel.CellSetValue(lnRow,18,0)
					ENDSCAN && crsrSODFreight
				ENDIF
				*lnRow = lnRow + 1
				*loExcel.CellSetValue(lnRow,1,"ENDTRNS")
				loResponseSet = loQBSM.DoRequests(loRequestSet)
				loResponse = loResponseSet.ResponseList.GetAt(0)
				* Any status code other than `0' should be investigated further
				IF (loResponse.StatusCode # 0)
					MESSAGEBOX("Lot: = " + ALLTRIM(STR(poheader.poh_lot)) + CHR(13) + ;
						"Status: Code = " + ALLTRIM(STR(loResponse.StatusCode)) + CHR(13) + ;
						"        Severity = " + loResponse.StatusSeverity + CHR(13) + ;
						"        Message = " + loResponse.StatusMessage, 64,"QuickBooks Interface",10000)
				ELSE
					lnAddCount = lnAddCount + 1
					* Update the POHEADER
					IF tnBatch = 0
						SELECT poheader
						REPLACE poh_ar_batch WITH lnNewBatch
					ENDIF
				ENDIF
			ENDIF
			loRequestSet = NULL
			loInvoiceAdd = NULL
			loInvoiceLineAdd = NULL
			loResponseSet = NULL
			loResponse = NULL
		ENDIF && !llSkip
	ENDFOR

	* End the QuickBooks session
	loQBSM.EndSession()

	* Close the QuickBooks connection
	loQBSM.CloseConnection()

	MESSAGEBOX('Trucker Invoice Export Complete.' + CHR(13) + CHR(13) + ;
		ALLTRIM(STR(lnAddCount)) + ' invoices were created.' + CHR(13) + CHR(13) + ;
		'Go to QuickBooks to print "Unprinted" invoices.', ;
		64, lcMsgCaption)
	RETURN .T.
ENDFUNC && QBTruckerInvoiceExport

FUNCTION QBCheckForInvoice
	LPARAMETERS toQBSM, tcInvoice
	LOCAL loQBSM, loRequestSet, loInvoiceQuery, loResponseSet, loInvoiceResp, loInvoice
	IF VARTYPE(toQBSM) = 'O' AND !ISNULL(toQBSM)
		loQBSM = toQBSM
	ELSE
		loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')
		loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')
		loQBSM.BeginSession('', 2)
	ENDIF
	loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
	loRequestSet.ATTRIBUTES.OnError = 1
	loInvoiceQuery = loRequestSet.AppendInvoiceQueryRq()
	loInvoiceQuery.ORInvoiceQuery.InvoiceFilter.ORRefNumberFilter.RefNumberFilter.RefNumber.SetValue(UPPER(tcInvoice))
	loInvoiceQuery.ORInvoiceQuery.InvoiceFilter.ORRefNumberFilter.RefNumberFilter.MatchCriterion.SetValue(0) && 0 - Starts With, 1 - Contains, 2 - Ends With
	loResponseSet = loQBSM.DoRequests(loRequestSet)
	loInvoiceResp = loResponseSet.ResponseList.GetAt(0)
	loInvoice = loInvoiceResp.Detail.GetAt(0)
	RETURN loInvoiceResp.Detail.COUNT > 0 AND ALLTRIM(UPPER(tcInvoice))== ALLTRIM(loInvoice.RefNumber.GetValue())

ENDFUNC && QBCheckForInvoice
