#Define WM_USER                   0x0400
#Define WM_USER_SHNOTIFY          WM_USER+10
#Define SHCNE_RENAMEITEM          0x00000001
#Define SHCNE_CREATE              0x00000002
#Define SHCNE_DELETE              0x00000004
#Define SHCNE_MKDIR               0x00000008
#Define SHCNE_RMDIR               0x00000010
#Define SHCNE_MEDIAINSERTED       0x00000020
#Define SHCNE_MEDIAREMOVED        0x00000040
#Define SHCNE_DRIVEREMOVED        0x00000080
#Define SHCNE_DRIVEADD            0x00000100
#Define SHCNE_NETSHARE            0x00000200
#Define SHCNE_NETUNSHARE          0x00000400
#Define SHCNE_ATTRIBUTES          0x00000800
#Define SHCNE_UPDATEDIR           0x00001000
#Define SHCNE_UPDATEITEM          0x00002000
#Define SHCNE_SERVERDISCONNECT    0x00004000
#Define SHCNE_UPDATEIMAGE         0x00008000
#Define SHCNE_DRIVEADDGUI         0x00010000
#Define SHCNE_RENAMEFOLDER        0x00020000
#Define SHCNE_FREESPACE           0x00040000

#Define SHCNE_DISKEVENTS          0x0002381F
#Define SHCNE_GLOBALEVENTS        0x0C0581E0 // Events that dont match pidls First
#Define SHCNE_ALLEVENTS           0x7FFFFFFF
#Define SHCNE_INTERRUPT           0x80000000 // The presence Of This Flag indicates
#Define GWL_WNDPROC         (-4)

#Define WM_DEVICECHANGE         0x0219
#Define DBT_DEVNODES_CHANGED            0x0007
#Define DBT_DEVICEARRIVAL               0x8000  &&// system detected a new device
#Define DBT_DEVICEQUERYREMOVE           0x8001  &&// wants to remove, may fail
#Define DBT_DEVICEQUERYREMOVEFAILED     0x8002  &&// removal aborted
#Define DBT_DEVICEREMOVEPENDING         0x8003  &&// about to remove, still avail.
#Define DBT_DEVICEREMOVECOMPLETE        0x8004  &&// device is gone

#Define DBT_DEVTYP_OEM                  0x00000000  &&// oem-defined device type
#Define DBT_DEVTYP_DEVNODE              0x00000001  &&// devnode number
#Define DBT_DEVTYP_VOLUME               0x00000002  &&// logical volume
#Define DBT_DEVTYP_PORT                 0x00000003  &&// serial, parallel
#Define DBT_DEVTYP_NET                  0x00000004  &&// network resource

Public nOldProc,oMsgHandler
Clear
Unbindevents(0)
oMsgHandler=Newobject("MsgHandler")
Bindevent(_vfp.HWnd,WM_DEVICECHANGE,oMsgHandler,"HandleWinMsg")
Bindevent(_vfp.HWnd,WM_USER_SHNOTIFY,oMsgHandler,"HandleWinMsg")
? "Total events:",Aevents(lAEvents,1)

Procedure Dump(cStr As String) As Number
	Local num,i
	num=0
	For i = 1 To Len(cStr)
		num=num+(256^(i-1) ) * Asc(Substr(cStr,i,1))
	Endfor
	Return Int(num)
Endproc

Define Class MsgHandler As Session
	dwShNotify=0
	nOldProc=0
	Procedure Init
		Declare Integer GetWindowLong In WIN32API ;
			integer HWnd, ;
			integer nIndex
		Declare Integer CallWindowProc In WIN32API ;
			integer lpPrevWndFunc, ;
			integer HWnd,Integer Msg,;
			integer wParam,;
			integer Lparam
		Declare Integer SHGetPathFromIDList In shell32 ;
			integer nItemList,;
			string @szPath
		Declare Integer SHChangeNotifyRegister In shell32 ;
			integer HWnd, ;
			integer fSources, ;
			integer fEvents, ;
			integer wMsg,;
			integer cEntries, ;
			string @ SEntry
		Declare Integer SHChangeNotifyDeregister In shell32 Integer
		cSEntry = Replicate(Chr(0),8)
		This.nOldProc=GetWindowLong(_Screen.HWnd,GWL_WNDPROC)
		This.dwShNotify = SHChangeNotifyRegister(_vfp.HWnd, ;
			SHCNE_DISKEVENTS,;
			SHCNE_MEDIAINSERTED + SHCNE_MEDIAREMOVED + SHCNE_DRIVEADD + SHCNE_DRIVEREMOVED,;
			WM_USER_SHNOTIFY,1,;
			@cSEntry)
		? "Notify", This.dwShNotify
	Endproc

	Procedure Destroy
		If This.dwShNotify != 0
			If SHChangeNotifyDeregister(This.dwShNotify) > 0
				?"Deregister successful"
			Else
				?"Deregister ERRORd"
			Endif
		Endif
		Unbindevent(_vfp.HWnd)
	Endproc

	Procedure ShowBHDR(Lparam As Integer)
		hdr=Sys(2600,Lparam,12)
		Size=Dump(Left(hdr,4))
		num=Dump(Substr(hdr,5,4))
		If num=DBT_DEVTYP_VOLUME
			unitmask=Dump(Substr(Sys(2600,Lparam,Size),13,4))
			??unitmask
			Flags=Dump(Substr(Sys(2600,Lparam,Size),17,2))
			??" Flags=",Flags
		Endif
	Endproc

	Procedure HandleWinMsg(HWnd As Integer, Msg As Integer, wParam As Integer, Lparam As Integer)
		lResult=0
		?This.Name,Transform(HWnd,"@0x"),Transform(Msg,"@0x"),Transform(wParam,"@0x"),Transform(Lparam,"@0x")

		Do Case
		Case Msg=WM_DEVICECHANGE
			Do Case
			Case wParam=DBT_DEVNODES_CHANGED
				?"devnodes changed"
			Case wParam=DBT_DEVICEARRIVAL
				?"device arrival"
				This.ShowBHDR(Lparam)
			Case wParam=DBT_DEVICEREMOVECOMPLETE
				?"device remove complete"
				This.ShowBHDR(Lparam)
			Endcase
		Case Msg=WM_USER_SHNOTIFY
			Do Case
			Case Lparam=SHCNE_DRIVEADD && Stuck a USB drive in, for instance
				?"Drive added "
				
				*-- First, determine the path string
				*-- of the drive
				num=Dump(Sys(2600,wParam,4))
				szPath=Space(270)
				SHGetPathFromIDList(num,@szPath)
				szPath=ALLTRIM(Left(szPath,At(Chr(0),szPath)-1))
			
				*-- Search the drive for the files we
				*-- want and do something with them
				ADIR(laPics, szPath + "*.jpg")
				FOR i = 1 TO ALEN(laPics,1)
					lsName = laPics(i,1)
					?lsName
				ENDFOR
				?
			Case Lparam=SHCNE_DRIVEREMOVED
				?"Drive removed"
			Case Lparam=SHCNE_MEDIAINSERTED
				?"Media inserted "
			Case Lparam=SHCNE_MEDIAREMOVED
				?"Media removed "
			Endcase
			num=Dump(Sys(2600,wParam,4))

			szPath=Space(270)
			SHGetPathFromIDList(num,@szPath)
			szPath=Left(szPath,At(Chr(0),szPath)-1)
			??" path=",Alltrim(szPath)
			lResult=CallWindowProc(This.nOldProc,HWnd,Msg,wParam,Lparam)
		Endcase
		Return lResult
	Endproc
Enddefine
