#define IDEWINDOW "Command"
#define GWL_WNDPROC         -4
#define WM_CUT                          0x0300
#define WM_COPY                         0x0301
#define WM_PASTE                        0x0302
#define WM_CLEAR                        0x0303
#define WM_UNDO                         0x0304
#define WM_LBUTTONDOWN                  0x0201
#define WM_RBUTTONDOWN                  0x0204
#define WM_MENUSELECT                   0x011F
#define WM_MENUCOMMAND                  0x0126

Declare Integer FindWindow In win32api String, String
Declare Integer FindWindowEx In win32api Integer, Integer, String, String
Declare Integer GetWindowText In WIN32API Integer, String @, Integer

PUBLIC oHandler
LOCAL ocChildren as Collection 
ocChildren = NEWOBJECT("collection")
oHandler=CREATEOBJECT("IDEHandler")
hWnd = 0

*-- find the parent window first...
hWnd = oHandler.FindIDEWindow(IDEWINDOW, _vfp.hWnd, 0)

*-- The window we went looking for probably has child windows that 
*-- we need to account for.  Go find them, and bind to each one.
oHandler.FindChildren(hWnd, @ocChildren,0)
FOR i = 1 TO ocChildren.Count 
	BINDEVENT(ocChildren.Item(i), WM_RBUTTONDOWN, oHandler, "HandleEvent")
ENDFOR

DEFINE CLASS IDEHandler AS Custom
nOldProc=0

PROCEDURE Destroy
	UNBINDEVENT(_SCREEN.hWnd, WM_CUT)
	UNBINDEVENT(_SCREEN.hWnd, WM_COPY)
	UNBINDEVENT(_SCREEN.hWnd, WM_PASTE)
	UNBINDEVENT(_SCREEN.hWnd, WM_CLEAR)
	UNBINDEVENT(_SCREEN.hWnd, WM_UNDO)
ENDPROC

PROCEDURE Init
	DECLARE integer GetWindowLong IN WIN32API ;
		integer hWnd, ;
		integer nIndex
	DECLARE integer CallWindowProc IN WIN32API ;
		integer lpPrevWndFunc, ;
		integer hWnd,integer Msg,;
		integer wParam,;
		integer lParam
	THIS.nOldProc=GetWindowLong(_VFP.HWnd,GWL_WNDPROC)
ENDPROC

Procedure FindIDEWindow(lsWind as String, HWnd As Integer,nLev As Integer)
Local hchild,res
hchild=0
hFoundChild = 0
	Do While .T.
		hchild=FindWindowEx(HWnd,hchild,0,0)
		If hchild=0
			Exit
		Endif
		res=Space(80)
		GetWindowText(hchild,@res, Len(res))
		IF lsWind $ res
			hFoundChild = hChild
			Exit
		Endif
		This.FindIDEWindow(lsWind, hchild, nLev+1)
	ENDDO
	*-- If nothing found, return
	RETURN hFoundChild
Endproc

Procedure FindChildren(HWnd As Integer,ocKids as Collection, nLev As Integer)
Local hchild,res
hchild=0
Do While .T.
	hchild=FindWindowEx(HWnd,hchild,0,0)
	If hchild=0
		Exit
	Endif
	res=Space(80)
	ocKids.Add(hChild)
	this.FindChildren(hchild, @ocKids, nLev+1)
Enddo
Endproc

PROCEDURE HandleEvent(hWnd as Integer, Msg as Integer, ;
	wParam as Integer, lParam as Integer)
	lResult=0
    	DO CASE
*!*	    	CASE msg=WM_LBUTTONDOWN
*!*	    		MESSAGEBOX("Lbuttondown...")
    	CASE msg=WM_RBUTTONDOWN
    		MESSAGEBOX("WM_RBUTTONDOWN...")
		ENDCASE 
	lResult=CallWindowProc(this.nOldProc,hWnd,msg,wParam,lParam)
    RETURN lResult
ENDPROC
ENDDEFINE 