*-- Program: reportmenuhook.prg
*-- Author: Mike Stewart
*-- Copyright 2004 Microsoft Corporation
*-- Comments:  Demonstrates how to hook into the right-click
*--            menu of the report designer and replace it 
*--            with a custom menu.

*-- 
*-- Setup code.  Create table, create a quick report.
*-- This section otherwise does nothing of note.
*-- 

*-- Defines for window title we're looking for, and windows
*-- messages we care about
#define IDEWINDOW "Report Designer"
#define WM_LBUTTONDOWN                  0x0201
#define WM_RBUTTONDOWN                  0x0204
#define WM_MENUSELECT                   0x011F
#define WM_MENUCOMMAND                  0x0126

SET SAFETY OFF && Just to eliminate the overwrite dialogs
CREATE TABLE MenuHook ;
	(id i AUTOINC, ;
	fname c(20), ;
	lname c(20), ;
	addr c(20), ;
	city c(20), ;
	state c(10), ;
	postalcode c(9))

INSERT INTO MenuHook ;
	(fname, lname, addr, city, state, postalcode) ;
	values;
	("Mike", "Stewart", "One Microsoft Way", "Redmond", "WA", "98052")
	
INSERT INTO MenuHook ;
	(fname, lname, addr, city, state, postalcode) ;
	values;
	("Bill", "Gates", "123 BillG Way", "Medina", "WA", "98953")

INSERT INTO MenuHook ;
	(fname, lname, addr, city, state, postalcode) ;
	values;
	("Larry", "Ellison", "666 Oracle Drive", "Mission Bay", "CA", "99999")
	
CREATE REPORT HookMyMenu FROM MenuHook	
*-- 
*-- End setup
*-- 

MODIFY REPORT HookMyMenu NOWAIT && Need the NOWAIT so we can get the window up,
								&& then run the code necessary to hook the window
								&& events

*-- The following does all the work to hook into the 
*-- msg queue and put our own menu in place of the stock one
Declare Integer FindWindow In win32api String, String
Declare Integer FindWindowEx In win32api Integer, Integer, String, String
Declare Integer GetWindowText In WIN32API Integer, String @, Integer

PUBLIC oHandler
LOCAL ocChildren as Collection 
ocChildren = NEWOBJECT("collection")
oHandler=CREATEOBJECT("IDEHandler")
hWnd = 0

*-- find the parent window first...
hWnd = oHandler.FindIDEWindow(IDEWINDOW, _vfp.hWnd, 0)

*-- The window we went looking for probably has child windows that 
*-- we need to account for.  Go find them, and bind to each one.
oHandler.FindChildren(hWnd, @ocChildren,0)
FOR i = 1 TO ocChildren.Count 
	BINDEVENT(ocChildren.Item(i), WM_RBUTTONDOWN, oHandler, "HandleEvent")
ENDFOR

DEFINE CLASS IDEHandler AS Custom
nOldProc = 0
*colEvents = NEWOBJECT("collection")

PROCEDURE Destroy
	*-- Unbind all of our events
	DEACTIVATE POPUP popReport
ENDPROC

PROCEDURE Init
	*-- APIs needed to pass msgs to the default window procedure
	DECLARE integer GetWindowLong IN WIN32API ;
		integer hWnd, ;
		integer nIndex
	DECLARE integer CallWindowProc IN WIN32API ;
		integer lpPrevWndFunc, ;
		integer hWnd,integer Msg,;
		integer wParam,;
		integer lParam
	*THIS.nOldProc=GetWindowLong(_VFP.HWnd,GWL_WNDPROC)
	this.CreateMenu
ENDPROC

Procedure FindIDEWindow(lsWind as String, HWnd As Integer,nLev As Integer)
*-- Finds the parent window that we want.  Need to call FindChildren later to 
*-- find all the subwindows.

Local hchild,res
hchild=0
hFoundChild = 0
	Do While .T.
		hchild=FindWindowEx(HWnd,hchild,0,0)
		If hchild=0
			Exit
		Endif
		res=Space(80)
		GetWindowText(hchild,@res, Len(res))
		IF lsWind $ res
			hFoundChild = hChild
			Exit
		Endif
		This.FindIDEWindow(lsWind, hchild, nLev+1)
	ENDDO
	*-- If nothing found, return
	RETURN hFoundChild
Endproc

Procedure FindChildren(HWnd As Integer,ocKids as Collection, nLev As Integer)
*-- Find the subwindows of a given parent IDE window.  Needed because most IDE
*-- windows are really made up of one or more subwindows (or child windows).

Local hchild,res
hchild=0
Do While .T.
	hchild=FindWindowEx(HWnd,hchild,0,0)
	If hchild=0
		Exit
	Endif
	res=Space(80)
	ocKids.Add(hChild)
	this.FindChildren(hchild, @ocKids, nLev+1)
Enddo
Endproc

PROCEDURE HandleEvent(hWnd as Integer, Msg as Integer, ;
	wParam as Integer, lParam as Integer)
*-- Windows message event handler.  Much like a window
*-- procedure using straight Win32 APIs, use a CASE
*-- statement that deals with any message one would
*-- expect and want to handle.

	lResult=0
    	DO CASE
    	CASE msg=WM_RBUTTONDOWN
    		*MESSAGEBOX("WM_RBUTTONDOWN...")
    		this.Displaymenu
		ENDCASE 
	lResult=CallWindowProc(this.nOldProc,hWnd,msg,wParam,lParam)
    RETURN lResult
ENDPROC

PROCEDURE CreateMenu
	DEFINE POPUP popReport FROM 5,5
	DEFINE BAR 1 OF popReport PROMPT 'One'
	DEFINE BAR 2 OF popReport PROMPT 'Two'
	DEFINE BAR 3 OF popReport PROMPT 'Three'
	DEFINE BAR 4 OF popReport PROMPT 'Four'
	ON SELECTION POPUP popReport MESSAGEBOX("menu")
ENDPROC

PROCEDURE DisplayMenu
	ACTIVATE POPUP popReport AT MROW(), MCOL()
	DEACTIVATE POPUP popReport
ENDPROC

Enddefine