** GETSYSTEMFONTINFO.PRG
** This program provides Windows
** system font information.
** This PRG contains modified code 
** from the examples provided at
** http://www.news2news.com/vfp/?example=556


DEFINE CLASS SystemFontInfo As Relation
	** FontName
	FontName = ""
	FontSize = 0
	FontBold = .F.
	FontItalic = .F.
	FontUnderline = .F.
	FontStrikethru = .F.

	PROCEDURE Init
		#DEFINE SPI_GETNONCLIENTMETRICS 0x0029
		#DEFINE NONCLIENTMETRICS_SIZE 0x0154
		#DEFINE LOGFONT_SIZE 0x003c
		#DEFINE LOGPIXELSY 0x005a

		DECLARE INTEGER GetWindowDC IN user32 INTEGER hWindow
 
		DECLARE INTEGER SystemParametersInfo IN user32 ;
			INTEGER uiAction, INTEGER uiParam, ;
		    STRING @pvParam, INTEGER fWinIni
	 
		DECLARE INTEGER GetDeviceCaps IN gdi32;
			INTEGER hdc, INTEGER nIndex
 
		DECLARE INTEGER ReleaseDC IN user32;
			INTEGER hWindow, INTEGER hDC

		LOCAL cNonClientMetrics, cLogFont
		** populating NONCLIENTMETRICS structure
		** the size of the structure occupies first 4 bytes
		cNonClientMetrics=num2dword(NONCLIENTMETRICS_SIZE)
 
		** padding the structure to the required size
		cNonClientMetrics=PADR(cNonClientMetrics, ;
			    NONCLIENTMETRICS_SIZE, CHR(0))
 
		** retrieving the metrics associated with the nonclient area
		** of nonminimized windows
		IF SystemParametersInfo(SPI_GETNONCLIENTMETRICS,;
		    NONCLIENTMETRICS_SIZE, @cNonClientMetrics, 0) = 0
		    RETURN .F.
		ENDIF
 
		LOCAL lcBuf, lfHeight, lfWidth, lfEscapement, lfOrientation, ;
			  lfWeight, lfItalic, lfUnderline, lfStrikeout, lfCharset, ;
			  lfOutPrecision, lfClipPrecision, lfQuality, lfPitchAndFamily, ;
			  lfFaceName
	  
		lfHeight=0
		lfWidth=0
		lfEscapement=0
		lfOrientation=0
		lfWeight=0
		lfItalic=.F.
		lfUnderline=.F.
		lfStrikeOut=.F.
		lfCharSet=0
		lfOutPrecision=0
		lfClipPrecision=0
		lfQuality=0
		lfPitchAndFamily=0
		lfFaceName=""
 
		lcBuf = SUBSTR(cNonClientMetrics, 281, LOGFONT_SIZE)

		lfHeight = buf2dword(SUBSTR(lcBuf,1,4))
		lfWidth = buf2dword(SUBSTR(lcBuf,5,4))
		lfEscapement = buf2dword(SUBSTR(lcBuf,9,4))
		lfOrientation = buf2dword(SUBSTR(lcBuf,13,4))
		lfWeight = buf2dword(SUBSTR(lcBuf,17,4))
		lfItalic = (ASC(SUBSTR(lcBuf,21,1)) <> 0)
		lfUnderline = (ASC(SUBSTR(lcBuf,22,1)) <> 0)
		lfStrikeOut = (ASC(SUBSTR(lcBuf,23,1)) <> 0)
		lfCharSet=ASC(SUBSTR(lcBuf,24,1))
		lfOutPrecision=ASC(SUBSTR(lcBuf,25,1))
		lfClipPrecision=ASC(SUBSTR(lcBuf,26,1))
		lfQuality=ASC(SUBSTR(lcBuf,27,1))
		lfPitchAndFamily=ASC(SUBSTR(lcBuf,28,1))
		lfFaceName=STRTRAN(SUBSTR(lcBuf,29,32), CHR(0),"")

		** FontName
		This.FontName = lfFaceName

		** Calculate the font size
		LOCAL hWindow, hDC, nPxPerInchY
		hWindow=_screen.HWnd
		hDC=GetWindowDC(hWindow)
		nPxPerInchY = GetDeviceCaps(hDC, LOGPIXELSY)
		ReleaseDC(hWindow, hDC)
		
		This.FontSize = ROUND((ABS(lfHeight) * 72) / nPxPerInchY, 0)

		** Other font properties
		This.FontBold = (lfWeight > 400)
		This.FontItalic = lfItalic
		This.FontUnderline = lfUnderline
		This.FontStrikethru = lfStrikeOut
	ENDPROC 
ENDDEFINE

FUNCTION num2dword(lnValue)
	#DEFINE m0 0x0000100
	#DEFINE m1 0x0010000
	#DEFINE m2 0x1000000

	IF lnValue < 0
		lnValue = 0x100000000 + lnValue
	ENDIF

	LOCAL b0, b1, b2, b3
	b3 = Int(lnValue/m2)
	b2 = Int((lnValue - b3*m2)/m1)
	b1 = Int((lnValue - b3*m2 - b2*m1)/m0)
	b0 = Mod(lnValue, m0)
	RETURN Chr(b0)+Chr(b1)+Chr(b2)+Chr(b3)
ENDFUNC	

FUNCTION buf2dword(cBuffer)
	RETURN Asc(SUBSTR(cBuffer, 1,1)) + ;
	    BitLShift(Asc(SUBSTR(cBuffer, 2,1)),  8) +;
	    BitLShift(Asc(SUBSTR(cBuffer, 3,1)), 16) +;
	    BitLShift(Asc(SUBSTR(cBuffer, 4,1)), 24)
ENDFUNC	

