&&-- BM_6.Prg
&&-- PRG Based Class that has multiple public methods that
&&-- bench mark computer performace via FoxPro code

	LOCAL loBenchMarker
	loBenchMarker = NEWOBJECT( [VFP_Benchmark], [BM_6.PRG] )
	loBenchMarker.Self_Test( )
Return	
&&=======================================================
Define Class VFP_Benchmark as DataEnvironment
	
	PROTECTED Loop_Modifier 
	PROTECTED Path_and_dir_to_Create_temp_files
	PROTECTED Test_Start_time
&&------------------------------------------------------------------
PROCEDURE Set_Time_Factor( tnLoop_Modifier )
	This.Loop_ModiFier = tnLoop_Modifier
EndProc
&&------------------------------------------------------------------
PROCEDURE set_Path_and_dir_to_Create_temp_files( tcPath )
	This.Path_and_dir_to_Create_temp_files = tcPath
EndProc
&&------------------------------------------------------------------
Procedure Get_BenchMark_Simple_Loop( )
	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 129300000
	LOCAL I
	
	This.Assign_Test_Start_time( )
	For I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
	endfor
	
Return This.Calculate_Test_time( )
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
EndProc 
&&------------------------------------------------------------------
Procedure Get_BenchMark_Random_Number( )
	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 21810000

	LOCAL I
	
	This.Assign_Test_Start_time( )

	for I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
		lnNumber = Rand( )
	endfor

Return This.Calculate_Test_time( ) 
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
EndProc 
&&------------------------------------------------------------------
Procedure Get_BenchMark_Table_Creation_Population( )
	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 72000
	LOCAL I, lxFile

	&&-- About to create free table BnchMark
	&&-- Erase from the directory if it exists
	&&-- So no errors occur when Create Table is called
		_Screen.SUPPORT.Table_Erase( [BnchMark], This.Path_and_dir_to_Create_temp_files )

	lxFile      = '['+This.Path_and_dir_to_Create_temp_files+'BnchMark.DBF]'

	This.Assign_Test_Start_time( )
				
	create table &lxFile(;
		Text 	c( 20 ),;
		Real 	N( 15, 5 ),;
		Integer I,;
		date	D,;
		Logical L,;
		Memo	M)
		
		index on text 		tag text
		index on integer 	tag integer
		index on date 		tag date
		index on real		tag real
						
	set order to integer

	for I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
	 	append blank
	 	replace ;
	 		Text 	with [ABCDefg],;
	 		Real	with 1.5678 * I,;
	 		Integer	with I,;
	 		date	with date( )+(Rand( )* 1000 ),;
	 		Logical	with ( Rand( ) > 0.5 ),;
	 		Memo	with replicate( [@], Rand( )* 500 )
	endfor

	_Screen.SUPPORT.Table_Erase( [BnchMark], This.Path_and_dir_to_Create_temp_files )
	 
Return This.Calculate_Test_time( ) 
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
EndProc 
&&------------------------------------------------------------------
Procedure Get_BenchMark_Table_Data_Access( )
	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 90500
	#Define knRepresentative_Real_Number 1.5678
	LOCAL I, lxFile

	This.Assign_Test_Start_time( )

	&&-- About to create free table BnchMark
	&&-- Erase from the directory if it exists
	&&-- So no errors occur when Create Table is called
		_Screen.SUPPORT.Table_Erase( [BnchMark], This.Path_and_dir_to_Create_temp_files )
	
	lxFile= '['+This.Path_and_dir_to_Create_temp_files+ 'BnchMark.DBF]'

	This.Assign_Test_Start_time( )
				
	create table &lxFile(;
		PK		I,;
		Text 	c( 20 ),;
		Real 	N( 15, 5 ),;
		Integer I,;
		date	D)
				
		Index on PK			Tag PK		
		index on text 		tag text
		index on integer 	tag integer
		index on date 		tag date
		index on real		tag real
						
	use &lxFile exclu
	set order to PK

	&&-- Loading test data
		for I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
		 	append blank
		 	replace ;
			 	PK		with I + 1000,;
			 	Text 	with [ABCDefg],;
			 	Real	with knRepresentative_Real_Number * I,;
			 	Integer	with I,;
			 	date	with date( ) + ( rand( )* 1000)
		endfor

	&&-- Testing the Data Access time
		For I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run  * This.Loop_modifier	
			lnPk = int( rand( ) * reccount( ) )+ 1000
			seek( lnPk )		
		Endfor

	_Screen.SUPPORT.Table_Erase( [BnchMark], This.Path_and_dir_to_Create_temp_files )

Return This.Calculate_Test_time( ) 
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
	#UnDefine knRepresentative_Real_Number
EndProc 
&&------------------------------------------------------------------
Procedure Get_BenchMark_Integer_Number_Calculation( )
	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 5380000
	#Define knRepresentative_Integer_Number1 1
	#Define knRepresentative_Integer_Number2 123
	
	LOCAL I, lnNumber1, lnNumber2, lnNumber3

	This.Assign_Test_Start_time( )
	
	lnNumber1 = knRepresentative_Integer_Number1
	lnNumber2 = knRepresentative_Integer_Number2
				 
	for I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
		lnNumber1 = lnNumber1 + 1
		lnNumber2 = lnNumber2 - 1
		lnNumber3 = lnNumber1 * lnNumber2
		lnNumber3 = 100 / 25
	endfor

Return This.Calculate_Test_time( ) 
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
	#UnDefine knRepresentative_Integer_Number1
	#UnDefine knRepresentative_Integer_Number2
EndProc 
&&------------------------------------------------------------------
Procedure Get_BenchMark_Real_number_Calculation( )
   	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 2370000
	#Define knRepresentative_Real_Number1 1.234567
	#Define knRepresentative_Real_Number2 3.432
	#Define knRepresentative_Real_Number3 1.738
	
	LOCAL I, lnNumber1, lnNumber2, lnNumber3, lnNumber4
	
	This.Assign_Test_Start_time( )

	lnNumber1 = knRepresentative_Real_Number1
	lnNumber2 = knRepresentative_Real_Number2
	for I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
		lnNumber1 = lnNumber1 + knRepresentative_Real_Number3
		lnNumber2 = lnNumber2 - lnNumber1
		lnNumber2 = sin( lnNumber1 ) / tan( lnNumber2 )
		lnNumber3 = lnNumber1 * lnNumber2
		lnNumber4 = round( cos( lnNumber1 ) / sin( lnNumber2 )* lnNumber3, 5 )
	endfor

Return This.Calculate_Test_time( ) 
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
	#UnDefine knRepresentative_Real_Number1
	#UnDefine knRepresentative_Real_Number2
	#UnDefine knRepresentative_Real_Number3

EndProc 
&&------------------------------------------------------------------
Procedure Get_BenchMark_Screen_Drawing( )
	#Define knNumber_of_Loops_on_Development_Computer_for_10_sec_run 6800
	#Define knRepresentative_Real_number 1234.5678
	LOCAL I, lnBox_Size_Divisor
	
	This.Assign_Test_Start_time( )

	lnBox_Size_Divisor = knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier / 10
	This.Assign_Test_Start_time( )
  
	DEFINE WINDOW Screen_Test AT  5,5  SIZE 15,25 ;
	TITLE "Testing Screen Output" FONT "Courier New", 10 ;
	NOFLOAT NOCLOSE NOMINIMIZE 
		
	Activate window Screen_Test
	move window Screen_Test center

	for I = 1 to knNumber_of_Loops_on_Development_Computer_for_10_sec_run * This.Loop_modifier
		clear
		@1,1 say [ABCDefg]
		@rand( ) * 10, rand( ) * 10 say knRepresentative_Real_number	
		@1 + ( I / lnBox_Size_Divisor ), 1 + ( I / lnBox_Size_Divisor) to 14,24 pen 2,2	
	endfor

	release window Screen_Test

Return This.Calculate_Test_time( ) 
	#UnDefine knNumber_of_Loops_on_Development_Computer_for_10_sec_run
	#UnDefine knRepresentative_Real_number 

EndProc 
&&------------------------------------------------------------------
PROTECTED Procedure Init
	WITH This
		.Loop_Modifier = 1
		.Path_and_dir_to_Create_temp_files = []
		.Test_Start_time = 0
	ENDWITH
	
	&&-- Make sure that the Support library has been added to 
	&&-- the _Screen Object.                                  
		IF VARTYPE( _Screen.Support ) = [U]
			_Screen.newobject( [Support], [Support], [Support.Prg] )
		Endif	
EndProc
&&------------------------------------------------------------------
PROTECTED Procedure Assign_Test_Start_time( )
	This.Test_Start_time = SECONDS( )
EndProc
&&------------------------------------------------------------------
PROTECTED Procedure Calculate_Test_time( )
RETURN round(Seconds( )-This.Test_Start_time,2)
EndProc
&&------------------------------------------------------------------
PROCEDURE Self_Test( )
	#Define knFast_Run 0.00001
	#Define knLongest_time_code_should_take_to_run 1
	LOCAL lnTotal_time
	WITH This
		.Set_Time_Factor( knFast_Run )
		.Set_Path_and_Dir_to_Create_temp_files( [C:\] )

		lnTotal_time = ; 
		    .Get_BenchMark_Simple_Loop( ) ;
		  + .Get_BenchMark_Random_Number( ) ;
		  + .Get_BenchMark_Integer_Number_Calculation( );
		  + .Get_BenchMark_Real_number_Calculation( );
		  + .Get_BenchMark_Screen_Drawing( ) ;
		  + .Get_BenchMark_Table_Creation_Population( ) ;
		  + .Get_BenchMark_Table_Data_Access( )	

		IF lnTotal_time <= knLongest_time_code_should_take_to_run
			MESSAGEBOX( [Benchmark Self Test: OK] )
		Else
			MESSAGEBOX( [Benchmark program taking too long] )
		ENDIF
		
	ENDWITH 
	#UnDefine knFast_Run
	#UnDefine knLongest_time_code_should_take_to_run

EndProc
EndDefine &&-- VFP_Benchmark